/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import io.papermc.paper.potion.PaperPotionMix;
import io.papermc.paper.potion.PotionMix;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeItemStack;
import org.bukkit.NamespacedKey;

public class PotionBrewer {
    public static final int a = 20;
    public static final PotionBrewer b = new PotionBrewer(List.of(), List.of(), List.of());
    private final List<RecipeItemStack> c;
    private final List<PredicatedCombination<PotionRegistry>> d;
    private final List<PredicatedCombination<Item>> e;
    private final Object2ObjectLinkedOpenHashMap<NamespacedKey, PaperPotionMix> customMixes = new Object2ObjectLinkedOpenHashMap();

    PotionBrewer(List<RecipeItemStack> potionTypes, List<PredicatedCombination<PotionRegistry>> potionRecipes, List<PredicatedCombination<Item>> itemRecipes) {
        this.c = potionTypes;
        this.d = potionRecipes;
        this.e = itemRecipes;
    }

    public boolean a(ItemStack stack) {
        return this.b(stack) || this.c(stack) || this.isCustomIngredient(stack);
    }

    private boolean d(ItemStack stack) {
        for (RecipeItemStack ingredient : this.c) {
            if (!ingredient.a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean b(ItemStack stack) {
        for (PredicatedCombination<Item> mix : this.e) {
            if (!mix.b.a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean c(ItemStack stack) {
        for (PredicatedCombination<PotionRegistry> mix : this.d) {
            if (!mix.b.a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean a(Holder<PotionRegistry> potion) {
        for (PredicatedCombination<PotionRegistry> mix : this.d) {
            if (!mix.c.a(potion)) continue;
            return true;
        }
        return false;
    }

    public boolean a(ItemStack input, ItemStack ingredient) {
        if (this.hasCustomMix(input, ingredient)) {
            return true;
        }
        return this.d(input) && (this.b(input, ingredient) || this.c(input, ingredient));
    }

    public boolean b(ItemStack input, ItemStack ingredient) {
        for (PredicatedCombination<Item> mix : this.e) {
            if (!input.a(mix.a) || !mix.b.a(ingredient)) continue;
            return true;
        }
        return false;
    }

    public boolean c(ItemStack input, ItemStack ingredient) {
        Optional<Holder<PotionRegistry>> optional = input.a(DataComponents.G, PotionContents.a).e();
        if (optional.isEmpty()) {
            return false;
        }
        for (PredicatedCombination<PotionRegistry> mix : this.d) {
            if (!mix.a.a(optional.get()) || !mix.b.a(ingredient)) continue;
            return true;
        }
        return false;
    }

    public ItemStack d(ItemStack ingredient, ItemStack input) {
        if (input.e()) {
            return input;
        }
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.input().test(input) || !mix.ingredient().test(ingredient)) continue;
            return mix.result().s();
        }
        Optional<Holder<PotionRegistry>> optional = input.a(DataComponents.G, PotionContents.a).e();
        if (optional.isEmpty()) {
            return input;
        }
        for (PredicatedCombination<Item> predicatedCombination : this.e) {
            if (!input.a(predicatedCombination.a) || !predicatedCombination.b.a(ingredient)) continue;
            return PotionContents.a((Item)predicatedCombination.c.a(), optional.get());
        }
        for (PredicatedCombination<FeatureElement> predicatedCombination : this.d) {
            if (!predicatedCombination.a.a(optional.get()) || !predicatedCombination.b.a(ingredient)) continue;
            return PotionContents.a(input.g(), predicatedCombination.c);
        }
        return input;
    }

    public static PotionBrewer a(FeatureFlagSet enabledFeatures) {
        a builder = new a(enabledFeatures);
        PotionBrewer.a(builder);
        return builder.a();
    }

    public static void a(a builder) {
        builder.a(Items.sk);
        builder.a(Items.vo);
        builder.a(Items.vr);
        builder.a(Items.sk, Items.pu, Items.vo);
        builder.a(Items.vo, Items.vn, Items.vr);
        builder.a(Potions.a, Items.qY, Potions.c);
        builder.a(Potions.a, Items.lH, Potions.b);
        builder.a(Potions.a, Items.sj, Potions.d);
        builder.a(Items.yG, Potions.Q);
        builder.a(Items.lO, Potions.S);
        builder.a(Items.b, Potions.T);
        builder.a(Items.cM, Potions.R);
        builder.a(Potions.d, Items.uk, Potions.e);
        builder.a(Potions.e, Items.lH, Potions.f);
        builder.a(Potions.e, Items.sn, Potions.g);
        builder.a(Potions.f, Items.sn, Potions.h);
        builder.a(Potions.g, Items.lH, Potions.h);
        builder.a(Items.sp, Potions.l);
        builder.a(Potions.l, Items.lH, Potions.m);
        builder.a(Items.uD, Potions.i);
        builder.a(Potions.i, Items.lH, Potions.j);
        builder.a(Potions.i, Items.qY, Potions.k);
        builder.a(Potions.i, Items.sn, Potions.q);
        builder.a(Potions.j, Items.sn, Potions.r);
        builder.a(Potions.q, Items.lH, Potions.r);
        builder.a(Potions.q, Items.qY, Potions.s);
        builder.a(Potions.d, Items.oo, Potions.t);
        builder.a(Potions.t, Items.lH, Potions.u);
        builder.a(Potions.t, Items.qY, Potions.v);
        builder.a(Potions.n, Items.sn, Potions.q);
        builder.a(Potions.o, Items.sn, Potions.r);
        builder.a(Items.rA, Potions.n);
        builder.a(Potions.n, Items.lH, Potions.o);
        builder.a(Potions.n, Items.qY, Potions.p);
        builder.a(Potions.d, Items.rc, Potions.w);
        builder.a(Potions.w, Items.lH, Potions.x);
        builder.a(Items.st, Potions.y);
        builder.a(Potions.y, Items.qY, Potions.z);
        builder.a(Potions.y, Items.sn, Potions.A);
        builder.a(Potions.z, Items.sn, Potions.B);
        builder.a(Potions.A, Items.qY, Potions.B);
        builder.a(Potions.C, Items.sn, Potions.A);
        builder.a(Potions.D, Items.sn, Potions.A);
        builder.a(Potions.E, Items.sn, Potions.B);
        builder.a(Items.sm, Potions.C);
        builder.a(Potions.C, Items.lH, Potions.D);
        builder.a(Potions.C, Items.qY, Potions.E);
        builder.a(Items.sh, Potions.F);
        builder.a(Potions.F, Items.lH, Potions.G);
        builder.a(Potions.F, Items.qY, Potions.H);
        builder.a(Items.so, Potions.I);
        builder.a(Potions.I, Items.lH, Potions.J);
        builder.a(Potions.I, Items.qY, Potions.K);
        builder.a(Potions.a, Items.sn, Potions.L);
        builder.a(Potions.L, Items.lH, Potions.M);
        builder.a(Potions.d, Items.vT, Potions.O);
        builder.a(Potions.O, Items.lH, Potions.P);
    }

    public boolean isCustomIngredient(ItemStack stack) {
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.ingredient().test(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isCustomInput(ItemStack stack) {
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.input().test(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCustomMix(ItemStack input, ItemStack ingredient) {
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.input().test(input) || !mix.ingredient().test(ingredient)) continue;
            return true;
        }
        return false;
    }

    public void addPotionMix(PotionMix mix) {
        if (this.customMixes.containsKey((Object)mix.getKey())) {
            throw new IllegalArgumentException("Duplicate recipe ignored with ID " + String.valueOf(mix.getKey()));
        }
        this.customMixes.putAndMoveToFirst((Object)mix.getKey(), (Object)new PaperPotionMix(mix));
    }

    public boolean removePotionMix(NamespacedKey key) {
        return this.customMixes.remove((Object)key) != null;
    }

    public PotionBrewer reload(FeatureFlagSet flags) {
        return PotionBrewer.a(flags);
    }

    record PredicatedCombination<T>(Holder<T> a, RecipeItemStack b, Holder<T> c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PredicatedCombination.class, "from;ingredient;to", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PredicatedCombination.class, "from;ingredient;to", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PredicatedCombination.class, "from;ingredient;to", "a", "b", "c"}, this, o2);
        }
    }

    public static class a {
        private final List<RecipeItemStack> a = new ArrayList<RecipeItemStack>();
        private final List<PredicatedCombination<PotionRegistry>> b = new ArrayList<PredicatedCombination<PotionRegistry>>();
        private final List<PredicatedCombination<Item>> c = new ArrayList<PredicatedCombination<Item>>();
        private final FeatureFlagSet d;

        public a(FeatureFlagSet enabledFeatures) {
            this.d = enabledFeatures;
        }

        private static void b(Item potionType) {
            if (!(potionType instanceof ItemPotion)) {
                throw new IllegalArgumentException("Expected a potion, got: " + String.valueOf(BuiltInRegistries.g.b(potionType)));
            }
        }

        public void a(Item input, Item ingredient, Item output) {
            if (input.a(this.d) && ingredient.a(this.d) && output.a(this.d)) {
                net.minecraft.world.item.alchemy.PotionBrewer$a.b(input);
                net.minecraft.world.item.alchemy.PotionBrewer$a.b(output);
                this.c.add(new PredicatedCombination<Item>(input.o(), RecipeItemStack.a(ingredient), output.o()));
            }
        }

        public void a(Item item) {
            if (item.a(this.d)) {
                net.minecraft.world.item.alchemy.PotionBrewer$a.b(item);
                this.a.add(RecipeItemStack.a(item));
            }
        }

        public void a(Holder<PotionRegistry> input, Item ingredient, Holder<PotionRegistry> output) {
            if (input.a().a(this.d) && ingredient.a(this.d) && output.a().a(this.d)) {
                this.b.add(new PredicatedCombination<PotionRegistry>(input, RecipeItemStack.a(ingredient), output));
            }
        }

        public void a(Item ingredient, Holder<PotionRegistry> potion) {
            if (potion.a().a(this.d)) {
                this.a(Potions.a, ingredient, Potions.b);
                this.a(Potions.d, ingredient, potion);
            }
        }

        public PotionBrewer a() {
            return new PotionBrewer(List.copyOf(this.a), List.copyOf(this.b), List.copyOf(this.c));
        }
    }
}

