/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.papermc.paper.event.entity.EntityDamageItemEvent;
import io.papermc.paper.event.player.PlayerOpenSignEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.NullOps;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBed;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemSign;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.saveddata.maps.MapId;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder {
    public static final Codec<Holder<Item>> a = BuiltInRegistries.g.s().validate(holder -> holder.a(Items.a.o()) ? DataResult.error(() -> "Item must not be minecraft:air") : DataResult.success((Object)holder));
    public static final Codec<ItemStack> b = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)a.fieldOf("id").forGetter(ItemStack::h), (App)ExtraCodecs.a(1, 99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::H), (App)DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).forGetter(itemstack -> itemstack.r.f())).apply((Applicative)instance, ItemStack::new)));
    public static final Codec<ItemStack> c = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)a.fieldOf("id").forGetter(ItemStack::h), (App)DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).forGetter(itemstack -> itemstack.r.f())).apply((Applicative)instance, (holder, datacomponentpatch) -> new ItemStack((Holder<Item>)holder, 1, (DataComponentPatch)datacomponentpatch))));
    public static final Codec<ItemStack> d = b.validate(ItemStack::b);
    public static final Codec<ItemStack> e = c.validate(ItemStack::b);
    public static final Codec<ItemStack> f = ExtraCodecs.e(b).xmap(optional -> optional.orElse(l), itemstack -> itemstack.e() ? Optional.empty() : Optional.of(itemstack));
    public static final Codec<ItemStack> g = a.xmap(ItemStack::new, ItemStack::h);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> h = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){
        private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> a = ByteBufCodecs.b(Registries.K);

        public ItemStack a(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            int i2 = registryfriendlybytebuf.l();
            if (i2 <= 0) {
                return l;
            }
            Holder holder = (Holder)a.decode(registryfriendlybytebuf);
            DataComponentPatch datacomponentpatch = (DataComponentPatch)DataComponentPatch.c.decode(registryfriendlybytebuf);
            ItemStack itemstack = new ItemStack(holder, i2, datacomponentpatch);
            return itemstack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void a(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
            if (itemstack.e() || itemstack.g() == null) {
                registryfriendlybytebuf.c(0);
            } else {
                registryfriendlybytebuf.c(itemstack.H());
                a.encode(registryfriendlybytebuf, itemstack.h());
                boolean prev = ComponentSerialization.DONT_RENDER_TRANSLATABLES.get();
                try {
                    ComponentSerialization.DONT_RENDER_TRANSLATABLES.set(true);
                    DataComponentPatch.c.encode(registryfriendlybytebuf, itemstack.r.f());
                }
                finally {
                    ComponentSerialization.DONT_RENDER_TRANSLATABLES.set(prev);
                }
            }
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> i = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

        public ItemStack a(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            ItemStack itemstack = (ItemStack)h.decode(registryfriendlybytebuf);
            if (itemstack.e()) {
                throw new DecoderException("Empty ItemStack not allowed");
            }
            return itemstack;
        }

        public void a(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
            if (itemstack.e()) {
                throw new EncoderException("Empty ItemStack not allowed");
            }
            h.encode(registryfriendlybytebuf, itemstack);
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> j = h.a(ByteBufCodecs.a(NonNullList::a));
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> k = i.a(ByteBufCodecs.a(NonNullList::a));
    private static final Logger m = LogUtils.getLogger();
    public static final ItemStack l = new ItemStack((Void)null);
    private static final IChatBaseComponent n = IChatBaseComponent.c("item.disabled").a(EnumChatFormat.m);
    private int o;
    private int p;
    @Deprecated
    @Nullable
    private Item q;
    private PatchedDataComponentMap r;
    @Nullable
    private net.minecraft.world.entity.Entity s;
    private CraftItemStack bukkitStack;

    private static DataResult<ItemStack> b(ItemStack stack) {
        DataResult<Unit> dataresult = ItemStack.a(stack.a());
        return dataresult.isError() ? dataresult.map(unit -> stack) : (stack.H() > stack.j() ? DataResult.error(() -> {
            int i2 = stack.H();
            return "Item stack with stack size of " + i2 + " was larger than maximum: " + stack.j();
        }) : DataResult.success((Object)stack));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> a(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> basePacketCodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            public ItemStack a(RegistryFriendlyByteBuf registryfriendlybytebuf) {
                ItemStack itemstack = (ItemStack)basePacketCodec.decode(registryfriendlybytebuf);
                if (!itemstack.e()) {
                    RegistryOps<Unit> registryops = registryfriendlybytebuf.G().a(NullOps.a);
                    b.encodeStart(registryops, (Object)itemstack).getOrThrow(DecoderException::new);
                }
                return itemstack;
            }

            public void a(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
                basePacketCodec.encode(registryfriendlybytebuf, itemstack);
            }
        };
    }

    public Optional<TooltipComponent> b() {
        return this.g().g(this);
    }

    @Override
    public DataComponentMap a() {
        return !this.e() ? this.r : DataComponentMap.a;
    }

    public DataComponentMap c() {
        return !this.e() ? this.g().p() : DataComponentMap.a;
    }

    public DataComponentPatch d() {
        return !this.e() ? this.r.f() : DataComponentPatch.a;
    }

    public ItemStack(IMaterial item) {
        this(item, 1);
    }

    public ItemStack(Holder<Item> entry) {
        this(entry.a(), 1);
    }

    public ItemStack(Holder<Item> item, int count, DataComponentPatch changes) {
        this(item.a(), count, PatchedDataComponentMap.a(item.a().p(), changes));
    }

    public ItemStack(Holder<Item> itemEntry, int count) {
        this(itemEntry.a(), count);
    }

    public ItemStack(IMaterial item, int count) {
        this(item, count, new PatchedDataComponentMap(item.r().p()));
    }

    private ItemStack(IMaterial item, int count, PatchedDataComponentMap components) {
        this.q = item.r();
        this.o = count;
        this.r = components;
        this.g().m(this);
    }

    private ItemStack(@Nullable Void v2) {
        this.q = null;
        this.r = new PatchedDataComponentMap(DataComponentMap.a);
    }

    public static DataResult<Unit> a(DataComponentMap components) {
        int j2;
        ItemStack itemstack;
        int i2;
        if (components.b(DataComponents.d) && components.a(DataComponents.c, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        ItemContainerContents itemcontainercontents = components.a(DataComponents.ab, ItemContainerContents.a);
        Iterator<ItemStack> iterator = itemcontainercontents.d().iterator();
        do {
            if (iterator.hasNext()) continue;
            return DataResult.success((Object)((Object)Unit.a));
        } while ((i2 = (itemstack = iterator.next()).H()) <= (j2 = itemstack.j()));
        int finalI = i2;
        int finalJ = j2;
        return DataResult.error(() -> "Item stack with count of " + finalI + " was larger than maximum: " + finalJ);
    }

    public static Optional<ItemStack> a(HolderLookup.a registries, NBTBase nbt) {
        return b.parse(registries.a(DynamicOpsNBT.a), (Object)nbt).resultOrPartial(s2 -> m.error("Tried to load invalid item: '{}'", s2));
    }

    public static ItemStack a(HolderLookup.a registries, NBTTagCompound nbt) {
        return nbt.g() ? l : ItemStack.a(registries, (NBTBase)nbt).orElse(l);
    }

    public boolean e() {
        return this == l || this.q == Items.a || this.o <= 0;
    }

    public boolean a(FeatureFlagSet enabledFeatures) {
        return this.e() || this.g().a(enabledFeatures);
    }

    public ItemStack a(int amount) {
        int j2 = Math.min(amount, this.H());
        ItemStack itemstack = this.c(j2);
        this.h(j2);
        return itemstack;
    }

    public ItemStack f() {
        if (this.e()) {
            return l;
        }
        ItemStack itemstack = this.s();
        this.e(0);
        return itemstack;
    }

    public Item g() {
        return this.e() ? Items.a : this.q;
    }

    public Holder<Item> h() {
        return this.g().o();
    }

    public boolean a(TagKey<Item> tag) {
        return this.g().o().a(tag);
    }

    public boolean a(Item item) {
        return this.g() == item;
    }

    public boolean a(Predicate<Holder<Item>> predicate) {
        return predicate.test(this.g().o());
    }

    public boolean a(Holder<Item> itemEntry) {
        return this.g().o() == itemEntry;
    }

    public boolean a(HolderSet<Item> registryEntryList) {
        return registryEntryList.a(this.h());
    }

    public Stream<TagKey<Item>> i() {
        return this.g().o().c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumInteractionResult a(ItemActionContext context) {
        EnumInteractionResult enuminteractionresult;
        EntityHuman entityhuman = context.o();
        BlockPosition blockposition = context.a();
        if (entityhuman != null && !entityhuman.fZ().e && !this.a(new ShapeDetectorBlock(context.q(), blockposition, false))) {
            return EnumInteractionResult.e;
        }
        Item item = this.g();
        DataComponentPatch oldData = this.r.f();
        int oldCount = this.H();
        WorldServer world = (WorldServer)context.q();
        if (!(item instanceof ItemBucket)) {
            world.captureBlockStates = true;
            if (item == Items.ry) {
                world.captureTreeGeneration = true;
            }
        }
        try {
            enuminteractionresult = item.a(context);
        }
        finally {
            world.captureBlockStates = false;
        }
        DataComponentPatch newData = this.r.f();
        int newCount = this.H();
        this.e(oldCount);
        this.restorePatch(oldData);
        if (enuminteractionresult.a() && world.captureTreeGeneration && world.capturedBlockStates.size() > 0) {
            world.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit(blockposition, (World)world.getWorld());
            TreeType treeType = BlockSapling.treeType;
            BlockSapling.treeType = null;
            ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                boolean isBonemeal = this.g() == Items.ry;
                structureEvent = new StructureGrowEvent(location, treeType, isBonemeal, (Player)entityhuman.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), (Player)entityhuman.getBukkitEntity(), blocks);
            fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
            if (!fertilizeEvent.isCancelled()) {
                if (this.H() == oldCount && Objects.equals(this.r.f(), oldData)) {
                    this.restorePatch(newData);
                    this.e(newCount);
                }
                for (CraftBlockState blockstate : blocks) {
                    CapturedBlockState.setBlockState(blockstate);
                    world.checkCapturedTreeStateForObserverNotify(blockposition, blockstate);
                }
                entityhuman.b(StatisticList.c.b(item));
            }
            ItemSign.openSign = null;
            return enuminteractionresult;
        }
        world.captureTreeGeneration = false;
        if (entityhuman != null && enuminteractionresult.c()) {
            EnumHand enumhand = context.p();
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(world, entityhuman, enumhand, blocks, blockposition.u(), blockposition.v(), blockposition.w());
            } else if (blocks.size() == 1 && item != Items.qB) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(world, entityhuman, enumhand, (BlockState)blocks.get(0), blockposition.u(), blockposition.v(), blockposition.w());
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                enuminteractionresult = EnumInteractionResult.f;
                placeEvent.getPlayer().updateInventory();
                world.capturedTileEntities.clear();
                world.preventPoiUpdated = true;
                world.isBlockPlaceCancelled = true;
                for (BlockState blockstate : blocks) {
                    blockstate.update(true, false);
                }
                world.isBlockPlaceCancelled = false;
                world.preventPoiUpdated = false;
                ItemSign.openSign = null;
            } else {
                BlockPosition position;
                IBlockData blockData;
                TileEntity te;
                if (this.H() == oldCount && Objects.equals(this.r.f(), oldData)) {
                    this.restorePatch(newData);
                    this.e(newCount);
                }
                for (Map.Entry<BlockPosition, TileEntity> e2 : world.capturedTileEntities.entrySet()) {
                    world.a(e2.getValue());
                }
                for (BlockState blockstate : blocks) {
                    int updateFlag = ((CraftBlockState)blockstate).getFlag();
                    IBlockData oldBlock = ((CraftBlockState)blockstate).getHandle();
                    BlockPosition newblockposition = ((CraftBlockState)blockstate).getPosition();
                    IBlockData block = world.a_(newblockposition);
                    if (!(block.b() instanceof BlockTileEntity)) {
                        block.onPlace(world, newblockposition, oldBlock, true, context);
                    }
                    world.notifyAndUpdatePhysics(newblockposition, null, oldBlock, block, world.a_(newblockposition), updateFlag, 512);
                }
                if (this.q == Items.um) {
                    BlockPosition bp = blockposition;
                    if (!world.a_(blockposition).r()) {
                        bp = !world.a_(blockposition).e() ? null : bp.a(context.k());
                    }
                    if (bp != null && (te = world.c_(bp)) instanceof TileEntitySkull) {
                        BlockWitherSkull.a((net.minecraft.world.level.World)world, bp, (TileEntitySkull)te);
                    }
                }
                if (this.q instanceof ItemSign && ItemSign.openSign != null) {
                    try {
                        te = world.c_(ItemSign.openSign);
                        if (te instanceof TileEntitySign) {
                            TileEntitySign tileentitysign = (TileEntitySign)te;
                            Block updateFlag = world.a_(ItemSign.openSign).b();
                            if (updateFlag instanceof BlockSign) {
                                BlockSign blocksign = (BlockSign)updateFlag;
                                blocksign.openTextEdit(entityhuman, tileentitysign, true, PlayerOpenSignEvent.Cause.PLACE);
                            }
                        }
                    }
                    finally {
                        ItemSign.openSign = null;
                    }
                }
                if (placeEvent != null && this.q instanceof ItemBed && (blockData = world.a_(position = ((CraftBlock)placeEvent.getBlock()).getPosition())).b() instanceof BlockBed) {
                    world.b(position, Blocks.a);
                    blockData.a((GeneratorAccess)world, position, 3);
                }
                if (this.q instanceof ItemBlock) {
                    position = new BlockActionContext(context).a();
                    blockData = world.a_(position);
                    SoundEffectType soundeffecttype = blockData.w();
                    world.a(entityhuman, blockposition, soundeffecttype.e(), SoundCategory.e, (soundeffecttype.a() + 1.0f) / 2.0f, soundeffecttype.b() * 0.8f);
                }
                entityhuman.b(StatisticList.c.b(item));
            }
        }
        world.capturedTileEntities.clear();
        world.capturedBlockStates.clear();
        return enuminteractionresult;
    }

    public float a(IBlockData state) {
        return this.g().a(this, state);
    }

    public InteractionResultWrapper<ItemStack> a(net.minecraft.world.level.World world, EntityHuman user, EnumHand hand) {
        return this.g().a(world, user, hand);
    }

    public ItemStack a(net.minecraft.world.level.World world, EntityLiving user) {
        return this.g().a(this, world, user);
    }

    public NBTBase b(HolderLookup.a registries, NBTBase prefix) {
        if (this.e()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)b.encode((Object)this, registries.a(DynamicOpsNBT.a), (Object)prefix).getOrThrow();
    }

    public NBTBase a(HolderLookup.a registries) {
        if (this.e()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)b.encodeStart(registries.a(DynamicOpsNBT.a), (Object)this).getOrThrow();
    }

    public NBTBase b(HolderLookup.a registries) {
        return this.e() ? new NBTTagCompound() : this.b(registries, new NBTTagCompound());
    }

    public int j() {
        return this.a(DataComponents.c, Integer.valueOf(1));
    }

    public boolean k() {
        return this.j() > 1 && (!this.l() || !this.m());
    }

    public boolean l() {
        return this.b(DataComponents.d) && !this.b(DataComponents.f) && this.b(DataComponents.e);
    }

    public boolean m() {
        return this.l() && this.n() > 0;
    }

    public int n() {
        return MathHelper.a((int)this.a(DataComponents.e, Integer.valueOf(0)), 0, this.o());
    }

    public void b(int damage) {
        this.b(DataComponents.e, Integer.valueOf(MathHelper.a(damage, 0, this.o())));
    }

    public int o() {
        return this.a(DataComponents.d, Integer.valueOf(0));
    }

    public void hurtAndBreak(int amount, WorldServer world, @Nullable EntityLiving player, Consumer<Item> breakCallback) {
        this.hurtAndBreak(amount, world, player, breakCallback, false);
    }

    public void hurtAndBreak(int amount, WorldServer world, @Nullable EntityLiving player, Consumer<Item> breakCallback, boolean force) {
        if (this.l() && (player == null || !player.fL() || force)) {
            if (amount > 0) {
                int originalDamage = amount;
                amount = EnchantmentManager.a(world, this, amount);
                if (player instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)player;
                    PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), amount, originalDamage);
                    event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
                    if (amount != event.getDamage() || event.isCancelled()) {
                        event.getPlayer().updateInventory();
                    }
                    if (event.isCancelled()) {
                        return;
                    }
                    amount = event.getDamage();
                } else if (player != null) {
                    EntityDamageItemEvent event = new EntityDamageItemEvent((Entity)player.getBukkitLivingEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), amount);
                    if (!event.callEvent()) {
                        return;
                    }
                    amount = event.getDamage();
                }
                if (amount <= 0) {
                    return;
                }
            }
            if (player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                if (amount != 0) {
                    CriterionTriggers.u.a(serverPlayer, this, this.n() + amount);
                }
            }
            int j2 = this.n() + amount;
            this.b(j2);
            if (j2 >= this.o()) {
                Item item = this.g();
                this.h(1);
                breakCallback.accept(item);
            }
        }
    }

    public void a(int amount, EntityLiving entity, EnumItemSlot slot) {
        this.hurtAndBreak(amount, entity, slot, false);
    }

    public void hurtAndBreak(int amount, EntityLiving entity, EnumItemSlot slot, boolean force) {
        net.minecraft.world.level.World world = entity.dO();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer1;
                EntityPlayer entityplayer = entityplayer1 = (EntityPlayer)entity;
            } else {
                Object entityplayer = null;
            }
            this.hurtAndBreak(amount, worldserver, entity, item -> {
                if (this.o == 1 && entity instanceof EntityHuman) {
                    CraftEventFactory.callPlayerItemBreakEvent((EntityHuman)entity, this);
                }
                entity.a((Item)item, slot);
            }, force);
        }
    }

    public ItemStack a(int amount, IMaterial itemAfterBreaking, EntityLiving entity, EnumItemSlot slot) {
        this.a(amount, entity, slot);
        if (this.e()) {
            ItemStack itemstack = this.b(itemAfterBreaking, 1);
            if (itemstack.l()) {
                itemstack.b(0);
            }
            return itemstack;
        }
        return this;
    }

    public boolean p() {
        return this.g().d(this);
    }

    public int q() {
        return this.g().e(this);
    }

    public int r() {
        return this.g().f(this);
    }

    public boolean a(Slot slot, ClickAction clickType, EntityHuman player) {
        return this.g().a(this, slot, clickType, player);
    }

    public boolean a(ItemStack stack, Slot slot, ClickAction clickType, EntityHuman player, SlotAccess cursorStackReference) {
        return this.g().a(this, stack, slot, clickType, player, cursorStackReference);
    }

    public boolean a(EntityLiving target, EntityHuman player) {
        Item item = this.g();
        if (item.a(this, target, (EntityLiving)player)) {
            player.b(StatisticList.c.b(item));
            return true;
        }
        return false;
    }

    public void b(EntityLiving target, EntityHuman player) {
        this.g().b(this, target, (EntityLiving)player);
    }

    public void a(net.minecraft.world.level.World world, IBlockData state, BlockPosition pos, EntityHuman miner) {
        Item item = this.g();
        if (item.a(this, world, state, pos, miner)) {
            miner.b(StatisticList.c.b(item));
        }
    }

    public boolean b(IBlockData state) {
        return this.g().b(this, state);
    }

    public EnumInteractionResult a(EntityHuman user, EntityLiving entity, EnumHand hand) {
        return this.g().a(this, user, entity, hand);
    }

    public ItemStack s() {
        return this.copy(false);
    }

    public ItemStack copy(boolean originalItem) {
        if (!originalItem && this.e()) {
            return l;
        }
        ItemStack itemstack = new ItemStack(originalItem ? this.q : this.g(), this.o, this.r.g());
        itemstack.d(this.G());
        return itemstack;
    }

    public ItemStack c(int count) {
        if (this.e()) {
            return l;
        }
        ItemStack itemstack = this.s();
        itemstack.e(count);
        return itemstack;
    }

    public ItemStack a(IMaterial item) {
        return this.a(item, this.H());
    }

    public ItemStack a(IMaterial item, int count) {
        return this.e() ? l : this.b(item, count);
    }

    private ItemStack b(IMaterial item, int count) {
        return new ItemStack(item.r().o(), count, this.r.f());
    }

    public static boolean a(ItemStack left, ItemStack right) {
        return left == right ? true : (left.H() != right.H() ? false : ItemStack.c(left, right));
    }

    @Deprecated
    public static boolean a(List<ItemStack> left, List<ItemStack> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (int i2 = 0; i2 < left.size(); ++i2) {
            if (ItemStack.a(left.get(i2), right.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean b(ItemStack left, ItemStack right) {
        return left.a(right.g());
    }

    public static boolean c(ItemStack stack, ItemStack otherStack) {
        return !stack.a(otherStack.g()) ? false : (stack.e() && otherStack.e() ? true : Objects.equals(stack.r, otherStack.r));
    }

    public static MapCodec<ItemStack> a(String fieldName) {
        return b.lenientOptionalFieldOf(fieldName).xmap(optional -> optional.orElse(l), itemstack -> itemstack.e() ? Optional.empty() : Optional.of(itemstack));
    }

    public static int a(@Nullable ItemStack stack) {
        if (stack != null) {
            int i2 = 31 + stack.g().hashCode();
            return 31 * i2 + stack.a().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int a(List<ItemStack> stacks) {
        int i2 = 0;
        for (ItemStack itemstack : stacks) {
            i2 = i2 * 31 + ItemStack.a(itemstack);
        }
        return i2;
    }

    public String t() {
        return this.g().h(this);
    }

    public String toString() {
        int i2 = this.H();
        return i2 + " " + String.valueOf(this.g());
    }

    public void a(net.minecraft.world.level.World world, net.minecraft.world.entity.Entity entity, int slot, boolean selected) {
        if (this.p > 0) {
            --this.p;
        }
        if (this.g() != null) {
            this.g().a(this, world, entity, slot, selected);
        }
    }

    public void a(net.minecraft.world.level.World world, EntityHuman player, int amount) {
        player.a(StatisticList.b.b(this.g()), amount);
        this.g().b(this, world, player);
    }

    public void a(net.minecraft.world.level.World world) {
        this.g().a(this, world);
    }

    public int a(EntityLiving user) {
        return this.g().a(this, user);
    }

    public EnumAnimation u() {
        return this.g().b(this);
    }

    public void a(net.minecraft.world.level.World world, EntityLiving user, int remainingUseTicks) {
        this.g().a(this, world, user, remainingUseTicks);
    }

    public boolean v() {
        return this.g().l(this);
    }

    public void restorePatch(DataComponentPatch datacomponentpatch) {
        this.r.b(datacomponentpatch);
    }

    @Nullable
    public <T> T b(DataComponentType<? super T> type, @Nullable T value) {
        return this.r.b(type, value);
    }

    @Nullable
    public <T, U> T a(DataComponentType<T> type, T defaultValue, U change, BiFunction<T, U, T> applier) {
        return this.b(type, applier.apply(this.a(type, defaultValue), change));
    }

    @Nullable
    public <T> T a(DataComponentType<T> type, T defaultValue, UnaryOperator<T> applier) {
        T t1 = this.a(type, defaultValue);
        return this.b(type, applier.apply(t1));
    }

    @Nullable
    public <T> T c(DataComponentType<? extends T> type) {
        return this.r.d(type);
    }

    public void a(DataComponentPatch changes) {
        DataComponentPatch datacomponentpatch1 = this.r.f();
        this.r.a(changes);
        Optional optional = ItemStack.b(this).error();
        if (optional.isPresent()) {
            m.error("Failed to apply component patch '{}' to item: '{}'", (Object)changes, (Object)((DataResult.Error)optional.get()).message());
            this.r.b(datacomponentpatch1);
        } else {
            this.g().m(this);
        }
    }

    public org.bukkit.inventory.ItemStack asBukkitMirror() {
        return CraftItemStack.asCraftMirror(this);
    }

    public org.bukkit.inventory.ItemStack asBukkitCopy() {
        return CraftItemStack.asCraftMirror(this.s());
    }

    public static ItemStack fromBukkitCopy(org.bukkit.inventory.ItemStack itemstack) {
        return CraftItemStack.asNMSCopy(itemstack);
    }

    public org.bukkit.inventory.ItemStack getBukkitStack() {
        if (this.bukkitStack == null || this.bukkitStack.handle != this) {
            this.bukkitStack = CraftItemStack.asCraftMirror(this);
        }
        return this.bukkitStack;
    }

    public void b(DataComponentPatch changes) {
        this.r.a(changes);
        this.g().m(this);
    }

    public void b(DataComponentMap components) {
        this.r.a(components);
        this.g().m(this);
    }

    public IChatBaseComponent w() {
        IChatBaseComponent ichatbasecomponent = this.a(DataComponents.g);
        if (ichatbasecomponent != null) {
            return ichatbasecomponent;
        }
        IChatBaseComponent ichatbasecomponent1 = this.a(DataComponents.h);
        return ichatbasecomponent1 != null ? ichatbasecomponent1 : this.g().n(this);
    }

    private <T extends TooltipProvider> void a(DataComponentType<T> componentType, Item.b context, Consumer<IChatBaseComponent> textConsumer, TooltipFlag type) {
        TooltipProvider t0 = (TooltipProvider)this.a(componentType);
        if (t0 != null) {
            t0.a(context, textConsumer, type);
        }
    }

    public List<IChatBaseComponent> a(Item.b context, @Nullable EntityHuman player, TooltipFlag type) {
        AdventureModePredicate adventuremodepredicate1;
        MapId mapid;
        if (!type.b() && this.b(DataComponents.q)) {
            return List.of();
        }
        ArrayList list = Lists.newArrayList();
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.i().b(this.w()).a(this.y().a());
        if (this.b(DataComponents.g)) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        list.add(ichatmutablecomponent);
        if (!type.a() && !this.b(DataComponents.g) && this.a(Items.rU) && (mapid = this.a(DataComponents.B)) != null) {
            list.add(ItemWorldMap.a(mapid));
        }
        Objects.requireNonNull(list);
        Consumer<IChatBaseComponent> consumer = list::add;
        if (!this.b(DataComponents.p)) {
            this.g().a(this, context, list, type);
        }
        this.a(DataComponents.R, context, consumer, type);
        this.a(DataComponents.K, context, consumer, type);
        this.a(DataComponents.y, context, consumer, type);
        this.a(DataComponents.k, context, consumer, type);
        this.a(DataComponents.z, context, consumer, type);
        this.a(DataComponents.i, context, consumer, type);
        this.a(consumer, player);
        this.a(DataComponents.f, context, consumer, type);
        AdventureModePredicate adventuremodepredicate = this.a(DataComponents.m);
        if (adventuremodepredicate != null && adventuremodepredicate.a()) {
            consumer.accept(CommonComponents.a);
            consumer.accept(AdventureModePredicate.c);
            adventuremodepredicate.a(consumer);
        }
        if ((adventuremodepredicate1 = this.a(DataComponents.l)) != null && adventuremodepredicate1.a()) {
            consumer.accept(CommonComponents.a);
            consumer.accept(AdventureModePredicate.d);
            adventuremodepredicate1.a(consumer);
        }
        if (type.a()) {
            if (this.m()) {
                list.add(IChatBaseComponent.a("item.durability", this.o() - this.n(), this.o()));
            }
            list.add(IChatBaseComponent.b(BuiltInRegistries.g.b(this.g()).toString()).a(EnumChatFormat.i));
            int i2 = this.r.d();
            if (i2 > 0) {
                list.add(IChatBaseComponent.a("item.components", i2).a(EnumChatFormat.i));
            }
        }
        if (player != null && !this.g().a(player.dO().J())) {
            list.add(n);
        }
        return list;
    }

    private void a(Consumer<IChatBaseComponent> textConsumer, @Nullable EntityHuman player) {
        ItemAttributeModifiers itemattributemodifiers = this.a(DataComponents.n, ItemAttributeModifiers.a);
        if (itemattributemodifiers.c()) {
            for (EquipmentSlotGroup equipmentslotgroup : EquipmentSlotGroup.values()) {
                MutableBoolean mutableboolean = new MutableBoolean(true);
                this.a(equipmentslotgroup, (Holder<AttributeBase> holder, AttributeModifier attributemodifier) -> {
                    if (mutableboolean.isTrue()) {
                        textConsumer.accept(CommonComponents.a);
                        textConsumer.accept(IChatBaseComponent.c("item.modifiers." + equipmentslotgroup.c()).a(EnumChatFormat.h));
                        mutableboolean.setFalse();
                    }
                    this.a(textConsumer, player, (Holder<AttributeBase>)holder, (AttributeModifier)attributemodifier);
                });
            }
        }
    }

    private void a(Consumer<IChatBaseComponent> textConsumer, @Nullable EntityHuman player, Holder<AttributeBase> attribute, AttributeModifier modifier) {
        double d0 = modifier.c();
        boolean flag = false;
        if (player != null) {
            if (modifier.a(Item.e)) {
                d0 += player.h(GenericAttributes.c);
                flag = true;
            } else if (modifier.a(Item.f)) {
                d0 += player.h(GenericAttributes.e);
                flag = true;
            }
        }
        double d1 = modifier.d() != AttributeModifier.Operation.b && modifier.d() != AttributeModifier.Operation.c ? (attribute.a(GenericAttributes.p) ? d0 * 10.0 : d0) : d0 * 100.0;
        if (flag) {
            textConsumer.accept(CommonComponents.a().b(IChatBaseComponent.a("attribute.modifier.equals." + modifier.d().a(), new Object[]{ItemAttributeModifiers.d.format(d1), IChatBaseComponent.c(attribute.a().c())})).a(EnumChatFormat.c));
        } else if (d0 > 0.0) {
            textConsumer.accept(IChatBaseComponent.a("attribute.modifier.plus." + modifier.d().a(), new Object[]{ItemAttributeModifiers.d.format(d1), IChatBaseComponent.c(attribute.a().c())}).a(attribute.a().b(true)));
        } else if (d0 < 0.0) {
            textConsumer.accept(IChatBaseComponent.a("attribute.modifier.take." + modifier.d().a(), new Object[]{ItemAttributeModifiers.d.format(-d1), IChatBaseComponent.c(attribute.a().c())}).a(attribute.a().b(false)));
        }
    }

    public boolean x() {
        Boolean obool = this.a(DataComponents.t);
        return obool != null ? obool.booleanValue() : this.g().d_(this);
    }

    public EnumItemRarity y() {
        EnumItemRarity enumitemrarity = this.a(DataComponents.j, EnumItemRarity.a);
        if (!this.A()) {
            return enumitemrarity;
        }
        return switch (enumitemrarity) {
            case EnumItemRarity.a, EnumItemRarity.b -> EnumItemRarity.c;
            case EnumItemRarity.c -> EnumItemRarity.d;
            default -> enumitemrarity;
        };
    }

    public boolean z() {
        if (!this.g().a(this)) {
            return false;
        }
        ItemEnchantments itemenchantments = this.a(DataComponents.k);
        return itemenchantments != null && itemenchantments.d();
    }

    public void a(Holder<Enchantment> enchantment, int level) {
        EnchantmentManager.a(this, (ItemEnchantments.a itemenchantments_a) -> itemenchantments_a.b(enchantment, level));
    }

    public boolean A() {
        return !this.a(DataComponents.k, ItemEnchantments.a).d();
    }

    public ItemEnchantments B() {
        return this.a(DataComponents.k, ItemEnchantments.a);
    }

    public boolean C() {
        return this.s instanceof EntityItemFrame;
    }

    public void a(@Nullable net.minecraft.world.entity.Entity holder) {
        if (!this.e()) {
            this.s = holder;
        }
    }

    @Nullable
    public EntityItemFrame D() {
        return this.s instanceof EntityItemFrame ? (EntityItemFrame)this.E() : null;
    }

    @Nullable
    public net.minecraft.world.entity.Entity E() {
        return !this.e() ? this.s : null;
    }

    public void a(EquipmentSlotGroup slot, BiConsumer<Holder<AttributeBase>, AttributeModifier> attributeModifierConsumer) {
        ItemAttributeModifiers itemattributemodifiers = this.a(DataComponents.n, ItemAttributeModifiers.a);
        if (!itemattributemodifiers.b().isEmpty()) {
            itemattributemodifiers.a(slot, attributeModifierConsumer);
        } else {
            this.g().j().a(slot, attributeModifierConsumer);
        }
        EnchantmentManager.a(this, slot, attributeModifierConsumer);
    }

    public void a(EnumItemSlot slot, BiConsumer<Holder<AttributeBase>, AttributeModifier> attributeModifierConsumer) {
        ItemAttributeModifiers itemattributemodifiers = this.a(DataComponents.n, ItemAttributeModifiers.a);
        if (!itemattributemodifiers.b().isEmpty()) {
            itemattributemodifiers.a(slot, attributeModifierConsumer);
        } else {
            this.g().j().a(slot, attributeModifierConsumer);
        }
        EnchantmentManager.a(this, slot, attributeModifierConsumer);
    }

    @Deprecated
    public void setItem(Item item) {
        this.bukkitStack = null;
        this.q = item;
        DataComponentPatch patch = this.d();
        this.r = new PatchedDataComponentMap(this.q.p());
        this.b(patch);
    }

    public IChatBaseComponent F() {
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.i().b(this.w());
        if (this.b(DataComponents.g)) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        IChatMutableComponent ichatmutablecomponent1 = ChatComponentUtils.a(ichatmutablecomponent);
        if (!this.e()) {
            ichatmutablecomponent1.a(this.y().a()).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.b, new ChatHoverable.c(this))));
        }
        return ichatmutablecomponent1;
    }

    public boolean a(ShapeDetectorBlock pos) {
        AdventureModePredicate adventuremodepredicate = this.a(DataComponents.l);
        return adventuremodepredicate != null && adventuremodepredicate.a(pos);
    }

    public boolean b(ShapeDetectorBlock pos) {
        AdventureModePredicate adventuremodepredicate = this.a(DataComponents.m);
        return adventuremodepredicate != null && adventuremodepredicate.a(pos);
    }

    public int G() {
        return this.p;
    }

    public void d(int bobbingAnimationTime) {
        this.p = bobbingAnimationTime;
    }

    public int H() {
        return this.e() ? 0 : this.o;
    }

    public void e(int count) {
        this.o = count;
    }

    public void f(int maxCount) {
        if (!this.e() && this.H() > maxCount) {
            this.e(maxCount);
        }
    }

    public void g(int amount) {
        this.e(this.H() + amount);
    }

    public void h(int amount) {
        this.g(-amount);
    }

    public void a(int amount, @Nullable EntityLiving entity) {
        if (!(entity != null && entity.fL() || this == l)) {
            this.h(amount);
        }
    }

    public ItemStack b(int amount, @Nullable EntityLiving entity) {
        ItemStack itemstack = this.c(amount);
        this.a(amount, entity);
        return itemstack;
    }

    public void b(net.minecraft.world.level.World world, EntityLiving user, int remainingUseTicks) {
        this.g().a(world, user, this, remainingUseTicks);
    }

    public void a(EntityItem entity) {
        this.g().a(entity);
    }

    public SoundEffect I() {
        return this.g().ap_();
    }

    public SoundEffect J() {
        return this.g().aq_();
    }

    public SoundEffect K() {
        return this.g().e();
    }

    public boolean a(DamageSource source) {
        return !this.b(DataComponents.w) || !source.a(DamageTypeTags.i);
    }
}

