/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.World;
import org.apache.commons.lang3.math.Fraction;

public class BundleItem
extends Item {
    private static final int a = MathHelper.f(0.4f, 0.4f, 1.0f);
    private static final int b = 64;

    public BundleItem(Item.Info settings) {
        super(settings);
    }

    public static float c(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.F, BundleContents.a);
        return bundleContents.e().floatValue();
    }

    @Override
    @Override
    public boolean a(ItemStack stack, Slot slot, ClickAction clickType, EntityHuman player) {
        int i2;
        if (clickType != ClickAction.b) {
            return false;
        }
        BundleContents bundleContents = stack.a(DataComponents.F);
        if (bundleContents == null) {
            return false;
        }
        ItemStack itemStack = slot.g();
        BundleContents.a mutable = new BundleContents.a(bundleContents);
        if (itemStack.e()) {
            this.a(player);
            ItemStack itemStack2 = mutable.b();
            if (itemStack2 != null) {
                ItemStack itemStack3 = slot.d(itemStack2);
                mutable.a(itemStack3);
            }
        } else if (itemStack.g().ar_() && (i2 = mutable.a(slot, player)) > 0) {
            this.b(player);
        }
        stack.b(DataComponents.F, mutable.d());
        return true;
    }

    @Override
    @Override
    public boolean a(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, EntityHuman player, SlotAccess cursorStackReference) {
        if (clickType != ClickAction.b || !slot.b(player)) {
            return false;
        }
        BundleContents bundleContents = stack.a(DataComponents.F);
        if (bundleContents == null) {
            return false;
        }
        BundleContents.a mutable = new BundleContents.a(bundleContents);
        if (otherStack.e()) {
            ItemStack itemStack = mutable.b();
            if (itemStack != null) {
                this.a(player);
                cursorStackReference.a(itemStack);
            }
        } else {
            int i2 = mutable.a(otherStack);
            if (i2 > 0) {
                this.b(player);
            }
        }
        stack.b(DataComponents.F, mutable.d());
        return true;
    }

    @Override
    @Override
    public InteractionResultWrapper<ItemStack> a(World world, EntityHuman user, EnumHand hand) {
        ItemStack itemStack = user.b(hand);
        if (BundleItem.a(itemStack, user)) {
            this.c(user);
            user.b(StatisticList.c.b(this));
            return InteractionResultWrapper.a(itemStack, world.x_());
        }
        return InteractionResultWrapper.d(itemStack);
    }

    @Override
    @Override
    public boolean d(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.F, BundleContents.a);
        return bundleContents.e().compareTo(Fraction.ZERO) > 0;
    }

    @Override
    @Override
    public int e(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.F, BundleContents.a);
        return Math.min(1 + MathHelper.a(bundleContents.e(), 12), 13);
    }

    @Override
    @Override
    public int f(ItemStack stack) {
        return a;
    }

    private static boolean a(ItemStack stack2, EntityHuman player) {
        BundleContents bundleContents = stack2.a(DataComponents.F);
        if (bundleContents == null || bundleContents.f()) {
            return false;
        }
        stack2.b(DataComponents.F, BundleContents.a);
        if (player instanceof EntityPlayer) {
            bundleContents.c().forEach(stack -> player.a((ItemStack)stack, true));
        }
        return true;
    }

    @Override
    @Override
    public Optional<TooltipComponent> g(ItemStack stack) {
        if (stack.b(DataComponents.q) || stack.b(DataComponents.p)) {
            return Optional.empty();
        }
        return Optional.ofNullable(stack.a(DataComponents.F)).map(BundleTooltip::new);
    }

    @Override
    @Override
    public void a(ItemStack stack, Item.b context, List<IChatBaseComponent> tooltip, TooltipFlag type) {
        BundleContents bundleContents = stack.a(DataComponents.F);
        if (bundleContents != null) {
            int i2 = MathHelper.a(bundleContents.e(), 64);
            tooltip.add(IChatBaseComponent.a("item.minecraft.bundle.fullness", i2, 64).a(EnumChatFormat.h));
        }
    }

    @Override
    @Override
    public void a(EntityItem entity) {
        BundleContents bundleContents = entity.p().a(DataComponents.F);
        if (bundleContents == null) {
            return;
        }
        entity.p().b(DataComponents.F, BundleContents.a);
        ItemLiquidUtil.a(entity, bundleContents.c());
    }

    private void a(Entity entity) {
        entity.a(SoundEffects.dq, 0.8f, 0.8f + entity.dO().E_().i() * 0.4f);
    }

    private void b(Entity entity) {
        entity.a(SoundEffects.dp, 0.8f, 0.8f + entity.dO().E_().i() * 0.4f);
    }

    private void c(Entity entity) {
        entity.a(SoundEffects.do, 0.8f, 0.8f + entity.dO().E_().i() * 0.4f);
    }
}

