/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import io.papermc.paper.event.player.PlayerLoomPatternSelectEvent;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BannerPatternTags;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemBannerPattern;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import org.bukkit.Location;
import org.bukkit.Registry;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryLoom;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.LoomInventory;
import org.slf4j.Logger;

public class ContainerLoom
extends Container {
    private CraftInventoryView bukkitEntity = null;
    private Player player;
    private static final int k = -1;
    private static final int l = 4;
    private static final int m = 31;
    private static final int n = 31;
    private static final int o = 40;
    private final ContainerAccess p;
    final ContainerProperty q = ContainerProperty.a();
    private List<Holder<EnumBannerPatternType>> r = List.of();
    Runnable s = () -> {};
    private final HolderGetter<EnumBannerPatternType> t;
    final Slot u;
    final Slot v;
    private final Slot w;
    private final Slot x;
    long y;
    private final IInventory z;
    private final IInventory A;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean PRINTED_PATTERN_TYPE_NAG = false;

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryLoom inventory = new CraftInventoryLoom(this.z, this.A);
        this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public ContainerLoom(int syncId, PlayerInventory playerInventory) {
        this(syncId, playerInventory, ContainerAccess.a);
    }

    public ContainerLoom(int syncId, PlayerInventory playerInventory, final ContainerAccess context) {
        super(Containers.s, syncId);
        int j2;
        this.z = new InventorySubcontainer(this.createBlockHolder(context), 3){

            @Override
            public void e() {
                super.e();
                ContainerLoom.this.a(this);
                ContainerLoom.this.s.run();
            }

            @Override
            public Location getLocation() {
                return context.getLocation();
            }
        };
        this.A = new InventorySubcontainer(this.createBlockHolder(context), 1){

            @Override
            public void e() {
                super.e();
                ContainerLoom.this.s.run();
            }

            @Override
            public Location getLocation() {
                return context.getLocation();
            }
        };
        this.p = context;
        this.u = this.a(new Slot(this, this.z, 0, 13, 26){

            @Override
            public boolean a(ItemStack stack) {
                return stack.g() instanceof ItemBanner;
            }
        });
        this.v = this.a(new Slot(this, this.z, 1, 33, 26){

            @Override
            public boolean a(ItemStack stack) {
                return stack.g() instanceof ItemDye;
            }
        });
        this.w = this.a(new Slot(this, this.z, 2, 23, 45){

            @Override
            public boolean a(ItemStack stack) {
                return stack.g() instanceof ItemBannerPattern;
            }
        });
        this.x = this.a(new Slot(this.A, 0, 143, 57){

            @Override
            public boolean a(ItemStack stack) {
                return false;
            }

            @Override
            public void a(EntityHuman player, ItemStack stack) {
                ContainerLoom.this.u.a(1);
                ContainerLoom.this.v.a(1);
                if (!ContainerLoom.this.u.h() || !ContainerLoom.this.v.h()) {
                    ContainerLoom.this.q.a(-1);
                }
                context.a((World world, BlockPosition blockposition) -> {
                    long j2 = world.Z();
                    if (ContainerLoom.this.y != j2) {
                        world.a((EntityHuman)null, (BlockPosition)blockposition, SoundEffects.At, SoundCategory.e, 1.0f, 1.0f);
                        ContainerLoom.this.y = j2;
                    }
                });
                super.a(player, stack);
            }
        });
        for (j2 = 0; j2 < 3; ++j2) {
            for (int k2 = 0; k2 < 9; ++k2) {
                this.a(new Slot(playerInventory, k2 + j2 * 9 + 9, 8 + k2 * 18, 84 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.a(new Slot(playerInventory, j2, 8 + j2 * 18, 142));
        }
        this.a(this.q);
        this.t = playerInventory.l.dQ().b(Registries.d);
        this.player = (Player)playerInventory.l.getBukkitEntity();
    }

    @Override
    public boolean b(EntityHuman player) {
        if (!this.checkReachable) {
            return true;
        }
        return ContainerLoom.a(this.p, player, Blocks.nT);
    }

    @Override
    public boolean a(EntityHuman player, int id) {
        if (id >= 0 && id < this.r.size()) {
            Optional patternType = CraftRegistry.unwrapAndConvertHolder(Registry.BANNER_PATTERN, this.r.get(id));
            if (patternType.isEmpty()) {
                if (!PRINTED_PATTERN_TYPE_NAG) {
                    LOGGER.warn("A datapack added a custom banner pattern, those are not supported yet in the API, skipping the PlayerLoomPatternSelectEvent for {}.", (Object)player.cB());
                    PRINTED_PATTERN_TYPE_NAG = true;
                }
                this.q.a(id);
                this.a(this.r.get(id));
                return true;
            }
            int selectablePatternIndex = id;
            PlayerLoomPatternSelectEvent event = new PlayerLoomPatternSelectEvent((Player)player.getBukkitEntity(), (LoomInventory)((CraftInventoryLoom)this.getBukkitView().getTopInventory()), (PatternType)patternType.get());
            if (!event.callEvent()) {
                player.cd.b();
                return false;
            }
            Holder<EnumBannerPatternType> eventPattern = CraftPatternType.bukkitToMinecraftHolder(event.getPatternType());
            Holder<EnumBannerPatternType> selectedPattern = null;
            for (int i2 = 0; i2 < this.r.size(); ++i2) {
                Holder<EnumBannerPatternType> holder = this.r.get(i2);
                if (!eventPattern.equals(holder)) continue;
                selectablePatternIndex = i2;
                selectedPattern = holder;
                break;
            }
            if (selectedPattern == null) {
                selectedPattern = eventPattern;
                selectablePatternIndex = -1;
            }
            player.cd.b();
            this.q.a(selectablePatternIndex);
            this.a(Objects.requireNonNull(selectedPattern, "selectedPattern was null, this is unexpected"));
            return true;
        }
        return false;
    }

    private List<Holder<EnumBannerPatternType>> c(ItemStack stack) {
        if (stack.e()) {
            return (List)this.t.a(BannerPatternTags.a).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        }
        Item item = stack.g();
        if (item instanceof ItemBannerPattern) {
            ItemBannerPattern itembannerpattern = (ItemBannerPattern)item;
            return (List)this.t.a(itembannerpattern.b()).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        }
        return List.of();
    }

    private boolean e(int index) {
        return index >= 0 && index < this.r.size();
    }

    @Override
    public void a(IInventory inventory) {
        ItemStack itemstack = this.u.g();
        ItemStack itemstack1 = this.v.g();
        ItemStack itemstack2 = this.w.g();
        if (!itemstack.e() && !itemstack1.e()) {
            Holder<EnumBannerPatternType> holder;
            int i2 = this.q.b();
            boolean flag = this.e(i2);
            List<Holder<EnumBannerPatternType>> list = this.r;
            this.r = this.c(itemstack2);
            if (this.r.size() == 1) {
                this.q.a(0);
                holder = this.r.get(0);
            } else if (!flag) {
                this.q.a(-1);
                holder = null;
            } else {
                Holder<EnumBannerPatternType> holder1 = list.get(i2);
                int j2 = this.r.indexOf(holder1);
                if (j2 != -1) {
                    holder = holder1;
                    this.q.a(j2);
                } else {
                    holder = null;
                    this.q.a(-1);
                }
            }
            if (holder != null) {
                boolean flag1;
                BannerPatternLayers bannerpatternlayers = itemstack.a(DataComponents.Y, BannerPatternLayers.a);
                boolean bl = flag1 = bannerpatternlayers.b().size() >= 6;
                if (flag1) {
                    this.q.a(-1);
                    this.x.f(ItemStack.l);
                } else {
                    this.a(holder);
                }
            } else {
                this.x.f(ItemStack.l);
            }
            CraftEventFactory.callPrepareResultEvent(this, 3);
        } else {
            this.x.f(ItemStack.l);
            this.r = List.of();
            this.q.a(-1);
        }
    }

    public List<Holder<EnumBannerPatternType>> l() {
        return this.r;
    }

    public int m() {
        return this.q.b();
    }

    public void a(Runnable inventoryChangeListener) {
        this.s = inventoryChangeListener;
    }

    @Override
    public ItemStack b(EntityHuman player, int slot) {
        ItemStack itemstack = ItemStack.l;
        Slot slot1 = this.i.get(slot);
        if (slot1 != null && slot1.h()) {
            ItemStack itemstack1 = slot1.g();
            itemstack = itemstack1.s();
            if (slot == this.x.d) {
                if (!this.a(itemstack1, 4, 40, true)) {
                    return ItemStack.l;
                }
                slot1.b(itemstack1, itemstack);
            } else if (slot != this.v.d && slot != this.u.d && slot != this.w.d ? (itemstack1.g() instanceof ItemBanner ? !this.a(itemstack1, this.u.d, this.u.d + 1, false) : (itemstack1.g() instanceof ItemDye ? !this.a(itemstack1, this.v.d, this.v.d + 1, false) : (itemstack1.g() instanceof ItemBannerPattern ? !this.a(itemstack1, this.w.d, this.w.d + 1, false) : (slot >= 4 && slot < 31 ? !this.a(itemstack1, 31, 40, false) : slot >= 31 && slot < 40 && !this.a(itemstack1, 4, 31, false))))) : !this.a(itemstack1, 4, 40, false)) {
                return ItemStack.l;
            }
            if (itemstack1.e()) {
                slot1.e(ItemStack.l);
            } else {
                slot1.c();
            }
            if (itemstack1.H() == itemstack.H()) {
                return ItemStack.l;
            }
            slot1.a(player, itemstack1);
        }
        return itemstack;
    }

    @Override
    public void a(EntityHuman player) {
        super.a(player);
        this.p.a((World world, BlockPosition blockposition) -> this.a(player, this.z));
    }

    private void a(Holder<EnumBannerPatternType> pattern) {
        ItemStack itemstack = this.u.g();
        ItemStack itemstack1 = this.v.g();
        ItemStack itemstack2 = ItemStack.l;
        if (!itemstack.e() && !itemstack1.e()) {
            itemstack2 = itemstack.c(1);
            EnumColor enumcolor = ((ItemDye)itemstack1.g()).c();
            itemstack2.a(DataComponents.Y, BannerPatternLayers.a, bannerpatternlayers -> {
                if (bannerpatternlayers.b().size() > 20) {
                    bannerpatternlayers = new BannerPatternLayers(List.copyOf(bannerpatternlayers.b().subList(0, 20)));
                }
                return new BannerPatternLayers.a().a((BannerPatternLayers)bannerpatternlayers).a(pattern, enumcolor).a();
            });
        }
        if (!ItemStack.a(itemstack2, this.x.g())) {
            this.x.f(itemstack2);
        }
    }

    public Slot n() {
        return this.u;
    }

    public Slot o() {
        return this.v;
    }

    public Slot p() {
        return this.w;
    }

    public Slot q() {
        return this.x;
    }
}

