/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockEnchantmentTable;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class ContainerEnchantTable
extends Container {
    static final MinecraftKey n = MinecraftKey.b("item/empty_slot_lapis_lazuli");
    private final IInventory o;
    private final ContainerAccess p;
    private final RandomSource q;
    private final ContainerProperty r;
    public final int[] k;
    public final int[] l;
    public final int[] m;
    private CraftInventoryView bukkitEntity = null;
    private Player player;

    public ContainerEnchantTable(int syncId, PlayerInventory playerInventory) {
        this(syncId, playerInventory, ContainerAccess.a);
    }

    public ContainerEnchantTable(int syncId, PlayerInventory playerInventory, final ContainerAccess context) {
        super(Containers.n, syncId);
        int j2;
        this.o = new InventorySubcontainer(this.createBlockHolder(context), 2){

            @Override
            public void e() {
                super.e();
                ContainerEnchantTable.this.a(this);
            }

            @Override
            public Location getLocation() {
                return context.getLocation();
            }
        };
        this.q = RandomSource.a();
        this.r = ContainerProperty.a();
        this.k = new int[3];
        this.l = new int[]{-1, -1, -1};
        this.m = new int[]{-1, -1, -1};
        this.p = context;
        this.a(new Slot(this, this.o, 0, 15, 47){

            @Override
            public int a() {
                return 1;
            }
        });
        this.a(new Slot(this, this.o, 1, 35, 47){

            @Override
            public boolean a(net.minecraft.world.item.ItemStack stack) {
                return stack.a(Items.oB);
            }

            @Override
            public Pair<MinecraftKey, MinecraftKey> b() {
                return Pair.of((Object)ContainerPlayer.x, (Object)n);
            }
        });
        for (j2 = 0; j2 < 3; ++j2) {
            for (int k2 = 0; k2 < 9; ++k2) {
                this.a(new Slot(playerInventory, k2 + j2 * 9 + 9, 8 + k2 * 18, 84 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.a(new Slot(playerInventory, j2, 8 + j2 * 18, 142));
        }
        this.a(ContainerProperty.a(this.k, 0));
        this.a(ContainerProperty.a(this.k, 1));
        this.a(ContainerProperty.a(this.k, 2));
        this.a(this.r).a(playerInventory.l.gg());
        this.a(ContainerProperty.a(this.l, 0));
        this.a(ContainerProperty.a(this.l, 1));
        this.a(ContainerProperty.a(this.l, 2));
        this.a(ContainerProperty.a(this.m, 0));
        this.a(ContainerProperty.a(this.m, 1));
        this.a(ContainerProperty.a(this.m, 2));
        this.player = (Player)playerInventory.l.getBukkitEntity();
    }

    @Override
    public void a(IInventory inventory) {
        if (inventory == this.o) {
            net.minecraft.world.item.ItemStack itemstack = inventory.a(0);
            if (!itemstack.e()) {
                this.p.a((World world, BlockPosition blockposition) -> {
                    int j2;
                    Registry<Holder<Enchantment>> registry = world.H_().d(Registries.aL).u();
                    int i2 = 0;
                    for (BlockPosition blockposition1 : BlockEnchantmentTable.c) {
                        if (!BlockEnchantmentTable.a(world, blockposition, blockposition1)) continue;
                        ++i2;
                    }
                    this.q.b((long)this.r.b());
                    for (j2 = 0; j2 < 3; ++j2) {
                        this.k[j2] = EnchantmentManager.a(this.q, j2, i2, itemstack);
                        this.l[j2] = -1;
                        this.m[j2] = -1;
                        if (this.k[j2] >= j2 + 1) continue;
                        this.k[j2] = 0;
                    }
                    for (j2 = 0; j2 < 3; ++j2) {
                        List<WeightedRandomEnchant> list;
                        if (this.k[j2] <= 0 || (list = this.a(world.H_(), itemstack, j2, this.k[j2])) == null || list.isEmpty()) continue;
                        WeightedRandomEnchant weightedrandomenchant = list.get(this.q.a(list.size()));
                        this.l[j2] = registry.a(weightedrandomenchant.a);
                        this.m[j2] = weightedrandomenchant.b;
                    }
                    CraftItemStack item = CraftItemStack.asCraftMirror(itemstack);
                    EnchantmentOffer[] offers = new EnchantmentOffer[3];
                    for (j2 = 0; j2 < 3; ++j2) {
                        org.bukkit.enchantments.Enchantment enchantment = this.l[j2] >= 0 ? CraftEnchantment.minecraftHolderToBukkit(registry.a(this.l[j2])) : null;
                        offers[j2] = enchantment != null ? new EnchantmentOffer(enchantment, this.m[j2], this.k[j2]) : null;
                    }
                    PrepareItemEnchantEvent event = new PrepareItemEnchantEvent(this.player, (InventoryView)this.getBukkitView(), this.p.getLocation().getBlock(), (ItemStack)item, offers, i2);
                    event.setCancelled(!itemstack.z());
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        for (j2 = 0; j2 < 3; ++j2) {
                            this.k[j2] = 0;
                            this.l[j2] = -1;
                            this.m[j2] = -1;
                        }
                        return;
                    }
                    for (j2 = 0; j2 < 3; ++j2) {
                        EnchantmentOffer offer = event.getOffers()[j2];
                        if (offer != null) {
                            this.k[j2] = offer.getCost();
                            this.l[j2] = registry.a(CraftEnchantment.bukkitToMinecraftHolder(offer.getEnchantment()));
                            this.m[j2] = offer.getEnchantmentLevel();
                            continue;
                        }
                        this.k[j2] = 0;
                        this.l[j2] = -1;
                        this.m[j2] = -1;
                    }
                    this.d();
                });
            } else {
                for (int i2 = 0; i2 < 3; ++i2) {
                    this.k[i2] = 0;
                    this.l[i2] = -1;
                    this.m[i2] = -1;
                }
            }
        }
    }

    @Override
    public boolean a(EntityHuman player, int id) {
        if (id >= 0 && id < this.k.length) {
            net.minecraft.world.item.ItemStack itemstack = this.o.a(0);
            net.minecraft.world.item.ItemStack itemstack1 = this.o.a(1);
            int j2 = id + 1;
            if ((itemstack1.e() || itemstack1.H() < j2) && !player.fL()) {
                return false;
            }
            if (this.k[id] > 0 && !itemstack.e() && (player.cq >= j2 && player.cq >= this.k[id] || player.fZ().d)) {
                this.p.a((World world, BlockPosition blockposition) -> {
                    net.minecraft.world.item.ItemStack itemstack2 = itemstack;
                    List<WeightedRandomEnchant> list = this.a(world.H_(), itemstack, id, this.k[id]);
                    Registry<Holder<Enchantment>> registry = world.H_().d(Registries.aL).u();
                    HashMap<org.bukkit.enchantments.Enchantment, Integer> enchants = new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
                    for (WeightedRandomEnchant instance : list) {
                        enchants.put(CraftEnchantment.minecraftHolderToBukkit(instance.a), instance.b);
                    }
                    CraftItemStack item = CraftItemStack.asCraftMirror(itemstack2);
                    org.bukkit.enchantments.Enchantment hintedEnchantment = CraftEnchantment.minecraftHolderToBukkit(registry.a(this.l[id]));
                    int hintedEnchantmentLevel = this.m[id];
                    EnchantItemEvent event = new EnchantItemEvent((Player)player.getBukkitEntity(), (InventoryView)this.getBukkitView(), this.p.getLocation().getBlock(), (ItemStack)item, this.k[id], enchants, hintedEnchantment, hintedEnchantmentLevel, id);
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    int level = event.getExpLevelCost();
                    if (event.isCancelled() || level > player.cq && !player.fZ().d || event.getEnchantsToAdd().isEmpty()) {
                        return;
                    }
                    itemstack2 = CraftItemStack.getOrCloneOnMutation(item, event.getItem());
                    if (itemstack2 != itemstack) {
                        this.o.a(0, itemstack2);
                    }
                    if (itemstack2.a(Items.qP)) {
                        itemstack2 = itemstack2.a((IMaterial)Items.uw);
                        this.o.a(0, itemstack2);
                    }
                    for (Map.Entry entry : event.getEnchantsToAdd().entrySet()) {
                        Holder<Enchantment> nms = CraftEnchantment.bukkitToMinecraftHolder((org.bukkit.enchantments.Enchantment)entry.getKey());
                        if (nms == null) continue;
                        WeightedRandomEnchant weightedrandomenchant = new WeightedRandomEnchant(nms, (Integer)entry.getValue());
                        itemstack2.a(weightedrandomenchant.a, weightedrandomenchant.b);
                    }
                    player.a(itemstack, j2);
                    itemstack1.a(j2, (EntityLiving)player);
                    if (itemstack1.e()) {
                        this.o.a(1, net.minecraft.world.item.ItemStack.l);
                    }
                    player.a(StatisticList.ak);
                    if (player instanceof EntityPlayer) {
                        CriterionTriggers.j.a((EntityPlayer)player, itemstack2, j2);
                    }
                    this.o.e();
                    this.r.a(player.gg());
                    this.a(this.o);
                    world.a((EntityHuman)null, (BlockPosition)blockposition, SoundEffects.hX, SoundCategory.e, 1.0f, world.z.i() * 0.1f + 0.9f);
                });
                return true;
            }
            return false;
        }
        String s2 = String.valueOf(player.ah());
        SystemUtils.b(s2 + " pressed invalid button id: " + id);
        return false;
    }

    private List<WeightedRandomEnchant> a(IRegistryCustom registryManager, net.minecraft.world.item.ItemStack stack, int slot, int level) {
        this.q.b((long)(this.r.b() + slot));
        Optional<HolderSet.Named<Enchantment>> optional = registryManager.d(Registries.aL).b(EnchantmentTags.k);
        if (optional.isEmpty()) {
            return List.of();
        }
        List<WeightedRandomEnchant> list = EnchantmentManager.b(this.q, stack, level, optional.get().a());
        if (stack.a(Items.qP) && list.size() > 1) {
            list.remove(this.q.a(list.size()));
        }
        return list;
    }

    public int l() {
        net.minecraft.world.item.ItemStack itemstack = this.o.a(1);
        return itemstack.e() ? 0 : itemstack.H();
    }

    public int m() {
        return this.r.b();
    }

    @Override
    public void a(EntityHuman player) {
        super.a(player);
        this.p.a((World world, BlockPosition blockposition) -> this.a(player, this.o));
    }

    @Override
    public boolean b(EntityHuman player) {
        if (!this.checkReachable) {
            return true;
        }
        return ContainerEnchantTable.a(this.p, player, Blocks.fr);
    }

    @Override
    public net.minecraft.world.item.ItemStack b(EntityHuman player, int slot) {
        net.minecraft.world.item.ItemStack itemstack = net.minecraft.world.item.ItemStack.l;
        Slot slot1 = this.i.get(slot);
        if (slot1 != null && slot1.h()) {
            net.minecraft.world.item.ItemStack itemstack1 = slot1.g();
            itemstack = itemstack1.s();
            if (slot == 0) {
                if (!this.a(itemstack1, 2, 38, true)) {
                    return net.minecraft.world.item.ItemStack.l;
                }
            } else if (slot == 1) {
                if (!this.a(itemstack1, 2, 38, true)) {
                    return net.minecraft.world.item.ItemStack.l;
                }
            } else if (itemstack1.a(Items.oB)) {
                if (!this.a(itemstack1, 1, 2, true)) {
                    return net.minecraft.world.item.ItemStack.l;
                }
            } else {
                if (this.i.get(0).h() || !this.i.get(0).a(itemstack1)) {
                    return net.minecraft.world.item.ItemStack.l;
                }
                net.minecraft.world.item.ItemStack itemstack2 = itemstack1.c(1);
                itemstack1.h(1);
                this.i.get(0).e(itemstack2);
            }
            if (itemstack1.e()) {
                slot1.e(net.minecraft.world.item.ItemStack.l);
            } else {
                slot1.c();
            }
            if (itemstack1.H() == itemstack.H()) {
                return net.minecraft.world.item.ItemStack.l;
            }
            slot1.a(player, itemstack1);
        }
        return itemstack;
    }

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryEnchanting inventory = new CraftInventoryEnchanting(this.o);
        this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }
}

