/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockWaterLily;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;

public class EntityBoat
extends VehicleEntity
implements Leashable,
VariantHolder<EnumBoatType> {
    private static final DataWatcherObject<Integer> i = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> j = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> k = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> l = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.b);
    public static final int b = 0;
    public static final int c = 1;
    private static final int m = 60;
    private static final float n = 0.3926991f;
    public static final double d = 0.7853981852531433;
    public static final int e = 60;
    private final float[] o = new float[2];
    private float p;
    private float q;
    private float r;
    private int s;
    private double t;
    private double u;
    private double v;
    private double aD;
    private double aE;
    private boolean aF;
    private boolean aG;
    private boolean aH;
    private boolean aI;
    private double aJ;
    private float aK;
    public EnumStatus aL;
    private EnumStatus aM;
    private double aN;
    private boolean aO;
    private boolean aP;
    private float aQ;
    private float aR;
    private float aS;
    @Nullable
    private Leashable.a aT;
    public double maxSpeed = 0.4;
    public double occupiedDeceleration = 0.2;
    public double unoccupiedDeceleration = -1.0;
    public boolean landBoats = false;
    private Location lastLocation;

    public EntityBoat(EntityTypes<? extends EntityBoat> type, World world) {
        super(type, world);
        this.J = true;
    }

    public EntityBoat(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityBoat>)EntityTypes.k, world);
        this.a_(x2, y2, z2);
        this.L = x2;
        this.M = y2;
        this.N = z2;
    }

    @Override
    protected Entity.MovementEmission bc() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(i, EnumBoatType.a.ordinal());
        builder.a(j, false);
        builder.a(k, false);
        builder.a(l, 0);
    }

    @Override
    public boolean i(Entity other) {
        return EntityBoat.a(this, other);
    }

    public static boolean a(Entity entity, Entity other) {
        return (other.bG() || other.bB()) && !entity.y(other);
    }

    @Override
    public boolean bG() {
        return true;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.k(super.a(portalAxis, portalRect));
    }

    @Override
    protected Vec3D a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        float f1 = this.w();
        if (this.cS().size() > 1) {
            int i2 = this.cS().indexOf(passenger);
            f1 = i2 == 0 ? 0.2f : -0.6f;
            if (passenger instanceof EntityAnimal) {
                f1 += 0.2f;
            }
        }
        return new Vec3D(0.0, this.x() == EnumBoatType.i ? (double)(dimensions.b() * 0.8888889f) : (double)(dimensions.b() / 3.0f), f1).b(-this.dE() * ((float)Math.PI / 180));
    }

    @Override
    public void l(boolean drag) {
        if (!this.dO().B) {
            this.aO = true;
            this.aP = drag;
            if (this.K() == 0) {
                this.b(60);
            }
        }
        this.dO().a(Particles.am, this.dt() + (double)this.ah.i(), this.dv() + 0.7, this.dz() + (double)this.ah.i(), 0.0, 0.0, 0.0);
        if (this.ah.a(20) == 0) {
            this.dO().a(this.dt(), this.dv(), this.dz(), this.aR(), this.de(), 1.0f, 0.8f + 0.4f * this.ah.i(), false);
            this.a(GameEvent.O, (Entity)this.cQ());
        }
    }

    @Override
    public void h(Entity entity) {
        if (!this.dO().paperConfig().collisions.allowVehicleCollisions && this.dO().paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
            return;
        }
        if (entity instanceof EntityBoat) {
            if (entity.cK().b < this.cK().e) {
                if (!this.y(entity)) {
                    VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                    this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                super.h(entity);
            }
        } else if (entity.cK().b <= this.cK().b) {
            if (!this.y(entity)) {
                VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            super.h(entity);
        }
    }

    @Override
    public Item ak_() {
        return switch (this.x().ordinal()) {
            case 1 -> Items.nW;
            case 2 -> Items.nY;
            case 3 -> Items.oa;
            case 4 -> Items.oc;
            case 5 -> Items.oe;
            case 6 -> Items.og;
            case 7 -> Items.oi;
            case 8 -> Items.ok;
            default -> Items.nU;
        };
    }

    @Override
    public void n(float yaw) {
        this.m(-this.P());
        this.d(10);
        this.b(this.N() * 11.0f);
    }

    @Override
    public boolean bA() {
        return !this.dJ();
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        this.t = x2;
        this.u = y2;
        this.v = z2;
        this.aD = yaw;
        this.aE = pitch;
        this.s = 10;
    }

    @Override
    public double c_() {
        return this.s > 0 ? this.t : this.dt();
    }

    @Override
    public double d_() {
        return this.s > 0 ? this.u : this.dv();
    }

    @Override
    public double P_() {
        return this.s > 0 ? this.v : this.dz();
    }

    @Override
    public float Q_() {
        return this.s > 0 ? (float)this.aE : this.dG();
    }

    @Override
    public float e_() {
        return this.s > 0 ? (float)this.aD : this.dE();
    }

    @Override
    public EnumDirection cI() {
        return this.cH().h();
    }

    @Override
    public void l() {
        this.aM = this.aL;
        this.aL = this.D();
        this.q = this.aL != EnumStatus.b && this.aL != EnumStatus.c ? 0.0f : (this.q += 1.0f);
        if (!this.dO().B && this.q >= 60.0f) {
            this.bI();
        }
        if (this.O() > 0) {
            this.d(this.O() - 1);
        }
        if (this.N() > 0.0f) {
            this.b(this.N() - 1.0f);
        }
        super.l();
        this.C();
        if (this.da()) {
            if (!(this.cT() instanceof EntityHuman)) {
                this.b(false, false);
            }
            this.I();
            if (this.dO().B) {
                this.J();
                this.dO().a(new PacketPlayInBoatMove(this.c(0), this.c(1)));
            }
            this.a(EnumMoveType.a, this.dr());
        } else {
            this.i(Vec3D.b);
        }
        CraftServer server = this.dO().getCraftServer();
        CraftWorld bworld = this.dO().getWorld();
        Location to = CraftLocation.toBukkit(this.dm(), (org.bukkit.World)bworld, this.dE(), this.dG());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        server.getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
        if (this.lastLocation != null && !this.lastLocation.equals((Object)to)) {
            VehicleMoveEvent event = new VehicleMoveEvent(vehicle, this.lastLocation, to);
            server.getPluginManager().callEvent((Event)event);
        }
        this.lastLocation = vehicle.getLocation();
        this.B();
        for (int i2 = 0; i2 <= 1; ++i2) {
            if (this.c(i2)) {
                SoundEffect soundeffect;
                if (!this.aX() && (double)(this.o[i2] % ((float)Math.PI * 2)) <= 0.7853981852531433 && (double)((this.o[i2] + 0.3926991f) % ((float)Math.PI * 2)) >= 0.7853981852531433 && (soundeffect = this.s()) != null) {
                    Vec3D vec3d = this.g(1.0f);
                    double d0 = i2 == 1 ? -vec3d.e : vec3d.e;
                    double d1 = i2 == 1 ? vec3d.c : -vec3d.c;
                    this.dO().a((EntityHuman)null, this.dt() + d0, this.dv(), this.dz() + d1, soundeffect, this.de(), 1.0f, 0.8f + 0.4f * this.ah.i());
                }
                int n2 = i2;
                this.o[n2] = this.o[n2] + 0.3926991f;
                continue;
            }
            this.o[i2] = 0.0f;
        }
        this.aT();
        List<Entity> list = this.dO().a((Entity)this, this.cK().c(0.2f, -0.01f, 0.2f), IEntitySelector.a(this));
        if (!list.isEmpty()) {
            boolean flag = !this.dO().B && !(this.cQ() instanceof EntityHuman);
            for (Entity entity : list) {
                if (entity.x(this)) continue;
                if (flag && this.cS().size() < this.F() && !entity.bS() && this.c(entity) && entity instanceof EntityLiving && !(entity instanceof EntityWaterAnimal) && !(entity instanceof EntityHuman)) {
                    entity.n(this);
                    continue;
                }
                this.h(entity);
            }
        }
    }

    private void B() {
        if (this.dO().B) {
            int i2 = this.K();
            this.aQ = i2 > 0 ? (this.aQ += 0.05f) : (this.aQ -= 0.1f);
            this.aQ = MathHelper.a(this.aQ, 0.0f, 1.0f);
            this.aS = this.aR;
            this.aR = 10.0f * (float)Math.sin(0.5f * (float)this.dO().Z()) * this.aQ;
        } else {
            int i3;
            if (!this.aO) {
                this.b(0);
            }
            if ((i3 = this.K()) > 0) {
                this.b(--i3);
                int j2 = 60 - i3 - 1;
                if (j2 > 0 && i3 == 0) {
                    this.b(0);
                    Vec3D vec3d = this.dr();
                    if (this.aP) {
                        this.i(vec3d.b(0.0, -0.7, 0.0));
                        this.bI();
                    } else {
                        this.n(vec3d.c, this.a((Entity entity) -> entity instanceof EntityHuman) ? 2.7 : 0.6, vec3d.e);
                    }
                }
                this.aO = false;
            }
        }
    }

    @Nullable
    protected SoundEffect s() {
        switch (this.D().ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return SoundEffects.cm;
            }
            case 3: {
                return SoundEffects.cl;
            }
        }
        return null;
    }

    private void C() {
        if (this.da()) {
            this.s = 0;
            this.f(this.dt(), this.dv(), this.dz());
        }
        if (this.s > 0) {
            this.a(this.s, this.t, this.u, this.v, this.aD, this.aE);
            --this.s;
        }
    }

    public void b(boolean leftMoving, boolean rightMoving) {
        this.ao.a(j, leftMoving);
        this.ao.a(k, rightMoving);
    }

    public float a(int paddle, float tickDelta) {
        return this.c(paddle) ? MathHelper.b(this.o[paddle] - 0.3926991f, this.o[paddle], tickDelta) : 0.0f;
    }

    @Override
    @Nullable
    public Leashable.a X_() {
        return this.aT;
    }

    @Override
    public void a(@Nullable Leashable.a leashData) {
        this.aT = leashData;
    }

    @Override
    public Vec3D cM() {
        return new Vec3D(0.0, 0.88f * this.cL(), this.dj() * 0.64f);
    }

    @Override
    public void b(Entity leashHolder, float distance) {
        Vec3D vec3d = leashHolder.dm().d(this.dm()).d().a((double)distance - 6.0);
        Vec3D vec3d1 = this.dr();
        boolean flag = vec3d1.b(vec3d) > 0.0;
        this.i(vec3d1.e(vec3d.a(flag ? (double)0.15f : (double)0.2f)));
    }

    public EnumStatus D() {
        EnumStatus entityboat_enumstatus = this.H();
        if (entityboat_enumstatus != null) {
            this.aJ = this.cK().e;
            return entityboat_enumstatus;
        }
        if (this.E()) {
            return EnumStatus.a;
        }
        float f2 = this.v();
        if (f2 > 0.0f) {
            this.aK = f2;
            return EnumStatus.d;
        }
        return EnumStatus.e;
    }

    public float t() {
        AxisAlignedBB axisalignedbb = this.cK();
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.e);
        int l2 = MathHelper.c(axisalignedbb.e - this.aN);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        block0: for (int k1 = k2; k1 < l2; ++k1) {
            float f2 = 0.0f;
            block1: for (int l1 = i2; l1 < j2; ++l1) {
                int i22 = i1;
                while (true) {
                    if (i22 >= j1) {
                        continue block1;
                    }
                    blockposition_mutableblockposition.d(l1, k1, i22);
                    Fluid fluid = this.dO().b_(blockposition_mutableblockposition);
                    if (fluid.a(TagsFluid.a)) {
                        f2 = Math.max(f2, fluid.a((IBlockAccess)this.dO(), (BlockPosition)blockposition_mutableblockposition));
                    }
                    if (f2 >= 1.0f) continue block0;
                    ++i22;
                }
            }
            if (!(f2 < 1.0f)) continue;
            return (float)blockposition_mutableblockposition.v() + f2;
        }
        return l2 + 1;
    }

    public float v() {
        AxisAlignedBB axisalignedbb = this.cK();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.a, axisalignedbb.b - 0.001, axisalignedbb.c, axisalignedbb.d, axisalignedbb.b, axisalignedbb.f);
        int i2 = MathHelper.a(axisalignedbb1.a) - 1;
        int j2 = MathHelper.c(axisalignedbb1.d) + 1;
        int k2 = MathHelper.a(axisalignedbb1.b) - 1;
        int l2 = MathHelper.c(axisalignedbb1.e) + 1;
        int i1 = MathHelper.a(axisalignedbb1.c) - 1;
        int j1 = MathHelper.c(axisalignedbb1.f) + 1;
        VoxelShape voxelshape = VoxelShapes.a(axisalignedbb1);
        float f2 = 0.0f;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int l1 = i2; l1 < j2; ++l1) {
            for (int i22 = i1; i22 < j1; ++i22) {
                int j22 = (l1 != i2 && l1 != j2 - 1 ? 0 : 1) + (i22 != i1 && i22 != j1 - 1 ? 0 : 1);
                if (j22 == 2) continue;
                for (int k22 = k2; k22 < l2; ++k22) {
                    if (j22 > 0 && (k22 == k2 || k22 == l2 - 1)) continue;
                    blockposition_mutableblockposition.d(l1, k22, i22);
                    IBlockData iblockdata = this.dO().a_(blockposition_mutableblockposition);
                    if (iblockdata.b() instanceof BlockWaterLily || !VoxelShapes.c(iblockdata.k(this.dO(), blockposition_mutableblockposition).a((double)l1, (double)k22, (double)i22), voxelshape, OperatorBoolean.i)) continue;
                    f2 += iblockdata.b().h();
                    ++k1;
                }
            }
        }
        return f2 / (float)k1;
    }

    private boolean E() {
        AxisAlignedBB axisalignedbb = this.cK();
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.b);
        int l2 = MathHelper.c(axisalignedbb.b + 0.001);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        boolean flag = false;
        this.aJ = -1.7976931348623157E308;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    blockposition_mutableblockposition.d(k1, l1, i22);
                    Fluid fluid = this.dO().b_(blockposition_mutableblockposition);
                    if (!fluid.a(TagsFluid.a)) continue;
                    float f2 = (float)l1 + fluid.a((IBlockAccess)this.dO(), (BlockPosition)blockposition_mutableblockposition);
                    this.aJ = Math.max((double)f2, this.aJ);
                    flag |= axisalignedbb.b < (double)f2;
                }
            }
        }
        return flag;
    }

    @Nullable
    private EnumStatus H() {
        AxisAlignedBB axisalignedbb = this.cK();
        double d0 = axisalignedbb.e + 0.001;
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.e);
        int l2 = MathHelper.c(d0);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        boolean flag = false;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    blockposition_mutableblockposition.d(k1, l1, i22);
                    Fluid fluid = this.dO().b_(blockposition_mutableblockposition);
                    if (!fluid.a(TagsFluid.a) || !(d0 < (double)((float)blockposition_mutableblockposition.v() + fluid.a((IBlockAccess)this.dO(), (BlockPosition)blockposition_mutableblockposition)))) continue;
                    if (!fluid.b()) {
                        return EnumStatus.c;
                    }
                    flag = true;
                }
            }
        }
        return flag ? EnumStatus.b : null;
    }

    @Override
    protected double aZ() {
        return 0.04;
    }

    private void I() {
        double d0 = -this.ba();
        double d1 = 0.0;
        this.p = 0.05f;
        if (this.aM == EnumStatus.e && this.aL != EnumStatus.e && this.aL != EnumStatus.d) {
            this.aJ = this.e(1.0);
            double d2 = (double)(this.t() - this.dk()) + 0.101;
            if (this.dO().a((Entity)this, this.cK().d(0.0, d2 - this.dv(), 0.0))) {
                this.a_(this.dt(), d2, this.dz());
                this.i(this.dr().d(1.0, 0.0, 1.0));
                this.aN = 0.0;
            }
            this.aL = EnumStatus.a;
        } else {
            if (this.aL == EnumStatus.a) {
                d1 = (this.aJ - this.dv()) / (double)this.dk();
                this.p = 0.9f;
            } else if (this.aL == EnumStatus.c) {
                d0 = -7.0E-4;
                this.p = 0.9f;
            } else if (this.aL == EnumStatus.b) {
                d1 = 0.01f;
                this.p = 0.45f;
            } else if (this.aL == EnumStatus.e) {
                this.p = 0.9f;
            } else if (this.aL == EnumStatus.d) {
                this.p = this.aK;
                if (this.cQ() instanceof EntityHuman) {
                    this.aK /= 2.0f;
                }
            }
            Vec3D vec3d = this.dr();
            this.n(vec3d.c * (double)this.p, vec3d.d + d0, vec3d.e * (double)this.p);
            this.r *= this.p;
            if (d1 > 0.0) {
                Vec3D vec3d1 = this.dr();
                this.n(vec3d1.c, (vec3d1.d + d1 * (this.aZ() / 0.65)) * 0.75, vec3d1.e);
            }
        }
    }

    private void J() {
        if (this.bT()) {
            float f2 = 0.0f;
            if (this.aF) {
                this.r -= 1.0f;
            }
            if (this.aG) {
                this.r += 1.0f;
            }
            if (this.aG != this.aF && !this.aH && !this.aI) {
                f2 += 0.005f;
            }
            this.t(this.dE() + this.r);
            if (this.aH) {
                f2 += 0.04f;
            }
            if (this.aI) {
                f2 -= 0.005f;
            }
            this.i(this.dr().b(MathHelper.a(-this.dE() * ((float)Math.PI / 180)) * f2, 0.0, MathHelper.b(this.dE() * ((float)Math.PI / 180)) * f2));
            this.b(this.aG && !this.aF || this.aH, this.aF && !this.aG || this.aH);
        }
    }

    protected float w() {
        return 0.0f;
    }

    public boolean c(Entity entity) {
        return entity.dj() < this.dj();
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction positionUpdater) {
        super.a(passenger, positionUpdater);
        if (!passenger.am().a(TagsEntity.s)) {
            passenger.t(passenger.dE() + this.r);
            passenger.o(passenger.ct() + this.r);
            this.d(passenger);
            if (passenger instanceof EntityAnimal && this.cS().size() == this.F()) {
                int i2 = passenger.an() % 2 == 0 ? 90 : 270;
                passenger.p(((EntityAnimal)passenger).aY + (float)i2);
                passenger.o(passenger.ct() + (float)i2);
            }
        }
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D vec3d = EntityBoat.a(this.dj() * MathHelper.g, passenger.dj(), passenger.dE());
        double d0 = this.dt() + vec3d.c;
        double d1 = this.dz() + vec3d.e;
        BlockPosition blockposition = BlockPosition.a(d0, this.cK().e, d1);
        BlockPosition blockposition1 = blockposition.e();
        if (!this.dO().z(blockposition1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.dO().j(blockposition);
            if (DismountUtil.a(d2)) {
                list.add(new Vec3D(d0, (double)blockposition.v() + d2, d1));
            }
            if (DismountUtil.a(d3 = this.dO().j(blockposition1))) {
                list.add(new Vec3D(d0, (double)blockposition1.v() + d3, d1));
            }
            for (EntityPose entitypose : passenger.fE()) {
                for (Vec3D vec3d1 : list) {
                    if (!DismountUtil.a(this.dO(), vec3d1, passenger, entitypose)) continue;
                    passenger.b(entitypose);
                    return vec3d1;
                }
            }
        }
        return super.b(passenger);
    }

    protected void d(Entity passenger) {
        passenger.p(this.dE());
        float f2 = MathHelper.g(passenger.dE() - this.dE());
        float f1 = MathHelper.a(f2, -105.0f, 105.0f);
        passenger.O += f1 - f2;
        passenger.t(passenger.dE() + f1 - f2);
        passenger.o(passenger.dE());
    }

    @Override
    public void k(Entity passenger) {
        this.d(passenger);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        this.a(nbt, this.aT);
        nbt.a("Type", this.x().c());
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.aT = this.c(nbt);
        if (nbt.b("Type", 8)) {
            this.a(EnumBoatType.a(nbt.l("Type")));
        }
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult = super.a(player, hand);
        return enuminteractionresult != EnumInteractionResult.e ? enuminteractionresult : (player.fN() ? EnumInteractionResult.e : (this.q < 60.0f ? (!this.dO().B ? (player.n(this) ? EnumInteractionResult.c : EnumInteractionResult.e) : EnumInteractionResult.a) : EnumInteractionResult.e));
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        if (!this.dO().B && entity_removalreason.a() && this.N_()) {
            this.a(true, true);
        }
        super.remove(entity_removalreason, cause);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        this.aN = this.dr().d;
        if (!this.bS()) {
            if (onGround) {
                if (this.ac > 3.0f) {
                    if (this.aL != EnumStatus.d) {
                        this.n();
                        return;
                    }
                    this.a(this.ac, 1.0f, this.dP().l());
                    if (!this.dO().B && !this.dJ()) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, null);
                        this.dO().getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                        if (!destroyEvent.isCancelled()) {
                            this.ap();
                            if (this.dO().ab().b(GameRules.i)) {
                                int i2;
                                for (i2 = 0; i2 < 3; ++i2) {
                                    this.a(this.x().b());
                                }
                                for (i2 = 0; i2 < 2; ++i2) {
                                    this.a((IMaterial)Items.pq);
                                }
                            }
                        }
                    }
                }
                this.n();
            } else if (!this.dO().b_(this.do().e()).a(TagsFluid.a) && heightDifference < 0.0) {
                this.ac -= (float)heightDifference;
            }
        }
    }

    public boolean c(int paddle) {
        return this.ao.a(paddle == 0 ? j : k) != false && this.cQ() != null;
    }

    private void b(int wobbleTicks) {
        this.ao.a(l, wobbleTicks);
    }

    private int K() {
        return this.ao.a(l);
    }

    public float a(float tickDelta) {
        return MathHelper.i(tickDelta, this.aS, this.aR);
    }

    @Override
    public void a(EnumBoatType variant) {
        this.ao.a(i, variant.ordinal());
    }

    public EnumBoatType x() {
        return EnumBoatType.a(this.ao.a(i));
    }

    @Override
    protected boolean r(Entity passenger) {
        return this.cS().size() < this.F() && !this.a(TagsFluid.a);
    }

    protected int F() {
        return 2;
    }

    @Override
    @Nullable
    public EntityLiving cQ() {
        EntityLiving entityliving1;
        Entity entity = this.cT();
        EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : super.cQ();
        return entityliving;
    }

    public void a(boolean pressingLeft, boolean pressingRight, boolean pressingForward, boolean pressingBack) {
        this.aF = pressingLeft;
        this.aG = pressingRight;
        this.aH = pressingForward;
        this.aI = pressingBack;
    }

    @Override
    protected IChatBaseComponent cs() {
        return IChatBaseComponent.c(this.ak_().a());
    }

    @Override
    public boolean bk() {
        return this.aL == EnumStatus.b || this.aL == EnumStatus.c;
    }

    @Override
    public ItemStack dB() {
        return new ItemStack(this.ak_());
    }

    public static enum EnumBoatType implements INamable
    {
        a(Blocks.n, "oak"),
        b(Blocks.o, "spruce"),
        c(Blocks.p, "birch"),
        d(Blocks.q, "jungle"),
        e(Blocks.r, "acacia"),
        f(Blocks.s, "cherry"),
        g(Blocks.t, "dark_oak"),
        h(Blocks.u, "mangrove"),
        i(Blocks.v, "bamboo");

        private final String k;
        private final Block l;
        public static final INamable.a<EnumBoatType> j;
        private static final IntFunction<EnumBoatType> m;

        private EnumBoatType(Block block, String s2) {
            this.k = s2;
            this.l = block;
        }

        @Override
        public String c() {
            return this.k;
        }

        public String a() {
            return this.k;
        }

        public Block b() {
            return this.l;
        }

        public String toString() {
            return this.k;
        }

        public static EnumBoatType a(int type) {
            return m.apply(type);
        }

        public static EnumBoatType a(String name) {
            return j.a(name, a);
        }

        static {
            j = INamable.a(EnumBoatType::values);
            m = ByIdMap.a(Enum::ordinal, EnumBoatType.values(), ByIdMap.a.a);
        }
    }

    public static enum EnumStatus {
        a,
        b,
        c,
        d,
        e;

    }
}

