/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import io.papermc.paper.event.player.PlayerShieldDisableEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftVector;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public abstract class EntityHuman
extends EntityLiving {
    private static final Logger b = LogUtils.getLogger();
    public static final EnumMainHand bH = EnumMainHand.b;
    public static final int bI = 0;
    public static final int bJ = 20;
    public static final int bK = 100;
    public static final int bL = 10;
    public static final int bM = 200;
    public static final int bN = 499;
    public static final int bO = 500;
    public static final float bP = 4.5f;
    public static final float bQ = 3.0f;
    public static final float bR = 1.5f;
    public static final float bS = 0.6f;
    public static final float bT = 0.6f;
    public static final float bU = 1.62f;
    private static final int c = 40;
    public static final Vec3D bV = new Vec3D(0.0, 0.6, 0.0);
    public static final EntitySize bW = EntitySize.b(0.6f, 1.8f).b(1.62f).a(EntityAttachments.a().a(EntityAttachment.b, bV));
    private static final Map<EntityPose, EntitySize> d = ImmutableMap.builder().put((Object)EntityPose.a, (Object)bW).put((Object)EntityPose.c, (Object)EntityLiving.aF).put((Object)EntityPose.b, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.d, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.e, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.f, (Object)EntitySize.b(0.6f, 1.5f).b(1.27f).a(EntityAttachments.a().a(EntityAttachment.b, bV))).put((Object)EntityPose.h, (Object)EntitySize.c(0.2f, 0.2f).b(1.62f)).build();
    private static final DataWatcherObject<Float> e = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> f = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Byte> bX = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Byte> bY = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<NBTTagCompound> bZ = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.t);
    protected static final DataWatcherObject<NBTTagCompound> ca = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.t);
    private long g;
    final PlayerInventory h = new PlayerInventory(this);
    protected InventoryEnderChest cb = new InventoryEnderChest(this);
    public final ContainerPlayer cc;
    public Container cd;
    protected FoodMetaData ce = new FoodMetaData(this);
    protected int cf;
    public float cg;
    public float ch;
    public int ci;
    public double cj;
    public double ck;
    public double cl;
    public double cm;
    public double cn;
    public double co;
    public int cz;
    protected boolean cp;
    private final PlayerAbilities cA = new PlayerAbilities();
    public int cq;
    public int cr;
    public float cs;
    public int ct;
    protected final float cu = 0.02f;
    private int cB;
    public GameProfile cD;
    private boolean cE;
    private net.minecraft.world.item.ItemStack cF;
    private final ItemCooldown cG;
    private Optional<GlobalPos> cH;
    @Nullable
    public EntityFishingHook cv;
    public float cw;
    @Nullable
    public Vec3D cx;
    @Nullable
    public Entity cy;
    private boolean cI;
    private int cJ;
    public boolean affectsSpawning = true;
    public TriState flyingFallDamage = TriState.NOT_SET;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World world, BlockPosition pos, float yaw, GameProfile gameProfile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.by, world);
        this.cF = net.minecraft.world.item.ItemStack.l;
        this.cG = this.k();
        this.cH = Optional.empty();
        this.a_(gameProfile.getId());
        this.cD = gameProfile;
        this.cc = new ContainerPlayer(this.h, !world.B, this);
        this.cd = this.cc;
        this.b((double)pos.u() + 0.5, pos.v() + 1, (double)pos.w() + 0.5, yaw, 0.0f);
        this.bk = 180.0f;
    }

    public boolean a(World world, BlockPosition pos, EnumGamemode gameMode) {
        if (!gameMode.f()) {
            return false;
        }
        if (gameMode == EnumGamemode.d) {
            return true;
        }
        if (this.gk()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = this.eT();
        return itemstack.e() || !itemstack.b(new ShapeDetectorBlock(world, pos, false));
    }

    public static AttributeProvider.Builder fM() {
        return EntityLiving.dV().a(GenericAttributes.c, 1.0).a(GenericAttributes.v, 0.1f).a(GenericAttributes.e).a(GenericAttributes.q).a(GenericAttributes.g, 4.5).a(GenericAttributes.j, 3.0).a(GenericAttributes.f).a(GenericAttributes.C).a(GenericAttributes.z).a(GenericAttributes.t).a(GenericAttributes.D);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(e, Float.valueOf(0.0f));
        builder.a(f, 0);
        builder.a(bX, (byte)0);
        builder.a(bY, (byte)bH.a());
        builder.a(bZ, new NBTTagCompound());
        builder.a(ca, new NBTTagCompound());
    }

    @Override
    public void l() {
        this.ag = this.R_();
        if (this.R_()) {
            this.d(false);
        }
        if (this.ci > 0) {
            --this.ci;
        }
        if (this.fH()) {
            ++this.cz;
            if (this.cz == 100 && !new PlayerDeepSleepEvent((Player)this.getBukkitEntity()).callEvent()) {
                this.cz = Integer.MIN_VALUE;
            }
            if (this.cz > 100) {
                this.cz = 100;
            }
            if (!this.dO().B && this.dO().R()) {
                this.a(false, true);
            }
        } else if (this.cz > 0) {
            ++this.cz;
            if (this.cz >= 110) {
                this.cz = 0;
            }
        }
        this.fQ();
        super.l();
        if (!this.dO().B && this.cd != null && !this.cd.b(this)) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.cd = this.cc;
        }
        this.x();
        if (!this.dO().B) {
            this.ce.a(this);
            this.a(StatisticList.k);
            this.a(StatisticList.l);
            if (this.bE()) {
                this.a(StatisticList.m);
            }
            if (this.bZ()) {
                this.a(StatisticList.o);
            }
            if (!this.fH()) {
                this.a(StatisticList.n);
            }
        }
        int i2 = 29999999;
        double d0 = MathHelper.a(this.dt(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dz(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.dt() || d1 != this.dz()) {
            this.a_(d0, this.dv(), d1);
        }
        ++this.aT;
        net.minecraft.world.item.ItemStack itemstack = this.eT();
        if (!net.minecraft.world.item.ItemStack.a(this.cF, itemstack)) {
            if (!net.minecraft.world.item.ItemStack.b(this.cF, itemstack)) {
                this.gs();
            }
            this.cF = itemstack.s();
        }
        this.v();
        this.cG.a();
        this.fR();
        if (this.cJ > 0) {
            --this.cJ;
        }
    }

    @Override
    protected float fk() {
        return this.fy() ? 15.0f : super.fk();
    }

    public boolean fN() {
        return this.bW();
    }

    protected boolean fO() {
        return this.bW();
    }

    protected boolean fP() {
        return this.bW();
    }

    protected boolean fQ() {
        this.cp = ((Entity)this).a(TagsFluid.a);
        return this.cp;
    }

    private void v() {
        net.minecraft.world.item.ItemStack itemstack = this.a(EnumItemSlot.f);
        if (itemstack.a(Items.oo) && !((Entity)this).a(TagsFluid.a)) {
            this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
        }
    }

    protected ItemCooldown k() {
        return new ItemCooldown();
    }

    private void x() {
        this.cj = this.cm;
        this.ck = this.cn;
        this.cl = this.co;
        double d0 = this.dt() - this.cm;
        double d1 = this.dv() - this.cn;
        double d2 = this.dz() - this.co;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.cj = this.cm = this.dt();
        }
        if (d2 > 10.0) {
            this.cl = this.co = this.dz();
        }
        if (d1 > 10.0) {
            this.ck = this.cn = this.dv();
        }
        if (d0 < -10.0) {
            this.cj = this.cm = this.dt();
        }
        if (d2 < -10.0) {
            this.cl = this.co = this.dz();
        }
        if (d1 < -10.0) {
            this.ck = this.cn = this.dv();
        }
        this.cm += d0 * 0.25;
        this.co += d2 * 0.25;
        this.cn += d1 * 0.25;
    }

    protected void fR() {
        if (this.h(EntityPose.d)) {
            EntityPose entitypose = this.fA() ? EntityPose.b : (this.fH() ? EntityPose.c : (this.cd() ? EntityPose.d : (this.fn() ? EntityPose.e : (this.bW() && !this.cA.b ? EntityPose.f : EntityPose.a))));
            EntityPose entitypose1 = !(this.R_() || this.bS() || this.h(entitypose)) ? (this.h(EntityPose.f) ? EntityPose.f : EntityPose.d) : entitypose;
            this.b(entitypose1);
        }
    }

    protected boolean h(EntityPose pose) {
        return this.dO().a((Entity)this, this.a(pose).a(this.dm()).h(1.0E-7));
    }

    @Override
    protected SoundEffect aQ() {
        return SoundEffects.uu;
    }

    @Override
    protected SoundEffect aR() {
        return SoundEffects.us;
    }

    @Override
    protected SoundEffect aS() {
        return SoundEffects.ut;
    }

    @Override
    public int bQ() {
        return 10;
    }

    @Override
    public void a(SoundEffect sound, float volume, float pitch) {
        this.dO().a(this, this.dt(), this.dv(), this.dz(), sound, this.de(), volume, pitch);
    }

    public void a(SoundEffect sound, SoundCategory category, float volume, float pitch) {
    }

    @Override
    public SoundCategory de() {
        return SoundCategory.h;
    }

    @Override
    public int df() {
        return 20;
    }

    @Override
    public void b(byte status) {
        if (status == 9) {
            this.L_();
        } else if (status == 23) {
            this.cE = false;
        } else if (status == 22) {
            this.cE = true;
        } else {
            super.b(status);
        }
    }

    public void closeContainer(InventoryCloseEvent.Reason reason) {
        this.s();
        this.cd = this.cc;
    }

    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        this.cd = this.cc;
    }

    public void s() {
        this.cd = this.cc;
    }

    protected void t() {
    }

    @Override
    public void u() {
        if (!this.dO().B && this.fO() && this.bS()) {
            this.ad();
            if (!this.bS()) {
                this.g(false);
                return;
            }
        }
        super.u();
        this.cg = this.ch;
        this.ch = 0.0f;
    }

    @Override
    protected void fm() {
        super.fm();
        this.eR();
        this.ba = this.dE();
    }

    @Override
    public void m_() {
        if (this.cf > 0) {
            --this.cf;
        }
        if (this.dO().al() == EnumDifficulty.a && this.dO().ab().b(GameRules.k)) {
            if (this.ew() < this.eN() && this.ai % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.ce.e() < 20.0f && this.ai % 20 == 0) {
                this.ce.b(this.ce.e() + 1.0f);
            }
            if (this.ce.c() && this.ai % 10 == 0) {
                this.ce.a(this.ce.a() + 1);
            }
        }
        this.h.j();
        this.cg = this.ch;
        super.m_();
        this.A((float)this.g(GenericAttributes.v));
        float f2 = this.aF() && !this.ex() && !this.cd() ? Math.min(0.1f, (float)this.dr().h()) : 0.0f;
        this.ch += (f2 - this.ch) * 0.4f;
        if (this.ew() > 0.0f && !this.R_()) {
            AxisAlignedBB axisalignedbb = this.bS() && !this.dc().dJ() ? this.cK().b(this.dc().cK()).c(1.0, 0.0, 1.0) : this.cK().c(1.0, 0.5, 1.0);
            List<Entity> list = this.dO().a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.am() == EntityTypes.M) {
                    list1.add(entity);
                    continue;
                }
                if (entity.dJ()) continue;
                this.d(entity);
            }
            if (!list1.isEmpty()) {
                this.d((Entity)SystemUtils.a(list1, this.ah));
            }
        }
        this.c(this.gp());
        this.c(this.gq());
        if ((!this.dO().B && (this.ac > 0.5f || this.bf()) || this.cA.b || this.fH() || this.az) && !this.dO().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) {
            this.gm();
        }
    }

    private void c(@Nullable NBTTagCompound entityNbt) {
        if (!(entityNbt == null || entityNbt.e("Silent") && entityNbt.q("Silent") || this.dO().z.a(200) != 0)) {
            String s2 = entityNbt.l("id");
            EntityTypes.a(s2).filter(entitytypes -> entitytypes == EntityTypes.ax).ifPresent(entitytypes -> {
                if (!EntityParrot.a(this.dO(), this)) {
                    this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), EntityParrot.a(this.dO(), this.dO().z), this.de(), 1.0f, EntityParrot.a(this.dO().z));
                }
            });
        }
    }

    private void d(Entity entity) {
        entity.b_(this);
    }

    public int fS() {
        return this.ao.a(f);
    }

    public void r(int score) {
        this.ao.a(f, score);
    }

    public void s(int score) {
        int j2 = this.fS();
        this.ao.a(f, j2 + score);
    }

    public void a(int riptideTicks, float riptideAttackDamage, net.minecraft.world.item.ItemStack stack) {
        this.bC = riptideTicks;
        this.bD = riptideAttackDamage;
        this.bE = stack;
        if (!this.dO().B) {
            this.gm();
            this.c(4, true);
        }
    }

    @Override
    @Nonnull
    public net.minecraft.world.item.ItemStack dS() {
        return this.fn() && this.bE != null ? this.bE : super.dS();
    }

    @Override
    public void a(DamageSource damageSource) {
        World world;
        super.a(damageSource);
        this.av();
        if (!this.R_() && (world = this.dO()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.dropAllDeathLoot(worldserver, damageSource);
        }
        if (damageSource != null) {
            this.n(-MathHelper.b((this.eE() + this.dE()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.a((this.eE() + this.dE()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.n(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aD();
        this.c(false);
        this.a(Optional.of(GlobalPos.a(this.dO().af(), this.do())));
    }

    @Override
    protected void ez() {
        super.ez();
        if (!this.dO().ab().b(GameRules.d)) {
            this.fT();
            this.h.k();
        }
    }

    protected void fT() {
        for (int i2 = 0; i2 < this.h.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.h.a(i2);
            if (itemstack.e() || !EnchantmentManager.a(itemstack, EnchantmentEffectComponents.D)) continue;
            this.h.b(i2);
        }
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return source.k().d().a();
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.uk;
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean retainOwnership) {
        return this.a(stack, false, retainOwnership);
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        return this.drop(stack, throwRandomly, retainOwnership, true);
    }

    @Nullable
    public EntityItem drop(net.minecraft.world.item.ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        WorldMap worldmap;
        if (itemstack.e()) {
            return null;
        }
        if (this.dO().B) {
            this.a(EnumHand.a);
        }
        double d0 = this.dx() - (double)0.3f;
        net.minecraft.world.item.ItemStack tmp = itemstack.s();
        itemstack.e(0);
        itemstack = tmp;
        EntityItem entityitem = new EntityItem(this.dO(), this.dt(), d0, this.dz(), itemstack);
        entityitem.b(40);
        if (flag1) {
            entityitem.b((Entity)this);
        }
        if (flag) {
            float f2 = this.ah.i() * 0.5f;
            float f1 = this.ah.i() * ((float)Math.PI * 2);
            entityitem.n(-MathHelper.a(f1) * f2, 0.2f, MathHelper.b(f1) * f2);
        } else {
            float f3 = 0.3f;
            float f1 = MathHelper.a(this.dG() * ((float)Math.PI / 180));
            float f2 = MathHelper.b(this.dG() * ((float)Math.PI / 180));
            float f32 = MathHelper.a(this.dE() * ((float)Math.PI / 180));
            float f4 = MathHelper.b(this.dE() * ((float)Math.PI / 180));
            float f5 = this.ah.i() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.ah.i();
            entityitem.n((double)(-f32 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f1 * 0.3f + 0.1f + (this.ah.i() - this.ah.i()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        if (!callEvent) {
            return entityitem;
        }
        Player player = (Player)this.getBukkitEntity();
        Item drop = (Item)entityitem.getBukkitEntity();
        PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
        this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            ItemStack cur = player.getInventory().getItemInHand();
            if (flag1 && (cur == null || cur.getAmount() == 0)) {
                player.getInventory().setItemInHand(drop.getItemStack());
            } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                cur.setAmount(cur.getAmount() + 1);
                player.getInventory().setItemInHand(cur);
            } else {
                player.getInventory().addItem(new ItemStack[]{drop.getItemStack()});
            }
            return null;
        }
        if (itemstack.g() == Items.rU && (worldmap = ItemWorldMap.b(itemstack, this.dO())) != null) {
            worldmap.a(this, itemstack);
        }
        return entityitem;
    }

    public float c(IBlockData block) {
        float f2 = this.h.a(block);
        if (f2 > 1.0f) {
            f2 += (float)this.g(GenericAttributes.t);
        }
        if (MobEffectUtil.a(this)) {
            f2 *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.b(MobEffects.d)) {
            f2 *= (switch (this.c(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        f2 *= (float)this.g(GenericAttributes.f);
        if (((Entity)this).a(TagsFluid.a)) {
            f2 *= (float)this.f(GenericAttributes.C).f();
        }
        if (!this.aF()) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean d(IBlockData state) {
        return !state.y() || this.h.f().b(state);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a_(this.cD.getId());
        NBTTagList nbttaglist = nbt.c("Inventory", 10);
        this.h.b(nbttaglist);
        this.h.k = nbt.h("SelectedItemSlot");
        this.cz = nbt.g("SleepTimer");
        this.cs = nbt.j("XpP");
        this.cq = nbt.h("XpLevel");
        this.cr = nbt.h("XpTotal");
        this.ct = nbt.h("XpSeed");
        if (this.ct == 0) {
            this.ct = this.ah.f();
        }
        this.r(nbt.h("Score"));
        this.ce.a(nbt);
        this.cA.b(nbt);
        this.f(GenericAttributes.v).a(this.cA.b());
        if (nbt.b("EnderItems", 9)) {
            this.cb.a(nbt.c("EnderItems", 10), this.dQ());
        }
        if (nbt.b("ShoulderEntityLeft", 10)) {
            this.i(nbt.p("ShoulderEntityLeft"));
        }
        if (nbt.b("ShoulderEntityRight", 10)) {
            this.j(nbt.p("ShoulderEntityRight"));
        }
        if (nbt.b("LastDeathLocation", 10)) {
            DataResult dataresult = GlobalPos.b.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("LastDeathLocation"));
            Logger logger = b;
            Objects.requireNonNull(logger);
            this.a(dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)));
        }
        if (nbt.b("current_explosion_impact_pos", 9)) {
            DataResult dataresult1 = Vec3D.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("current_explosion_impact_pos"));
            Logger logger1 = b;
            Objects.requireNonNull(logger1);
            dataresult1.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).ifPresent(vec3d -> {
                this.cx = vec3d;
            });
        }
        this.cI = nbt.q("ignore_fall_damage_from_current_explosion");
        this.cJ = nbt.h("current_impulse_context_reset_grace_time");
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        GameProfileSerializer.e(nbt);
        nbt.a("Inventory", this.h.a(new NBTTagList()));
        nbt.a("SelectedItemSlot", this.h.k);
        nbt.a("SleepTimer", (short)this.cz);
        nbt.a("XpP", this.cs);
        nbt.a("XpLevel", this.cq);
        nbt.a("XpTotal", this.cr);
        nbt.a("XpSeed", this.ct);
        nbt.a("Score", this.fS());
        this.ce.b(nbt);
        this.cA.a(nbt);
        nbt.a("EnderItems", this.cb.a(this.dQ()));
        if (!this.gp().g()) {
            nbt.a("ShoulderEntityLeft", this.gp());
        }
        if (!this.gq().g()) {
            nbt.a("ShoulderEntityRight", this.gq());
        }
        this.gx().flatMap(globalpos -> {
            DataResult dataresult = GlobalPos.b.encodeStart((DynamicOps)DynamicOpsNBT.a, globalpos);
            Logger logger = b;
            Objects.requireNonNull(logger);
            return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
        }).ifPresent(nbtbase -> nbt.a("LastDeathLocation", (NBTBase)nbtbase));
        if (this.cx != null) {
            nbt.a("current_explosion_impact_pos", (NBTBase)Vec3D.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cx).getOrThrow());
        }
        nbt.a("ignore_fall_damage_from_current_explosion", this.cI);
        nbt.a("current_impulse_context_reset_grace_time", this.cJ);
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return super.b(damageSource) ? true : (damageSource.a(DamageTypeTags.n) ? !this.dO().ab().b(GameRules.G) : (damageSource.a(DamageTypeTags.m) ? !this.dO().ab().b(GameRules.H) : (damageSource.a(DamageTypeTags.i) ? !this.dO().ab().b(GameRules.I) : (damageSource.a(DamageTypeTags.o) ? !this.dO().ab().b(GameRules.J) : false))));
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean damaged;
        if (this.b(source)) {
            return false;
        }
        if (this.cA.a && !source.a(DamageTypeTags.d)) {
            return false;
        }
        this.bf = 0;
        if (this.ex()) {
            return false;
        }
        if (!this.dO().B) {
            // empty if block
        }
        if (source.g()) {
            if (this.dO().al() == EnumDifficulty.a) {
                return false;
            }
            if (this.dO().al() == EnumDifficulty.b) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (this.dO().al() == EnumDifficulty.d) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(source, amount)) {
            this.gm();
        }
        return damaged;
    }

    @Override
    protected void d(EntityLiving attacker) {
        super.d(attacker);
        if (attacker.fK()) {
            this.disableShield(attacker);
        }
    }

    @Override
    public boolean ep() {
        return !this.fZ().a && super.ep();
    }

    public boolean a(EntityHuman player) {
        Team team;
        if (player instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)player;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = player.dO().getCraftServer().getOfflinePlayer(player.cB());
            team = player.dO().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.dO().getCraftServer().getOfflinePlayer(this.cB()));
    }

    @Override
    protected void b(DamageSource source, float amount) {
        this.a(source, amount, EnumItemSlot.c, EnumItemSlot.d, EnumItemSlot.e, EnumItemSlot.f);
    }

    @Override
    protected void c(DamageSource source, float amount) {
        this.a(source, amount, EnumItemSlot.f);
    }

    @Override
    protected void x(float amount) {
        if (this.bz.a(Items.vs)) {
            if (!this.dO().B) {
                this.b(StatisticList.c.b(this.bz.g()));
            }
            if (amount >= 3.0f) {
                int i2 = 1 + MathHelper.d(amount);
                EnumHand enumhand = this.fs();
                this.bz.a(i2, (EntityLiving)this, EntityHuman.d(enumhand));
                if (this.bz.e()) {
                    if (enumhand == EnumHand.a) {
                        this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.l);
                    } else {
                        this.a(EnumItemSlot.b, net.minecraft.world.item.ItemStack.l);
                    }
                    this.bz = net.minecraft.world.item.ItemStack.l;
                    this.a(SoundEffects.wE, 0.8f, 0.8f + this.dO().z.i() * 0.4f);
                }
            }
        }
    }

    @Override
    protected boolean actuallyHurt(DamageSource damagesource, float f2) {
        return super.actuallyHurt(damagesource, f2);
    }

    public boolean Z() {
        return false;
    }

    public void a(TileEntitySign sign, boolean front) {
    }

    public void a(CommandBlockListenerAbstract commandBlockExecutor) {
    }

    public void a(TileEntityCommand commandBlock) {
    }

    public void a(TileEntityStructure structureBlock) {
    }

    public void a(TileEntityJigsaw jigsaw) {
    }

    public void a(EntityHorseAbstract horse, IInventory inventory) {
    }

    public OptionalInt a(@Nullable ITileInventory factory) {
        return OptionalInt.empty();
    }

    public void a(int syncId, MerchantRecipeList offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
    }

    public void a(net.minecraft.world.item.ItemStack book, EnumHand hand) {
    }

    public EnumInteractionResult a(Entity entity, EnumHand hand) {
        if (this.R_()) {
            if (entity instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entity));
            }
            return EnumInteractionResult.e;
        }
        net.minecraft.world.item.ItemStack itemstack = this.b(hand);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.s();
        EnumInteractionResult enuminteractionresult = entity.a(this, hand);
        if (enuminteractionresult.a()) {
            if (this.cA.d && itemstack == this.b(hand) && itemstack.H() < itemstack1.H()) {
                itemstack.e(itemstack1.H());
            }
            return enuminteractionresult;
        }
        if (!itemstack.e() && entity instanceof EntityLiving) {
            EnumInteractionResult enuminteractionresult1;
            if (this.cA.d) {
                itemstack = itemstack1;
            }
            if ((enuminteractionresult1 = itemstack.a(this, (EntityLiving)entity, hand)).a()) {
                this.dO().a(GameEvent.r, entity.dm(), GameEvent.a.a(this));
                if (itemstack.e() && !this.cA.d) {
                    this.a(hand, net.minecraft.world.item.ItemStack.l);
                }
                return enuminteractionresult1;
            }
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void bJ() {
        this.removeVehicle(false);
    }

    @Override
    public void removeVehicle(boolean suppressCancellation) {
        super.removeVehicle(suppressCancellation);
        this.K = 0;
    }

    @Override
    protected boolean fc() {
        return super.fc() || this.fH() || this.dJ() || !this.valid;
    }

    @Override
    public boolean ec() {
        return !this.cA.b;
    }

    @Override
    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        float f2 = this.dI();
        if (!this.cA.b && movement.d <= 0.0 && (type == EnumMoveType.a || type == EnumMoveType.b) && this.fP() && this.G(f2)) {
            double d0;
            double d1 = movement.e;
            double d2 = 0.05;
            double d3 = Math.signum(d0) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d0 = movement.c; d0 != 0.0 && this.b(d0, 0.0, f2); d0 -= d3) {
                if (!(Math.abs(d0) <= 0.05)) continue;
                d0 = 0.0;
                break;
            }
            while (d1 != 0.0 && this.b(0.0, d1, f2)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.b(d0, d1, f2)) {
                d0 = Math.abs(d0) <= 0.05 ? 0.0 : (d0 -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3D(d0, movement.d, d1);
        }
        return movement;
    }

    private boolean G(float f2) {
        return this.aF() || this.ac < f2 && !this.b(0.0, 0.0, f2 - this.ac);
    }

    private boolean b(double offsetX, double offsetZ, float f2) {
        AxisAlignedBB axisalignedbb = this.cK();
        return this.dO().a((Entity)this, new AxisAlignedBB(axisalignedbb.a + offsetX, axisalignedbb.b - (double)f2 - (double)1.0E-5f, axisalignedbb.c + offsetZ, axisalignedbb.d + offsetX, axisalignedbb.b, axisalignedbb.f + offsetZ));
    }

    public void e(Entity target) {
        boolean willAttack = target.cu() && !target.u(this);
        PrePlayerAttackEntityEvent playerAttackEntityEvent = new PrePlayerAttackEntityEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), willAttack);
        if (playerAttackEntityEvent.callEvent() && willAttack) {
            float f2 = this.fn() ? this.bD : (float)this.g(GenericAttributes.c);
            net.minecraft.world.item.ItemStack itemstack = this.dS();
            DamageSource damagesource = this.dP().a(this);
            float f1 = this.a(target, f2, damagesource) - f2;
            float f22 = this.F(0.5f);
            f2 *= 0.2f + f22 * f22 * 0.8f;
            f1 *= f22;
            if (target.am().a(TagsEntity.H) && target instanceof IProjectile) {
                IProjectile iprojectile = (IProjectile)target;
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(target, damagesource, f1, false)) {
                    return;
                }
                if (iprojectile.a(ProjectileDeflection.c, this, this, true)) {
                    this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.ud, this.de());
                    return;
                }
            }
            if (f2 > 0.0f || f1 > 0.0f) {
                net.minecraft.world.item.ItemStack itemstack1;
                boolean flag1;
                boolean flag;
                boolean bl = flag = f22 > 0.9f;
                if (this.cc() && flag) {
                    EntityHuman.sendSoundEffect(this, this.dt(), this.dv(), this.dz(), SoundEffects.uc, this.de(), 1.0f, 1.0f);
                    flag1 = true;
                } else {
                    flag1 = false;
                }
                f2 += itemstack.g().a(target, f2, damagesource);
                boolean flag2 = flag && this.ac > 0.0f && !this.aF() && !this.p_() && !this.bf() && !this.b(MobEffects.o) && !this.bS() && target instanceof EntityLiving && !this.cc();
                boolean bl2 = flag2 = flag2 && !this.dO().paperConfig().entities.behavior.disablePlayerCrits;
                if (flag2) {
                    damagesource = damagesource.critical(true);
                    f2 *= 1.5f;
                }
                float f3 = f2 + f1;
                boolean flag3 = false;
                double d0 = this.Z - this.Y;
                if (flag && !flag2 && !flag1 && this.aF() && d0 < (double)this.fj() && (itemstack1 = this.b(EnumHand.a)).g() instanceof ItemSword) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                if (target instanceof EntityLiving) {
                    EntityLiving entityliving = (EntityLiving)target;
                    f4 = entityliving.ew();
                }
                Vec3D vec3d = target.dr();
                boolean flag4 = target.a(damagesource, f3);
                if (flag4) {
                    float f5 = this.a(target, damagesource) + (flag1 ? 1.0f : 0.0f);
                    if (f5 > 0.0f) {
                        if (target instanceof EntityLiving) {
                            EntityLiving entityliving1 = (EntityLiving)target;
                            entityliving1.knockback(f5 * 0.5f, MathHelper.a(this.dE() * ((float)Math.PI / 180)), -MathHelper.b(this.dE() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                        } else {
                            target.push(-MathHelper.a(this.dE() * ((float)Math.PI / 180)) * f5 * 0.5f, 0.1, MathHelper.b(this.dE() * ((float)Math.PI / 180)) * f5 * 0.5f, this);
                        }
                        this.i(this.dr().d(0.6, 1.0, 0.6));
                        if (!this.dO().paperConfig().misc.disableSprintInterruptionOnAttack) {
                            this.h(false);
                        }
                    }
                    if (flag3) {
                        float f6 = 1.0f + (float)this.g(GenericAttributes.D) * f2;
                        List<EntityLiving> list = this.dO().a(EntityLiving.class, target.cK().c(1.0, 0.25, 1.0));
                        for (EntityLiving entityliving2 : list) {
                            World world;
                            if (entityliving2 == this || entityliving2 == target || this.s(entityliving2) || entityliving2 instanceof EntityArmorStand && ((EntityArmorStand)entityliving2).z() || !(this.g((Entity)entityliving2) < 9.0)) continue;
                            float f7 = this.a((Entity)entityliving2, f6, damagesource) * f22;
                            if (entityliving2.a(this.dP().a(this).sweep().critical(flag2), f7)) {
                                entityliving2.knockback(0.4f, MathHelper.a(this.dE() * ((float)Math.PI / 180)), -MathHelper.b(this.dE() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.SWEEP_ATTACK);
                            }
                            if (!((world = this.dO()) instanceof WorldServer)) continue;
                            WorldServer worldserver = (WorldServer)world;
                            EnchantmentManager.a(worldserver, (Entity)entityliving2, damagesource);
                        }
                        EntityHuman.sendSoundEffect(this, this.dt(), this.dv(), this.dz(), SoundEffects.uf, this.de(), 1.0f, 1.0f);
                        this.fV();
                    }
                    if (target instanceof EntityPlayer && target.U) {
                        boolean cancelled = false;
                        Player player = (Player)target.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(vec3d);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)target).c.b(new PacketPlayOutEntityVelocity(target));
                            target.U = false;
                            target.i(vec3d);
                        }
                    }
                    if (flag2) {
                        EntityHuman.sendSoundEffect(this, this.dt(), this.dv(), this.dz(), SoundEffects.ub, this.de(), 1.0f, 1.0f);
                        this.b(target);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            EntityHuman.sendSoundEffect(this, this.dt(), this.dv(), this.dz(), SoundEffects.ue, this.de(), 1.0f, 1.0f);
                        } else {
                            EntityHuman.sendSoundEffect(this, this.dt(), this.dv(), this.dz(), SoundEffects.ug, this.de(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.c(target);
                    }
                    this.A(target);
                    Entity object = target;
                    if (target instanceof EntityComplexPart) {
                        object = ((EntityComplexPart)target).b;
                    }
                    boolean flag5 = false;
                    World world1 = this.dO();
                    if (world1 instanceof WorldServer) {
                        WorldServer worldserver1 = (WorldServer)world1;
                        if (object instanceof EntityLiving) {
                            EntityLiving entityliving2;
                            entityliving2 = (EntityLiving)object;
                            flag5 = itemstack.a(entityliving2, this);
                        }
                        EnchantmentManager.a(worldserver1, target, damagesource);
                    }
                    if (!this.dO().B && !itemstack.e() && object instanceof EntityLiving) {
                        if (flag5) {
                            itemstack.b((EntityLiving)object, this);
                        }
                        if (itemstack.e()) {
                            if (itemstack == this.eT()) {
                                this.a(EnumHand.a, net.minecraft.world.item.ItemStack.l);
                            } else {
                                this.a(EnumHand.b, net.minecraft.world.item.ItemStack.l);
                            }
                        }
                    }
                    if (target instanceof EntityLiving) {
                        float f8 = f4 - ((EntityLiving)target).ew();
                        this.a(StatisticList.G, Math.round(f8 * 10.0f));
                        if (this.dO() instanceof WorldServer && f8 > 2.0f) {
                            int i2 = (int)((double)f8 * 0.5);
                            ((WorldServer)this.dO()).a(Particles.g, target.dt(), target.e(0.5), target.dz(), i2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.dO().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    EntityHuman.sendSoundEffect(this, this.dt(), this.dv(), this.dz(), SoundEffects.ud, this.de(), 1.0f, 1.0f);
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    protected float a(Entity target, float baseDamage, DamageSource damageSource) {
        return baseDamage;
    }

    @Override
    protected void g(EntityLiving target) {
        this.e((Entity)target);
    }

    @DoNotUse
    @Deprecated
    public void fU() {
        this.disableShield(null);
    }

    public void disableShield(@Nullable EntityLiving attacker) {
        CraftEntity finalAttacker;
        CraftEntity craftEntity = finalAttacker = attacker != null ? attacker.getBukkitEntity() : null;
        if (finalAttacker != null) {
            PlayerShieldDisableEvent shieldDisableEvent = new PlayerShieldDisableEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)finalAttacker, 100);
            if (!shieldDisableEvent.callEvent()) {
                return;
            }
            this.gt().a(Items.vs, shieldDisableEvent.getCooldown());
        } else {
            this.gt().a(Items.vs, 100);
        }
        this.fx();
        this.dO().a((Entity)this, (byte)30);
    }

    public void b(Entity target) {
    }

    public void c(Entity target) {
    }

    public void fV() {
        double d0 = -MathHelper.a(this.dE() * ((float)Math.PI / 180));
        double d1 = MathHelper.b(this.dE() * ((float)Math.PI / 180));
        if (this.dO() instanceof WorldServer) {
            ((WorldServer)this.dO()).a(Particles.aj, this.dt() + d0, this.e(0.5), this.dz() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void fW() {
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        super.remove(entity_removalreason, cause);
        this.cc.a(this);
        if (this.cd != null && this.ga()) {
            this.t();
        }
    }

    public boolean g() {
        return false;
    }

    public GameProfile fX() {
        return this.cD;
    }

    public PlayerInventory fY() {
        return this.h;
    }

    public PlayerAbilities fZ() {
        return this.cA;
    }

    @Override
    public boolean fL() {
        return this.cA.d;
    }

    public void a(net.minecraft.world.item.ItemStack cursorStack, net.minecraft.world.item.ItemStack slotStack, ClickAction clickType) {
    }

    public boolean ga() {
        return this.cd != this.cc;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition pos) {
        return this.startSleepInBed(pos, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        this.b(blockposition);
        this.cz = 0;
        return Either.right(Unit.a);
    }

    public void a(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        super.fI();
        if (this.dO() instanceof WorldServer && updateSleepingPlayers) {
            ((WorldServer)this.dO()).e();
        }
        this.cz = skipSleepTimer ? 0 : 100;
    }

    @Override
    public void fI() {
        this.a(true, true);
    }

    public boolean gb() {
        return this.fH() && this.cz >= 100;
    }

    public int gc() {
        return this.cz;
    }

    public void a(IChatBaseComponent message, boolean overlay) {
    }

    public void a(MinecraftKey stat) {
        this.b(StatisticList.i.b(stat));
    }

    public void a(MinecraftKey stat, int amount) {
        this.a(StatisticList.i.b(stat), amount);
    }

    public void b(Statistic<?> stat) {
        this.a(stat, 1);
    }

    public void a(Statistic<?> stat, int amount) {
    }

    public void a(Statistic<?> stat) {
    }

    public int a(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    public void a(RecipeHolder<?> recipe, List<net.minecraft.world.item.ItemStack> ingredients) {
    }

    public void b(List<MinecraftKey> recipes) {
    }

    public int b(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    @Override
    public void ff() {
        super.ff();
        this.a(StatisticList.E);
        if (this.cc()) {
            this.causeFoodExhaustion(this.dO().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.dO().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void a(Vec3D movementInput) {
        double d0;
        if (this.cd() && !this.bS()) {
            double d1;
            d0 = this.bM().d;
            double d2 = d1 = d0 < -0.2 ? 0.085 : 0.06;
            if (d0 <= 0.0 || this.bn || !this.dO().a_(BlockPosition.a(this.dt(), this.dv() + 1.0 - 0.1, this.dz())).u().c()) {
                Vec3D vec3d1 = this.dr();
                this.i(vec3d1.b(0.0, (d0 - vec3d1.d) * d1, 0.0));
            }
        }
        if (this.cA.b && !this.bS()) {
            d0 = this.dr().d;
            super.a(movementInput);
            Vec3D vec3d2 = this.dr();
            this.n(vec3d2.c, d0 * 0.6, vec3d2.e);
            this.n();
            if (this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                this.b(7, false);
            }
        } else {
            super.a(movementInput);
        }
    }

    @Override
    public void bl() {
        if (this.cA.b) {
            this.i(false);
        } else {
            super.bl();
        }
    }

    protected boolean h(BlockPosition pos) {
        return !this.dO().a_(pos).o(this.dO(), pos);
    }

    @Override
    public float fj() {
        return (float)this.g(GenericAttributes.v);
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag;
        if (this.cA.c && !this.flyingFallDamage.toBooleanOrElse(false)) {
            return false;
        }
        if (fallDistance >= 2.0f) {
            this.a(StatisticList.t, (int)Math.round((double)fallDistance * 100.0));
        }
        if (this.cI && this.cx != null) {
            double d0 = this.cx.d;
            this.gB();
            if (d0 < this.dv()) {
                return false;
            }
            float f2 = Math.min(fallDistance, (float)(d0 - this.dv()));
            flag = super.a(f2, damageMultiplier, damageSource);
        } else {
            flag = super.a(fallDistance, damageMultiplier, damageSource);
        }
        if (flag) {
            this.gC();
        }
        return flag;
    }

    public boolean gd() {
        net.minecraft.world.item.ItemStack itemstack;
        if (!this.aF() && !this.fA() && !this.bf() && !this.b(MobEffects.y) && (itemstack = this.a(EnumItemSlot.e)).a(Items.nT) && ItemElytra.i(itemstack)) {
            this.ge();
            return true;
        }
        return false;
    }

    public void ge() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    public void gf() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bo() {
        if (!this.R_()) {
            super.bo();
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (this.bf()) {
            this.aU();
            this.b(state);
        } else {
            BlockPosition blockposition1 = this.e(pos);
            if (!pos.equals(blockposition1)) {
                IBlockData iblockdata1 = this.dO().a_(blockposition1);
                if (iblockdata1.a(TagsBlock.bp)) {
                    this.a(iblockdata1, state);
                } else {
                    super.b(blockposition1, iblockdata1);
                }
            } else {
                super.b(pos, state);
            }
        }
    }

    @Override
    public EntityLiving.a eH() {
        return new EntityLiving.a(SoundEffects.ur, SoundEffects.uh);
    }

    @Override
    public boolean a(WorldServer world, EntityLiving other) {
        this.b(StatisticList.g.b(other.am()));
        return true;
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
        if (!this.cA.b) {
            super.a(state, multiplier);
        }
        this.gB();
    }

    public void d(int experience) {
        this.s(experience);
        this.cs += (float)experience / (float)this.gh();
        this.cr = MathHelper.a(this.cr + experience, 0, Integer.MAX_VALUE);
        while (this.cs < 0.0f) {
            float f2 = this.cs * (float)this.gh();
            if (this.cq > 0) {
                this.c(-1);
                this.cs = 1.0f + f2 / (float)this.gh();
                continue;
            }
            this.c(-1);
            this.cs = 0.0f;
        }
        while (this.cs >= 1.0f) {
            this.cs = (this.cs - 1.0f) * (float)this.gh();
            this.c(1);
            this.cs /= (float)this.gh();
        }
    }

    public int gg() {
        return this.ct;
    }

    public void a(net.minecraft.world.item.ItemStack enchantedItem, int experienceLevels) {
        this.cq -= experienceLevels;
        if (this.cq < 0) {
            this.cq = 0;
            this.cs = 0.0f;
            this.cr = 0;
        }
        this.ct = this.ah.f();
    }

    public void c(int levels) {
        this.cq += levels;
        if (this.cq < 0) {
            this.cq = 0;
            this.cs = 0.0f;
            this.cr = 0;
        }
        if (levels > 0 && this.cq % 5 == 0 && (float)this.cB < (float)this.ai - 100.0f) {
            float f2 = this.cq > 30 ? 1.0f : (float)this.cq / 30.0f;
            this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.uq, this.de(), f2 * 0.75f, 1.0f);
            this.cB = this.ai;
        }
    }

    public int gh() {
        return this.cq >= 30 ? 112 + (this.cq - 30) * 9 : (this.cq >= 15 ? 37 + (this.cq - 15) * 5 : 7 + this.cq * 2);
    }

    private static void sendSoundEffect(EntityHuman fromEntity, double x2, double y2, double z2, SoundEffect soundEffect, SoundCategory soundCategory, float volume, float pitch) {
        fromEntity.dO().a(fromEntity, x2, y2, z2, soundEffect, soundCategory, volume, pitch);
        if (fromEntity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)fromEntity;
            serverPlayer.c.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(soundEffect), soundCategory, x2, y2, z2, volume, pitch, fromEntity.ah.g()));
        }
    }

    public void E(float exhaustion) {
        this.causeFoodExhaustion(exhaustion, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float f2, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.cA.a || this.dO().B || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, f2)).isCancelled())) {
            this.ce.a(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> ab() {
        return Optional.empty();
    }

    public FoodMetaData gi() {
        return this.ce;
    }

    public boolean u(boolean ignoreHunger) {
        return this.cA.a || ignoreHunger || this.ce.c();
    }

    public boolean gj() {
        return this.ew() > 0.0f && this.ew() < this.eN();
    }

    public boolean gk() {
        return this.cA.e;
    }

    public boolean a(BlockPosition pos, EnumDirection facing, net.minecraft.world.item.ItemStack stack) {
        if (this.cA.e) {
            return true;
        }
        BlockPosition blockposition1 = pos.a(facing.g());
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(this.dO(), blockposition1, false);
        return stack.a(shapedetectorblock);
    }

    @Override
    protected int eg() {
        if (!this.dO().ab().b(GameRules.d) && !this.R_()) {
            int i2 = this.cq * 7;
            return i2 > 100 ? 100 : i2;
        }
        return 0;
    }

    @Override
    protected boolean eh() {
        return true;
    }

    @Override
    public boolean cF() {
        return true;
    }

    @Override
    protected Entity.MovementEmission bc() {
        return !this.cA.b && (!this.aF() || !this.bZ()) ? Entity.MovementEmission.d : Entity.MovementEmission.a;
    }

    public void z() {
    }

    @Override
    public IChatBaseComponent ah() {
        return IChatBaseComponent.b(this.cD.getName());
    }

    public InventoryEnderChest gl() {
        return this.cb;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(EnumItemSlot slot) {
        return slot == EnumItemSlot.a ? this.h.f() : (slot == EnumItemSlot.b ? this.h.j.get(0) : (slot.a() == EnumItemSlot.Function.b ? this.h.i.get(slot.b()) : net.minecraft.world.item.ItemStack.l));
    }

    @Override
    protected boolean b(EnumItemSlot slot) {
        return slot.a() == EnumItemSlot.Function.b;
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.e(itemstack);
        if (enumitemslot == EnumItemSlot.a) {
            this.onEquipItem(enumitemslot, this.h.h.set(this.h.k, itemstack), itemstack, silent);
        } else if (enumitemslot == EnumItemSlot.b) {
            this.onEquipItem(enumitemslot, this.h.j.set(0, itemstack), itemstack, silent);
        } else if (enumitemslot.a() == EnumItemSlot.Function.b) {
            this.onEquipItem(enumitemslot, this.h.i.set(enumitemslot.b(), itemstack), itemstack, silent);
        }
    }

    public boolean i(net.minecraft.world.item.ItemStack stack) {
        return this.h.f(stack);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> eW() {
        return Lists.newArrayList((Object[])new net.minecraft.world.item.ItemStack[]{this.eT(), this.eU()});
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> eV() {
        return this.h.i;
    }

    @Override
    public boolean d(EnumItemSlot slot) {
        return slot != EnumItemSlot.g;
    }

    public boolean h(NBTTagCompound entityNbt) {
        if (!this.bS() && this.aF() && !this.bf() && !this.az) {
            if (this.gp().g()) {
                this.i(entityNbt);
                this.g = this.dO().Z();
                return true;
            }
            if (this.gq().g()) {
                this.j(entityNbt);
                this.g = this.dO().Z();
                return true;
            }
            return false;
        }
        return false;
    }

    public void gm() {
        if (this.g + 20L < this.dO().Z()) {
            if (this.respawnEntityOnShoulder(this.gp())) {
                this.i(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.gq())) {
                this.j(new NBTTagCompound());
            }
        }
    }

    public Entity releaseLeftShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.gp());
        if (entity != null) {
            this.i(new NBTTagCompound());
        }
        return entity;
    }

    public Entity releaseRightShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.gq());
        if (entity != null) {
            this.j(new NBTTagCompound());
        }
        return entity;
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound nbttagcompound) {
        return this.respawnEntityOnShoulder0(nbttagcompound) != null;
    }

    private Entity respawnEntityOnShoulder0(NBTTagCompound nbttagcompound) {
        if (!this.dO().B && nbttagcompound != null && !nbttagcompound.g()) {
            return EntityTypes.a(nbttagcompound, this.dO()).map(entity -> {
                if (entity instanceof EntityTameableAnimal) {
                    ((EntityTameableAnimal)entity).b(this.ax);
                }
                entity.a_(this.dt(), this.dv() + (double)0.7f, this.dz());
                boolean addedToWorld = ((WorldServer)this.dO()).addWithUUID((Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
                return addedToWorld ? entity : null;
            }).orElse(null);
        }
        return null;
    }

    @Override
    public abstract boolean R_();

    @Override
    public boolean bz() {
        return !this.R_() && super.bz();
    }

    @Override
    public boolean cd() {
        return !this.cA.b && !this.R_() && super.cd();
    }

    public abstract boolean f();

    @Override
    public boolean cC() {
        return !this.cA.b;
    }

    public Scoreboard gn() {
        return this.dO().M();
    }

    @Override
    public IChatBaseComponent S_() {
        IChatMutableComponent ichatmutablecomponent = ScoreboardTeam.a(this.ck(), this.ah());
        return this.a(ichatmutablecomponent);
    }

    private IChatMutableComponent a(IChatMutableComponent component) {
        String s2 = this.fX().getName();
        return component.a(chatmodifier -> chatmodifier.a(new ChatClickable(ChatClickable.EnumClickAction.d, "/tell " + s2 + " ")).a(this.cJ()).a(s2));
    }

    @Override
    public String cB() {
        return this.fX().getName();
    }

    @Override
    protected void D(float absorptionAmount) {
        this.ar().a(e, Float.valueOf(absorptionAmount));
    }

    @Override
    public float fo() {
        return this.ar().a(e).floatValue();
    }

    public boolean a(PlayerModelPart modelPart) {
        return (this.ar().a(bX) & modelPart.a()) == modelPart.a();
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        if (mappedIndex == 499) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack a() {
                    return EntityHuman.this.cd.g();
                }

                @Override
                public boolean a(net.minecraft.world.item.ItemStack stack) {
                    EntityHuman.this.cd.b(stack);
                    return true;
                }
            };
        }
        final int j2 = mappedIndex - 500;
        if (j2 >= 0 && j2 < 4) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack a() {
                    return EntityHuman.this.cc.r().a(j2);
                }

                @Override
                public boolean a(net.minecraft.world.item.ItemStack stack) {
                    EntityHuman.this.cc.r().a(j2, stack);
                    EntityHuman.this.cc.a(EntityHuman.this.h);
                    return true;
                }
            };
        }
        if (mappedIndex >= 0 && mappedIndex < this.h.h.size()) {
            return SlotAccess.a(this.h, mappedIndex);
        }
        int k2 = mappedIndex - 200;
        return k2 >= 0 && k2 < this.cb.b() ? SlotAccess.a(this.cb, k2) : super.a_(mappedIndex);
    }

    public boolean go() {
        return this.cE;
    }

    public void v(boolean reducedDebugInfo) {
        this.cE = reducedDebugInfo;
    }

    @Override
    public void h(int fireTicks) {
        super.h(this.cA.a ? Math.min(fireTicks, 1) : fireTicks);
    }

    @Override
    public EnumMainHand fq() {
        return this.ao.a(bY) == 0 ? EnumMainHand.a : EnumMainHand.b;
    }

    public void a(EnumMainHand arm) {
        this.ao.a(bY, (byte)(arm != EnumMainHand.a ? 1 : 0));
    }

    public NBTTagCompound gp() {
        return this.ao.a(bZ);
    }

    public void i(NBTTagCompound entityNbt) {
        this.ao.a(bZ, entityNbt);
    }

    public NBTTagCompound gq() {
        return this.ao.a(ca);
    }

    public void j(NBTTagCompound entityNbt) {
        this.ao.a(ca, entityNbt);
    }

    public float gr() {
        return (float)(1.0 / this.g(GenericAttributes.e) * 20.0);
    }

    public float F(float baseTime) {
        return MathHelper.a(((float)this.aT + baseTime) / this.gr(), 0.0f, 1.0f);
    }

    public void gs() {
        this.aT = 0;
    }

    public ItemCooldown gt() {
        return this.cG;
    }

    @Override
    protected float aO() {
        return !this.cA.b && !this.fA() ? super.aO() : 1.0f;
    }

    public float gu() {
        return (float)this.g(GenericAttributes.q);
    }

    public boolean gv() {
        return this.cA.d && this.G() >= 2;
    }

    @Override
    public boolean f(net.minecraft.world.item.ItemStack stack) {
        EnumItemSlot enumitemslot = this.h(stack);
        return this.a(enumitemslot).e();
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return d.getOrDefault((Object)pose, bW);
    }

    @Override
    public ImmutableList<EntityPose> fE() {
        return ImmutableList.of((Object)((Object)EntityPose.a), (Object)((Object)EntityPose.f), (Object)((Object)EntityPose.d));
    }

    protected boolean tryReadyArrow(net.minecraft.world.item.ItemStack bow, net.minecraft.world.item.ItemStack itemstack) {
        return !(this instanceof EntityPlayer) || new PlayerReadyArrowEvent((Player)((EntityPlayer)this).getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(bow), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
    }

    @Override
    public net.minecraft.world.item.ItemStack g(net.minecraft.world.item.ItemStack stack) {
        if (!(stack.g() instanceof ItemProjectileWeapon)) {
            return net.minecraft.world.item.ItemStack.l;
        }
        Predicate<net.minecraft.world.item.ItemStack> predicate = ((ItemProjectileWeapon)stack.g()).d().and(item -> this.tryReadyArrow(stack, (net.minecraft.world.item.ItemStack)item));
        net.minecraft.world.item.ItemStack itemstack1 = ItemProjectileWeapon.a(this, predicate);
        if (!itemstack1.e()) {
            return itemstack1;
        }
        predicate = ((ItemProjectileWeapon)stack.g()).b().and(item -> this.tryReadyArrow(stack, (net.minecraft.world.item.ItemStack)item));
        for (int i2 = 0; i2 < this.h.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack2 = this.h.a(i2);
            if (!predicate.test(itemstack2)) continue;
            return itemstack2;
        }
        return this.cA.d ? new net.minecraft.world.item.ItemStack(Items.ow) : net.minecraft.world.item.ItemStack.l;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(World world, net.minecraft.world.item.ItemStack stack, FoodInfo foodComponent) {
        this.gi().eat(stack, foodComponent);
        this.b(StatisticList.c.b(stack.g()));
        world.a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.uj, SoundCategory.h, 0.5f, world.z.i() * 0.1f + 0.9f);
        if (this instanceof EntityPlayer) {
            CriterionTriggers.A.a((EntityPlayer)this, stack);
        }
        net.minecraft.world.item.ItemStack itemstack1 = super.a(world, stack, foodComponent);
        Optional<net.minecraft.world.item.ItemStack> optional = foodComponent.f();
        if (optional.isPresent() && !this.fL()) {
            if (itemstack1.e()) {
                return optional.get().s();
            }
            if (!this.dO().x_()) {
                this.fY().f(optional.get().s());
            }
        }
        return itemstack1;
    }

    @Override
    public Vec3D s(float delta) {
        float f3;
        double d0 = 0.22 * (this.fq() == EnumMainHand.b ? -1.0 : 1.0);
        float f1 = MathHelper.i(delta * 0.5f, this.dG(), this.P) * ((float)Math.PI / 180);
        float f2 = MathHelper.i(delta, this.aZ, this.aY) * ((float)Math.PI / 180);
        if (!this.fA() && !this.fn()) {
            if (this.ce()) {
                return this.m(delta).e(new Vec3D(d0, 0.2, -0.15).a(-f1).b(-f2));
            }
            double d2 = this.cK().c() - 1.0;
            double d1 = this.cb() ? -0.2 : 0.07;
            return this.m(delta).e(new Vec3D(d0, d2, d1).b(-f2));
        }
        Vec3D vec3d = this.g(delta);
        Vec3D vec3d1 = this.dr();
        double d1 = vec3d1.i();
        double d3 = vec3d.i();
        if (d1 > 0.0 && d3 > 0.0) {
            double d4 = (vec3d1.c * vec3d.c + vec3d1.e * vec3d.e) / Math.sqrt(d1 * d3);
            double d5 = vec3d1.c * vec3d.e - vec3d1.e * vec3d.c;
            f3 = (float)(Math.signum(d5) * Math.acos(d4));
        } else {
            f3 = 0.0f;
        }
        return this.m(delta).e(new Vec3D(d0, -0.11, 0.85).c(-f3).a(-f1).b(-f2));
    }

    @Override
    public boolean dN() {
        return true;
    }

    public boolean gw() {
        return this.fr() && this.ft().a(Items.qX);
    }

    @Override
    public boolean dM() {
        return false;
    }

    public Optional<GlobalPos> gx() {
        return this.cH;
    }

    public void a(Optional<GlobalPos> lastDeathPos) {
        this.cH = lastDeathPos;
    }

    @Override
    public float eE() {
        return this.cw;
    }

    @Override
    public void n(float yaw) {
        super.n(yaw);
        this.cw = yaw;
    }

    @Override
    public boolean dH() {
        return true;
    }

    @Override
    protected float fi() {
        return this.cA.b && !this.bS() ? (this.cc() ? this.cA.a() * 2.0f : this.cA.a()) : (this.cc() ? 0.025999999f : 0.02f);
    }

    public double gy() {
        return this.g(GenericAttributes.g);
    }

    public double gz() {
        return this.g(GenericAttributes.j);
    }

    public boolean b(Entity entity, double additionalRange) {
        return entity.dJ() ? false : this.a(entity.cK(), additionalRange);
    }

    public boolean a(AxisAlignedBB box, double additionalRange) {
        double d1 = this.gz() + additionalRange;
        return box.e(this.by()) < d1 * d1;
    }

    public boolean a(BlockPosition pos, double additionalRange) {
        double d1 = this.gy() + additionalRange;
        return new AxisAlignedBB(pos).e(this.by()) < d1 * d1;
    }

    public void w(boolean ignoreFallDamageFromCurrentExplosion) {
        this.cI = ignoreFallDamageFromCurrentExplosion;
        this.cJ = ignoreFallDamageFromCurrentExplosion ? 40 : 0;
    }

    public boolean gA() {
        return this.cI;
    }

    public void gB() {
        if (this.cJ == 0) {
            this.gC();
        }
    }

    public void gC() {
        this.cJ = 0;
        this.cy = null;
        this.cx = null;
        this.cI = false;
    }

    public static enum EnumBedResult {
        a,
        b(IChatBaseComponent.c("block.minecraft.bed.no_sleep")),
        c(IChatBaseComponent.c("block.minecraft.bed.too_far_away")),
        d(IChatBaseComponent.c("block.minecraft.bed.obstructed")),
        e,
        f(IChatBaseComponent.c("block.minecraft.bed.not_safe"));

        @Nullable
        private final IChatBaseComponent g;

        private EnumBedResult() {
            this.g = null;
        }

        private EnumBedResult(IChatBaseComponent ichatbasecomponent) {
            this.g = ichatbasecomponent;
        }

        @Nullable
        public IChatBaseComponent a() {
            return this.g;
        }
    }
}

