/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class EntityStrider
extends EntityAnimal
implements ISteerable,
ISaddleable {
    private static final MinecraftKey cc = MinecraftKey.b("suffocating");
    private static final AttributeModifier cd = new AttributeModifier(cc, -0.34f, AttributeModifier.Operation.b);
    private static final float ce = 0.35f;
    private static final float cg = 0.55f;
    private static final DataWatcherObject<Integer> ch = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> ci = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cj = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    public final SaddleStorage ck;
    @Nullable
    private PathfinderGoalTempt cl;

    public EntityStrider(EntityTypes<? extends EntityStrider> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.ck = new SaddleStorage(this.ao, ch, cj);
        this.J = true;
        this.a(PathType.j, -1.0f);
        this.a(PathType.i, 0.0f);
        this.a(PathType.n, 0.0f);
        this.a(PathType.o, 0.0f);
    }

    public static boolean c(EntityTypes<EntityStrider> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.k();
        do {
            blockposition_mutableblockposition.c(EnumDirection.b);
        } while (world.b_(blockposition_mutableblockposition).a(TagsFluid.b));
        return world.a_(blockposition_mutableblockposition).i();
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (ch.equals(data) && this.dO().B) {
            this.ck.a();
        }
        super.a(data);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ch, 0);
        builder.a(ci, false);
        builder.a(cj, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.ck.a(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.ck.b(nbt);
    }

    @Override
    public boolean i() {
        return this.ck.d();
    }

    @Override
    public boolean f() {
        return this.bE() && !this.o_();
    }

    @Override
    public void a(ItemStack stack, @Nullable SoundCategory soundCategory) {
        this.ck.a(true);
        if (soundCategory != null) {
            this.dO().a((EntityHuman)null, this, SoundEffects.ye, soundCategory, 0.5f, 1.0f);
        }
    }

    @Override
    protected void B() {
        this.bW.a(1, new PathfinderGoalPanic(this, 1.65));
        this.bW.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cl = new PathfinderGoalTempt(this, 1.4, itemstack -> itemstack.a(TagsItem.au), false);
        this.bW.a(3, this.cl);
        this.bW.a(4, new a(this, 1.0));
        this.bW.a(5, new PathfinderGoalFollowParent(this, 1.0));
        this.bW.a(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.bW.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bW.a(8, new PathfinderGoalRandomLookaround(this));
        this.bW.a(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void x(boolean cold) {
        this.ao.a(ci, cold);
        AttributeModifiable attributemodifiable = this.f(GenericAttributes.v);
        if (attributemodifiable != null) {
            if (cold) {
                attributemodifiable.a(cd);
            } else {
                attributemodifiable.c(cc);
            }
        }
    }

    public boolean s() {
        return this.ao.a(ci);
    }

    @Override
    public boolean a(Fluid state) {
        return state.a(TagsFluid.b);
    }

    @Override
    protected Vec3D a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        float f1 = Math.min(0.25f, this.aU.a());
        float f2 = this.aU.b();
        float f3 = 0.12f * MathHelper.b(f2 * 1.5f) * 2.0f * f1;
        return super.a(passenger, dimensions, scaleFactor).b(0.0, f3 * scaleFactor, 0.0);
    }

    @Override
    public boolean a(IWorldReader world) {
        return world.f(this);
    }

    @Override
    @Nullable
    public EntityLiving cQ() {
        EntityHuman entityhuman;
        Entity entity;
        if (this.i() && (entity = this.cT()) instanceof EntityHuman && (entityhuman = (EntityHuman)entity).b(Items.nS)) {
            return entityhuman;
        }
        return super.cQ();
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D[] avec3d = new Vec3D[]{EntityStrider.a(this.dj(), passenger.dj(), passenger.dE()), EntityStrider.a(this.dj(), passenger.dj(), passenger.dE() - 22.5f), EntityStrider.a(this.dj(), passenger.dj(), passenger.dE() + 22.5f), EntityStrider.a(this.dj(), passenger.dj(), passenger.dE() - 45.0f), EntityStrider.a(this.dj(), passenger.dj(), passenger.dE() + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.cK().e;
        double d1 = this.cK().b - 0.5;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        Vec3D[] avec3d1 = avec3d;
        int i2 = avec3d.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            Vec3D vec3d = avec3d1[j2];
            blockposition_mutableblockposition.b(this.dt() + vec3d.c, d0, this.dz() + vec3d.e);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockposition_mutableblockposition.j());
                blockposition_mutableblockposition.c(EnumDirection.a);
            }
        }
        for (BlockPosition blockposition : set) {
            double d3;
            if (this.dO().b_(blockposition).a(TagsFluid.b) || !DismountUtil.a(d3 = this.dO().j(blockposition))) continue;
            Vec3D vec3d1 = Vec3D.a(blockposition, d3);
            for (EntityPose entitypose : passenger.fE()) {
                AxisAlignedBB axisalignedbb = passenger.f(entitypose);
                if (!DismountUtil.a(this.dO(), passenger, axisalignedbb.c(vec3d1))) continue;
                passenger.b(entitypose);
                return vec3d1;
            }
        }
        return new Vec3D(this.dt(), this.cK().e, this.dz());
    }

    @Override
    protected void a(EntityHuman controllingPlayer, Vec3D movementInput) {
        this.a(controllingPlayer.dE(), controllingPlayer.dG() * 0.5f);
        this.aY = this.ba = this.dE();
        this.O = this.ba;
        this.ck.b();
        super.a(controllingPlayer, movementInput);
    }

    @Override
    protected Vec3D b(EntityHuman controllingPlayer, Vec3D movementInput) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float e(EntityHuman controllingPlayer) {
        return (float)(this.g(GenericAttributes.v) * (double)(this.s() ? 0.35f : 0.55f) * (double)this.ck.c());
    }

    @Override
    protected float aP() {
        return this.aa + 0.6f;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(this.bt() ? SoundEffects.yc : SoundEffects.yb, 1.0f, 1.0f);
    }

    @Override
    public boolean a() {
        return this.ck.a(this.dR());
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        this.aT();
        if (this.bt()) {
            this.n();
        } else {
            super.a(heightDifference, onGround, state, landedPosition);
        }
    }

    @Override
    public void l() {
        if (this.x() && this.ah.a(140) == 0) {
            this.b(SoundEffects.xX);
        } else if (this.gh() && this.ah.a(60) == 0) {
            this.b(SoundEffects.xY);
        }
        if (!this.fZ()) {
            boolean suffocating;
            EntityStrider entitystrider;
            IBlockData iblockdata = this.dO().a_(this.do());
            IBlockData iblockdata1 = this.bp();
            boolean flag = iblockdata.a(TagsBlock.aV) || iblockdata1.a(TagsBlock.aV) || this.b(TagsFluid.b) > 0.0;
            Entity entity = this.dc();
            boolean flag1 = entity instanceof EntityStrider && (entitystrider = (EntityStrider)entity).s();
            boolean flag2 = flag1;
            boolean bl = suffocating = !flag || flag2;
            if (suffocating ^ this.s() && CraftEventFactory.callStriderTemperatureChangeEvent(this, suffocating)) {
                this.x(suffocating);
            }
        }
        super.l();
        this.gk();
        this.aT();
    }

    private boolean x() {
        return this.cl != null && this.cl.i();
    }

    @Override
    protected boolean D() {
        return true;
    }

    private void gk() {
        if (this.bt()) {
            VoxelShapeCollision voxelshapecollision = VoxelShapeCollision.a(this);
            if (voxelshapecollision.a(BlockFluids.d, this.do(), true) && !this.dO().b_(this.do().d()).a(TagsFluid.b)) {
                this.d(true);
            } else {
                this.i(this.dr().a(0.5).b(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeProvider.Builder t() {
        return EntityInsentient.C().a(GenericAttributes.v, 0.175f).a(GenericAttributes.m, 16.0);
    }

    @Override
    protected SoundEffect v() {
        return !this.gh() && !this.x() ? SoundEffects.xW : null;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.ya;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.xZ;
    }

    @Override
    protected boolean r(Entity passenger) {
        return !this.bT() && !((Entity)this).a(TagsFluid.b);
    }

    @Override
    public boolean fl() {
        return true;
    }

    @Override
    public boolean bR() {
        return false;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new b(this, world);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos).u().a(TagsFluid.b) ? 10.0f : (this.bt() ? Float.NEGATIVE_INFINITY : 0.0f);
    }

    @Nullable
    public EntityStrider b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.aZ.a(world);
    }

    @Override
    public boolean o(ItemStack stack) {
        return stack.a(TagsItem.at);
    }

    @Override
    protected void ez() {
        super.ez();
        if (this.i()) {
            this.a((IMaterial)Items.nL);
        }
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean flag = this.o(player.b(hand));
        if (!flag && this.i() && !this.bT() && !player.fN()) {
            if (!this.dO().B) {
                player.n(this);
            }
            return EnumInteractionResult.a(this.dO().B);
        }
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = player.b(hand);
            return itemstack.a(Items.nL) ? itemstack.a(player, (EntityLiving)this, hand) : EnumInteractionResult.e;
        }
        if (flag && !this.aX()) {
            this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.yd, this.de(), 1.0f, 1.0f + (this.ah.i() - this.ah.i()) * 0.2f);
        }
        return enuminteractionresult;
    }

    @Override
    public Vec3D cM() {
        return new Vec3D(0.0, 0.6f * this.cL(), this.dj() * 0.4f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData) {
        if (this.o_()) {
            return super.a(world, difficulty, spawnReason, entityData);
        }
        RandomSource randomsource = world.E_();
        if (randomsource.a(30) == 0) {
            EntityInsentient entityinsentient = EntityTypes.bx.a(world.E());
            if (entityinsentient != null) {
                entityData = this.a(world, difficulty, entityinsentient, (GroupDataEntity)new EntityZombie.GroupDataZombie(EntityZombie.a(randomsource), false));
                entityinsentient.a(EnumItemSlot.a, new ItemStack(Items.nS));
                this.a(new ItemStack(Items.nL), (SoundCategory)null);
            }
        } else if (randomsource.a(10) == 0) {
            EntityAgeable entityageable = EntityTypes.aZ.a(world.E());
            if (entityageable != null) {
                entityageable.c_(-24000);
                entityData = this.a(world, difficulty, entityageable, (GroupDataEntity)null);
            }
        } else {
            entityData = new EntityAgeable.a(0.5f);
        }
        return super.a(world, difficulty, spawnReason, entityData);
    }

    private GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntityInsentient rider, @Nullable GroupDataEntity entityData) {
        rider.b(this.dt(), this.dv(), this.dz(), this.dE(), 0.0f);
        rider.a(world, difficulty, EnumMobSpawn.g, entityData);
        rider.a((Entity)this, true);
        return new EntityAgeable.a(0.0f);
    }

    private static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider g;

        a(EntityStrider strider, double speed) {
            super(strider, speed, 8, 2);
            this.g = strider;
        }

        @Override
        public BlockPosition k() {
            return this.e;
        }

        @Override
        public boolean c() {
            return !this.g.bt() && this.a(this.g.dO(), this.e);
        }

        @Override
        public boolean b() {
            return !this.g.bt() && super.b();
        }

        @Override
        public boolean l() {
            return this.d % 20 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            return world.a_(pos).a(Blocks.H) && world.a_(pos.d()).a(PathMode.a);
        }
    }

    private static class b
    extends Navigation {
        b(EntityStrider entity, World world) {
            super(entity, world);
        }

        @Override
        protected Pathfinder a(int range) {
            this.o = new PathfinderNormal();
            this.o.a(true);
            return new Pathfinder(this.o, range);
        }

        @Override
        protected boolean a(PathType pathType) {
            return pathType != PathType.i && pathType != PathType.o && pathType != PathType.n ? super.a(pathType) : true;
        }

        @Override
        public boolean a(BlockPosition pos) {
            return this.b.a_(pos).a(Blocks.H) || super.a(pos);
        }
    }
}

