/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.portal.DimensionTransition;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Explosive;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityTNTPrimed
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityTNTPrimed.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<IBlockData> d = DataWatcher.a(EntityTNTPrimed.class, DataWatcherRegistry.i);
    private static final int e = 80;
    private static final String f = "block_state";
    public static final String b = "fuse";
    private static final ExplosionDamageCalculator g = new ExplosionDamageCalculator(){

        @Override
        public boolean a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData state, float power) {
            return state.a(Blocks.ed) ? false : super.a(explosion, world, pos, state, power);
        }

        @Override
        public Optional<Float> a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData blockState, Fluid fluidState) {
            return blockState.a(Blocks.ed) ? Optional.empty() : super.a(explosion, world, pos, blockState, fluidState);
        }
    };
    @Nullable
    public EntityLiving h;
    private boolean i;
    public float yield = 4.0f;
    public boolean isIncendiary = false;

    public EntityTNTPrimed(EntityTypes<? extends EntityTNTPrimed> type, World world) {
        super(type, world);
        this.J = true;
    }

    public EntityTNTPrimed(World world, double x2, double y2, double z2, @Nullable EntityLiving igniter) {
        this((EntityTypes<? extends EntityTNTPrimed>)EntityTypes.bc, world);
        this.a_(x2, y2, z2);
        double d3 = this.ah.j() * 6.2831854820251465;
        this.n(-Math.sin(d3) * 0.02, 0.2f, -Math.cos(d3) * 0.02);
        this.b(80);
        this.L = x2;
        this.M = y2;
        this.N = z2;
        this.h = igniter;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(c, 80);
        builder.a(d, Blocks.ck.o());
    }

    @Override
    protected Entity.MovementEmission bc() {
        return Entity.MovementEmission.a;
    }

    @Override
    public boolean bA() {
        return !this.dJ();
    }

    @Override
    protected double aZ() {
        return 0.04;
    }

    @Override
    public void l() {
        PlayerChunkMap.EntityTracker ete;
        if (this.dO().spigotConfig.maxTntTicksPerTick > 0 && ++this.dO().spigotConfig.currentPrimedTnt > this.dO().spigotConfig.maxTntTicksPerTick) {
            return;
        }
        this.bP();
        this.bb();
        this.a(EnumMoveType.a, this.dr());
        if (this.dO().paperConfig().fixes.tntEntityHeightNerf.test(v2 -> this.dv() > (double)v2)) {
            this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
            return;
        }
        this.i(this.dr().a(0.98));
        if (this.aF()) {
            this.i(this.dr().d(0.7, -0.5, 0.7));
        }
        int i2 = this.t() - 1;
        this.b(i2);
        if (i2 <= 0) {
            if (!this.dO().B) {
                this.w();
            }
            this.discard(EntityRemoveEvent.Cause.EXPLODE);
        } else {
            this.bm();
            if (this.dO().B) {
                this.dO().a(Particles.ae, this.dt(), this.dv() + 0.5, this.dz(), 0.0, 0.0, 0.0);
            }
        }
        if (!this.dJ() && this.aj && this.dO().paperConfig().fixes.preventTntFromMovingInWater && (ete = (PlayerChunkMap.EntityTracker)((WorldServer)this.dO()).l().a.K.get(this.an())) != null) {
            PacketPlayOutEntityVelocity velocityPacket = new PacketPlayOutEntityVelocity(this);
            PacketPlayOutEntityTeleport positionPacket = new PacketPlayOutEntityTeleport(this);
            ete.f.stream().filter(viewer -> (viewer.o().dt() - this.dt()) * (viewer.o().dv() - this.dv()) * (viewer.o().dz() - this.dz()) < 256.0).forEach(viewer -> {
                viewer.b(velocityPacket);
                viewer.b(positionPacket);
            });
        }
    }

    private void w() {
        ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent((Explosive)this.getBukkitEntity());
        if (!event.isCancelled()) {
            this.dO().a(this, Explosion.a(this.dO(), (Entity)this), this.i ? g : null, this.dt(), this.e(0.0625), this.dz(), event.getRadius(), event.getFire(), World.a.d);
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a(b, (short)this.t());
        nbt.a(f, GameProfileSerializer.a(this.v()));
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.b(nbt.g(b));
        if (nbt.b(f, 10)) {
            this.c(GameProfileSerializer.a(this.dO().a(Registries.f), nbt.p(f)));
        }
    }

    @Nullable
    public EntityLiving p() {
        return this.h;
    }

    @Override
    public void w(Entity original) {
        super.w(original);
        if (original instanceof EntityTNTPrimed) {
            EntityTNTPrimed entitytntprimed = (EntityTNTPrimed)original;
            this.h = entitytntprimed.h;
        }
    }

    public void b(int fuse) {
        this.ao.a(c, fuse);
    }

    public int t() {
        return this.ao.a(c);
    }

    public void c(IBlockData state) {
        this.ao.a(d, state);
    }

    public IBlockData v() {
        return this.ao.a(d);
    }

    private void a(boolean teleported) {
        this.i = teleported;
    }

    @Override
    @Nullable
    public Entity a(DimensionTransition teleportTarget) {
        Entity entity = super.a(teleportTarget);
        if (entity instanceof EntityTNTPrimed) {
            EntityTNTPrimed entitytntprimed = (EntityTNTPrimed)entity;
            entitytntprimed.a(true);
        }
        return entity;
    }

    @Override
    public boolean cC() {
        return !this.dO().paperConfig().fixes.preventTntFromMovingInWater && super.cC();
    }
}

