/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import io.papermc.paper.event.player.PlayerItemFrameChangeEvent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class EntityItemFrame
extends EntityHanging {
    public static final DataWatcherObject<ItemStack> f = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.h);
    public static final DataWatcherObject<Integer> g = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.b);
    public static final int e = 8;
    private static final float h = 0.0625f;
    private static final float i = 0.75f;
    private static final float j = 0.75f;
    public float k = 1.0f;
    public boolean l;
    @javax.annotation.Nullable
    public MapId cachedMapId;

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> type, World world) {
        super((EntityTypes<? extends EntityHanging>)type, world);
    }

    public EntityItemFrame(World world, BlockPosition pos, EnumDirection facing) {
        this(EntityTypes.ai, world, pos, facing);
    }

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> type, World world, BlockPosition pos, EnumDirection facing) {
        super((EntityTypes<? extends EntityHanging>)type, world, pos);
        this.a(facing);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(f, ItemStack.l);
        builder.a(g, 0);
    }

    @Override
    public void a(EnumDirection facing) {
        Validate.notNull((Object)facing);
        this.d = facing;
        if (facing.o().d()) {
            this.u(0.0f);
            this.t(this.d.e() * 90);
        } else {
            this.u(-90 * facing.f().a());
            this.t(0.0f);
        }
        this.P = this.dG();
        this.O = this.dE();
        this.p();
    }

    @Override
    protected AxisAlignedBB a(BlockPosition pos, EnumDirection side) {
        return EntityItemFrame.calculateBoundingBoxStatic(pos, side);
    }

    public static AxisAlignedBB calculateBoundingBoxStatic(BlockPosition blockposition, EnumDirection enumdirection) {
        float f2 = 0.46875f;
        Vec3D vec3d = Vec3D.b(blockposition).a(enumdirection, -0.46875);
        EnumDirection.EnumAxis enumdirection_enumaxis = enumdirection.o();
        double d0 = enumdirection_enumaxis == EnumDirection.EnumAxis.a ? 0.0625 : 0.75;
        double d1 = enumdirection_enumaxis == EnumDirection.EnumAxis.b ? 0.0625 : 0.75;
        double d2 = enumdirection_enumaxis == EnumDirection.EnumAxis.c ? 0.0625 : 0.75;
        return AxisAlignedBB.a(vec3d, d0, d1, d2);
    }

    @Override
    public boolean s() {
        if (this.l) {
            return true;
        }
        if (!this.dO().g(this)) {
            return false;
        }
        IBlockData iblockdata = this.dO().a_(this.b.a(this.d.g()));
        return !iblockdata.e() && (!this.d.o().d() || !BlockDiodeAbstract.m(iblockdata)) ? false : this.dO().a((Entity)this, this.cK(), EntityHanging.c).isEmpty();
    }

    @Override
    public void a(EnumMoveType movementType, Vec3D movement) {
        if (!this.l) {
            super.a(movementType, movement);
        }
    }

    @Override
    public void push(double deltaX, double deltaY, double deltaZ, @Nullable Entity pushingEntity) {
        if (!this.l) {
            super.push(deltaX, deltaY, deltaZ, pushingEntity);
        }
    }

    @Override
    public void ap() {
        this.d(this.D());
        super.ap();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.l) {
            return !source.a(DamageTypeTags.d) && !source.h() ? false : super.a(source, amount);
        }
        if (this.b(source)) {
            return false;
        }
        if (!source.a(DamageTypeTags.l) && !this.D().e()) {
            if (!this.dO().B) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false) || this.dJ()) {
                    return true;
                }
                Entity entity = source.d();
                if (entity instanceof EntityHuman) {
                    EntityHuman player = (EntityHuman)entity;
                    PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), this.D().asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.REMOVE);
                    if (!event.callEvent()) {
                        return true;
                    }
                    this.a(ItemStack.fromBukkitCopy(event.getItemStack()), false);
                }
                this.b(source.d(), false);
                this.a(GameEvent.c, source.d());
                this.a(this.v(), 1.0f, 1.0f);
            }
            return true;
        }
        return super.a(source, amount);
    }

    public SoundEffect v() {
        return SoundEffects.nz;
    }

    @Override
    public boolean a(double distance) {
        double d1 = 16.0;
        return distance < (d1 *= 64.0 * EntityItemFrame.cD()) * d1;
    }

    @Override
    public void b(@javax.annotation.Nullable Entity breaker) {
        this.a(this.w(), 1.0f, 1.0f);
        this.b(breaker, true);
        this.a(GameEvent.c, breaker);
    }

    public SoundEffect w() {
        return SoundEffects.nx;
    }

    @Override
    public void C() {
        this.a(this.x(), 1.0f, 1.0f);
    }

    public SoundEffect x() {
        return SoundEffects.ny;
    }

    private void b(@javax.annotation.Nullable Entity entity, boolean alwaysDrop) {
        if (!this.l) {
            ItemStack itemstack = this.D();
            this.c(ItemStack.l);
            if (!this.dO().ab().b(GameRules.i)) {
                if (entity == null) {
                    this.d(itemstack);
                }
            } else {
                EntityHuman entityhuman;
                if (entity instanceof EntityHuman && (entityhuman = (EntityHuman)entity).fL()) {
                    this.d(itemstack);
                    return;
                }
                if (alwaysDrop) {
                    this.b(this.A());
                }
                if (!itemstack.e()) {
                    itemstack = itemstack.s();
                    this.d(itemstack);
                    if (this.ah.i() < this.k) {
                        this.b(itemstack);
                    }
                }
            }
        }
    }

    private void d(ItemStack stack) {
        WorldMap worldmap;
        MapId mapid = this.a(stack);
        if (mapid != null && (worldmap = ItemWorldMap.a(mapid, this.dO())) != null) {
            worldmap.a(this.b, this.an());
            worldmap.a(true);
        }
        stack.a((Entity)null);
    }

    public ItemStack D() {
        return this.ar().a(f);
    }

    @Override
    @javax.annotation.Nullable
    public EntityItem b(ItemStack stack) {
        return this.a(stack, this.cH().equals(EnumDirection.a) ? -0.6f : 0.0f);
    }

    @javax.annotation.Nullable
    public MapId a(ItemStack itemstack) {
        return itemstack.a(DataComponents.B);
    }

    public boolean E() {
        return this.D().b(DataComponents.B);
    }

    public void c(ItemStack stack) {
        this.a(stack, true);
    }

    public void a(ItemStack value, boolean update) {
        this.setItem(value, update, true);
    }

    public void setItem(ItemStack itemstack, boolean flag, boolean playSound) {
        if (!itemstack.e()) {
            itemstack = itemstack.c(1);
        }
        this.e(itemstack);
        this.ar().a(f, itemstack);
        if (!itemstack.e() && flag && playSound) {
            this.a(this.y(), 1.0f, 1.0f);
        }
        if (flag && this.b != null) {
            this.dO().c(this.b, Blocks.a);
        }
    }

    public SoundEffect y() {
        return SoundEffects.nw;
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        return mappedIndex == 0 ? SlotAccess.a(this::D, this::c) : super.a_(mappedIndex);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (data.equals(f)) {
            this.e(this.D());
        }
    }

    private void e(ItemStack stack) {
        this.cachedMapId = stack.a().a(DataComponents.B);
        if (!stack.e() && stack.D() != this) {
            stack.a(this);
        }
        this.p();
    }

    public int F() {
        return this.ar().a(g);
    }

    public void b(int value) {
        this.a(value, true);
    }

    private void a(int value, boolean updateComparators) {
        this.ar().a(g, value % 8);
        if (updateComparators && this.b != null) {
            this.dO().c(this.b, Blocks.a);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (!this.D().e()) {
            nbt.a("Item", this.D().a(this.dQ()));
            nbt.a("ItemRotation", (byte)this.F());
            nbt.a("ItemDropChance", this.k);
        }
        nbt.a("Facing", (byte)this.d.d());
        nbt.a("Invisible", this.ci());
        nbt.a("Fixed", this.l);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        ItemStack itemstack;
        super.a(nbt);
        if (nbt.b("Item", 10)) {
            NBTTagCompound nbttagcompound1 = nbt.p("Item");
            itemstack = ItemStack.a((HolderLookup.a)this.dQ(), (NBTBase)nbttagcompound1).orElse(ItemStack.l);
        } else {
            itemstack = ItemStack.l;
        }
        ItemStack itemstack1 = this.D();
        if (!itemstack1.e() && !ItemStack.a(itemstack, itemstack1)) {
            this.d(itemstack1);
        }
        this.a(itemstack, false);
        if (!itemstack.e()) {
            this.a(nbt.f("ItemRotation"), false);
            if (nbt.b("ItemDropChance", 99)) {
                this.k = nbt.j("ItemDropChance");
            }
        }
        this.a(EnumDirection.a(nbt.f("Facing")));
        this.k(nbt.q("Invisible"));
        this.l = nbt.q("Fixed");
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        boolean flag1;
        ItemStack itemstack = player.b(hand);
        boolean flag = !this.D().e();
        boolean bl = flag1 = !itemstack.e();
        if (this.l) {
            return EnumInteractionResult.e;
        }
        if (!this.dO().B) {
            if (!flag) {
                if (flag1 && !this.dJ()) {
                    WorldMap worldmap;
                    if (itemstack.a(Items.rU) && (worldmap = ItemWorldMap.b(itemstack, this.dO())) != null && worldmap.a(256)) {
                        return EnumInteractionResult.f;
                    }
                    PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), itemstack.asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.PLACE);
                    if (!event.callEvent()) {
                        return EnumInteractionResult.f;
                    }
                    this.c(ItemStack.fromBukkitCopy(event.getItemStack()));
                    this.a(GameEvent.c, (Entity)player);
                    itemstack.a(1, (EntityLiving)player);
                }
            } else {
                PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), this.D().asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.ROTATE);
                if (!event.callEvent()) {
                    return EnumInteractionResult.f;
                }
                this.setItem(ItemStack.fromBukkitCopy(event.getItemStack()), false, false);
                this.a(this.z(), 1.0f, 1.0f);
                this.b(this.F() + 1);
                this.a(GameEvent.c, (Entity)player);
            }
            return EnumInteractionResult.c;
        }
        return !flag && !flag1 ? EnumInteractionResult.e : EnumInteractionResult.a;
    }

    public SoundEffect z() {
        return SoundEffects.nA;
    }

    public int H() {
        return this.D().e() ? 0 : this.F() % 8 + 1;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entityTrackerEntry) {
        return new PacketPlayOutSpawnEntity((Entity)this, this.d.d(), this.t());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.a(EnumDirection.a(packet.p()));
    }

    @Override
    public ItemStack dB() {
        ItemStack itemstack = this.D();
        return itemstack.e() ? this.A() : itemstack.s();
    }

    protected ItemStack A() {
        return new ItemStack(Items.uc);
    }

    @Override
    public float dF() {
        EnumDirection enumdirection = this.cH();
        int i2 = enumdirection.o().b() ? 90 * enumdirection.f().a() : 0;
        return MathHelper.b(180 + enumdirection.e() * 90 + this.F() * 45 + i2);
    }
}

