/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vector3f;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class EntityArmorStand
extends EntityLiving {
    public static final int b = 5;
    private static final boolean bP = true;
    private static final Vector3f bQ = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f bR = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f bS = new Vector3f(-10.0f, 0.0f, -10.0f);
    private static final Vector3f bT = new Vector3f(-15.0f, 0.0f, 10.0f);
    private static final Vector3f bU = new Vector3f(-1.0f, 0.0f, -1.0f);
    private static final Vector3f bV = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final EntitySize bW = EntitySize.c(0.0f, 0.0f);
    private static final EntitySize bX = EntityTypes.d.n().a(0.5f).b(0.9875f);
    private static final double bY = 0.1;
    private static final double bZ = 0.9;
    private static final double ca = 0.4;
    private static final double cb = 1.6;
    public static final int c = 8;
    public static final int d = 16;
    public static final int e = 1;
    public static final int f = 4;
    public static final int g = 8;
    public static final int h = 16;
    public static final DataWatcherObject<Byte> bH = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Vector3f> bI = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bJ = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bK = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bL = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bM = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bN = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    private static final Predicate<Entity> cc = entity -> entity instanceof EntityMinecartAbstract && ((EntityMinecartAbstract)entity).v() == EntityMinecartAbstract.EnumMinecartType.a;
    private final NonNullList<net.minecraft.world.item.ItemStack> cd;
    private final NonNullList<net.minecraft.world.item.ItemStack> ce;
    private boolean cf;
    public long bO;
    public int cg;
    public Vector3f ch;
    public Vector3f ci;
    public Vector3f cj;
    public Vector3f ck;
    public Vector3f cl;
    public Vector3f cm;
    public boolean canMove = true;
    public boolean canTick = true;
    public boolean canTickSetByAPI = false;
    private boolean noTickPoseDirty = false;
    private boolean noTickEquipmentDirty = false;

    public EntityArmorStand(EntityTypes<? extends EntityArmorStand> type, World world) {
        super((EntityTypes<? extends EntityLiving>)type, world);
        if (world != null) {
            this.canTick = world.paperConfig().entities.armorStands.tick;
        }
        this.cd = NonNullList.a(2, net.minecraft.world.item.ItemStack.l);
        this.ce = NonNullList.a(4, net.minecraft.world.item.ItemStack.l);
        this.ch = bQ;
        this.ci = bR;
        this.cj = bS;
        this.ck = bT;
        this.cl = bU;
        this.cm = bV;
    }

    public EntityArmorStand(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityArmorStand>)EntityTypes.d, world);
        this.a_(x2, y2, z2);
    }

    public static AttributeProvider.Builder s() {
        return EntityArmorStand.dV().a(GenericAttributes.B, 0.0);
    }

    @Override
    public float getBukkitYaw() {
        return this.dE();
    }

    @Override
    public void i_() {
        double d0 = this.dt();
        double d1 = this.dv();
        double d2 = this.dz();
        super.i_();
        this.a_(d0, d1, d2);
    }

    private boolean H() {
        return !this.z() && !this.aY();
    }

    @Override
    public boolean db() {
        return super.db() && this.H();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bH, (byte)0);
        builder.a(bI, bQ);
        builder.a(bJ, bR);
        builder.a(bK, bS);
        builder.a(bL, bT);
        builder.a(bM, bU);
        builder.a(bN, bV);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> eW() {
        return this.cd;
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> eV() {
        return this.ce;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                return this.cd.get(slot.b());
            }
            case b: {
                return this.ce.get(slot.b());
            }
        }
        return net.minecraft.world.item.ItemStack.l;
    }

    @Override
    public boolean d(EnumItemSlot slot) {
        return slot != EnumItemSlot.g;
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.e(itemstack);
        switch (enumitemslot.a()) {
            case a: {
                this.onEquipItem(enumitemslot, this.cd.set(enumitemslot.b(), itemstack), itemstack, silent);
                break;
            }
            case b: {
                this.onEquipItem(enumitemslot, this.ce.set(enumitemslot.b(), itemstack), itemstack, silent);
            }
        }
        this.noTickEquipmentDirty = true;
    }

    @Override
    public boolean f(net.minecraft.world.item.ItemStack stack) {
        EnumItemSlot enumitemslot = this.h(stack);
        return this.a(enumitemslot).e() && !this.e(enumitemslot);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemstack : this.ce) {
            nbttaglist.add(itemstack.b(this.dQ()));
        }
        nbt.a("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemstack1 : this.cd) {
            nbttaglist1.add(itemstack1.b(this.dQ()));
        }
        nbt.a("HandItems", nbttaglist1);
        nbt.a("Invisible", this.ci());
        nbt.a("Small", this.t());
        nbt.a("ShowArms", this.v());
        nbt.a("DisabledSlots", this.cg);
        nbt.a("NoBasePlate", this.x());
        if (this.z()) {
            nbt.a("Marker", this.z());
        }
        nbt.a("Pose", this.I());
        if (this.canTickSetByAPI) {
            nbt.a("Paper.CanTickOverride", this.canTick);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound1;
        int i2;
        NBTTagList nbttaglist;
        super.a(nbt);
        if (nbt.b("ArmorItems", 9)) {
            nbttaglist = nbt.c("ArmorItems", 10);
            for (i2 = 0; i2 < this.ce.size(); ++i2) {
                nbttagcompound1 = nbttaglist.a(i2);
                this.ce.set(i2, net.minecraft.world.item.ItemStack.a((HolderLookup.a)this.dQ(), nbttagcompound1));
            }
        }
        if (nbt.b("HandItems", 9)) {
            nbttaglist = nbt.c("HandItems", 10);
            for (i2 = 0; i2 < this.cd.size(); ++i2) {
                nbttagcompound1 = nbttaglist.a(i2);
                this.cd.set(i2, net.minecraft.world.item.ItemStack.a((HolderLookup.a)this.dQ(), nbttagcompound1));
            }
        }
        this.k(nbt.q("Invisible"));
        this.u(nbt.q("Small"));
        this.a(nbt.q("ShowArms"));
        this.cg = nbt.h("DisabledSlots");
        this.b(nbt.q("NoBasePlate"));
        this.v(nbt.q("Marker"));
        boolean bl = this.ag = !this.H();
        if (nbt.e("Paper.CanTickOverride")) {
            this.canTick = nbt.q("Paper.CanTickOverride");
            this.canTickSetByAPI = true;
        }
        NBTTagCompound nbttagcompound2 = nbt.p("Pose");
        this.c(nbttagcompound2);
    }

    private void c(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.c("Head", 5);
        this.a(nbttaglist.isEmpty() ? bQ : new Vector3f(nbttaglist));
        NBTTagList nbttaglist1 = nbt.c("Body", 5);
        this.b(nbttaglist1.isEmpty() ? bR : new Vector3f(nbttaglist1));
        NBTTagList nbttaglist2 = nbt.c("LeftArm", 5);
        this.c(nbttaglist2.isEmpty() ? bS : new Vector3f(nbttaglist2));
        NBTTagList nbttaglist3 = nbt.c("RightArm", 5);
        this.d(nbttaglist3.isEmpty() ? bT : new Vector3f(nbttaglist3));
        NBTTagList nbttaglist4 = nbt.c("LeftLeg", 5);
        this.e(nbttaglist4.isEmpty() ? bU : new Vector3f(nbttaglist4));
        NBTTagList nbttaglist5 = nbt.c("RightLeg", 5);
        this.f(nbttaglist5.isEmpty() ? bV : new Vector3f(nbttaglist5));
    }

    private NBTTagCompound I() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (!bQ.equals(this.ch)) {
            nbttagcompound.a("Head", this.ch.a());
        }
        if (!bR.equals(this.ci)) {
            nbttagcompound.a("Body", this.ci.a());
        }
        if (!bS.equals(this.cj)) {
            nbttagcompound.a("LeftArm", this.cj.a());
        }
        if (!bT.equals(this.ck)) {
            nbttagcompound.a("RightArm", this.ck.a());
        }
        if (!bU.equals(this.cl)) {
            nbttagcompound.a("LeftLeg", this.cl.a());
        }
        if (!bV.equals(this.cm)) {
            nbttagcompound.a("RightLeg", this.cm.a());
        }
        return nbttagcompound;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    @Override
    protected void E(Entity entity) {
    }

    @Override
    protected void r() {
        if (!this.dO().paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return;
        }
        List<Entity> list = this.dO().a((Entity)this, this.cK(), cc);
        for (Entity entity : list) {
            if (!(this.g(entity) <= 0.2)) continue;
            entity.h(this);
        }
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, Vec3D hitPos, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemstack = player.b(hand);
        if (!this.z() && !itemstack.a(Items.uL)) {
            if (player.R_()) {
                return EnumInteractionResult.a;
            }
            if (player.dO().B) {
                return EnumInteractionResult.c;
            }
            EnumItemSlot enumitemslot = this.h(itemstack);
            if (itemstack.e()) {
                EnumItemSlot enumitemslot2;
                EnumItemSlot enumitemslot1 = this.b(hitPos);
                EnumItemSlot enumItemSlot = enumitemslot2 = this.e(enumitemslot1) ? enumitemslot : enumitemslot1;
                if (this.c(enumitemslot2) && this.a(player, enumitemslot2, itemstack, hand)) {
                    return EnumInteractionResult.a;
                }
            } else {
                if (this.e(enumitemslot)) {
                    return EnumInteractionResult.f;
                }
                if (enumitemslot.a() == EnumItemSlot.Function.a && !this.v()) {
                    return EnumInteractionResult.f;
                }
                if (this.a(player, enumitemslot, itemstack, hand)) {
                    return EnumInteractionResult.a;
                }
            }
            return EnumInteractionResult.e;
        }
        return EnumInteractionResult.e;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumItemSlot b(Vec3D hitPos) {
        EnumItemSlot enumitemslot = EnumItemSlot.a;
        boolean flag = this.t();
        double d0 = hitPos.d / (double)(this.eb() * this.ea());
        EnumItemSlot enumitemslot1 = EnumItemSlot.c;
        if (d0 >= 0.1) {
            double d2 = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d2 && this.c(enumitemslot1)) {
                return EnumItemSlot.c;
            }
        }
        double d3 = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d3) {
            double d4 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d4 && this.c(EnumItemSlot.e)) {
                return EnumItemSlot.e;
            }
        }
        if (d0 >= 0.4) {
            double d5 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d5 && this.c(EnumItemSlot.d)) {
                return EnumItemSlot.d;
            }
        }
        if (d0 >= 1.6 && this.c(EnumItemSlot.f)) {
            return EnumItemSlot.f;
        }
        if (this.c(EnumItemSlot.a)) return enumitemslot;
        if (!this.c(EnumItemSlot.b)) return enumitemslot;
        return EnumItemSlot.b;
    }

    public boolean e(EnumItemSlot slot) {
        return (this.cg & 1 << slot.d()) != 0 || slot.a() == EnumItemSlot.Function.a && !this.v();
    }

    private boolean a(EntityHuman player, EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemstack1 = this.a(slot);
        if (!itemstack1.e() && (this.cg & 1 << slot.d() + 8) != 0) {
            return false;
        }
        if (itemstack1.e() && (this.cg & 1 << slot.d() + 16) != 0) {
            return false;
        }
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemstack1);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(stack);
        Player player1 = (Player)player.getBukkitEntity();
        ArmorStand self = (ArmorStand)this.getBukkitEntity();
        EquipmentSlot slot1 = CraftEquipmentSlot.getSlot(slot);
        EquipmentSlot hand1 = CraftEquipmentSlot.getHand(hand);
        PlayerArmorStandManipulateEvent armorStandManipulateEvent = new PlayerArmorStandManipulateEvent(player1, self, (ItemStack)playerHeldItem, (ItemStack)armorStandItem, slot1, hand1);
        this.dO().getCraftServer().getPluginManager().callEvent((Event)armorStandManipulateEvent);
        if (armorStandManipulateEvent.isCancelled()) {
            return true;
        }
        if (player.fL() && itemstack1.e() && !stack.e()) {
            this.a(slot, stack.c(1));
            return true;
        }
        if (!stack.e() && stack.H() > 1) {
            if (!itemstack1.e()) {
                return false;
            }
            this.a(slot, stack.a(1));
            return true;
        }
        this.a(slot, stack);
        player.a(hand, itemstack1);
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.dJ()) {
            return false;
        }
        World world = this.dO();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (source.a(DamageTypeTags.d)) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
                    return false;
                }
                this.kill(source);
                return false;
            }
            if (!this.b(source) && !this.z()) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, true, this.cf)) {
                    return false;
                }
                if (source.a(DamageTypeTags.l)) {
                    EntityDeathEvent event = this.brokenByAnything(worldserver, source);
                    if (!event.isCancelled()) {
                        this.kill(source, false);
                    }
                    return false;
                }
                if (source.a(DamageTypeTags.u)) {
                    if (this.bR()) {
                        this.a(worldserver, source, 0.15f);
                    } else {
                        this.d(5.0f);
                    }
                    return false;
                }
                if (source.a(DamageTypeTags.v) && this.ew() > 0.5f) {
                    this.a(worldserver, source, 4.0f);
                    return false;
                }
                boolean flag = source.a(DamageTypeTags.B);
                boolean flag1 = source.a(DamageTypeTags.A);
                if (!flag && !flag1) {
                    return false;
                }
                Entity entity = source.d();
                if (entity instanceof EntityHuman) {
                    EntityHuman entityhuman = (EntityHuman)entity;
                    if (!entityhuman.fZ().e) {
                        return false;
                    }
                }
                if (source.h()) {
                    this.L();
                    this.J();
                    this.kill(source);
                    return true;
                }
                long i2 = worldserver.Z();
                if (i2 - this.bO > 5L && !flag1) {
                    worldserver.a((Entity)this, (byte)32);
                    this.a(GameEvent.o, source.d());
                    this.bO = i2;
                } else {
                    EntityDeathEvent event = this.brokenByPlayer(worldserver, source);
                    this.J();
                    if (!event.isCancelled()) {
                        this.kill(source, false);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void b(byte status) {
        if (status == 32) {
            if (this.dO().B) {
                this.dO().a(this.dt(), this.dv(), this.dz(), SoundEffects.aC, this.de(), 0.3f, 1.0f, false);
                this.bO = this.dO().Z();
            }
        } else {
            super.b(status);
        }
    }

    @Override
    public boolean a(double distance) {
        double d1 = this.cK().a() * 4.0;
        if (Double.isNaN(d1) || d1 == 0.0) {
            d1 = 4.0;
        }
        return distance < (d1 *= 64.0) * d1;
    }

    private void J() {
        if (this.dO() instanceof WorldServer) {
            ((WorldServer)this.dO()).a(new ParticleParamBlock(Particles.b, Blocks.n.o()), this.dt(), this.e(0.6666666666666666), this.dz(), 10, (double)(this.dj() / 4.0f), (double)(this.dk() / 4.0f), (double)(this.dj() / 4.0f), 0.05);
        }
    }

    private void a(WorldServer world, DamageSource damageSource, float amount) {
        float f1 = this.ew();
        if ((f1 -= amount) <= 0.5f) {
            EntityDeathEvent event = this.brokenByAnything(world, damageSource);
            if (!event.isCancelled()) {
                this.kill(damageSource, false);
            }
        } else {
            this.v(f1);
            this.a(GameEvent.o, damageSource.d());
        }
    }

    private EntityDeathEvent brokenByPlayer(WorldServer world, DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemstack = new net.minecraft.world.item.ItemStack(Items.uF);
        itemstack.b(DataComponents.g, this.aj());
        this.drops.add(new Entity.DefaultDrop(itemstack, stack -> Block.a(this.dO(), this.do(), stack)));
        return this.brokenByAnything(world, damageSource);
    }

    private EntityDeathEvent brokenByAnything(WorldServer world, DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemstack;
        int i2;
        this.L();
        for (i2 = 0; i2 < this.cd.size(); ++i2) {
            itemstack = this.cd.get(i2);
            if (itemstack.e()) continue;
            this.drops.add(new Entity.DefaultDrop(itemstack, stack -> Block.a(this.dO(), this.do().d(), stack)));
            this.cd.set(i2, net.minecraft.world.item.ItemStack.l);
        }
        for (i2 = 0; i2 < this.ce.size(); ++i2) {
            itemstack = this.ce.get(i2);
            if (itemstack.e()) continue;
            this.drops.add(new Entity.DefaultDrop(itemstack, stack -> Block.a(this.dO(), this.do().d(), stack)));
            this.ce.set(i2, net.minecraft.world.item.ItemStack.l);
        }
        return this.dropAllDeathLoot(world, damageSource);
    }

    private void L() {
        this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.aA, this.de(), 1.0f, 1.0f);
    }

    @Override
    protected float f(float bodyRotation, float headRotation) {
        this.aZ = this.O;
        this.aY = this.dE();
        return 0.0f;
    }

    @Override
    public void a(Vec3D movementInput) {
        if (this.H()) {
            super.a(movementInput);
        }
    }

    @Override
    public void p(float bodyYaw) {
        this.aZ = this.O = bodyYaw;
        this.bb = this.ba = bodyYaw;
    }

    @Override
    public void o(float headYaw) {
        this.aZ = this.O = headYaw;
        this.bb = this.ba = headYaw;
    }

    @Override
    public void l() {
        if (!this.canTick) {
            if (this.noTickPoseDirty) {
                this.noTickPoseDirty = false;
                this.updatePose();
            }
            if (this.noTickEquipmentDirty) {
                this.noTickEquipmentDirty = false;
                this.detectEquipmentUpdatesPublic();
            }
            return;
        }
        super.l();
        this.updatePose();
    }

    public void updatePose() {
        Vector3f vector3f5;
        Vector3f vector3f4;
        Vector3f vector3f3;
        Vector3f vector3f2;
        Vector3f vector3f1;
        Vector3f vector3f = this.ao.a(bI);
        if (!this.ch.equals(vector3f)) {
            this.a(vector3f);
        }
        if (!this.ci.equals(vector3f1 = this.ao.a(bJ))) {
            this.b(vector3f1);
        }
        if (!this.cj.equals(vector3f2 = this.ao.a(bK))) {
            this.c(vector3f2);
        }
        if (!this.ck.equals(vector3f3 = this.ao.a(bL))) {
            this.d(vector3f3);
        }
        if (!this.cl.equals(vector3f4 = this.ao.a(bM))) {
            this.e(vector3f4);
        }
        if (!this.cm.equals(vector3f5 = this.ao.a(bN))) {
            this.f(vector3f5);
        }
    }

    @Override
    protected void K() {
        this.k(this.cf);
    }

    @Override
    public void k(boolean invisible) {
        this.cf = invisible;
        super.k(invisible);
    }

    @Override
    public boolean o_() {
        return this.t();
    }

    @Override
    public boolean ee() {
        return true;
    }

    @Override
    public void ap() {
        this.kill(null);
    }

    public void kill(DamageSource damageSource) {
        this.kill(damageSource, true);
    }

    public void kill(DamageSource damageSource, boolean callEvent) {
        EntityDeathEvent event;
        if (callEvent && (event = CraftEventFactory.callEntityDeathEvent(this, damageSource == null ? this.dP().x() : damageSource, this.drops)).isCancelled()) {
            return;
        }
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        ((Entity)this).a(GameEvent.p);
    }

    @Override
    public boolean a(Explosion explosion) {
        return this.ci();
    }

    @Override
    public EnumPistonReaction j_() {
        return this.z() ? EnumPistonReaction.d : super.j_();
    }

    @Override
    public boolean r_() {
        return this.z();
    }

    public void u(boolean small) {
        this.ao.a(bH, this.a(this.ao.a(bH), 1, small));
    }

    public boolean t() {
        return (this.ao.a(bH) & 1) != 0;
    }

    public void a(boolean showArms) {
        this.ao.a(bH, this.a(this.ao.a(bH), 4, showArms));
    }

    public boolean v() {
        return (this.ao.a(bH) & 4) != 0;
    }

    public void b(boolean hideBasePlate) {
        this.ao.a(bH, this.a(this.ao.a(bH), 8, hideBasePlate));
    }

    public boolean x() {
        return (this.ao.a(bH) & 8) != 0;
    }

    public void v(boolean marker) {
        this.ao.a(bH, this.a(this.ao.a(bH), 16, marker));
    }

    public boolean z() {
        return (this.ao.a(bH) & 0x10) != 0;
    }

    private byte a(byte value, int bitField, boolean set) {
        value = set ? (byte)(value | bitField) : (byte)(value & ~bitField);
        return value;
    }

    public void a(Vector3f angle) {
        this.ch = angle;
        this.ao.a(bI, angle);
        this.noTickPoseDirty = true;
    }

    public void b(Vector3f angle) {
        this.ci = angle;
        this.ao.a(bJ, angle);
        this.noTickPoseDirty = true;
    }

    public void c(Vector3f angle) {
        this.cj = angle;
        this.ao.a(bK, angle);
        this.noTickPoseDirty = true;
    }

    public void d(Vector3f angle) {
        this.ck = angle;
        this.ao.a(bL, angle);
        this.noTickPoseDirty = true;
    }

    public void e(Vector3f angle) {
        this.cl = angle;
        this.ao.a(bM, angle);
        this.noTickPoseDirty = true;
    }

    public void f(Vector3f angle) {
        this.cm = angle;
        this.ao.a(bN, angle);
        this.noTickPoseDirty = true;
    }

    public Vector3f A() {
        return this.ch;
    }

    public Vector3f B() {
        return this.ci;
    }

    public Vector3f C() {
        return this.cj;
    }

    public Vector3f D() {
        return this.ck;
    }

    public Vector3f E() {
        return this.cl;
    }

    public Vector3f F() {
        return this.cm;
    }

    @Override
    public boolean bA() {
        return super.bA() && !this.z();
    }

    @Override
    public boolean u(Entity attacker) {
        return attacker instanceof EntityHuman && !this.dO().a((EntityHuman)attacker, this.do());
    }

    @Override
    public EnumMainHand fq() {
        return EnumMainHand.b;
    }

    @Override
    public EntityLiving.a eH() {
        return new EntityLiving.a(SoundEffects.aB, SoundEffects.aB);
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.aC;
    }

    @Override
    @Nullable
    public SoundEffect n_() {
        return SoundEffects.aA;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
    }

    @Override
    public boolean fC() {
        return false;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bH.equals(data)) {
            this.i_();
            this.J = !this.z();
        }
        super.a(data);
    }

    @Override
    public boolean fD() {
        return false;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.w(this.z());
    }

    private EntitySize w(boolean marker) {
        return marker ? bW : (this.o_() ? bX : this.am().n());
    }

    @Override
    public Vec3D l(float tickDelta) {
        if (this.z()) {
            AxisAlignedBB axisalignedbb = this.w(false).a(this.dm());
            BlockPosition blockposition = this.do();
            int i2 = Integer.MIN_VALUE;
            for (BlockPosition blockposition1 : BlockPosition.c(BlockPosition.a(axisalignedbb.a, axisalignedbb.b, axisalignedbb.c), BlockPosition.a(axisalignedbb.d, axisalignedbb.e, axisalignedbb.f))) {
                int j2 = Math.max(this.dO().a(EnumSkyBlock.b, blockposition1), this.dO().a(EnumSkyBlock.a, blockposition1));
                if (j2 == 15) {
                    return Vec3D.b(blockposition1);
                }
                if (j2 <= i2) continue;
                i2 = j2;
                blockposition = blockposition1.j();
            }
            return Vec3D.b(blockposition);
        }
        return super.l(tickDelta);
    }

    @Override
    public net.minecraft.world.item.ItemStack dB() {
        return new net.minecraft.world.item.ItemStack(Items.uF);
    }

    @Override
    public boolean eq() {
        return !this.ci() && !this.z();
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (this.canMove) {
            super.a(type, movement);
        }
    }
}

