/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.TadpoleAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class Tadpole
extends EntityFish {
    @VisibleForTesting
    public static int b = Math.abs(-24000);
    public static final float c = 0.4f;
    public static final float d = 0.3f;
    public int cd;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Tadpole>>> e = ImmutableList.of(SensorType.c, SensorType.d, SensorType.f, SensorType.s);
    protected static final ImmutableList<MemoryModuleType<?>> cc = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.K, MemoryModuleType.P, MemoryModuleType.R, MemoryModuleType.O, MemoryModuleType.r, MemoryModuleType.Z);
    public boolean ageLocked;

    public Tadpole(EntityTypes<? extends EntityFish> type, World world) {
        super(type, world);
        this.bT = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true);
        this.bS = new SmoothSwimmingLookControl(this, 10);
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new NavigationGuardian(this, world);
    }

    protected BehaviorController.b<Tadpole> dU() {
        return BehaviorController.a(cc, e);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return TadpoleAi.a(this.dU().a(dynamic));
    }

    public BehaviorController<Tadpole> dT() {
        return super.dT();
    }

    @Override
    protected SoundEffect gl() {
        return SoundEffects.zu;
    }

    @Override
    protected void ab() {
        this.dO().ag().a("tadpoleBrain");
        this.dT().a((WorldServer)this.dO(), this);
        this.dO().ag().c();
        this.dO().ag().a("tadpoleActivityUpdate");
        TadpoleAi.a(this);
        this.dO().ag().c();
        super.ab();
    }

    public static AttributeProvider.Builder gm() {
        return EntityInsentient.C().a(GenericAttributes.v, 1.0).a(GenericAttributes.s, 6.0);
    }

    @Override
    public void m_() {
        super.m_();
        if (!this.dO().B && !this.ageLocked) {
            this.s(this.cd + 1);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Age", this.cd);
        nbt.a("AgeLocked", this.ageLocked);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.s(nbt.h("Age"));
        this.ageLocked = nbt.q("AgeLocked");
    }

    @Override
    @Nullable
    protected SoundEffect v() {
        return null;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.zw;
    }

    @Override
    @Nullable
    public SoundEffect n_() {
        return SoundEffects.zt;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (this.o(itemstack)) {
            this.a(player, itemstack);
            return EnumInteractionResult.a(this.dO().B);
        }
        return Bucketable.a(player, hand, this).orElse(super.b(player, hand));
    }

    @Override
    protected void aa() {
        super.aa();
        PacketDebug.a(this);
    }

    @Override
    public boolean t() {
        return true;
    }

    @Override
    public void x(boolean fromBucket) {
    }

    @Override
    public void n(ItemStack stack) {
        Bucketable.a((EntityInsentient)this, stack);
        CustomData.a(DataComponents.N, stack, (NBTTagCompound nbttagcompound) -> {
            nbttagcompound.a("Age", this.gn());
            nbttagcompound.a("AgeLocked", this.ageLocked);
        });
    }

    @Override
    public void h(NBTTagCompound nbt) {
        Bucketable.a((EntityInsentient)this, nbt);
        if (nbt.e("Age")) {
            this.s(nbt.h("Age"));
        }
        this.ageLocked = nbt.q("AgeLocked");
    }

    @Override
    public ItemStack b() {
        return new ItemStack(Items.qK);
    }

    @Override
    public SoundEffect x() {
        return SoundEffects.dn;
    }

    private boolean o(ItemStack stack) {
        return stack.a(TagsItem.al);
    }

    private void a(EntityHuman player, ItemStack stack) {
        this.b(player, stack);
        this.c(EntityAgeable.d_(this.gp()));
        this.dO().a(Particles.O, this.d(1.0), this.dw() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
    }

    private void b(EntityHuman player, ItemStack stack) {
        stack.a(1, (EntityLiving)player);
    }

    private int gn() {
        return this.cd;
    }

    private void c(int seconds) {
        if (this.ageLocked) {
            return;
        }
        this.s(this.cd + seconds * 20);
    }

    private void s(int tadpoleAge) {
        this.cd = tadpoleAge;
        if (this.cd >= b) {
            this.go();
        }
    }

    private void go() {
        World world = this.dO();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Frog frog = EntityTypes.R.a(this.dO());
            if (frog != null) {
                frog.b(this.dt(), this.dv(), this.dz(), this.dE(), this.dG());
                frog.a((WorldAccess)worldserver, this.dO().d_(frog.do()), EnumMobSpawn.i, (GroupDataEntity)null);
                frog.u(this.fZ());
                if (this.ai()) {
                    frog.b(this.aj());
                    frog.p(this.cE());
                }
                frog.fR();
                if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, frog, EntityTransformEvent.TransformReason.METAMORPHOSIS).isCancelled()) {
                    this.s(0);
                    return;
                }
                frog.a(this.a(this.at()));
                this.a(SoundEffects.zv, 0.15f, 1.0f);
                worldserver.addFreshEntityWithPassengers(frog, CreatureSpawnEvent.SpawnReason.METAMORPHOSIS);
                this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            }
        }
    }

    private int gp() {
        return Math.max(0, b - this.cd);
    }

    @Override
    public boolean ee() {
        return false;
    }
}

