/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOfferFlower;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillageGolem;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalDefendVillage;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityIronGolem
extends EntityGolem
implements IEntityAngerable {
    protected static final DataWatcherObject<Byte> c = DataWatcher.a(EntityIronGolem.class, DataWatcherRegistry.a);
    private static final int d = 25;
    private int e;
    private int cc;
    private static final UniformInt cd = TimeRange.a(20, 39);
    private int ce;
    @Nullable
    private UUID cf;

    public EntityIronGolem(EntityTypes<? extends EntityIronGolem> type, World world) {
        super((EntityTypes<? extends EntityGolem>)type, world);
    }

    @Override
    protected void B() {
        this.bW.a(1, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bW.a(2, new PathfinderGoalMoveTowardsTarget(this, 0.9, 32.0f));
        this.bW.a(2, new PathfinderGoalStrollVillage((EntityCreature)this, 0.6, false));
        this.bW.a(4, new PathfinderGoalStrollVillageGolem(this, 0.6));
        this.bW.a(5, new PathfinderGoalOfferFlower(this));
        this.bW.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bW.a(8, new PathfinderGoalRandomLookaround(this));
        this.bX.a(1, new PathfinderGoalDefendVillage(this));
        this.bX.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bX.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a_));
        this.bX.a(3, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 5, false, false, entityliving -> entityliving instanceof IMonster && !(entityliving instanceof EntityCreeper)));
        this.bX.a(4, new PathfinderGoalUniversalAngerReset<EntityIronGolem>(this, false));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, (byte)0);
    }

    public static AttributeProvider.Builder s() {
        return EntityInsentient.C().a(GenericAttributes.s, 100.0).a(GenericAttributes.v, 0.25).a(GenericAttributes.p, 1.0).a(GenericAttributes.c, 15.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    protected int m(int air) {
        return air;
    }

    @Override
    protected void E(Entity entity) {
        if (entity instanceof IMonster && !(entity instanceof EntityCreeper) && this.dR().a(20) == 0) {
            this.setTarget((EntityLiving)entity, EntityTargetEvent.TargetReason.COLLISION, true);
        }
        super.E(entity);
    }

    @Override
    public void m_() {
        super.m_();
        if (this.e > 0) {
            --this.e;
        }
        if (this.cc > 0) {
            --this.cc;
        }
        if (!this.dO().B) {
            this.a((WorldServer)this.dO(), true);
        }
    }

    @Override
    public boolean br() {
        return this.dr().i() > 2.500000277905201E-7 && this.ah.a(5) == 0;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return this.gl() && type == EntityTypes.by ? false : (type == EntityTypes.x ? false : super.a(type));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("PlayerCreated", this.gl());
        this.a_(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.y(nbt.q("PlayerCreated"));
        this.a(this.dO(), nbt);
    }

    @Override
    public void c() {
        this.a(cd.a(this.ah));
    }

    @Override
    public void a(int angerTime) {
        this.ce = angerTime;
    }

    @Override
    public int a() {
        return this.ce;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.cf = angryAt;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cf;
    }

    private float gm() {
        return (float)this.g(GenericAttributes.c);
    }

    @Override
    public boolean D(Entity target) {
        this.e = 10;
        this.dO().a((Entity)this, (byte)4);
        float f2 = this.gm();
        float f1 = (int)f2 > 0 ? f2 / 2.0f + (float)this.ah.a((int)f2) : f2;
        DamageSource damagesource = this.dP().b(this);
        boolean flag = target.a(damagesource, f1);
        if (flag) {
            double d0;
            if (target instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)target;
                d0 = entityliving.g(GenericAttributes.p);
            } else {
                d0 = 0.0;
            }
            double d1 = d0;
            double d2 = Math.max(0.0, 1.0 - d1);
            target.i(target.dr().b(0.0, (double)0.4f * d2, 0.0));
            World world = this.dO();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.a(worldserver, target, damagesource);
            }
        }
        this.a(SoundEffects.no, 1.0f, 1.0f);
        return flag;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        Crackiness.a crackiness_a = this.t();
        boolean flag = super.a(source, amount);
        if (flag && this.t() != crackiness_a) {
            this.a(SoundEffects.np, 1.0f, 1.0f);
        }
        return flag;
    }

    public Crackiness.a t() {
        return Crackiness.a.a(this.ew() / this.eN());
    }

    @Override
    public void b(byte status) {
        if (status == 4) {
            this.e = 10;
            this.a(SoundEffects.no, 1.0f, 1.0f);
        } else if (status == 11) {
            this.cc = 400;
        } else if (status == 34) {
            this.cc = 0;
        } else {
            super.b(status);
        }
    }

    public int x() {
        return this.e;
    }

    public void x(boolean lookingAtVillager) {
        if (lookingAtVillager) {
            this.cc = 400;
            this.dO().a((Entity)this, (byte)11);
        } else {
            this.cc = 0;
            this.dO().a((Entity)this, (byte)34);
        }
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.nr;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.nq;
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!itemstack.a(Items.oF)) {
            return EnumInteractionResult.e;
        }
        float f2 = this.ew();
        this.c(25.0f);
        if (this.ew() == f2) {
            return EnumInteractionResult.e;
        }
        float f1 = 1.0f + (this.ah.i() - this.ah.i()) * 0.2f;
        this.a(SoundEffects.ns, 1.0f, f1);
        itemstack.a(1, (EntityLiving)player);
        return EnumInteractionResult.a(this.dO().B);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.nt, 1.0f, 1.0f);
    }

    public int gk() {
        return this.cc;
    }

    public boolean gl() {
        return (this.ao.a(c) & 1) != 0;
    }

    public void y(boolean playerCreated) {
        byte b0 = this.ao.a(c);
        if (playerCreated) {
            this.ao.a(c, (byte)(b0 | 1));
        } else {
            this.ao.a(c, (byte)(b0 & 0xFFFFFFFE));
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
    }

    @Override
    public boolean a(IWorldReader world) {
        BlockPosition blockposition = this.do();
        BlockPosition blockposition1 = blockposition.e();
        IBlockData iblockdata = world.a_(blockposition1);
        if (!iblockdata.a((IBlockAccess)world, blockposition1, (Entity)this) && !this.dO().paperConfig().entities.spawning.ironGolemsCanSpawnInAir) {
            return false;
        }
        for (int i2 = 1; i2 < 3; ++i2) {
            IBlockData iblockdata1;
            BlockPosition blockposition2 = blockposition.b(i2);
            if (SpawnerCreature.a(world, blockposition2, iblockdata1 = world.a_(blockposition2), iblockdata1.u(), EntityTypes.af)) continue;
            return false;
        }
        return SpawnerCreature.a(world, blockposition, world.a_(blockposition), FluidTypes.a.g(), EntityTypes.af) && world.f(this);
    }

    @Override
    public Vec3D cM() {
        return new Vec3D(0.0, 0.875f * this.cL(), this.dj() * 0.4f);
    }
}

