/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class EntityCow
extends EntityAnimal {
    private static final EntitySize cc = EntityTypes.w.n().a(0.5f).b(0.665f);

    public EntityCow(EntityTypes<? extends EntityCow> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
    }

    @Override
    protected void B() {
        this.bW.a(0, new PathfinderGoalFloat(this));
        this.bW.a(1, new PathfinderGoalPanic(this, 2.0));
        this.bW.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bW.a(3, new PathfinderGoalTempt(this, 1.25, itemstack -> itemstack.a(TagsItem.aa), false));
        this.bW.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.bW.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bW.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bW.a(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean o(ItemStack stack) {
        return stack.a(TagsItem.aa);
    }

    public static AttributeProvider.Builder s() {
        return EntityInsentient.C().a(GenericAttributes.s, 10.0).a(GenericAttributes.v, 0.2f);
    }

    @Override
    protected SoundEffect v() {
        return SoundEffects.gb;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.gd;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.gc;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.gf, 0.15f, 1.0f);
    }

    @Override
    public float fa() {
        return 0.4f;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.qy) && !this.o_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)player.dO(), player, this.do(), this.do(), null, itemstack, Items.qE, hand);
            if (event.isCancelled()) {
                player.cd.b();
                return EnumInteractionResult.e;
            }
            player.a(SoundEffects.ge, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemstack1);
            return EnumInteractionResult.a(this.dO().B);
        }
        return super.b(player, hand);
    }

    @Nullable
    public EntityCow b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.w.a(world);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.o_() ? cc : super.e(pose);
    }
}

