/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.destroystokyo.paper.util.set.OptimizedSmallEnumSet;
import com.google.common.annotations.VisibleForTesting;
import io.papermc.paper.util.IntegerUtil;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;

public class PathfinderGoalSelector {
    private static final PathfinderGoalWrapped a = new PathfinderGoalWrapped(Integer.MAX_VALUE, new PathfinderGoal(){

        @Override
        public boolean b() {
            return false;
        }
    }){

        @Override
        public boolean h() {
            return false;
        }
    };
    private final Map<PathfinderGoal.Type, PathfinderGoalWrapped> b = new EnumMap<PathfinderGoal.Type, PathfinderGoalWrapped>(PathfinderGoal.Type.class);
    private final Set<PathfinderGoalWrapped> c = new ObjectLinkedOpenHashSet();
    private final Supplier<GameProfilerFiller> d;
    private static final PathfinderGoal.Type[] GOAL_FLAG_VALUES = PathfinderGoal.Type.values();
    private final OptimizedSmallEnumSet<PathfinderGoal.Type> goalTypes = new OptimizedSmallEnumSet<PathfinderGoal.Type>(PathfinderGoal.Type.class);
    private int curRate;

    public PathfinderGoalSelector(Supplier<GameProfilerFiller> profiler) {
        this.d = profiler;
    }

    public void a(int priority, PathfinderGoal goal) {
        this.c.add(new PathfinderGoalWrapped(priority, goal));
    }

    @VisibleForTesting
    public void a(Predicate<PathfinderGoal> predicate) {
        this.c.removeIf(goal -> predicate.test(goal.k()));
    }

    public boolean inactiveTick() {
        ++this.curRate;
        return this.curRate % 3 == 0;
    }

    public boolean hasTasks() {
        for (PathfinderGoalWrapped task : this.c) {
            if (!task.h()) continue;
            return true;
        }
        return false;
    }

    public void a(PathfinderGoal goal) {
        for (PathfinderGoalWrapped wrappedGoal : this.c) {
            if (wrappedGoal.k() != goal || !wrappedGoal.h()) continue;
            wrappedGoal.e();
        }
        this.c.removeIf(wrappedGoalx -> wrappedGoalx.k() == goal);
    }

    private static boolean goalContainsAnyFlags(PathfinderGoalWrapped goal, OptimizedSmallEnumSet<PathfinderGoal.Type> controls) {
        return goal.getFlags().hasCommonElements(controls);
    }

    private static boolean a(PathfinderGoalWrapped goal, Map<PathfinderGoal.Type, PathfinderGoalWrapped> goalsByControl) {
        long flagIterator = goal.getFlags().getBackingSet();
        int wrappedGoalSize = goal.getFlags().size();
        for (int i2 = 0; i2 < wrappedGoalSize; ++i2) {
            PathfinderGoal.Type flag = GOAL_FLAG_VALUES[Long.numberOfTrailingZeros(flagIterator)];
            flagIterator ^= IntegerUtil.getTrailingBit(flagIterator);
            if (goalsByControl.getOrDefault((Object)flag, a).a(goal)) continue;
            return false;
        }
        return true;
    }

    public void a() {
        GameProfilerFiller profilerFiller = this.d.get();
        profilerFiller.a("goalCleanup");
        for (PathfinderGoalWrapped wrappedGoal : this.c) {
            if (!wrappedGoal.h() || !PathfinderGoalSelector.goalContainsAnyFlags(wrappedGoal, this.goalTypes) && wrappedGoal.c()) continue;
            wrappedGoal.e();
        }
        this.b.entrySet().removeIf(entry -> !((PathfinderGoalWrapped)entry.getValue()).h());
        profilerFiller.c();
        profilerFiller.a("goalUpdate");
        for (PathfinderGoalWrapped wrappedGoal2 : this.c) {
            if (wrappedGoal2.h() || PathfinderGoalSelector.goalContainsAnyFlags(wrappedGoal2, this.goalTypes) || !PathfinderGoalSelector.a(wrappedGoal2, this.b) || !wrappedGoal2.b()) continue;
            long flagIterator = wrappedGoal2.getFlags().getBackingSet();
            int wrappedGoalSize = wrappedGoal2.getFlags().size();
            for (int i2 = 0; i2 < wrappedGoalSize; ++i2) {
                PathfinderGoal.Type flag = GOAL_FLAG_VALUES[Long.numberOfTrailingZeros(flagIterator)];
                flagIterator ^= IntegerUtil.getTrailingBit(flagIterator);
                PathfinderGoalWrapped wrappedGoal3 = this.b.getOrDefault((Object)flag, a);
                wrappedGoal3.e();
                this.b.put(flag, wrappedGoal2);
            }
            wrappedGoal2.d();
        }
        profilerFiller.c();
        this.a(true);
    }

    public void a(boolean tickAll) {
        GameProfilerFiller profilerFiller = this.d.get();
        profilerFiller.a("goalTick");
        for (PathfinderGoalWrapped wrappedGoal : this.c) {
            if (!wrappedGoal.h() || !tickAll && !wrappedGoal.V_()) continue;
            wrappedGoal.a();
        }
        profilerFiller.c();
    }

    public Set<PathfinderGoalWrapped> b() {
        return this.c;
    }

    public void a(PathfinderGoal.Type control) {
        this.goalTypes.add(control);
    }

    public void b(PathfinderGoal.Type control) {
        this.goalTypes.remove(control);
    }

    public void a(PathfinderGoal.Type control, boolean enabled) {
        if (enabled) {
            this.b(control);
        } else {
            this.a(control);
        }
    }
}

