/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.memory.ExpirableMemory;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class BehaviorController<E extends EntityLiving> {
    static final Logger a = LogUtils.getLogger();
    private final Supplier<Codec<BehaviorController<E>>> b;
    private static final int c = 20;
    private final Map<MemoryModuleType<?>, Optional<? extends ExpirableMemory<?>>> d = Maps.newHashMap();
    private final Map<SensorType<? extends Sensor<? super E>>, Sensor<? super E>> e = Maps.newLinkedHashMap();
    private final Map<Integer, Map<Activity, Set<BehaviorControl<? super E>>>> f = Maps.newTreeMap();
    private Schedule g = Schedule.c;
    private final Map<Activity, Set<Pair<MemoryModuleType<?>, MemoryStatus>>> h = Maps.newHashMap();
    private final Map<Activity, Set<MemoryModuleType<?>>> i = Maps.newHashMap();
    private Set<Activity> j = Sets.newHashSet();
    private final Set<Activity> k = Sets.newHashSet();
    private Activity l = Activity.b;
    private long m = -9999L;

    public static <E extends EntityLiving> b<E> a(Collection<? extends MemoryModuleType<?>> memoryModules, Collection<? extends SensorType<? extends Sensor<? super E>>> sensors) {
        return new b(memoryModules, sensors);
    }

    public static <E extends EntityLiving> Codec<BehaviorController<E>> b(final Collection<? extends MemoryModuleType<?>> memoryModules, final Collection<? extends SensorType<? extends Sensor<? super E>>> sensors) {
        final MutableObject mutableObject = new MutableObject();
        mutableObject.setValue((Object)new MapCodec<BehaviorController<E>>(){

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return memoryModules.stream().flatMap(memoryType -> memoryType.a().map(codec -> BuiltInRegistries.z.b((MemoryModuleType<?>)memoryType)).stream()).map(id -> dynamicOps.createString(id.toString()));
            }

            public <T> DataResult<BehaviorController<E>> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                MutableObject mutableObject2 = new MutableObject((Object)DataResult.success((Object)ImmutableList.builder()));
                mapLike.entries().forEach(pair -> {
                    DataResult dataResult = BuiltInRegistries.z.r().parse(dynamicOps, pair.getFirst());
                    DataResult dataResult2 = dataResult.flatMap(memoryType -> this.a((MemoryModuleType)memoryType, dynamicOps, (Object)pair.getSecond()));
                    mutableObject2.setValue((Object)((DataResult)mutableObject2.getValue()).apply2(ImmutableList.Builder::add, dataResult2));
                });
                ImmutableList immutableList = ((DataResult)mutableObject2.getValue()).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).map(ImmutableList.Builder::build).orElseGet(ImmutableList::of);
                return DataResult.success(new BehaviorController(memoryModules, sensors, immutableList, () -> ((MutableObject)mutableObject).getValue()));
            }

            private <T, U> DataResult<a<U>> a(MemoryModuleType<U> memoryType, DynamicOps<T> ops, T value) {
                return memoryType.a().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No codec for memory: " + String.valueOf(memoryType))).flatMap(codec -> codec.parse(ops, value)).map(data -> new a(memoryType, Optional.of(data)));
            }

            public <T> RecordBuilder<T> a(BehaviorController<E> brain, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                brain.j().forEach(entry -> entry.a(dynamicOps, recordBuilder));
                return recordBuilder;
            }

            public /* synthetic */ RecordBuilder encode(Object object, DynamicOps dynamicOps, RecordBuilder recordBuilder) {
                return this.a((BehaviorController)object, dynamicOps, recordBuilder);
            }
        }.fieldOf("memories").codec());
        return (Codec)mutableObject.getValue();
    }

    public BehaviorController(Collection<? extends MemoryModuleType<?>> memories, Collection<? extends SensorType<? extends Sensor<? super E>>> sensors, ImmutableList<a<?>> memoryEntries, Supplier<Codec<BehaviorController<E>>> codecSupplier) {
        this.b = codecSupplier;
        for (MemoryModuleType<?> memoryModuleType : memories) {
            this.d.put(memoryModuleType, Optional.empty());
        }
        for (SensorType sensorType : sensors) {
            this.e.put(sensorType, (Sensor<E>)sensorType.a());
        }
        for (Sensor sensor : this.e.values()) {
            for (MemoryModuleType<?> memoryModuleType2 : sensor.a()) {
                this.d.put(memoryModuleType2, Optional.empty());
            }
        }
        for (a a2 : memoryEntries) {
            a2.a(this);
        }
    }

    public <T> DataResult<T> a(DynamicOps<T> ops) {
        return this.b.get().encodeStart(ops, (Object)this);
    }

    Stream<a<?>> j() {
        return this.d.entrySet().stream().map(entry -> net.minecraft.world.entity.ai.BehaviorController$a.a((MemoryModuleType)entry.getKey(), (Optional)entry.getValue()));
    }

    public boolean a(MemoryModuleType<?> type) {
        return this.a(type, MemoryStatus.a);
    }

    public void a() {
        this.d.keySet().forEach(type -> this.d.put((MemoryModuleType<?>)type, Optional.empty()));
    }

    public <U> void b(MemoryModuleType<U> type) {
        this.a(type, Optional.empty());
    }

    public <U> void a(MemoryModuleType<U> type, @Nullable U value) {
        this.a(type, Optional.ofNullable(value));
    }

    public <U> void a(MemoryModuleType<U> type, U value, long expiry) {
        this.b(type, Optional.of(ExpirableMemory.a(value, expiry)));
    }

    public <U> void a(MemoryModuleType<U> type, Optional<? extends U> value) {
        this.b(type, value.map(ExpirableMemory::a));
    }

    <U> void b(MemoryModuleType<U> type, Optional<? extends ExpirableMemory<?>> memory) {
        if (this.d.containsKey(type)) {
            if (memory.isPresent() && this.a(memory.get().c())) {
                this.b(type);
            } else {
                this.d.put(type, memory);
            }
        }
    }

    public <U> Optional<U> c(MemoryModuleType<U> type) {
        Optional<ExpirableMemory<?>> optional = this.d.get(type);
        if (optional == null) {
            throw new IllegalStateException("Unregistered memory fetched: " + String.valueOf(type));
        }
        return optional.map(ExpirableMemory::c);
    }

    @Nullable
    public <U> Optional<U> d(MemoryModuleType<U> type) {
        Optional<ExpirableMemory<?>> optional = this.d.get(type);
        if (optional == null) {
            return null;
        }
        return optional.map(ExpirableMemory::c);
    }

    public <U> long e(MemoryModuleType<U> type) {
        Optional<ExpirableMemory<?>> optional = this.d.get(type);
        return optional.map(ExpirableMemory::b).orElse(0L);
    }

    @Deprecated
    @VisibleForDebug
    public Map<MemoryModuleType<?>, Optional<? extends ExpirableMemory<?>>> b() {
        return this.d;
    }

    public <U> boolean b(MemoryModuleType<U> type, U value) {
        if (!this.a(type)) {
            return false;
        }
        return this.c(type).filter(memoryValue -> memoryValue.equals(value)).isPresent();
    }

    public boolean a(MemoryModuleType<?> type, MemoryStatus state) {
        Optional<ExpirableMemory<?>> optional = this.d.get(type);
        if (optional == null) {
            return false;
        }
        return state == MemoryStatus.c || state == MemoryStatus.a && optional.isPresent() || state == MemoryStatus.b && optional.isEmpty();
    }

    public Schedule c() {
        return this.g;
    }

    public void a(Schedule schedule) {
        this.g = schedule;
    }

    public void a(Set<Activity> coreActivities) {
        this.j = coreActivities;
    }

    @Deprecated
    @VisibleForDebug
    public Set<Activity> d() {
        return this.k;
    }

    @Deprecated
    @VisibleForDebug
    public List<BehaviorControl<? super E>> e() {
        ObjectArrayList list = new ObjectArrayList();
        for (Map<Activity, Set<BehaviorControl<E>>> map : this.f.values()) {
            for (Set<BehaviorControl<E>> set : map.values()) {
                for (BehaviorControl<E> behaviorControl : set) {
                    if (behaviorControl.a() != Behavior.Status.b) continue;
                    list.add(behaviorControl);
                }
            }
        }
        return list;
    }

    public void f() {
        this.d(this.l);
    }

    public Optional<Activity> g() {
        for (Activity activity : this.k) {
            if (this.j.contains(activity)) continue;
            return Optional.of(activity);
        }
        return Optional.empty();
    }

    public void a(Activity activity) {
        if (this.f(activity)) {
            this.d(activity);
        } else {
            this.f();
        }
    }

    private void d(Activity except) {
        if (this.c(except)) {
            return;
        }
        this.e(except);
        this.k.clear();
        this.k.addAll(this.j);
        this.k.add(except);
    }

    private void e(Activity except) {
        for (Activity activity : this.k) {
            Set<MemoryModuleType<?>> set;
            if (activity == except || (set = this.i.get(activity)) == null) continue;
            for (MemoryModuleType<?> memoryModuleType : set) {
                this.b(memoryModuleType);
            }
        }
    }

    public void a(long timeOfDay, long time) {
        if (time - this.m > 20L) {
            this.m = time;
            Activity activity = this.c().a((int)(timeOfDay % 24000L));
            if (!this.k.contains(activity)) {
                this.a(activity);
            }
        }
    }

    public void a(List<Activity> activities) {
        for (Activity activity : activities) {
            if (!this.f(activity)) continue;
            this.d(activity);
            break;
        }
    }

    public void b(Activity activity) {
        this.l = activity;
    }

    public void a(Activity activity, int begin, ImmutableList<? extends BehaviorControl<? super E>> list) {
        this.a(activity, this.a(begin, list));
    }

    public void a(Activity activity, int begin, ImmutableList<? extends BehaviorControl<? super E>> tasks, MemoryModuleType<?> memoryType) {
        ImmutableSet set = ImmutableSet.of((Object)Pair.of(memoryType, (Object)((Object)MemoryStatus.a)));
        ImmutableSet set2 = ImmutableSet.of(memoryType);
        this.a(activity, (ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>>)this.a(begin, tasks), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)set, (Set<MemoryModuleType<?>>)set2);
    }

    public void a(Activity activity, ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> indexedTasks) {
        this.a(activity, indexedTasks, (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of(), Sets.newHashSet());
    }

    public void a(Activity activity, ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> indexedTasks, Set<Pair<MemoryModuleType<?>, MemoryStatus>> requiredMemories) {
        this.a(activity, indexedTasks, requiredMemories, Sets.newHashSet());
    }

    public void a(Activity activity, ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> indexedTasks, Set<Pair<MemoryModuleType<?>, MemoryStatus>> requiredMemories, Set<MemoryModuleType<?>> forgettingMemories) {
        this.h.put(activity, requiredMemories);
        if (!forgettingMemories.isEmpty()) {
            this.i.put(activity, forgettingMemories);
        }
        for (Pair pair : indexedTasks) {
            this.f.computeIfAbsent((Integer)pair.getFirst(), index -> Maps.newHashMap()).computeIfAbsent(activity, activity2 -> Sets.newLinkedHashSet()).add((BehaviorControl)pair.getSecond());
        }
    }

    @VisibleForTesting
    public void h() {
        this.f.clear();
    }

    public boolean c(Activity activity) {
        return this.k.contains(activity);
    }

    public BehaviorController<E> i() {
        BehaviorController<E> brain = new BehaviorController<E>(this.d.keySet(), this.e.keySet(), ImmutableList.of(), this.b);
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableMemory<?>>> entry : this.d.entrySet()) {
            MemoryModuleType<?> memoryModuleType = entry.getKey();
            if (!entry.getValue().isPresent()) continue;
            brain.d.put(memoryModuleType, entry.getValue());
        }
        return brain;
    }

    public void a(WorldServer world, E entity) {
        this.k();
        this.c(world, entity);
        this.d(world, entity);
        this.e(world, entity);
    }

    private void c(WorldServer world, E entity) {
        for (Sensor<E> sensor : this.e.values()) {
            sensor.b(world, entity);
        }
    }

    private void k() {
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableMemory<?>>> entry : this.d.entrySet()) {
            if (!entry.getValue().isPresent()) continue;
            ExpirableMemory<?> expirableValue = entry.getValue().get();
            if (expirableValue.d()) {
                this.b(entry.getKey());
            }
            expirableValue.a();
        }
    }

    public void b(WorldServer world, E entity) {
        long l2 = ((Entity)entity).dO().Z();
        for (BehaviorControl<E> behaviorControl : this.e()) {
            behaviorControl.g(world, entity, l2);
        }
    }

    private void d(WorldServer world, E entity) {
        long l2 = world.Z();
        for (Map<Activity, Set<BehaviorControl<E>>> map : this.f.values()) {
            for (Map.Entry<Activity, Set<BehaviorControl<E>>> entry : map.entrySet()) {
                Activity activity = entry.getKey();
                if (!this.k.contains(activity)) continue;
                Set<BehaviorControl<E>> set = entry.getValue();
                for (BehaviorControl<E> behaviorControl : set) {
                    if (behaviorControl.a() != Behavior.Status.a) continue;
                    behaviorControl.e(world, entity, l2);
                }
            }
        }
    }

    private void e(WorldServer world, E entity) {
        long l2 = world.Z();
        for (BehaviorControl<E> behaviorControl : this.e()) {
            behaviorControl.f(world, entity, l2);
        }
    }

    private boolean f(Activity activity) {
        if (!this.h.containsKey(activity)) {
            return false;
        }
        for (Pair<MemoryModuleType<?>, MemoryStatus> pair : this.h.get(activity)) {
            MemoryStatus memoryStatus;
            MemoryModuleType memoryModuleType = (MemoryModuleType)pair.getFirst();
            if (this.a(memoryModuleType, memoryStatus = (MemoryStatus)((Object)pair.getSecond()))) continue;
            return false;
        }
        return true;
    }

    private boolean a(Object value) {
        return value instanceof Collection && ((Collection)value).isEmpty();
    }

    ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> a(int begin, ImmutableList<? extends BehaviorControl<? super E>> tasks) {
        int i2 = begin;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BehaviorControl behaviorControl : tasks) {
            builder.add((Object)Pair.of((Object)i2++, (Object)behaviorControl));
        }
        return builder.build();
    }

    public static final class b<E extends EntityLiving> {
        private final Collection<? extends MemoryModuleType<?>> a;
        private final Collection<? extends SensorType<? extends Sensor<? super E>>> b;
        private final Codec<BehaviorController<E>> c;

        b(Collection<? extends MemoryModuleType<?>> memoryModules, Collection<? extends SensorType<? extends Sensor<? super E>>> sensors) {
            this.a = memoryModules;
            this.b = sensors;
            this.c = BehaviorController.b(memoryModules, sensors);
        }

        public BehaviorController<E> a(Dynamic<?> data) {
            return this.c.parse(data).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).orElseGet(() -> new BehaviorController(this.a, this.b, ImmutableList.of(), () -> this.c));
        }
    }

    static final class a<U> {
        private final MemoryModuleType<U> a;
        private final Optional<? extends ExpirableMemory<U>> b;

        static <U> a<U> a(MemoryModuleType<U> type, Optional<? extends ExpirableMemory<?>> data) {
            return new a<U>(type, data);
        }

        a(MemoryModuleType<U> type, Optional<? extends ExpirableMemory<U>> data) {
            this.a = type;
            this.b = data;
        }

        void a(BehaviorController<?> brain) {
            brain.b(this.a, this.b);
        }

        public <T> void a(DynamicOps<T> ops, RecordBuilder<T> builder) {
            this.a.a().ifPresent(codec -> this.b.ifPresent(data -> builder.add(BuiltInRegistries.z.r().encodeStart(ops, this.a), codec.encodeStart(ops, data))));
        }
    }
}

