/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityDamageEvent;
import org.slf4j.Logger;

public class Interaction
extends Entity
implements Attackable,
Targeting {
    private static final Logger b = LogUtils.getLogger();
    private static final DataWatcherObject<Float> c = DataWatcher.a(Interaction.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> d = DataWatcher.a(Interaction.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Boolean> e = DataWatcher.a(Interaction.class, DataWatcherRegistry.k);
    private static final String f = "width";
    private static final String g = "height";
    private static final String h = "attack";
    private static final String i = "interaction";
    private static final String j = "response";
    @Nullable
    public PlayerAction k;
    @Nullable
    public PlayerAction l;

    public Interaction(EntityTypes<?> type, World world) {
        super(type, world);
        this.ag = true;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(c, Float.valueOf(1.0f));
        builder.a(d, Float.valueOf(1.0f));
        builder.a(e, false);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        Logger logger;
        DataResult dataresult;
        if (nbt.b(f, 99)) {
            this.a(nbt.j(f));
        }
        if (nbt.b(g, 99)) {
            this.b(nbt.j(g));
        }
        if (nbt.e(h)) {
            dataresult = PlayerAction.a.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(h));
            logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(SystemUtils.a("Interaction entity", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(pair -> {
                this.k = (PlayerAction)pair.getFirst();
            });
        } else {
            this.k = null;
        }
        if (nbt.e(i)) {
            dataresult = PlayerAction.a.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(i));
            logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(SystemUtils.a("Interaction entity", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(pair -> {
                this.l = (PlayerAction)pair.getFirst();
            });
        } else {
            this.l = null;
        }
        this.a(nbt.q(j));
        this.a(this.au());
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a(f, this.s());
        nbt.a(g, this.t());
        if (this.k != null) {
            PlayerAction.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.k).ifSuccess(nbtbase -> nbt.a(h, (NBTBase)nbtbase));
        }
        if (this.l != null) {
            PlayerAction.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.l).ifSuccess(nbtbase -> nbt.a(i, (NBTBase)nbtbase));
        }
        nbt.a(j, this.v());
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (d.equals(data) || c.equals(data)) {
            this.a(this.au());
        }
    }

    @Override
    public boolean bz() {
        return false;
    }

    @Override
    public boolean bA() {
        return true;
    }

    @Override
    public EnumPistonReaction j_() {
        return EnumPistonReaction.d;
    }

    @Override
    public boolean r_() {
        return true;
    }

    @Override
    public boolean u(Entity attacker) {
        if (attacker instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)attacker;
            DamageSource source = entityhuman.dP().a(entityhuman);
            EntityDamageEvent event = CraftEventFactory.callNonLivingEntityDamageEvent(this, source, 1.0, false);
            if (event.isCancelled()) {
                return true;
            }
            this.k = new PlayerAction(entityhuman.cz(), this.dO().Z());
            if (entityhuman instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityhuman;
                CriterionTriggers.h.a(entityplayer, this, entityhuman.dP().o(), 1.0f, (float)event.getFinalDamage(), false);
            }
            return !this.v();
        }
        return false;
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        if (this.dO().B) {
            return this.v() ? EnumInteractionResult.a : EnumInteractionResult.c;
        }
        this.l = new PlayerAction(player.cz(), this.dO().Z());
        return EnumInteractionResult.c;
    }

    @Override
    public void l() {
    }

    @Override
    @Nullable
    public EntityLiving Y_() {
        return this.k != null ? this.dO().b(this.k.a()) : null;
    }

    @Override
    @Nullable
    public EntityLiving p() {
        return this.l != null ? this.dO().b(this.l.a()) : null;
    }

    public void a(float width) {
        this.ao.a(c, Float.valueOf(width));
    }

    public float s() {
        return this.ao.a(c).floatValue();
    }

    public void b(float height) {
        this.ao.a(d, Float.valueOf(height));
    }

    public float t() {
        return this.ao.a(d).floatValue();
    }

    public void a(boolean response) {
        this.ao.a(e, response);
    }

    public boolean v() {
        return this.ao.a(e);
    }

    private EntitySize w() {
        return EntitySize.b(this.s(), this.t());
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return this.w();
    }

    @Override
    protected AxisAlignedBB au() {
        return this.w().a(this.dm());
    }

    public static final class PlayerAction
    extends Record {
        private final UUID b;
        private final long c;
        public static final Codec<PlayerAction> a = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.a.fieldOf("player").forGetter(PlayerAction::a), (App)Codec.LONG.fieldOf("timestamp").forGetter(PlayerAction::b)).apply((Applicative)instance, PlayerAction::new));

        public PlayerAction(UUID player, long timestamp) {
            this.b = player;
            this.c = timestamp;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PlayerAction.class, "player;timestamp", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PlayerAction.class, "player;timestamp", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PlayerAction.class, "player;timestamp", "b", "c"}, this, o2);
        }

        public UUID a() {
            return this.b;
        }

        public long b() {
            return this.c;
        }
    }
}

