/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;

public class ClampedInt
extends IntProvider {
    public static final MapCodec<ClampedInt> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IntProvider.c.fieldOf("source").forGetter(provider -> provider.b), (App)Codec.INT.fieldOf("min_inclusive").forGetter(provider -> provider.f), (App)Codec.INT.fieldOf("max_inclusive").forGetter(provider -> provider.g)).apply((Applicative)instance, ClampedInt::new)).validate(provider -> {
        if (provider.g < provider.f) {
            return DataResult.error(() -> "Max must be at least min, min_inclusive: " + clampedInt.f + ", max_inclusive: " + clampedInt.g);
        }
        return DataResult.success((Object)provider);
    });
    private final IntProvider b;
    private final int f;
    private final int g;

    public static ClampedInt a(IntProvider source, int min, int max) {
        return new ClampedInt(source, min, max);
    }

    public ClampedInt(IntProvider source, int min, int max) {
        this.b = source;
        this.f = min;
        this.g = max;
    }

    @Override
    @Override
    public int a(RandomSource random) {
        return MathHelper.a(this.b.a(random), this.f, this.g);
    }

    @Override
    @Override
    public int a() {
        return Math.max(this.f, this.b.a());
    }

    @Override
    @Override
    public int b() {
        return Math.min(this.g, this.b.b());
    }

    @Override
    @Override
    public IntProviderType<?> c() {
        return IntProviderType.d;
    }
}

