/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.eventlog;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class EventLogDirectory {
    static final Logger a = LogUtils.getLogger();
    private static final int b = 4096;
    private static final String c = ".gz";
    private final Path d;
    private final String e;

    private EventLogDirectory(Path directory, String extension) {
        this.d = directory;
        this.e = extension;
    }

    public static EventLogDirectory a(Path directory, String extension) throws IOException {
        Files.createDirectories(directory, new FileAttribute[0]);
        return new EventLogDirectory(directory, extension);
    }

    public d a() throws IOException {
        try (Stream<Path> stream = Files.list(this.d);){
            d d2 = new d(stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).map(this::a).filter(Objects::nonNull).toList());
            return d2;
        }
    }

    @Nullable
    private b a(Path path) {
        String string = path.getFileName().toString();
        int i2 = string.indexOf(46);
        if (i2 == -1) {
            return null;
        }
        c fileId = net.minecraft.util.eventlog.EventLogDirectory$c.a(string.substring(0, i2));
        if (fileId != null) {
            String string2 = string.substring(i2);
            if (string2.equals(this.e)) {
                return new e(path, fileId);
            }
            if (string2.equals(this.e + c)) {
                return new a(path, fileId);
            }
        }
        return null;
    }

    static void a(Path from, Path to) throws IOException {
        if (Files.exists(to, new LinkOption[0])) {
            throw new IOException("Compressed target file already exists: " + String.valueOf(to));
        }
        try (FileChannel fileChannel = FileChannel.open(from, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            FileLock fileLock = fileChannel.tryLock();
            if (fileLock == null) {
                throw new IOException("Raw log file is already locked, cannot compress: " + String.valueOf(from));
            }
            EventLogDirectory.a(fileChannel, to);
            fileChannel.truncate(0L);
        }
        Files.delete(from);
    }

    private static void a(ReadableByteChannel source, Path outputPath) throws IOException {
        try (GZIPOutputStream outputStream = new GZIPOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
            byte[] bs = new byte[4096];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bs);
            while (source.read(byteBuffer) >= 0) {
                byteBuffer.flip();
                ((OutputStream)outputStream).write(bs, 0, byteBuffer.limit());
                byteBuffer.clear();
            }
        }
    }

    public e a(LocalDate date) throws IOException {
        c fileId;
        int i2 = 1;
        Set<c> set = this.a().c();
        while (set.contains(fileId = new c(date, i2++))) {
        }
        e rawFile = new e(this.d.resolve(fileId.b(this.e)), fileId);
        Files.createFile(rawFile.c(), new FileAttribute[0]);
        return rawFile;
    }

    public static class d
    implements Iterable<b> {
        private final List<b> a;

        d(List<b> logs) {
            this.a = new ArrayList<b>(logs);
        }

        public d a(LocalDate currentDate, int retentionDays) {
            this.a.removeIf(log -> {
                c fileId = log.d();
                LocalDate localDate2 = fileId.a().plusDays(retentionDays);
                if (!currentDate.isBefore(localDate2)) {
                    try {
                        Files.delete(log.c());
                        return true;
                    }
                    catch (IOException iOException) {
                        a.warn("Failed to delete expired event log file: {}", (Object)log.c(), (Object)iOException);
                    }
                }
                return false;
            });
            return this;
        }

        public d a() {
            ListIterator<b> listIterator = this.a.listIterator();
            while (listIterator.hasNext()) {
                b file = listIterator.next();
                try {
                    listIterator.set(file.b());
                }
                catch (IOException iOException) {
                    a.warn("Failed to compress event log file: {}", (Object)file.c(), (Object)iOException);
                }
            }
            return this;
        }

        @Override
        @Override
        public Iterator<b> iterator() {
            return this.a.iterator();
        }

        public Stream<b> b() {
            return this.a.stream();
        }

        public Set<c> c() {
            return this.a.stream().map(b::d).collect(Collectors.toSet());
        }
    }

    public record c(LocalDate a, int b) {
        private static final DateTimeFormatter c = DateTimeFormatter.BASIC_ISO_DATE;

        @Nullable
        public static c a(String fileName) {
            int i2 = fileName.indexOf("-");
            if (i2 == -1) {
                return null;
            }
            String string = fileName.substring(0, i2);
            String string2 = fileName.substring(i2 + 1);
            try {
                return new c(LocalDate.parse(string, c), Integer.parseInt(string2));
            }
            catch (NumberFormatException | DateTimeParseException runtimeException) {
                return null;
            }
        }

        @Override
        @Override
        public String toString() {
            return c.format(this.a) + "-" + this.b;
        }

        public String b(String extension) {
            return String.valueOf(this) + extension;
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "date;index", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "date;index", "a", "b"}, this, object);
        }
    }

    public record e(Path a, c b) implements b
    {
        private final Path a;
        private final c b;

        public FileChannel e() throws IOException {
            return FileChannel.open(this.a, StandardOpenOption.WRITE, StandardOpenOption.READ);
        }

        @Override
        @Nullable
        @Override
        public Reader a() throws IOException {
            return Files.exists(this.a, new LinkOption[0]) ? Files.newBufferedReader(this.a) : null;
        }

        @Override
        @Override
        public a b() throws IOException {
            Path path = this.a.resolveSibling(this.a.getFileName().toString() + EventLogDirectory.c);
            EventLogDirectory.a(this.a, path);
            return new a(path, this.b);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "path;id", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "path;id", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "path;id", "a", "b"}, this, object);
        }

        @Override
        @Override
        public Path c() {
            return this.a;
        }

        @Override
        @Override
        public c d() {
            return this.b;
        }
    }

    public record a(Path a, c b) implements b
    {
        private final Path a;
        private final c b;

        @Override
        @Nullable
        @Override
        public Reader a() throws IOException {
            if (!Files.exists(this.a, new LinkOption[0])) {
                return null;
            }
            return new BufferedReader(new InputStreamReader(new GZIPInputStream(Files.newInputStream(this.a, new OpenOption[0]))));
        }

        @Override
        @Override
        public a b() {
            return this;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "path;id", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "path;id", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "path;id", "a", "b"}, this, object);
        }

        @Override
        @Override
        public Path c() {
            return this.a;
        }

        @Override
        @Override
        public c d() {
            return this.b;
        }
    }

    public static interface b {
        public Path c();

        public c d();

        @Nullable
        public Reader a() throws IOException;

        public a b() throws IOException;
    }
}

