/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public abstract class ItemStackComponentRemainderFix
extends DataFix {
    private final String a;
    private final String b;
    private final String c;

    public ItemStackComponentRemainderFix(Schema outputSchema, String name, String componentId) {
        this(outputSchema, name, componentId, componentId);
    }

    public ItemStackComponentRemainderFix(Schema outputSchema, String name, String oldComponentId, String newComponentId) {
        super(outputSchema, false);
        this.a = name;
        this.b = oldComponentId;
        this.c = newComponentId;
    }

    public final TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.t);
        OpticFinder opticFinder = type.findField("components");
        return this.fixTypeEverywhereTyped(this.a, type, typed2 -> typed2.updateTyped(opticFinder, typed -> typed.update(DSL.remainderFinder(), dynamic -> dynamic.renameAndFixField(this.b, this.c, this::a))));
    }

    protected abstract <T> Dynamic<T> a(Dynamic<T> var1);
}

