/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.fixes.DataConverterNamedEntity;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterVillagerFollowRange
extends DataConverterNamedEntity {
    private static final double a = 16.0;
    private static final double b = 48.0;

    public DataConverterVillagerFollowRange(Schema outputSchema) {
        super(outputSchema, false, "Villager Follow Range Fix", DataConverterTypes.B, "minecraft:villager");
    }

    @Override
    @Override
    protected Typed<?> a(Typed<?> inputTyped) {
        return inputTyped.update(DSL.remainderFinder(), DataConverterVillagerFollowRange::a);
    }

    private static Dynamic<?> a(Dynamic<?> villagerDynamic) {
        return villagerDynamic.update("Attributes", attributesDynamic -> villagerDynamic.createList(attributesDynamic.asStream().map(attributeDynamic -> {
            if (!attributeDynamic.get("Name").asString("").equals("generic.follow_range") || attributeDynamic.get("Base").asDouble(0.0) != 16.0) {
                return attributeDynamic;
            }
            return attributeDynamic.set("Base", attributeDynamic.createDouble(48.0));
        })));
    }
}

