/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Locale;
import java.util.function.Consumer;

public class StaticCache2D<T> {
    private final int a;
    private final int b;
    private final int c;
    private final int d;
    private final Object[] e;

    public static <T> StaticCache2D<T> a(int centerX, int centerZ, int radius, a<T> getter) {
        int i2 = centerX - radius;
        int j2 = centerZ - radius;
        int k2 = 2 * radius + 1;
        return new StaticCache2D<T>(i2, j2, k2, k2, getter);
    }

    private StaticCache2D(int minX, int minZ, int maxX, int maxZ, a<T> getter) {
        this.a = minX;
        this.b = minZ;
        this.c = maxX;
        this.d = maxZ;
        this.e = new Object[this.c * this.d];
        for (int i2 = minX; i2 < minX + maxX; ++i2) {
            for (int j2 = minZ; j2 < minZ + maxZ; ++j2) {
                this.e[this.c((int)i2, (int)j2)] = getter.get(i2, j2);
            }
        }
    }

    public void a(Consumer<T> callback) {
        for (Object object : this.e) {
            callback.accept(object);
        }
    }

    public T a(int x2, int z2) {
        if (!this.b(x2, z2)) {
            throw new IllegalArgumentException("Requested out of range value (" + x2 + "," + z2 + ") from " + String.valueOf(this));
        }
        return (T)this.e[this.c(x2, z2)];
    }

    public boolean b(int x2, int z2) {
        int i2 = x2 - this.a;
        int j2 = z2 - this.b;
        return i2 >= 0 && i2 < this.c && j2 >= 0 && j2 < this.d;
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "StaticCache2D[%d, %d, %d, %d]", this.a, this.b, this.a + this.c, this.b + this.d);
    }

    private int c(int x2, int z2) {
        int i2 = x2 - this.a;
        int j2 = z2 - this.b;
        return i2 * this.d + j2;
    }

    @FunctionalInterface
    public static interface a<T> {
        public T get(int var1, int var2);
    }
}

