/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import co.aikar.timings.MinecraftTimings;
import com.destroystokyo.paper.console.TerminalConsoleCommandSender;
import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.profile.ProfileWhitelistVerifyEvent;
import com.destroystokyo.paper.event.server.WhitelistToggleEvent;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.MCUtil;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutLogin;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutViewDistance;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkEmpty;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public abstract class PlayerList {
    public static final File a = new File("banned-players.json");
    public static final File b = new File("banned-ips.json");
    public static final File c = new File("ops.json");
    public static final File d = new File("whitelist.json");
    public static final IChatBaseComponent e = IChatBaseComponent.c("chat.filtered_full");
    public static final IChatBaseComponent f = IChatBaseComponent.c("multiplayer.disconnect.duplicate_login");
    private static final Logger h = LogUtils.getLogger();
    private static final int i = 600;
    private static final SimpleDateFormat j = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer k;
    public final List<EntityPlayer> l = new CopyOnWriteArrayList<EntityPlayer>();
    private final Map<UUID, EntityPlayer> m = Maps.newHashMap();
    private final GameProfileBanList n;
    private final IpBanList o;
    private final OpList p;
    private final WhiteList q;
    public final WorldNBTStorage t;
    private boolean u;
    private final LayeredRegistryAccess<RegistryLayer> v;
    public int g;
    private int w;
    private int x;
    private boolean y;
    private static final boolean z = false;
    private int A;
    private CraftServer cserver;
    private final Map<String, EntityPlayer> playersByName = new HashMap<String, EntityPlayer>();
    @Nullable
    public String collideRuleTeamName;

    public PlayerList(MinecraftServer server, LayeredRegistryAccess<RegistryLayer> registryManager, WorldNBTStorage saveHandler, int maxPlayers) {
        this.cserver = server.server = new CraftServer((DedicatedServer)server, this);
        server.console = new TerminalConsoleCommandSender();
        this.n = new GameProfileBanList(a);
        this.o = new IpBanList(b);
        this.p = new OpList(c);
        this.q = new WhiteList(d);
        this.k = server;
        this.v = registryManager;
        this.g = maxPlayers;
        this.t = saveHandler;
    }

    public abstract void loadAndSaveFiles();

    public void a(NetworkManager connection, EntityPlayer player, CommonListenerCookie clientData) {
        WorldServer worldserver1;
        WorldServer worldserver;
        boolean[] invalidPlayerWorld;
        ResourceKey<net.minecraft.world.level.World> resourcekey;
        String s2;
        Optional<Object> optional;
        block23: {
            World bWorld;
            block25: {
                block24: {
                    NBTTagCompound nbttagcompound2;
                    player.isRealPlayer = true;
                    player.loginTime = System.currentTimeMillis();
                    GameProfile gameprofile = player.fX();
                    UserCache usercache = this.k.au();
                    if (usercache != null) {
                        optional = usercache.a(gameprofile.getId());
                        s2 = optional.map(GameProfile::getName).orElse(gameprofile.getName());
                        usercache.a(gameprofile);
                    } else {
                        s2 = gameprofile.getName();
                    }
                    optional = this.a(player);
                    resourcekey = null;
                    if (optional.isPresent() && (nbttagcompound2 = (NBTTagCompound)optional.get()).e("bukkit")) {
                        NBTTagCompound bukkit = nbttagcompound2.p("bukkit");
                        s2 = bukkit.b("lastKnownName", 8) ? bukkit.l("lastKnownName") : s2;
                    }
                    invalidPlayerWorld = new boolean[]{false};
                    if (!optional.isPresent()) break block23;
                    if (!((NBTTagCompound)optional.get()).e("WorldUUIDMost") || !((NBTTagCompound)optional.get()).e("WorldUUIDLeast")) break block24;
                    bWorld = Bukkit.getServer().getWorld(new UUID(((NBTTagCompound)optional.get()).i("WorldUUIDMost"), ((NBTTagCompound)optional.get()).i("WorldUUIDLeast")));
                    break block25;
                }
                if (!((NBTTagCompound)optional.get()).b("world", 8)) break block23;
                bWorld = Bukkit.getServer().getWorld(((NBTTagCompound)optional.get()).l("world"));
            }
            if (bWorld != null) {
                resourcekey = ((CraftWorld)bWorld).getHandle().af();
            } else {
                resourcekey = net.minecraft.world.level.World.h;
                invalidPlayerWorld[0] = true;
            }
        }
        if (resourcekey == null) {
            resourcekey = optional.flatMap(nbttagcompound -> {
                DataResult<ResourceKey<net.minecraft.world.level.World>> dataresult = DimensionManager.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbttagcompound.c("Dimension")));
                Logger logger = h;
                Objects.requireNonNull(logger);
                Optional result = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
                invalidPlayerWorld[0] = result.isEmpty();
                return result;
            }).orElse(net.minecraft.world.level.World.h);
        }
        if ((worldserver = this.k.a(resourcekey)) == null) {
            h.warn("Unknown respawn dimension {}, defaulting to overworld", resourcekey);
            worldserver1 = this.k.I();
            invalidPlayerWorld[0] = true;
        } else {
            worldserver1 = worldserver;
        }
        if (optional.isEmpty()) {
            player.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
        }
        if (optional.isEmpty() || invalidPlayerWorld[0]) {
            player.a(player.a(worldserver1, worldserver1.V()).c(), worldserver1.W(), 0.0f);
        }
        player.a(worldserver1);
        String s1 = connection.a(this.k.bn());
        CraftPlayer spawnPlayer = player.getBukkitEntity();
        PlayerSpawnLocationEvent ev = new PlayerSpawnLocationEvent((Player)spawnPlayer, spawnPlayer.getLocation());
        this.cserver.getPluginManager().callEvent((Event)ev);
        Location loc = ev.getSpawnLocation();
        worldserver1 = ((CraftWorld)loc.getWorld()).getHandle();
        player.spawnIn(worldserver1);
        player.e.a((WorldServer)player.dO());
        player.o(loc.getX(), loc.getY(), loc.getZ());
        player.a(loc.getYaw(), loc.getPitch());
        WorldData worlddata = worldserver1.A_();
        player.c((NBTTagCompound)optional.orElse(null));
        PlayerConnection playerconnection = new PlayerConnection(this.k, connection, player, clientData);
        connection.a(GameProtocols.a.a(RegistryFriendlyByteBuf.a(this.k.bc())), playerconnection);
        GameRules gamerules = worldserver1.ab();
        boolean flag = gamerules.b(GameRules.D);
        boolean flag1 = gamerules.b(GameRules.q);
        boolean flag2 = gamerules.b(GameRules.w);
        playerconnection.b(new PacketPlayOutLogin(player.an(), worlddata.l(), this.k.J(), this.n(), worldserver1.spigotConfig.viewDistance, worldserver1.spigotConfig.simulationDistance, flag1, !flag, flag2, player.b(worldserver1), this.k.aB()));
        player.getBukkitEntity().sendSupportedChannels();
        playerconnection.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
        playerconnection.b(new PacketPlayOutAbilities(player.fZ()));
        playerconnection.b(new PacketPlayOutHeldItemSlot(player.fY().k));
        playerconnection.b(new PacketPlayOutRecipeUpdate(this.k.aJ().b()));
        this.e(player);
        player.I().c();
        player.J().a(player);
        this.a(worldserver1.f(), player);
        this.k.aw();
        IChatMutableComponent ichatmutablecomponent = player.fX().getName().equalsIgnoreCase(s2) ? IChatBaseComponent.a("multiplayer.player.joined", player.S_()) : IChatBaseComponent.a("multiplayer.player.joined.renamed", player.S_(), s2);
        ichatmutablecomponent.a(EnumChatFormat.o);
        IChatBaseComponent joinMessage = ichatmutablecomponent;
        playerconnection.a(player.dt(), player.dv(), player.dz(), player.dE(), player.dG());
        ServerPing serverping = this.k.av();
        if (serverping != null && !clientData.d()) {
            player.a(serverping);
        }
        this.l.add(player);
        this.playersByName.put(player.cB().toLowerCase(Locale.ROOT), player);
        this.m.put(player.cz(), player);
        player.supressTrackerForLogin = true;
        worldserver1.a(player);
        this.k.aN().a(player);
        this.mountSavedVehicle(player, worldserver1, optional);
        CraftPlayer bukkitPlayer = player.getBukkitEntity();
        player.cd.transferTo(player.cd, bukkitPlayer);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)bukkitPlayer, PaperAdventure.asAdventure(ichatmutablecomponent));
        this.cserver.getPluginManager().callEvent((Event)playerJoinEvent);
        if (!player.c.c()) {
            return;
        }
        Component jm = playerJoinEvent.joinMessage();
        if (jm != null && !jm.equals((Object)Component.empty())) {
            joinMessage = PaperAdventure.asVanilla(jm);
            this.k.ah().a(joinMessage, false);
        }
        ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.a(List.of(player));
        ArrayList onlinePlayers = Lists.newArrayListWithExpectedSize((int)(this.l.size() - 1));
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            EntityPlayer entityplayer1 = this.l.get(i2);
            if (entityplayer1.getBukkitEntity().canSee(bukkitPlayer)) {
                if (entityplayer1.getBukkitEntity().isListed(bukkitPlayer)) {
                    entityplayer1.c.b(packet);
                } else {
                    entityplayer1.c.b(ClientboundPlayerInfoUpdatePacket.createSinglePlayerInitializing(player, false));
                }
            }
            if (entityplayer1 == player || !bukkitPlayer.canSee(entityplayer1.getBukkitEntity())) continue;
            onlinePlayers.add(entityplayer1);
        }
        if (!onlinePlayers.isEmpty()) {
            player.c.b(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(onlinePlayers, player));
        }
        player.sentListPacket = true;
        player.supressTrackerForLogin = false;
        ((WorldServer)player.dO()).l().a.a((Entity)player);
        this.a(player, worldserver1);
        if (player.dO() == worldserver1 && !worldserver1.x().contains(player)) {
            worldserver1.a(player);
            this.k.aN().a(player);
        }
        worldserver1 = player.A();
        this.d(player);
        this.onPlayerJoinFinish(player, worldserver1, s1);
        if (player.ex()) {
            Holder.c<BiomeBase> plains = worldserver1.H_().d(Registries.aF).g(Biomes.b);
            player.c.b(new ClientboundLevelChunkWithLightPacket(new ChunkEmpty((net.minecraft.world.level.World)worldserver1, player.dq(), plains), worldserver1.y_(), null, null, true));
        }
    }

    private void mountSavedVehicle(EntityPlayer player, WorldServer worldserver1, Optional<NBTTagCompound> optional) {
        if (optional.isPresent() && optional.get().b("RootVehicle", 10)) {
            NBTTagCompound nbttagcompound = optional.get().p("RootVehicle");
            WorldServer finalWorldServer = worldserver1;
            Entity entity = EntityTypes.a(nbttagcompound.p("Entity"), worldserver1, entity1 -> !finalWorldServer.addWithUUID((Entity)entity1, CreatureSpawnEvent.SpawnReason.MOUNT) ? null : entity1);
            if (entity != null) {
                UUID uuid = nbttagcompound.b("Attach") ? nbttagcompound.a("Attach") : null;
                if (entity.cz().equals(uuid)) {
                    player.a(entity, true);
                } else {
                    for (Entity entity12 : entity.cW()) {
                        if (!entity12.cz().equals(uuid)) continue;
                        player.a(entity12, true);
                        break;
                    }
                }
                if (!player.bS()) {
                    h.warn("Couldn't reattach entity to player");
                    entity.discard(null);
                    for (Entity entity12 : entity.cW()) {
                        entity12.discard(null);
                    }
                }
            }
        }
    }

    public void onPlayerJoinFinish(EntityPlayer player, WorldServer worldserver1, String s1) {
        player.h();
        ScoreboardServer scoreboard = this.c().a(net.minecraft.world.level.World.h).f();
        ScoreboardTeam collideRuleTeam = scoreboard.b(this.collideRuleTeamName);
        if (this.collideRuleTeamName != null && collideRuleTeam != null && player.ck() == null) {
            ((Scoreboard)scoreboard).a(player.cB(), collideRuleTeam);
        }
        h.info("{}[{}] logged in with entity id {} at ([{}]{}, {}, {})", new Object[]{player.ah().getString(), s1, player.an(), worldserver1.K.e(), player.dt(), player.dv(), player.dz()});
    }

    public void a(ScoreboardServer scoreboard, EntityPlayer player) {
        HashSet set = Sets.newHashSet();
        for (ScoreboardTeam scoreboardteam : scoreboard.g()) {
            player.c.b(PacketPlayOutScoreboardTeam.a(scoreboardteam, true));
        }
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            ScoreboardObjective scoreboardobjective = scoreboard.a(displayslot);
            if (scoreboardobjective == null || set.contains(scoreboardobjective)) continue;
            List<Packet<?>> list = scoreboard.d(scoreboardobjective);
            for (Packet<?> packet : list) {
                player.c.b(packet);
            }
            set.add(scoreboardobjective);
        }
    }

    public void a(WorldServer world) {
        if (this.t != null) {
            return;
        }
        world.C_().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder border, double size) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderSizePacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, double fromSize, double toSize, long time) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, double centerX, double centerZ) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderCenterPacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, int warningTime) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(border), border.world);
            }

            @Override
            public void b(WorldBorder border, int warningBlockDistance) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(border), border.world);
            }

            @Override
            public void b(WorldBorder border, double damagePerBlock) {
            }

            @Override
            public void c(WorldBorder border, double safeZoneRadius) {
            }
        });
    }

    public Optional<NBTTagCompound> a(EntityPlayer player) {
        Optional<NBTTagCompound> optional;
        NBTTagCompound nbttagcompound = this.k.bb().w();
        if (this.k.a(player.fX()) && nbttagcompound != null) {
            optional = Optional.of(nbttagcompound);
            player.g(nbttagcompound);
            h.debug("loading single player");
        } else {
            optional = this.t.b(player);
        }
        return optional;
    }

    protected void b(EntityPlayer player) {
        AdvancementDataPlayer advancementdataplayer;
        if (!player.getBukkitEntity().isPersistent()) {
            return;
        }
        this.t.a(player);
        ServerStatisticManager serverstatisticmanager = player.I();
        if (serverstatisticmanager != null) {
            serverstatisticmanager.a();
        }
        if ((advancementdataplayer = player.R()) != null) {
            advancementdataplayer.b();
        }
    }

    public Component remove(EntityPlayer entityplayer) {
        return this.remove(entityplayer, (Component)Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? entityplayer.getBukkitEntity().displayName() : PaperAdventure.asAdventure(entityplayer.S_())}));
    }

    public Component remove(EntityPlayer entityplayer, Component leaveMessage) {
        Entity entity;
        WorldServer worldserver = entityplayer.A();
        entityplayer.a(StatisticList.j);
        if (entityplayer.cd != entityplayer.cc) {
            entityplayer.closeContainer(InventoryCloseEvent.Reason.DISCONNECT);
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((Player)entityplayer.getBukkitEntity(), (Component)Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? entityplayer.getBukkitEntity().displayName() : PaperAdventure.asAdventure(entityplayer.S_())}), entityplayer.quitReason);
        this.cserver.getPluginManager().callEvent((Event)playerQuitEvent);
        entityplayer.getBukkitEntity().disconnect(playerQuitEvent.getQuitMessage());
        if (this.k.bx()) {
            entityplayer.m();
        }
        if (this.collideRuleTeamName != null) {
            ScoreboardServer scoreBoard = this.k.a(net.minecraft.world.level.World.h).f();
            ScoreboardTeam team = scoreBoard.e(this.collideRuleTeamName);
            if (entityplayer.ck() == team && team != null) {
                ((Scoreboard)scoreBoard).b(entityplayer.cB(), team);
            }
        }
        if (!entityplayer.cd.g().e()) {
            ItemStack carried = entityplayer.cd.g();
            entityplayer.cd.b(ItemStack.l);
            entityplayer.a(carried, false);
        }
        this.b(entityplayer);
        if (entityplayer.bS() && (entity = entityplayer.cZ()).cY()) {
            h.debug("Removing player mount");
            entityplayer.ad();
            entity.cV().forEach(entity1 -> {
                EntityVillagerAbstract villager;
                EntityHuman human;
                if (entity1 instanceof EntityVillagerAbstract && (human = (villager = (EntityVillagerAbstract)entity1).gk()) != null) {
                    villager.a((EntityHuman)null);
                }
                entity1.setRemoved(Entity.RemovalReason.d, EntityRemoveEvent.Cause.PLAYER_QUIT);
            });
        }
        entityplayer.ak();
        worldserver.a(entityplayer, Entity.RemovalReason.d);
        entityplayer.retireScheduler();
        entityplayer.R().a();
        this.l.remove(entityplayer);
        this.playersByName.remove(entityplayer.cB().toLowerCase(Locale.ROOT));
        this.k.aN().b(entityplayer);
        UUID uuid = entityplayer.cz();
        EntityPlayer entityplayer1 = this.m.get(uuid);
        if (entityplayer1 == entityplayer) {
            this.m.remove(uuid);
        }
        ClientboundPlayerInfoRemovePacket packet = new ClientboundPlayerInfoRemovePacket(List.of(entityplayer.cz()));
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            EntityPlayer entityplayer2 = this.l.get(i2);
            if (entityplayer2.getBukkitEntity().canSee(entityplayer.getBukkitEntity())) {
                entityplayer2.c.b(packet);
                continue;
            }
            entityplayer2.getBukkitEntity().onEntityRemove(entityplayer);
        }
        this.cserver.getScoreboardManager().removePlayer(entityplayer.getBukkitEntity());
        return playerQuitEvent.quitMessage();
    }

    public EntityPlayer canPlayerLogin(LoginListener loginlistener, GameProfile gameprofile) {
        GameProfileBanEntry gameprofilebanentry;
        UUID uuid = gameprofile.getId();
        ArrayList list = Lists.newArrayList();
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            EntityPlayer entityplayer = this.l.get(i2);
            if (!entityplayer.cz().equals(uuid) && (!GlobalConfiguration.get().proxies.isProxyOnlineMode() || !entityplayer.fX().getName().equalsIgnoreCase(gameprofile.getName()))) continue;
            list.add(entityplayer);
        }
        for (EntityPlayer entityplayer : list) {
            this.b(entityplayer);
            entityplayer.c.disconnect(IChatBaseComponent.c("multiplayer.disconnect.duplicate_login"), PlayerKickEvent.Cause.DUPLICATE_LOGIN);
        }
        SocketAddress socketaddress = loginlistener.g.d();
        EntityPlayer entity = new EntityPlayer(this.k, this.k.a(net.minecraft.world.level.World.h), gameprofile, ClientInformation.a());
        entity.transferCookieConnection = loginlistener;
        CraftPlayer player = entity.getBukkitEntity();
        PlayerLoginEvent event = new PlayerLoginEvent((Player)player, loginlistener.g.hostname, ((InetSocketAddress)socketaddress).getAddress(), ((InetSocketAddress)loginlistener.g.n.remoteAddress()).getAddress());
        if (this.n.a(gameprofile) && (gameprofilebanentry = (GameProfileBanEntry)this.n.b(gameprofile)) != null) {
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("multiplayer.disconnect.banned.reason", new Object[]{gameprofilebanentry.d()});
            if (gameprofilebanentry.c() != null) {
                ichatmutablecomponent.b(IChatBaseComponent.a("multiplayer.disconnect.banned.expiration", new Object[]{j.format(gameprofilebanentry.c())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, PaperAdventure.asAdventure(ichatmutablecomponent));
        } else if (this.isWhiteListed(gameprofile, event)) {
            if (this.g().a(socketaddress) && this.g().b(socketaddress) != null && !this.g().b(socketaddress).f()) {
                IpBanEntry ipbanentry = this.o.b(socketaddress);
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("multiplayer.disconnect.banned_ip.reason", new Object[]{ipbanentry.d()});
                if (ipbanentry.c() != null) {
                    ichatmutablecomponent.b(IChatBaseComponent.a("multiplayer.disconnect.banned_ip.expiration", new Object[]{j.format(ipbanentry.c())}));
                }
                event.disallow(PlayerLoginEvent.Result.KICK_BANNED, PaperAdventure.asAdventure(ichatmutablecomponent));
            } else if (this.l.size() >= this.g && !this.d(gameprofile)) {
                event.disallow(PlayerLoginEvent.Result.KICK_FULL, (Component)LegacyComponentSerializer.legacySection().deserialize(SpigotConfig.serverFullMessage));
            }
        }
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            loginlistener.a(PaperAdventure.asVanilla(event.kickMessage()));
            return null;
        }
        return entity;
    }

    public EntityPlayer getPlayerForLogin(GameProfile gameprofile, ClientInformation clientinformation, EntityPlayer player) {
        player.a(clientinformation);
        return player;
    }

    public boolean disconnectAllPlayersWithProfile(GameProfile gameprofile, EntityPlayer player) {
        return player == null;
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, boolean flag, Entity.RemovalReason entity_removalreason, PlayerRespawnEvent.RespawnReason reason) {
        return this.respawn(entityplayer, flag, entity_removalreason, reason, null);
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, boolean flag, Entity.RemovalReason entity_removalreason, PlayerRespawnEvent.RespawnReason reason, Location location) {
        DimensionTransition dimensiontransition;
        entityplayer.ad();
        this.l.remove(entityplayer);
        this.playersByName.remove(entityplayer.cB().toLowerCase(Locale.ROOT));
        entityplayer.A().a(entityplayer, entity_removalreason);
        EntityPlayer entityplayer1 = entityplayer;
        net.minecraft.world.level.World fromWorld = entityplayer.dO();
        entityplayer.h = false;
        entityplayer1.c = entityplayer.c;
        entityplayer1.a(entityplayer, flag);
        entityplayer1.e(entityplayer.an());
        entityplayer1.a(entityplayer.fq());
        for (String s2 : entityplayer.ao()) {
            entityplayer1.a(s2);
        }
        boolean isBedSpawn = false;
        boolean isRespawn = false;
        if (location == null) {
            dimensiontransition = entityplayer.findRespawnPositionAndUseSpawnBlock(flag, DimensionTransition.a, reason);
            if (!flag) {
                entityplayer.reset();
            }
            isRespawn = true;
        } else {
            dimensiontransition = new DimensionTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), Vec3D.b, location.getYaw(), location.getPitch(), DimensionTransition.a);
        }
        if (dimensiontransition == null) {
            return entityplayer;
        }
        WorldServer worldserver = dimensiontransition.a();
        entityplayer1.spawnIn(worldserver);
        entityplayer1.dL();
        entityplayer1.g(false);
        Vec3D vec3d = dimensiontransition.b();
        entityplayer1.forceSetPositionRotation(vec3d.c, vec3d.d, vec3d.e, dimensiontransition.d(), dimensiontransition.e());
        if (dimensiontransition.f()) {
            entityplayer1.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
            entityplayer1.setRespawnPosition(null, null, 0.0f, false, false, PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN);
        }
        boolean i2 = flag;
        WorldServer worldserver1 = entityplayer1.A();
        WorldData worlddata = worldserver1.A_();
        entityplayer1.c.b(new PacketPlayOutRespawn(entityplayer1.b(worldserver1), (byte)(i2 ? 1 : 0)));
        entityplayer1.c.b(new PacketPlayOutViewDistance(worldserver1.spigotConfig.viewDistance));
        entityplayer1.c.b(new ClientboundSetSimulationDistancePacket(worldserver1.spigotConfig.simulationDistance));
        entityplayer1.c.teleport(CraftLocation.toBukkit(entityplayer1.dm(), (World)worldserver1.getWorld(), entityplayer1.dE(), entityplayer1.dG()));
        entityplayer1.c.b(new PacketPlayOutSpawnPosition(worldserver.V(), worldserver.W()));
        entityplayer1.c.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
        entityplayer1.c.b(new PacketPlayOutExperience(entityplayer1.cs, entityplayer1.cr, entityplayer1.cq));
        this.d(entityplayer1);
        this.a(entityplayer1, worldserver);
        this.e(entityplayer1);
        if (!entityplayer.c.isDisconnected()) {
            worldserver.b(entityplayer1);
            this.l.add(entityplayer1);
            this.playersByName.put(entityplayer1.cB().toLowerCase(Locale.ROOT), entityplayer1);
            this.m.put(entityplayer1.cz(), entityplayer1);
        }
        entityplayer1.v(entityplayer1.ew());
        if (!flag) {
            BlockPosition blockposition = BlockPosition.a(dimensiontransition.b());
            IBlockData iblockdata = worldserver.a_(blockposition);
            if (iblockdata.a(Blocks.pl)) {
                entityplayer1.c.b(new PacketPlayOutNamedSoundEffect(SoundEffects.vy, SoundCategory.e, blockposition.u(), blockposition.v(), blockposition.w(), 1.0f, 1.0f, worldserver.E_().g()));
            }
            if (iblockdata.a(TagsBlock.S) && !dimensiontransition.f()) {
                isBedSpawn = true;
            }
        }
        this.f(entityplayer);
        entityplayer.z();
        for (MobEffect mobEffect : entityplayer.et()) {
            entityplayer.c.b(new PacketPlayOutEntityEffect(entityplayer.an(), mobEffect, false));
        }
        entityplayer.c(worldserver);
        if (fromWorld != worldserver) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)entityplayer.getBukkitEntity(), (World)fromWorld.getWorld());
            this.k.server.getPluginManager().callEvent((Event)event);
        }
        if (entityplayer.c.isDisconnected()) {
            this.b(entityplayer);
        }
        if (isRespawn) {
            this.cserver.getPluginManager().callEvent((Event)new PlayerPostRespawnEvent((Player)entityplayer.getBukkitEntity(), location, isBedSpawn));
        }
        return entityplayer1;
    }

    public void d(EntityPlayer player) {
        this.a((EntityLiving)player, player.c);
    }

    public void a(EntityLiving entity, PlayerConnection networkHandler) {
        for (MobEffect mobeffect : entity.et()) {
            networkHandler.b(new PacketPlayOutEntityEffect(entity.an(), mobeffect, false));
        }
    }

    public void e(EntityPlayer player) {
        this.sendPlayerPermissionLevel(player, true);
    }

    public void sendPlayerPermissionLevel(EntityPlayer player, boolean recalculatePermissions) {
        GameProfile gameprofile = player.fX();
        int i2 = this.k.c(gameprofile);
        this.sendPlayerPermissionLevel(player, i2, recalculatePermissions);
    }

    public void d() {
        if (++this.A > 600) {
            for (int i2 = 0; i2 < this.l.size(); ++i2) {
                final EntityPlayer target = this.l.get(i2);
                target.c.b(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.e), this.l.stream().filter(new Predicate<EntityPlayer>(){

                    @Override
                    public boolean test(EntityPlayer input) {
                        return target.getBukkitEntity().canSee(input.getBukkitEntity());
                    }
                }).collect(Collectors.toList())));
            }
            this.A = 0;
        }
    }

    public void a(Packet<?> packet) {
        for (EntityPlayer entityplayer : this.l) {
            entityplayer.c.b(packet);
        }
    }

    public void broadcastAll(Packet packet, EntityHuman entityhuman) {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            EntityPlayer entityplayer = this.l.get(i2);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity())) continue;
            this.l.get((int)i2).c.b(packet);
        }
    }

    public void broadcastAll(Packet packet, net.minecraft.world.level.World world) {
        for (int i2 = 0; i2 < world.x().size(); ++i2) {
            ((EntityPlayer)world.x().get((int)i2)).c.b(packet);
        }
    }

    public void a(Packet<?> packet, ResourceKey<net.minecraft.world.level.World> dimension) {
        for (EntityPlayer entityplayer : this.l) {
            if (entityplayer.dO().af() != dimension) continue;
            entityplayer.c.b(packet);
        }
    }

    public void a(EntityHuman source, IChatBaseComponent message) {
        ScoreboardTeam scoreboardteam = source.ck();
        if (scoreboardteam != null) {
            Collection<String> collection = scoreboardteam.g();
            for (String s2 : collection) {
                EntityPlayer entityplayer = this.a(s2);
                if (entityplayer == null || entityplayer == source) continue;
                entityplayer.a(message);
            }
        }
    }

    public void b(EntityHuman source, IChatBaseComponent message) {
        ScoreboardTeam scoreboardteam = source.ck();
        if (scoreboardteam == null) {
            this.a(message, false);
        } else {
            for (int i2 = 0; i2 < this.l.size(); ++i2) {
                EntityPlayer entityplayer = this.l.get(i2);
                if (entityplayer.ck() == scoreboardteam) continue;
                entityplayer.a(message);
            }
        }
    }

    public String[] e() {
        String[] astring = new String[this.l.size()];
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            astring[i2] = this.l.get(i2).fX().getName();
        }
        return astring;
    }

    public GameProfileBanList f() {
        return this.n;
    }

    public IpBanList g() {
        return this.o;
    }

    public void a(GameProfile profile) {
        this.p.a(new OpListEntry(profile, this.k.k(), this.p.a(profile)));
        EntityPlayer entityplayer = this.a(profile.getId());
        if (entityplayer != null) {
            this.e(entityplayer);
        }
    }

    public void b(GameProfile profile) {
        this.p.c(profile);
        EntityPlayer entityplayer = this.a(profile.getId());
        if (entityplayer != null) {
            this.e(entityplayer);
        }
    }

    private void a(EntityPlayer player, int permissionLevel) {
        this.sendPlayerPermissionLevel(player, permissionLevel, true);
    }

    public void sendPlayerPermissionLevel(EntityPlayer player, int permissionLevel, boolean recalculatePermissions) {
        if (player.c != null) {
            byte b0 = permissionLevel <= 0 ? (byte)24 : (permissionLevel >= 4 ? (byte)28 : (byte)((byte)(24 + permissionLevel)));
            player.c.b(new PacketPlayOutEntityStatus(player, b0));
        }
        if (recalculatePermissions) {
            player.getBukkitEntity().recalculatePermissions();
            this.k.aH().a(player);
        }
    }

    public boolean c(GameProfile profile) {
        return this.isWhiteListed(profile, null);
    }

    public boolean isWhiteListed(GameProfile gameprofile, PlayerLoginEvent loginEvent) {
        boolean isOp = this.p.d(gameprofile);
        boolean isWhitelisted = !this.u || isOp || this.q.d(gameprofile);
        ProfileWhitelistVerifyEvent event = new ProfileWhitelistVerifyEvent(MCUtil.toBukkit(gameprofile), this.u, isWhitelisted, isOp, SpigotConfig.whitelistMessage);
        event.callEvent();
        if (!event.isWhitelisted()) {
            if (loginEvent != null) {
                loginEvent.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, (Component)LegacyComponentSerializer.legacySection().deserialize(event.getKickMessage() == null ? SpigotConfig.whitelistMessage : event.getKickMessage()));
            }
            return false;
        }
        return true;
    }

    public boolean f(GameProfile profile) {
        return this.p.d(profile) || this.k.a(profile) && this.k.bb().m() || this.y;
    }

    @Nullable
    public EntityPlayer a(String name) {
        return this.playersByName.get(name.toLowerCase(Locale.ROOT));
    }

    public void a(@Nullable EntityHuman player, double x2, double y2, double z2, double distance, ResourceKey<net.minecraft.world.level.World> worldKey, Packet<?> packet) {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            double d6;
            double d5;
            double d4;
            EntityPlayer entityplayer = this.l.get(i2);
            if (player != null && !entityplayer.getBukkitEntity().canSee(player.getBukkitEntity()) || entityplayer == player || entityplayer.dO().af() != worldKey || !((d4 = x2 - entityplayer.dt()) * d4 + (d5 = y2 - entityplayer.dv()) * d5 + (d6 = z2 - entityplayer.dz()) * d6 < distance * distance)) continue;
            entityplayer.c.b(packet);
        }
    }

    public void h() {
        MCUtil.ensureMain("Save Players", () -> {
            MinecraftTimings.savePlayers.startTiming();
            for (int i2 = 0; i2 < this.l.size(); ++i2) {
                this.b(this.l.get(i2));
            }
            MinecraftTimings.savePlayers.stopTiming();
            return null;
        });
    }

    public WhiteList i() {
        return this.q;
    }

    public String[] j() {
        return this.q.a();
    }

    public OpList k() {
        return this.p;
    }

    public String[] l() {
        return this.p.a();
    }

    public void a() {
    }

    public void a(EntityPlayer player, WorldServer world) {
        WorldBorder worldborder = player.dO().C_();
        player.c.b(new ClientboundInitializeBorderPacket(worldborder));
        player.c.b(new PacketPlayOutUpdateTime(world.Z(), world.aa(), world.ab().b(GameRules.l)));
        player.c.b(new PacketPlayOutSpawnPosition(world.V(), world.W()));
        if (world.ad()) {
            player.setPlayerWeather(WeatherType.DOWNFALL, false);
            player.updateWeather(-world.w, world.w, -world.y, world.y);
        }
        player.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.o, 0.0f));
        this.k.aQ().a(player);
    }

    public void f(EntityPlayer player) {
        player.cc.b();
        player.getBukkitEntity().updateScaledHealth();
        player.refreshEntityData(player);
        player.c.b(new PacketPlayOutHeldItemSlot(player.fY().k));
        int i2 = player.dO().ab().b(GameRules.q) ? 22 : 23;
        player.c.b(new PacketPlayOutEntityStatus(player, (byte)i2));
        float immediateRespawn = player.dO().ab().b(GameRules.D) ? 1.0f : 0.0f;
        player.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.m, immediateRespawn));
    }

    public int m() {
        return this.l.size();
    }

    public int n() {
        return this.g;
    }

    public boolean o() {
        return this.u;
    }

    public void a(boolean whitelistEnabled) {
        new WhitelistToggleEvent(whitelistEnabled).callEvent();
        this.u = whitelistEnabled;
    }

    public List<EntityPlayer> b(String ip) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.l) {
            if (!entityplayer.B().equals(ip)) continue;
            list.add(entityplayer);
        }
        return list;
    }

    public int p() {
        return this.w;
    }

    public int q() {
        return this.x;
    }

    public MinecraftServer c() {
        return this.k;
    }

    @Nullable
    public NBTTagCompound r() {
        return null;
    }

    public void b(boolean cheatsAllowed) {
        this.y = cheatsAllowed;
    }

    public void s() {
        this.removeAll(false);
    }

    public void removeAll(boolean isRestarting) {
        ScoreboardServer scoreboard;
        ScoreboardTeam team;
        for (EntityPlayer player : this.l) {
            if (isRestarting) {
                player.c.disconnect((Component)LegacyComponentSerializer.legacySection().deserialize(SpigotConfig.restartMessage), PlayerKickEvent.Cause.UNKNOWN);
                continue;
            }
            player.c.disconnect(Objects.requireNonNullElseGet(this.k.server.shutdownMessage(), Component::empty));
        }
        if (this.collideRuleTeamName != null && (team = (scoreboard = this.c().a(net.minecraft.world.level.World.h).f()).e(this.collideRuleTeamName)) != null) {
            scoreboard.d(team);
        }
    }

    public void broadcastMessage(IChatBaseComponent[] iChatBaseComponents) {
        for (IChatBaseComponent component : iChatBaseComponents) {
            this.a(component, false);
        }
    }

    public void a(IChatBaseComponent message, boolean overlay) {
        this.a(message, (EntityPlayer entityplayer) -> message, overlay);
    }

    public void a(IChatBaseComponent message, Function<EntityPlayer, IChatBaseComponent> playerMessageFactory, boolean overlay) {
        this.k.a(message);
        for (EntityPlayer entityplayer : this.l) {
            IChatBaseComponent ichatbasecomponent1 = playerMessageFactory.apply(entityplayer);
            if (ichatbasecomponent1 == null) continue;
            entityplayer.b(ichatbasecomponent1, overlay);
        }
    }

    public void a(PlayerChatMessage message, CommandListenerWrapper source, ChatMessageType.a params) {
        Objects.requireNonNull(source);
        this.a(message, source::a, source.i(), params);
    }

    public void a(PlayerChatMessage message, EntityPlayer sender, ChatMessageType.a params) {
        this.broadcastChatMessage(message, sender, params, null);
    }

    public void broadcastChatMessage(PlayerChatMessage message, EntityPlayer sender, ChatMessageType.a params, @Nullable Function<Audience, IChatBaseComponent> unsignedFunction) {
        Objects.requireNonNull(sender);
        this.broadcastChatMessage(message, sender::c, sender, params, unsignedFunction);
    }

    private void a(PlayerChatMessage message, Predicate<EntityPlayer> shouldSendFiltered, @Nullable EntityPlayer sender, ChatMessageType.a params) {
        this.broadcastChatMessage(message, shouldSendFiltered, sender, params, null);
    }

    public void broadcastChatMessage(PlayerChatMessage message, Predicate<EntityPlayer> shouldSendFiltered, @Nullable EntityPlayer sender, ChatMessageType.a params, @Nullable Function<Audience, IChatBaseComponent> unsignedFunction) {
        boolean flag = this.a(message);
        this.k.a(unsignedFunction == null ? message.d() : unsignedFunction.apply((Audience)this.k.console), params, flag ? null : "Not Secure");
        OutgoingChatMessage outgoingchatmessage = OutgoingChatMessage.a(message);
        boolean flag1 = false;
        ClientboundDisguisedChatPacket disguised = sender != null && unsignedFunction == null ? new ClientboundDisguisedChatPacket(outgoingchatmessage.a(), params) : null;
        for (EntityPlayer entityplayer1 : this.l) {
            boolean flag2 = shouldSendFiltered.test(entityplayer1);
            if (sender != null && !entityplayer1.getBukkitEntity().canSee(sender.getBukkitEntity())) {
                entityplayer1.c.b(unsignedFunction != null ? new ClientboundDisguisedChatPacket(unsignedFunction.apply((Audience)entityplayer1.getBukkitEntity()), params) : disguised);
            } else {
                entityplayer1.sendChatMessage(outgoingchatmessage, flag2, params, unsignedFunction == null ? null : unsignedFunction.apply((Audience)entityplayer1.getBukkitEntity()));
            }
            flag1 |= flag2 && message.j();
        }
        if (flag1 && sender != null) {
            sender.a(e);
        }
    }

    public boolean a(PlayerChatMessage message) {
        return message.i() && !message.a(Instant.now());
    }

    public ServerStatisticManager getPlayerStats(EntityPlayer entityhuman) {
        ServerStatisticManager serverstatisticmanager = entityhuman.I();
        return serverstatisticmanager == null ? this.getPlayerStats(entityhuman.cz(), entityhuman.fX().getName()) : serverstatisticmanager;
    }

    public ServerStatisticManager getPlayerStats(UUID uuid, String displayName) {
        ServerStatisticManager serverstatisticmanager;
        EntityPlayer entityhuman = this.a(uuid);
        ServerStatisticManager serverStatisticManager = serverstatisticmanager = entityhuman == null ? null : entityhuman.I();
        if (serverstatisticmanager == null) {
            File file2;
            Path path;
            File file = this.k.a(SavedFile.b).toFile();
            File file1 = new File(file, String.valueOf(uuid) + ".json");
            if (!file1.exists() && FileUtils.a(path = (file2 = new File(file, displayName + ".json")).toPath()) && FileUtils.b(path) && path.startsWith(file.getPath()) && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverstatisticmanager = new ServerStatisticManager(this.k, file1);
        }
        return serverstatisticmanager;
    }

    public AdvancementDataPlayer g(EntityPlayer player) {
        UUID uuid = player.cz();
        AdvancementDataPlayer advancementdataplayer = player.R();
        if (advancementdataplayer == null) {
            Path path = this.k.a(SavedFile.a).resolve(String.valueOf(uuid) + ".json");
            advancementdataplayer = new AdvancementDataPlayer(this.k.aD(), this, this.k.aE(), path, player);
        }
        advancementdataplayer.a(player);
        return advancementdataplayer;
    }

    public void a(int viewDistance) {
        this.w = viewDistance;
        this.a(new PacketPlayOutViewDistance(viewDistance));
        for (WorldServer worldserver : this.k.K()) {
            if (worldserver == null) continue;
            worldserver.l().a(viewDistance);
        }
    }

    public void b(int simulationDistance) {
        this.x = simulationDistance;
        this.a(new ClientboundSetSimulationDistancePacket(simulationDistance));
        for (WorldServer worldserver : this.k.K()) {
            if (worldserver == null) continue;
            worldserver.l().b(simulationDistance);
        }
    }

    public List<EntityPlayer> t() {
        return this.l;
    }

    @Nullable
    public EntityPlayer a(UUID uuid) {
        return this.m.get(uuid);
    }

    public boolean d(GameProfile profile) {
        return false;
    }

    public void u() {
        this.reloadAdvancementData();
        this.reloadTagData();
        this.reloadRecipeData();
    }

    public void reloadAdvancementData() {
        for (EntityPlayer player : this.l) {
            player.R().a(this.k.aE());
            player.R().b(player);
        }
    }

    public void reloadTagData() {
        this.a(new ClientboundUpdateTagsPacket(TagNetworkSerialization.a(this.v)));
    }

    public void reloadRecipeData() {
        PacketPlayOutRecipeUpdate packetplayoutrecipeupdate = new PacketPlayOutRecipeUpdate(this.k.aJ().b());
        for (EntityPlayer entityplayer : this.l) {
            entityplayer.c.b(packetplayoutrecipeupdate);
            entityplayer.J().a(entityplayer);
        }
    }

    public boolean v() {
        return this.y;
    }
}

