/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;

@FunctionalInterface
public interface ResourceProvider {
    public static final ResourceProvider b = id -> Optional.empty();

    public Optional<IResource> getResource(MinecraftKey var1);

    default public IResource getResourceOrThrow(MinecraftKey id) throws FileNotFoundException {
        return this.getResource(id).orElseThrow(() -> new FileNotFoundException(id.toString()));
    }

    default public InputStream open(MinecraftKey id) throws IOException {
        return this.getResourceOrThrow(id).d();
    }

    default public BufferedReader openAsReader(MinecraftKey id) throws IOException {
        return this.getResourceOrThrow(id).e();
    }

    public static ResourceProvider fromMap(Map<MinecraftKey, IResource> map) {
        return id -> Optional.ofNullable((IResource)map.get(id));
    }
}

