/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataAbstract;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;

public abstract class ResourceDataJson
extends ResourceDataAbstract<Map<MinecraftKey, JsonElement>> {
    private static final Logger a = LogUtils.getLogger();
    private final Gson b;
    private final String c;

    public ResourceDataJson(Gson gson, String dataType) {
        this.b = gson;
        this.c = dataType;
    }

    @Override
    protected Map<MinecraftKey, JsonElement> a(IResourceManager resourceManager, GameProfilerFiller profilerFiller) {
        HashMap<MinecraftKey, JsonElement> map = new HashMap<MinecraftKey, JsonElement>();
        ResourceDataJson.a(resourceManager, this.c, this.b, map);
        return map;
    }

    public static void a(IResourceManager manager, String dataType, Gson gson, Map<MinecraftKey, JsonElement> results) {
        FileToIdConverter fileToIdConverter = FileToIdConverter.a(dataType);
        for (Map.Entry<MinecraftKey, IResource> entry : fileToIdConverter.a(manager).entrySet()) {
            MinecraftKey resourceLocation = entry.getKey();
            MinecraftKey resourceLocation2 = fileToIdConverter.b(resourceLocation);
            try {
                BufferedReader reader = entry.getValue().e();
                try {
                    JsonElement jsonElement = ChatDeserializer.a(gson, (Reader)reader, JsonElement.class);
                    JsonElement jsonElement2 = results.put(resourceLocation2, jsonElement);
                    if (jsonElement2 == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(resourceLocation2));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                a.error("Couldn't parse data file {} from {}", new Object[]{resourceLocation2, resourceLocation, exception});
            }
        }
    }

    @Override
    protected /* synthetic */ Object b(IResourceManager manager, GameProfilerFiller profiler) {
        return this.a(manager, profiler);
    }
}

