/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.ResourcePackAbstract;
import net.minecraft.server.packs.metadata.ResourcePackMetaParser;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.slf4j.Logger;

public class ResourcePackVanilla
implements IResourcePack {
    private static final Logger c = LogUtils.getLogger();
    private final PackLocationInfo d;
    private final BuiltInMetadata e;
    private final Set<String> f;
    private final List<Path> g;
    private final Map<EnumResourcePackType, List<Path>> h;

    ResourcePackVanilla(PackLocationInfo info, BuiltInMetadata metadata, Set<String> namespaces, List<Path> rootPaths, Map<EnumResourcePackType, List<Path>> namespacePaths) {
        this.d = info;
        this.e = metadata;
        this.f = namespaces;
        this.g = rootPaths;
        this.h = namespacePaths;
    }

    @Override
    @Nullable
    @Override
    public IoSupplier<InputStream> a(String ... segments) {
        FileUtils.a(segments);
        List<String> list = List.of(segments);
        for (Path path : this.g) {
            Path path2 = FileUtils.a(path, list);
            if (!Files.exists(path2, new LinkOption[0]) || !PathPackResources.a(path2)) continue;
            return IoSupplier.create(path2);
        }
        return null;
    }

    public void a(EnumResourcePackType type, MinecraftKey path, Consumer<Path> consumer) {
        FileUtils.d(path.a()).ifSuccess(segments -> {
            String string = path.b();
            for (Path path : this.h.get((Object)type)) {
                Path path2 = path.resolve(string);
                consumer.accept(FileUtils.a(path2, segments));
            }
        }).ifError(error -> c.error("Invalid path {}: {}", (Object)path, (Object)error.message()));
    }

    @Override
    @Override
    public void a(EnumResourcePackType type, String namespace, String prefix, IResourcePack.a consumer) {
        FileUtils.d(prefix).ifSuccess(segments -> {
            List<Path> list = this.h.get((Object)type);
            int i2 = list.size();
            if (i2 == 1) {
                ResourcePackVanilla.a(consumer, namespace, list.get(0), segments);
            } else if (i2 > 1) {
                HashMap<MinecraftKey, IoSupplier<InputStream>> map = new HashMap<MinecraftKey, IoSupplier<InputStream>>();
                for (int j2 = 0; j2 < i2 - 1; ++j2) {
                    ResourcePackVanilla.a(map::putIfAbsent, namespace, list.get(j2), segments);
                }
                Path path = list.get(i2 - 1);
                if (map.isEmpty()) {
                    ResourcePackVanilla.a(consumer, namespace, path, segments);
                } else {
                    ResourcePackVanilla.a(map::putIfAbsent, namespace, path, segments);
                    map.forEach(consumer);
                }
            }
        }).ifError(error -> c.error("Invalid path {}: {}", (Object)prefix, (Object)error.message()));
    }

    private static void a(IResourcePack.a consumer, String namespace, Path root, List<String> prefixSegments) {
        Path path = root.resolve(namespace);
        PathPackResources.a(namespace, path, prefixSegments, consumer);
    }

    @Override
    @Nullable
    @Override
    public IoSupplier<InputStream> a(EnumResourcePackType type, MinecraftKey id) {
        return (IoSupplier)FileUtils.d(id.a()).mapOrElse(segments -> {
            String string = id.b();
            for (Path path : this.h.get((Object)type)) {
                Path path2 = FileUtils.a(path.resolve(string), segments);
                if (!Files.exists(path2, new LinkOption[0]) || !PathPackResources.a(path2)) continue;
                return IoSupplier.create(path2);
            }
            return null;
        }, error -> {
            c.error("Invalid path {}: {}", (Object)id, (Object)error.message());
            return null;
        });
    }

    @Override
    @Override
    public Set<String> a(EnumResourcePackType type) {
        return this.f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    @Override
    public <T> T a(ResourcePackMetaParser<T> metaReader) {
        IoSupplier<InputStream> ioSupplier = this.a("pack.mcmeta");
        if (ioSupplier == null) return this.e.a(metaReader);
        try (InputStream inputStream = ioSupplier.get();){
            T object = ResourcePackAbstract.a(metaReader, inputStream);
            if (object == null) return this.e.a(metaReader);
            T t2 = object;
            return t2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.e.a(metaReader);
    }

    @Override
    @Override
    public PackLocationInfo a() {
        return this.d;
    }

    @Override
    @Override
    public void close() {
    }

    public ResourceProvider d() {
        return id -> Optional.ofNullable(this.a(EnumResourcePackType.a, id)).map(stream -> new IResource(this, (IoSupplier<InputStream>)stream));
    }
}

