/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBisected;
import net.minecraft.world.item.ItemDebugStick;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockCake;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.slf4j.Logger;

public class PlayerInteractManager {
    private static final Logger a = LogUtils.getLogger();
    public WorldServer c;
    protected final EntityPlayer d;
    private EnumGamemode b = EnumGamemode.e;
    @Nullable
    private EnumGamemode e;
    private boolean f;
    private int g;
    private BlockPosition h = BlockPosition.c;
    private int i;
    private boolean j;
    private BlockPosition k = BlockPosition.c;
    private int l;
    private int m = -1;
    public boolean captureSentBlockEntities = false;
    public boolean capturedBlockEntity = false;
    public boolean interactResult = false;
    public boolean firedInteract = false;
    public BlockPosition interactPosition;
    public EnumHand interactHand;
    public ItemStack interactItemStack;

    public PlayerInteractManager(EntityPlayer player) {
        this.d = player;
        this.c = player.A();
    }

    public boolean a(EnumGamemode gameMode) {
        PlayerGameModeChangeEvent event = this.changeGameModeForPlayer(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event != null && event.isCancelled();
    }

    @Nullable
    public PlayerGameModeChangeEvent changeGameModeForPlayer(EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause, @Nullable Component cancelMessage) {
        if (gameMode == this.b) {
            return null;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this.d.getBukkitEntity(), GameMode.getByValue((int)gameMode.a()), cause, cancelMessage);
        this.c.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.a(gameMode, this.b);
        this.d.z();
        this.d.d.ah().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.c, this.d), this.d);
        this.c.e();
        if (gameMode == EnumGamemode.b) {
            this.d.gC();
        }
        return event;
    }

    protected void a(EnumGamemode gameMode, @Nullable EnumGamemode previousGameMode) {
        this.e = previousGameMode;
        this.b = gameMode;
        gameMode.a(this.d.fZ());
    }

    public EnumGamemode b() {
        return this.b;
    }

    @Nullable
    public EnumGamemode c() {
        return this.e;
    }

    public boolean d() {
        return this.b.h();
    }

    public boolean e() {
        return this.b.g();
    }

    public void a() {
        this.i = MinecraftServer.currentTick;
        if (this.j) {
            IBlockData iblockdata = this.c.getBlockStateIfLoaded(this.k);
            if (iblockdata == null || iblockdata.i()) {
                this.j = false;
            } else {
                float f2 = this.a(iblockdata, this.k, this.l);
                if (f2 >= 1.0f) {
                    this.j = false;
                    this.a(this.k);
                }
            }
        } else if (this.f) {
            IBlockData iblockdata = this.c.getBlockStateIfLoaded(this.h);
            if (iblockdata == null) {
                this.f = false;
                return;
            }
            if (iblockdata.i()) {
                this.c.a(this.d.an(), this.h, -1);
                this.m = -1;
                this.f = false;
            } else {
                this.a(iblockdata, this.h, this.g);
            }
        }
    }

    private float a(IBlockData state, BlockPosition pos, int failedStartMiningTime) {
        int j2 = this.i - failedStartMiningTime;
        float f2 = state.a(this.d, this.d.dO(), pos) * (float)(j2 + 1);
        int k2 = (int)(f2 * 10.0f);
        if (k2 != this.m) {
            this.c.a(this.d.an(), pos, k2);
            this.m = k2;
        }
        return f2;
    }

    private void a(BlockPosition pos, boolean success, int sequence, String reason) {
    }

    public void a(BlockPosition pos, PacketPlayInBlockDig.EnumPlayerDigType action, EnumDirection direction, int worldHeight, int sequence) {
        if (!this.d.a(pos, 1.0)) {
            return;
        }
        if (pos.v() >= worldHeight) {
            this.d.c.b(new PacketPlayOutBlockChange(pos, this.c.a_(pos)));
            this.a(pos, false, sequence, "too high");
        } else if (action == PacketPlayInBlockDig.EnumPlayerDigType.a) {
            if (!this.c.a((EntityHuman)this.d, pos)) {
                CraftEventFactory.callPlayerInteractEvent(this.d, Action.LEFT_CLICK_BLOCK, pos, direction, this.d.fY().f(), EnumHand.a);
                this.d.c.b(new PacketPlayOutBlockChange(pos, this.c.a_(pos)));
                this.a(pos, false, sequence, "may not interact");
                this.capturedBlockEntity = true;
                return;
            }
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.d, Action.LEFT_CLICK_BLOCK, pos, direction, this.d.fY().f(), EnumHand.a);
            if (event.isCancelled()) {
                this.capturedBlockEntity = true;
                return;
            }
            if (this.e()) {
                this.a(pos, sequence, "creative destroy");
                return;
            }
            if (this.d.eT().a(Items.vx) && ((ItemDebugStick)Items.vx).a(this.d, this.c.a_(pos), this.c, pos, false, this.d.eT())) {
                return;
            }
            if (this.d.a((World)this.c, pos, this.b)) {
                this.d.c.b(new PacketPlayOutBlockChange(pos, this.c.a_(pos)));
                this.a(pos, false, sequence, "block action restricted");
                return;
            }
            this.g = this.i;
            float f2 = 1.0f;
            IBlockData iblockdata = this.c.a_(pos);
            if (event.useInteractedBlock() != Event.Result.DENY && !iblockdata.i()) {
                EnchantmentManager.a(this.c, this.d.eT(), this.d, this.d, EnumItemSlot.a, Vec3D.b(pos), iblockdata, item -> this.d.a((Item)item, EnumItemSlot.a));
                iblockdata.a((World)this.c, pos, this.d);
                f2 = iblockdata.a(this.d, this.d.dO(), pos);
            }
            if (event.useItemInHand() == Event.Result.DENY) {
                if (f2 > 1.0f) {
                    // empty if block
                }
                return;
            }
            BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent(this.d, pos, direction, this.d.fY().f(), f2 >= 1.0f);
            if (blockEvent.isCancelled()) {
                return;
            }
            if (blockEvent.getInstaBreak()) {
                f2 = 2.0f;
            }
            if (!iblockdata.i() && f2 >= 1.0f) {
                this.a(pos, sequence, "insta mine");
            } else {
                if (this.f) {
                    this.d.c.b(new PacketPlayOutBlockChange(this.h, this.c.a_(this.h)));
                    this.a(pos, false, sequence, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.f = true;
                this.h = pos.j();
                int k2 = (int)(f2 * 10.0f);
                this.c.a(this.d.an(), pos, k2);
                this.a(pos, true, sequence, "actual start of destroying");
                this.m = k2;
            }
        } else if (action == PacketPlayInBlockDig.EnumPlayerDigType.c) {
            if (pos.equals(this.h)) {
                int l2 = this.i - this.g;
                IBlockData iblockdata = this.c.a_(pos);
                if (!iblockdata.i()) {
                    float f1 = iblockdata.a(this.d, this.d.dO(), pos) * (float)(l2 + 1);
                    if (f1 >= 0.7f) {
                        this.f = false;
                        this.c.a(this.d.an(), pos, -1);
                        this.a(pos, sequence, "destroyed");
                        return;
                    }
                    if (!this.j) {
                        this.f = false;
                        this.j = true;
                        this.k = pos;
                        this.l = this.g;
                    }
                }
            }
            this.a(pos, true, sequence, "stopped destroying");
        } else if (action == PacketPlayInBlockDig.EnumPlayerDigType.b) {
            this.f = false;
            if (!Objects.equals(this.h, pos) && !BlockPosition.c.equals(this.h)) {
                a.debug("Mismatch in destroy block pos: {} {}", (Object)this.h, (Object)pos);
                IBlockData type = this.c.getBlockStateIfLoaded(this.h);
                if (type != null) {
                    this.c.a(this.d.an(), this.h, -1);
                }
                if (type != null) {
                    this.a(pos, true, sequence, "aborted mismatched destroying");
                }
                this.h = BlockPosition.c;
            }
            this.c.a(this.d.an(), pos, -1);
            this.a(pos, true, sequence, "aborted destroying");
            CraftEventFactory.callBlockDamageAbortEvent(this.d, pos, this.d.fY().f());
        }
        this.c.chunkPacketBlockController.onPlayerLeftClickBlock(this, pos, action, direction, worldHeight, sequence);
    }

    public void a(BlockPosition pos, int sequence, String reason) {
        if (this.a(pos)) {
            this.a(pos, true, sequence, reason);
        } else {
            this.d.c.b(new PacketPlayOutBlockChange(pos, this.c.a_(pos)));
            this.a(pos, false, sequence, reason);
        }
    }

    public boolean a(BlockPosition pos) {
        IBlockData iblockdata = this.c.a_(pos);
        CraftBlock bblock = CraftBlock.at(this.c, pos);
        BlockBreakEvent event = null;
        if (this.d instanceof EntityPlayer) {
            boolean isSwordNoBreak = !this.d.eT().g().a(iblockdata, (World)this.c, pos, (EntityHuman)this.d);
            event = new BlockBreakEvent((org.bukkit.block.Block)bblock, (Player)this.d.getBukkitEntity());
            event.setCancelled(isSwordNoBreak);
            IBlockData nmsData = this.c.a_(pos);
            Block nmsBlock = nmsData.b();
            ItemStack itemstack = this.d.a(EnumItemSlot.a);
            if (nmsBlock != null && !event.isCancelled() && !this.e() && this.d.d(nmsBlock.o())) {
                event.setExpToDrop(nmsBlock.getExpDrop(nmsData, this.c, pos, itemstack, true));
            }
            this.c.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                if (isSwordNoBreak) {
                    return false;
                }
                if (!this.captureSentBlockEntities) {
                    TileEntity tileentity = this.c.c_(pos);
                    if (tileentity != null) {
                        this.d.c.b(tileentity.az_());
                    }
                } else {
                    this.capturedBlockEntity = true;
                }
                return false;
            }
        }
        if ((iblockdata = this.c.a_(pos)).i()) {
            return false;
        }
        TileEntity tileentity = this.c.c_(pos);
        Block block = iblockdata.b();
        if (!(!(block instanceof GameMasterBlock) || this.d.gv() || block instanceof BlockCommand && this.d.f() && this.d.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.c.a(pos, iblockdata, iblockdata, 3);
            return false;
        }
        if (this.d.a((World)this.c, pos, this.b)) {
            return false;
        }
        BlockState state = bblock.getState();
        this.c.captureDrops = new ArrayList<EntityItem>();
        IBlockData iblockdata1 = block.a((World)this.c, pos, iblockdata, this.d);
        boolean flag = this.c.a(pos, false);
        if (flag) {
            block.a((GeneratorAccess)this.c, pos, iblockdata1);
        }
        ItemStack mainHandStack = null;
        boolean isCorrectTool = false;
        if (!this.e()) {
            ItemStack itemstack = this.d.eT();
            ItemStack itemstack1 = itemstack.s();
            boolean flag1 = this.d.d(iblockdata1);
            mainHandStack = itemstack1;
            isCorrectTool = flag1;
            itemstack.a((World)this.c, iblockdata1, pos, this.d);
            if (flag && flag1) {
                block.playerDestroy(this.c, this.d, pos, iblockdata1, tileentity, itemstack1, event.isDropItems(), false);
            }
        }
        List<EntityItem> itemsToDrop = this.c.captureDrops;
        this.c.captureDrops = null;
        if (event.isDropItems()) {
            CraftEventFactory.handleBlockDropItemEvent(bblock, state, this.d, itemsToDrop);
        }
        if (flag && event != null) {
            iblockdata.b().popExperience(this.c, pos, event.getExpToDrop(), this.d);
        }
        if (mainHandStack != null && flag && isCorrectTool && event.isDropItems() && block instanceof BlockBeehive && tileentity instanceof TileEntityBeehive) {
            TileEntityBeehive beehiveBlockEntity = (TileEntityBeehive)tileentity;
            CriterionTriggers.L.a(this.d, iblockdata, mainHandStack, beehiveBlockEntity.f());
        }
        return true;
    }

    public EnumInteractionResult a(EntityPlayer player, World world, ItemStack stack, EnumHand hand) {
        if (this.b == EnumGamemode.d) {
            return EnumInteractionResult.e;
        }
        if (player.gt().a(stack.g())) {
            return EnumInteractionResult.e;
        }
        int i2 = stack.H();
        int j2 = stack.n();
        InteractionResultWrapper<ItemStack> interactionresultwrapper = stack.a(world, (EntityHuman)player, hand);
        ItemStack itemstack1 = interactionresultwrapper.b();
        if (itemstack1 == stack && itemstack1.H() == i2 && itemstack1.a(player) <= 0 && itemstack1.n() == j2) {
            return interactionresultwrapper.a();
        }
        if (interactionresultwrapper.a() == EnumInteractionResult.f && itemstack1.a(player) > 0 && !player.fr()) {
            return interactionresultwrapper.a();
        }
        if (stack != itemstack1) {
            player.a(hand, itemstack1);
        }
        if (itemstack1.e()) {
            player.a(hand, ItemStack.l);
        }
        if (!player.fr()) {
            player.cc.b();
        }
        return interactionresultwrapper.a();
    }

    public EnumInteractionResult a(EntityPlayer player, World world, ItemStack stack, EnumHand hand, MovingObjectPositionBlock hitResult) {
        EnumInteractionResult enuminteractionresult;
        BlockPosition blockposition = hitResult.a();
        IBlockData iblockdata = world.a_(blockposition);
        boolean cancelledBlock = false;
        boolean cancelledItem = false;
        if (!iblockdata.b().a(world.J())) {
            return EnumInteractionResult.f;
        }
        if (this.b == EnumGamemode.d) {
            ITileInventory itileinventory = iblockdata.b(world, blockposition);
            boolean bl = cancelledBlock = !(itileinventory instanceof ITileInventory);
        }
        if (player.gt().a(stack.g())) {
            cancelledItem = true;
        }
        PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(player, Action.RIGHT_CLICK_BLOCK, blockposition, hitResult.b(), stack, cancelledBlock, cancelledItem, hand, hitResult.e());
        this.firedInteract = true;
        this.interactResult = event.useItemInHand() == Event.Result.DENY;
        this.interactPosition = blockposition.j();
        this.interactHand = hand;
        this.interactItemStack = stack.s();
        if (event.useInteractedBlock() == Event.Result.DENY) {
            if (!(iblockdata.b() instanceof BlockDoor)) {
                if (iblockdata.b() instanceof BlockCake) {
                    player.getBukkitEntity().sendHealthUpdate();
                } else if (!(this.interactItemStack.g() instanceof ItemBisected) && (iblockdata.a(Blocks.pb) || iblockdata.a(Blocks.pa) || iblockdata.b() instanceof BlockCommand)) {
                    player.c.b(new PacketPlayOutCloseWindow(this.d.cd.j));
                }
            }
            player.getBukkitEntity().updateInventory();
            this.d.resyncUsingItem(this.d);
            return event.useItemInHand() != Event.Result.ALLOW ? EnumInteractionResult.a : EnumInteractionResult.e;
        }
        if (this.b == EnumGamemode.d) {
            ITileInventory itileinventory = iblockdata.b(world, blockposition);
            if (itileinventory != null) {
                player.a(itileinventory);
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.e;
        }
        boolean flag = !player.eT().e() || !player.eU().e();
        boolean flag1 = player.fN() && flag;
        ItemStack itemstack1 = stack.s();
        if (!flag1) {
            ItemInteractionResult iteminteractionresult = iblockdata.a(player.b(hand), world, player, hand, hitResult);
            if (iteminteractionresult.a()) {
                CriterionTriggers.N.a(player, blockposition, itemstack1);
                return iteminteractionresult.b();
            }
            if (iteminteractionresult == ItemInteractionResult.d && hand == EnumHand.a && (enuminteractionresult = iblockdata.a(world, player, hitResult)).a()) {
                CriterionTriggers.O.a(player, blockposition);
                return enuminteractionresult;
            }
        }
        if (!stack.e() && !this.interactResult) {
            ItemActionContext itemactioncontext = new ItemActionContext(player, hand, hitResult);
            if (this.e()) {
                int i2 = stack.H();
                enuminteractionresult = stack.a(itemactioncontext);
                stack.e(i2);
            } else {
                enuminteractionresult = stack.a(itemactioncontext);
            }
            if (enuminteractionresult.a()) {
                CriterionTriggers.N.a(player, blockposition, itemstack1);
            }
            return enuminteractionresult;
        }
        if (this.interactResult && this.interactResult != cancelledItem) {
            this.d.resyncUsingItem(this.d);
        }
        return EnumInteractionResult.e;
    }

    public void a(WorldServer world) {
        this.c = world;
    }
}

