/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemServerChunkCache;
import co.aikar.timings.Timing;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.maplist.IteratorSafeOrderedReferenceSet;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.util.MathHelper;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.slf4j.Logger;

public class ChunkProviderServer
extends IChunkProvider
implements ChunkSystemServerChunkCache {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final List<ChunkStatus> b = ChunkStatus.a();
    private final ChunkMapDistance c;
    final WorldServer d;
    public final Thread e;
    final LightEngineThreaded f;
    public final b g;
    public final PlayerChunkMap a;
    private final WorldPersistentData h;
    private long i;
    public boolean j = true;
    public boolean k = true;
    private static final int l = 4;
    private final long[] m = new long[4];
    private final ChunkStatus[] n = new ChunkStatus[4];
    private final IChunkAccess[] o = new IChunkAccess[4];
    @Nullable
    @VisibleForDebug
    private SpawnerCreature.d p;
    public final IteratorSafeOrderedReferenceSet<Chunk> tickingChunks = new IteratorSafeOrderedReferenceSet(4096, 0.75f, 4096, 0.15, true);
    public final IteratorSafeOrderedReferenceSet<Chunk> entityTickingChunks = new IteratorSafeOrderedReferenceSet(4096, 0.75f, 4096, 0.15, true);
    private final ConcurrentLong2ReferenceChainedHashTable<Chunk> fullChunks = new ConcurrentLong2ReferenceChainedHashTable();
    long chunkFutureAwaitCounter;

    @Override
    public final void moonrise$setFullChunk(int chunkX, int chunkZ, Chunk chunk) {
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (chunk == null) {
            this.fullChunks.remove(key);
        } else {
            this.fullChunks.put(key, chunk);
        }
    }

    @Override
    public final Chunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return this.fullChunks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    private IChunkAccess syncLoad(int chunkX, int chunkZ, ChunkStatus toStatus) {
        IChunkAccess ret;
        ChunkTaskScheduler chunkTaskScheduler = this.d.moonrise$getChunkTaskScheduler();
        CompletableFuture completable = new CompletableFuture();
        chunkTaskScheduler.scheduleChunkLoad(chunkX, chunkZ, toStatus, true, PrioritisedExecutor.Priority.BLOCKING, completable::complete);
        if (TickThread.isTickThreadFor(this.d, chunkX, chunkZ)) {
            ChunkTaskScheduler.pushChunkWait(this.d, chunkX, chunkZ);
            this.g.b(completable::isDone);
            ChunkTaskScheduler.popChunkWait();
        }
        if ((ret = (IChunkAccess)completable.join()) == null) {
            throw new IllegalStateException("Chunk not loaded when requested");
        }
        return ret;
    }

    private IChunkAccess getChunkFallback(int chunkX, int chunkZ, ChunkStatus toStatus, boolean load) {
        IChunkAccess ifPresent;
        ChunkTaskScheduler chunkTaskScheduler = this.d.moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        NewChunkHolder currentChunk = chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        IChunkAccess iChunkAccess = ifPresent = currentChunk == null ? null : currentChunk.getChunkIfPresent(toStatus);
        if (ifPresent != null && (toStatus != ChunkStatus.n || currentChunk.isFullChunkReady())) {
            return ifPresent;
        }
        return load ? this.syncLoad(chunkX, chunkZ, toStatus) : null;
    }

    public ChunkProviderServer(WorldServer world, Convertable.ConversionSession session, DataFixer dataFixer, StructureTemplateManager structureTemplateManager, Executor workerExecutor, ChunkGenerator chunkGenerator, int viewDistance, int simulationDistance, boolean dsync, WorldLoadListener worldGenerationProgressListener, ChunkStatusUpdateListener chunkStatusChangeListener, Supplier<WorldPersistentData> persistentStateManagerFactory) {
        this.d = world;
        this.g = new b(world);
        this.e = Thread.currentThread();
        File file = session.a(world.af()).resolve("data").toFile();
        file.mkdirs();
        this.h = new WorldPersistentData(file, dataFixer, world.H_());
        this.a = new PlayerChunkMap(world, session, dataFixer, structureTemplateManager, workerExecutor, this.g, this, chunkGenerator, worldGenerationProgressListener, chunkStatusChangeListener, persistentStateManagerFactory, viewDistance, dsync);
        this.f = this.a.d();
        this.c = this.a.j();
        this.c.b(simulationDistance);
        this.r();
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        PlayerChunk chunk = this.a.a(ChunkCoordIntPair.c(chunkX, chunkZ));
        if (chunk == null) {
            return false;
        }
        return chunk.getFullChunkNow() != null;
    }

    @Nullable
    public IChunkAccess getChunkAtImmediately(int x2, int z2) {
        PlayerChunk holder = this.a.b(ChunkCoordIntPair.c(x2, z2));
        if (holder == null) {
            return null;
        }
        return holder.p();
    }

    public <T> void addTicketAtLevel(TicketType<T> ticketType, ChunkCoordIntPair chunkPos, int ticketLevel, T identifier) {
        this.c.a(ticketType, chunkPos, ticketLevel, identifier);
    }

    public <T> void removeTicketAtLevel(TicketType<T> ticketType, ChunkCoordIntPair chunkPos, int ticketLevel, T identifier) {
        this.c.b(ticketType, chunkPos, ticketLevel, identifier);
    }

    @Nullable
    public Chunk getChunkAtIfCachedImmediately(int x2, int z2) {
        long k2 = ChunkCoordIntPair.c(x2, z2);
        PlayerChunk playerChunk = this.b(k2);
        if (playerChunk == null) {
            return null;
        }
        return playerChunk.getFullChunkNowUnchecked();
    }

    @Nullable
    public Chunk getChunkAtIfLoadedImmediately(int x2, int z2) {
        return this.fullChunks.get(ChunkCoordIntPair.c(x2, z2));
    }

    public LightEngineThreaded a() {
        return this.f;
    }

    @Nullable
    private PlayerChunk b(long pos) {
        return this.a.b(pos);
    }

    public int b() {
        return this.a.h();
    }

    private void a(long pos, @Nullable IChunkAccess chunk, ChunkStatus status) {
        for (int j2 = 3; j2 > 0; --j2) {
            this.m[j2] = this.m[j2 - 1];
            this.n[j2] = this.n[j2 - 1];
            this.o[j2] = this.o[j2 - 1];
        }
        this.m[0] = pos;
        this.n[0] = status;
        this.o[0] = chunk;
    }

    @Override
    @Nullable
    public IChunkAccess a(int x2, int z2, ChunkStatus leastStatus, boolean create) {
        if (leastStatus == ChunkStatus.n) {
            Chunk ret = this.fullChunks.get(CoordinateUtils.getChunkKey(x2, z2));
            if (ret != null) {
                return ret;
            }
            return create ? this.getChunkFallback(x2, z2, leastStatus, create) : null;
        }
        return this.getChunkFallback(x2, z2, leastStatus, create);
    }

    @Override
    @Nullable
    public Chunk a(int chunkX, int chunkZ) {
        return this.d.moonrise$getFullChunkIfLoaded(chunkX, chunkZ);
    }

    private void r() {
        Arrays.fill(this.m, ChunkCoordIntPair.a);
        Arrays.fill(this.n, null);
        Arrays.fill(this.o, null);
    }

    public CompletableFuture<ChunkResult<IChunkAccess>> b(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        CompletionStage<ChunkResult<IChunkAccess>> completablefuture;
        boolean flag1;
        boolean bl = flag1 = Thread.currentThread() == this.e;
        if (flag1) {
            completablefuture = this.c(chunkX, chunkZ, leastStatus, create);
            b chunkproviderserver_b = this.g;
            Objects.requireNonNull(completablefuture);
            chunkproviderserver_b.b(() -> completablefuture.isDone());
        } else {
            completablefuture = CompletableFuture.supplyAsync(() -> this.c(chunkX, chunkZ, leastStatus, create), this.g).thenCompose(completablefuture1 -> completablefuture1);
        }
        return completablefuture;
    }

    private CompletableFuture<ChunkResult<IChunkAccess>> c(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        IChunkAccess ifPresent;
        boolean needsFullScheduling;
        TickThread.ensureTickThread(this.d, chunkX, chunkZ, "Scheduling chunk load off-main");
        int minLevel = ChunkLevel.a(leastStatus);
        NewChunkHolder chunkHolder = this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        boolean bl = needsFullScheduling = leastStatus == ChunkStatus.n && (chunkHolder == null || !chunkHolder.getChunkStatus().a(FullChunkStatus.b));
        if ((chunkHolder == null || chunkHolder.getTicketLevel() > minLevel || needsFullScheduling) && !create) {
            return GenerationChunkHolder.c;
        }
        IChunkAccess iChunkAccess = ifPresent = chunkHolder == null ? null : chunkHolder.getChunkIfPresent(leastStatus);
        if (needsFullScheduling || ifPresent == null) {
            CompletableFuture<ChunkResult<IChunkAccess>> ret = new CompletableFuture<ChunkResult<IChunkAccess>>();
            Consumer<IChunkAccess> complete = chunk -> {
                if (chunk == null) {
                    ret.complete(GenerationChunkHolder.b);
                } else {
                    ret.complete(ChunkResult.a(chunk));
                }
            };
            this.d.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, leastStatus, true, PrioritisedExecutor.Priority.HIGHER, complete);
            return ret;
        }
        return CompletableFuture.completedFuture(ChunkResult.a(ifPresent));
    }

    @Override
    public boolean b(int x2, int z2) {
        return this.a(x2, z2) != null;
    }

    @Override
    @Nullable
    public LightChunk c(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(ChunkStatus.k.c());
    }

    public World c() {
        return this.d;
    }

    public boolean d() {
        return this.g.B();
    }

    public boolean s() {
        return this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.processTicketUpdates();
    }

    public boolean isPositionTicking(Entity entity) {
        return this.a(ChunkCoordIntPair.c(MathHelper.a(entity.dt()) >> 4, MathHelper.a(entity.dz()) >> 4));
    }

    public boolean a(long pos) {
        NewChunkHolder newChunkHolder = this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos);
        return newChunkHolder != null && newChunkHolder.isTickingReady();
    }

    public void a(boolean flush) {
        try (Timing timed = this.d.timings.chunkSaveData.startTiming();){
            this.a.a(flush);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.close(save, true);
    }

    public void purgeUnload() {
        this.d.ag().a("purge");
        this.c.a();
        this.s();
        this.d.ag().b("unload");
        this.a.a(() -> true);
        this.d.ag().c();
        this.r();
    }

    @Override
    public void a(BooleanSupplier shouldKeepTicking, boolean tickChunks) {
        this.d.ag().a("purge");
        this.d.timings.doChunkMap.startTiming();
        if (this.d.s().i() || !tickChunks || this.d.spigotConfig.unloadFrozenChunks) {
            this.c.a();
        }
        this.s();
        this.d.timings.doChunkMap.stopTiming();
        this.d.ag().b("chunks");
        if (tickChunks) {
            this.d.timings.chunks.startTiming();
            this.d.moonrise$getPlayerChunkLoader().tick();
            this.t();
            this.d.timings.chunks.stopTiming();
            this.a.l();
        }
        this.d.timings.doChunkUnload.startTiming();
        this.d.ag().b("unload");
        this.a.a(shouldKeepTicking);
        this.d.timings.doChunkUnload.stopTiming();
        this.d.ag().c();
        this.r();
    }

    private void t() {
        long i2 = this.d.Z();
        long j2 = i2 - this.i;
        this.i = i2;
        if (!this.d.ai()) {
            GameProfilerFiller gameprofilerfiller = this.d.ag();
            gameprofilerfiller.a("pollingChunks");
            gameprofilerfiller.a("filteringLoadedChunks");
            ArrayList list = Lists.newArrayListWithCapacity((int)this.a.i());
            Iterator<PlayerChunk> iterator = this.a.k().iterator();
            if (this.d.o().aQ().i()) {
                this.d.timings.chunkTicks.startTiming();
            }
            while (iterator.hasNext()) {
                PlayerChunk playerchunk = iterator.next();
                Chunk chunk = playerchunk.d();
                if (chunk == null) continue;
                list.add(new a(chunk, playerchunk));
            }
            if (this.d.s().i()) {
                SpawnerCreature.d spawnercreature_d;
                int k2;
                gameprofilerfiller.b("naturalSpawnCount");
                this.d.timings.countNaturalMobs.startTiming();
                int naturalSpawnChunkCount = k2 = this.c.b();
                if ((this.k || this.j) && this.d.paperConfig().entities.spawning.perPlayerMobSpawns) {
                    for (EntityPlayer player : this.d.H) {
                        for (int ii = 0; ii < EntityPlayer.MOBCATEGORY_TOTAL_ENUMS; ++ii) {
                            player.mobCounts[ii] = 0;
                            int newBackoff = player.mobBackoffCounts[ii] - 1;
                            if (newBackoff < 0) {
                                newBackoff = 0;
                            }
                            player.mobBackoffCounts[ii] = newBackoff;
                        }
                    }
                    spawnercreature_d = SpawnerCreature.createState(naturalSpawnChunkCount, this.d.A(), this::a, null, true);
                } else {
                    spawnercreature_d = SpawnerCreature.createState(naturalSpawnChunkCount, this.d.A(), this::a, !this.d.paperConfig().entities.spawning.perPlayerMobSpawns ? new LocalMobCapCalculator(this.a) : null, false);
                }
                this.d.timings.countNaturalMobs.stopTiming();
                this.p = spawnercreature_d;
                gameprofilerfiller.b("spawnAndTick");
                boolean flag = this.d.ab().b(GameRules.e) && !this.d.x().isEmpty();
                SystemUtils.c(list, this.d.z);
                int chunkRange = this.d.spigotConfig.mobSpawnRange;
                chunkRange = chunkRange > this.d.spigotConfig.viewDistance ? (int)this.d.spigotConfig.viewDistance : chunkRange;
                chunkRange = Math.min(chunkRange, 8);
                for (EntityPlayer entityPlayer : this.d.x()) {
                    entityPlayer.playerNaturallySpawnedEvent = new PlayerNaturallySpawnCreaturesEvent((Player)entityPlayer.getBukkitEntity(), (byte)chunkRange);
                    entityPlayer.playerNaturallySpawnedEvent.callEvent();
                }
                int l2 = this.d.ab().c(GameRules.o);
                boolean flag1 = this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) != 0L && this.d.A_().c() % this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) == 0L;
                for (a chunkproviderserver_a : list) {
                    Chunk chunk1 = chunkproviderserver_a.a;
                    ChunkCoordIntPair chunkcoordintpair = chunk1.f();
                    if (!this.d.a(chunkcoordintpair) || !this.a.b(chunkcoordintpair)) continue;
                    chunk1.a(j2);
                    if (flag && (this.j || this.k) && this.d.C_().a(chunkcoordintpair) && this.a.anyPlayerCloseEnoughForSpawning(chunkcoordintpair, true)) {
                        SpawnerCreature.a(this.d, chunk1, spawnercreature_d, this.k, this.j, flag1);
                    }
                    if (!this.d.a(chunkcoordintpair.a())) continue;
                    this.d.a(chunk1, l2);
                }
                this.d.timings.chunkTicks.stopTiming();
                gameprofilerfiller.b("customSpawners");
                if (flag) {
                    try (Timing ignored = this.d.timings.miscMobSpawning.startTiming();){
                        this.d.a(this.j, this.k);
                    }
                }
            }
            gameprofilerfiller.b("broadcast");
            list.forEach(chunkproviderserver_a1 -> {
                this.d.timings.broadcastChunkUpdates.startTiming();
                chunkproviderserver_a1.b.a(chunkproviderserver_a1.a);
                this.d.timings.broadcastChunkUpdates.stopTiming();
            });
            gameprofilerfiller.c();
            gameprofilerfiller.c();
        }
    }

    private void a(long pos, Consumer<Chunk> chunkConsumer) {
        Chunk fullChunk = this.a(CoordinateUtils.getChunkX(pos), CoordinateUtils.getChunkZ(pos));
        if (fullChunk != null) {
            chunkConsumer.accept(fullChunk);
        }
    }

    @Override
    public String e() {
        return Integer.toString(this.j());
    }

    @VisibleForTesting
    public int f() {
        return this.g.by();
    }

    public ChunkGenerator g() {
        return this.a.a();
    }

    public ChunkGeneratorStructureState h() {
        return this.a.b();
    }

    public RandomState i() {
        return this.a.c();
    }

    @Override
    public int j() {
        return this.a.i();
    }

    public void a(BlockPosition pos) {
        int j2;
        int i2 = SectionPosition.a(pos.u());
        PlayerChunk playerchunk = this.b(ChunkCoordIntPair.c(i2, j2 = SectionPosition.a(pos.w())));
        if (playerchunk != null) {
            playerchunk.a(pos);
        }
    }

    @Override
    public void a(EnumSkyBlock type, SectionPosition pos) {
        this.g.execute(() -> {
            PlayerChunk playerchunk = this.b(pos.r().a());
            if (playerchunk != null) {
                playerchunk.a(type, pos.b());
            }
        });
    }

    public <T> void a(TicketType<T> ticketType, ChunkCoordIntPair pos, int radius, T argument) {
        this.c.c(ticketType, pos, radius, argument);
    }

    public <T> void b(TicketType<T> ticketType, ChunkCoordIntPair pos, int radius, T argument) {
        this.c.d(ticketType, pos, radius, argument);
    }

    @Override
    public void a(ChunkCoordIntPair pos, boolean forced) {
        this.c.a(pos, forced);
    }

    public void a(EntityPlayer player) {
        if (!player.dJ()) {
            this.a.a(player);
        }
    }

    public void a(Entity entity) {
        this.a.b(entity);
    }

    public void b(Entity entity) {
        this.a.a(entity);
    }

    public void a(Entity entity, Packet<?> packet) {
        this.a.b(entity, packet);
    }

    public void b(Entity entity, Packet<?> packet) {
        this.a.a(entity, packet);
    }

    public void a(int watchDistance) {
        this.a.a(watchDistance);
    }

    public void setSendViewDistance(int viewDistance) {
        this.d.moonrise$getPlayerChunkLoader().setSendDistance(viewDistance);
    }

    public void b(int simulationDistance) {
        this.c.b(simulationDistance);
    }

    @Override
    public void a(boolean spawnMonsters, boolean spawnAnimals) {
        this.j = spawnMonsters;
        this.k = spawnAnimals;
    }

    public String a(ChunkCoordIntPair pos) {
        return this.a.a(pos);
    }

    public WorldPersistentData k() {
        return this.h;
    }

    public VillagePlace l() {
        return this.a.m();
    }

    public ChunkScanAccess m() {
        return this.a.p();
    }

    @Nullable
    @VisibleForDebug
    public SpawnerCreature.d n() {
        return this.p;
    }

    public void o() {
        this.c.e();
    }

    public final class b
    extends IAsyncTaskHandler<Runnable> {
        b(World world) {
            super("Chunk source main thread executor for " + String.valueOf(world.af().a()));
        }

        @Override
        public void b(BooleanSupplier stopCondition) {
            super.b(() -> MinecraftServer.z() && stopCondition.getAsBoolean());
        }

        @Override
        protected Runnable f(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean e(Runnable task) {
            return true;
        }

        @Override
        protected boolean ay() {
            return true;
        }

        @Override
        protected Thread az() {
            return ChunkProviderServer.this.e;
        }

        @Override
        protected void d(Runnable task) {
            ChunkProviderServer.this.d.ag().d("runTask");
            super.d(task);
        }

        @Override
        public boolean B() {
            ChunkProviderServer serverChunkCache = ChunkProviderServer.this;
            if (serverChunkCache.s()) {
                return true;
            }
            return super.B() | serverChunkCache.d.moonrise$getChunkTaskScheduler().executeMainThreadTask();
        }
    }

    private record a(Chunk a, PlayerChunk b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this, o2);
        }
    }
}

