/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import ca.spottedleaf.moonrise.patches.chunk_system.io.RegionFileIOThread;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import co.aikar.timings.TimingsManager;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.destroystokyo.paper.event.server.ServerTickStartEvent;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.ServerBuildInfo;
import io.papermc.paper.adventure.ImprovedChatDecorator;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.adventure.providers.ClickCallbackProviderImpl;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.command.brigadier.PaperBrigadier;
import io.papermc.paper.command.brigadier.PaperCommands;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import io.papermc.paper.log.CustomLogManager;
import io.papermc.paper.plugin.PluginInitializerManager;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventRunner;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.threadedregions.scheduler.FoliaGlobalRegionScheduler;
import io.papermc.paper.util.CachedLists;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.ServerStopRejectedExecutionException;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.Proxy;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.OptionSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.FileUtils;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.Main;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.Services;
import net.minecraft.server.TickTask;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.bossevents.BossBattleCustomData;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.DemoPlayerInteractManager;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.level.progress.WorldLoadListenerFactory;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerConnection;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.ModCheck;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.TimeRange;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.debugchart.RemoteDebugSampleType;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.GameProfilerTick;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsEmpty;
import net.minecraft.util.profiling.MethodProfilerResultsField;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.ServerMetricsSamplersProvider;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.IAsyncTaskHandlerReentrant;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.MobSpawnerCat;
import net.minecraft.world.entity.npc.MobSpawnerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.MobSpawnerPatrol;
import net.minecraft.world.level.levelgen.MobSpawnerPhantom;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.PersistentCommandStorage;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_21_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_21_R1.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R1.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public abstract class MinecraftServer
extends IAsyncTaskHandlerReentrant<TickTask>
implements ServerInfo,
ChunkIOErrorReporter,
ICommandListener,
AutoCloseable,
ChunkSystemMinecraftServer {
    private static MinecraftServer SERVER;
    public static final Logger k;
    public static final ComponentLogger COMPONENT_LOGGER;
    public static final String b = "vanilla";
    private static final float l = 0.8f;
    private static final int m = 100;
    private static final long n;
    private static final int o = 20;
    private static final long p;
    private static final int q = 100;
    private static final long r;
    private static final long s;
    private static final int t = 12;
    private static final int u = 5;
    private static final int v = 6000;
    private static final int w = 100;
    private static final int x = 3;
    public static final int c = 29999984;
    public static final WorldSettings d;
    public static final GameProfile e;
    public Convertable.ConversionSession f;
    public final WorldNBTStorage g;
    private final List<Runnable> y = Lists.newArrayList();
    private MetricsRecorder z;
    private GameProfilerFiller A;
    private Consumer<MethodProfilerResults> B;
    private Consumer<Path> C;
    private boolean D;
    @Nullable
    private TimeProfiler E;
    private boolean F;
    private ServerConnection G;
    public final WorldLoadListenerFactory H;
    @Nullable
    private ServerPing I;
    @Nullable
    private ServerPing.a J;
    private final RandomSource K;
    public final DataFixer L;
    private String M;
    private int N;
    private final LayeredRegistryAccess<RegistryLayer> O;
    private Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> P;
    private PlayerList Q;
    private volatile boolean R;
    private volatile boolean isRestarting = false;
    private boolean S;
    private int T;
    private int U;
    protected final Proxy h;
    private boolean V;
    private boolean W;
    private boolean X;
    private boolean Y;
    private Component motd;
    private int aa;
    private final long[] ab;
    private long ac;
    public final TickTimes tickTimes5s = new TickTimes(100);
    public final TickTimes tickTimes10s = new TickTimes(200);
    public final TickTimes tickTimes60s = new TickTimes(1200);
    @Nullable
    private KeyPair ad;
    @Nullable
    private GameProfile ae;
    private boolean af;
    private volatile boolean ag;
    private long ah;
    protected final Services i;
    private long ai;
    public final Thread aj;
    private long ak;
    private long al;
    private long am;
    private long an;
    private long ao;
    private boolean ap;
    private final ResourcePackRepository aq;
    private final ScoreboardServer ar;
    @Nullable
    private PersistentCommandStorage as;
    private final BossBattleCustomData at;
    private final CustomFunctionData au;
    private boolean av;
    private float aw;
    public final Executor ax;
    @Nullable
    private String ay;
    public ReloadableResources az;
    private final StructureTemplateManager aA;
    private final ServerTickRateManager aB;
    protected SaveData j;
    public PotionBrewer aC;
    private volatile boolean aD;
    private static final AtomicReference<RuntimeException> aE;
    public final WorldLoader.a worldLoader;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public static int currentTick;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public boolean forceTicks;
    public static final int TPS = 20;
    public static final int TICK_TIME = 50000000;
    private static final int SAMPLE_INTERVAL = 20;
    @Deprecated(forRemoval=true)
    public final double[] recentTps = new double[3];
    public final PaperConfigurations paperConfigurations;
    public static long currentTickLong;
    public boolean isIteratingOverLevels = false;
    public volatile Thread shutdownThread;
    public volatile boolean abnormalExit = false;
    private volatile Throwable chunkSystemCrash;
    private boolean hasStopped = false;
    private boolean hasLoggedStop = false;
    public volatile boolean hasFullyShutdown = false;
    private final Object stopLock = new Object();
    private static final long SEC_IN_NANO = 1000000000L;
    private static final long MAX_CATCHUP_BUFFER = 60000000000L;
    private long lastTick = 0L;
    private long catchupTime = 0L;
    public final RollingAverage tps1 = new RollingAverage(60);
    public final RollingAverage tps5 = new RollingAverage(300);
    public final RollingAverage tps15 = new RollingAverage(900);
    private static final BigDecimal TPS_BASE;
    boolean isOversleep = false;
    public final ExecutorService chatExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Chat Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(k)).build());
    public final ChatDecorator improvedChatDecorator = new ImprovedChatDecorator(this);

    public static <S extends MinecraftServer> S a(Function<Thread, S> serverFactory) {
        AtomicReference<MinecraftServer> atomicreference = new AtomicReference<MinecraftServer>();
        TickThread thread = new TickThread(() -> ((MinecraftServer)atomicreference.get()).y(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, throwable) -> k.error("Uncaught exception in server thread", throwable));
        thread.setPriority(7);
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer s0 = (MinecraftServer)serverFactory.apply(thread);
        atomicreference.set(s0);
        thread.start();
        return (S)s0;
    }

    @Override
    public final void moonrise$setChunkSystemCrash(Throwable throwable) {
        this.chunkSystemCrash = throwable;
    }

    public MinecraftServer(OptionSet options, WorldLoader.a worldLoader, Thread thread, Convertable.ConversionSession convertable_conversionsession, ResourcePackRepository resourcepackrepository, WorldStem worldstem, Proxy proxy, DataFixer datafixer, Services services, WorldLoadListenerFactory worldloadlistenerfactory) {
        super("Server");
        SERVER = this;
        this.z = InactiveMetricsRecorder.a;
        this.A = this.z.f();
        this.B = methodprofilerresults -> this.aW();
        this.C = path -> {};
        this.K = RandomSource.a();
        this.N = -1;
        this.P = Maps.newLinkedHashMap();
        this.R = true;
        this.U = 6000;
        this.ab = new long[100];
        this.ac = 0L;
        this.ak = SystemUtils.d();
        this.al = SystemUtils.d();
        this.an = SystemUtils.d();
        this.ar = new ScoreboardServer(this);
        this.at = new BossBattleCustomData();
        this.O = worldstem.c();
        this.j = worldstem.d();
        this.h = proxy;
        this.aq = resourcepackrepository;
        this.az = new ReloadableResources(worldstem.a(), worldstem.b());
        this.i = services;
        if (services.f() != null) {
            services.f().a(this);
        }
        this.aB = new ServerTickRateManager(this);
        this.H = worldloadlistenerfactory;
        this.f = convertable_conversionsession;
        this.g = convertable_conversionsession.g();
        this.L = datafixer;
        this.au = new CustomFunctionData(this, this.az.b.a());
        HolderLookup.b<Block> holdergetter = this.O.a().d(Registries.f).q().a(this.j.K());
        this.aA = new StructureTemplateManager(worldstem.a(), convertable_conversionsession, datafixer, holdergetter);
        this.aj = thread;
        this.ax = SystemUtils.g();
        this.aC = PotionBrewer.a(this.j.K());
        this.options = options;
        this.worldLoader = worldLoader;
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
        this.paperConfigurations = services.paperConfigurations();
    }

    @Override
    private void a(WorldPersistentData persistentStateManager) {
        persistentStateManager.a(this.aK().b(), "scoreboard");
    }

    protected abstract boolean e() throws IOException;

    protected void loadLevel(String s2) {
        if (!JvmProfiler.f.c()) {
            // empty if block
        }
        boolean flag = false;
        ProfiledDuration profiledduration = JvmProfiler.f.e();
        this.loadWorld0(s2);
        if (profiledduration != null) {
            profiledduration.finish();
        }
        if (flag) {
            try {
                JvmProfiler.f.b();
            }
            catch (Throwable throwable) {
                k.warn("Failed to stop JFR profiling", throwable);
            }
        }
    }

    protected void t() {
    }

    private void loadWorld0(String s2) {
        Convertable.ConversionSession worldSession = this.f;
        IRegistryCustom.Dimension iregistrycustom_dimension = this.O.a();
        IRegistry<WorldDimension> dimensions = iregistrycustom_dimension.d(Registries.bb);
        for (WorldDimension worldDimension : dimensions) {
            WorldServer world;
            WorldDataServer worlddata;
            Dynamic<?> dynamic;
            String name;
            ResourceKey<WorldDimension> dimensionKey = dimensions.d(worldDimension).get();
            int dimension = 0;
            if (dimensionKey == WorldDimension.c) {
                if (!this.server.getAllowNether()) continue;
                dimension = -1;
            } else if (dimensionKey == WorldDimension.d) {
                if (!this.server.getAllowEnd()) continue;
                dimension = 1;
            } else if (dimensionKey != WorldDimension.b) {
                dimension = -999;
            }
            String worldType = dimension == -999 ? dimensionKey.a().b() + "_" + dimensionKey.a().a() : World.Environment.getEnvironment((int)dimension).toString().toLowerCase(Locale.ROOT);
            String string = name = dimensionKey == WorldDimension.b ? s2 : s2 + "_" + worldType;
            if (dimension != 0) {
                File newWorld = Convertable.getStorageFolder(new File(name).toPath(), dimensionKey).toFile();
                File oldWorld = Convertable.getStorageFolder(new File(s2).toPath(), dimensionKey).toFile();
                File oldLevelDat = new File(new File(s2), "level.dat");
                if (!newWorld.isDirectory() && oldWorld.isDirectory() && oldLevelDat.isFile()) {
                    k.info("---- Migration of old " + worldType + " folder required ----");
                    k.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + worldType + " folder to a new location in order to operate correctly.");
                    k.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
                    k.info("Attempting to move " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "...");
                    if (newWorld.exists()) {
                        k.warn("A file or folder already exists at " + String.valueOf(newWorld) + "!");
                        k.info("---- Migration of old " + worldType + " folder failed ----");
                    } else if (newWorld.getParentFile().mkdirs()) {
                        if (oldWorld.renameTo(newWorld)) {
                            k.info("Success! To restore " + worldType + " in the future, simply move " + String.valueOf(newWorld) + " to " + String.valueOf(oldWorld));
                            try {
                                Files.copy((File)oldLevelDat, (File)new File(new File(name), "level.dat"));
                                org.apache.commons.io.FileUtils.copyDirectory((File)new File(new File(s2), "data"), (File)new File(new File(name), "data"));
                            }
                            catch (IOException exception) {
                                k.warn("Unable to migrate world data.");
                            }
                            k.info("---- Migration of old " + worldType + " folder complete ----");
                        } else {
                            k.warn("Could not move folder " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "!");
                            k.info("---- Migration of old " + worldType + " folder failed ----");
                        }
                    } else {
                        k.warn("Could not create path for " + String.valueOf(newWorld) + "!");
                        k.info("---- Migration of old " + worldType + " folder failed ----");
                    }
                }
                try {
                    worldSession = Convertable.b(this.server.getWorldContainer().toPath()).validateAndCreateAccess(name, dimensionKey);
                }
                catch (IOException | ContentValidationException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (worldSession.m()) {
                WorldInfo worldinfo;
                try {
                    dynamic = worldSession.h();
                    worldinfo = worldSession.a(dynamic);
                }
                catch (IOException | NbtException | ReportedNbtException ioexception) {
                    Convertable.b convertable_b = worldSession.e();
                    k.warn("Failed to load world data from {}", (Object)convertable_b.b(), (Object)ioexception);
                    k.info("Attempting to use fallback");
                    try {
                        dynamic = worldSession.i();
                        worldinfo = worldSession.a(dynamic);
                    }
                    catch (IOException | NbtException | ReportedNbtException ioexception1) {
                        k.error("Failed to load world data from {}", (Object)convertable_b.c(), (Object)ioexception1);
                        k.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.b(), (Object)convertable_b.c());
                        return;
                    }
                    worldSession.n();
                }
                if (worldinfo.d()) {
                    k.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!worldinfo.r()) {
                    k.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dynamic = null;
            }
            ChunkGenerator gen = this.server.getGenerator(name);
            BiomeProvider biomeProvider = this.server.getBiomeProvider(name);
            WorldLoader.a worldloader_a = this.worldLoader;
            IRegistry<WorldDimension> iregistry = worldloader_a.d().d(Registries.bb);
            if (dynamic != null) {
                LevelDataAndDimensions leveldataanddimensions = Convertable.a(dynamic, worldloader_a.b(), iregistry, worldloader_a.c());
                worlddata = (WorldDataServer)leveldataanddimensions.a();
            } else {
                WorldDimensions worlddimensions;
                WorldOptions worldoptions;
                WorldSettings worldsettings;
                if (this.W()) {
                    worldsettings = d;
                    worldoptions = WorldOptions.b;
                    worlddimensions = WorldPresets.a(worldloader_a.c());
                } else {
                    DedicatedServerProperties dedicatedserverproperties = ((DedicatedServer)this).a();
                    worldsettings = new WorldSettings(dedicatedserverproperties.n, dedicatedserverproperties.m, dedicatedserverproperties.v, dedicatedserverproperties.l, false, new GameRules(), worldloader_a.b());
                    worldoptions = this.options.has("bonusChest") ? dedicatedserverproperties.aa.a(true) : dedicatedserverproperties.aa;
                    worlddimensions = dedicatedserverproperties.a(worldloader_a.c());
                }
                WorldDimensions.b worlddimensions_b = worlddimensions.a(iregistry);
                Lifecycle lifecycle = worlddimensions_b.a().add(worldloader_a.c().e());
                worlddata = new WorldDataServer(worldsettings, worldoptions, worlddimensions_b.d(), lifecycle);
            }
            worlddata.checkName(name);
            if (this.options.has("forceUpgrade")) {
                Main.a(worldSession, DataConverterRegistry.a(), this.options.has("eraseCache"), () -> true, iregistrycustom_dimension, this.options.has("recreateRegionFiles"));
            }
            WorldDataServer iworlddataserver = worlddata;
            boolean flag = worlddata.A();
            WorldOptions worldoptions = worlddata.y();
            long i2 = worldoptions.b();
            long j2 = BiomeManager.a(i2);
            ImmutableList list = ImmutableList.of((Object)new MobSpawnerPhantom(), (Object)new MobSpawnerPatrol(), (Object)new MobSpawnerCat(), (Object)new VillageSiege(), (Object)new MobSpawnerTrader(iworlddataserver));
            WorldDimension worlddimension = dimensions.a(dimensionKey);
            CraftWorldInfo worldInfo = new CraftWorldInfo(iworlddataserver, worldSession, World.Environment.getEnvironment((int)dimension), worlddimension.a().a(), worlddimension.b(), this.bc());
            if (biomeProvider == null && gen != null) {
                biomeProvider = gen.getDefaultBiomeProvider((org.bukkit.generator.WorldInfo)worldInfo);
            }
            ResourceKey<net.minecraft.world.level.World> worldKey = ResourceKey.a(Registries.ba, dimensionKey.a());
            if (dimensionKey == WorldDimension.b) {
                this.j = worlddata;
                this.j.a(((DedicatedServer)this).a().m);
                worldloadlistener = this.H.create(this.j.o().c(GameRules.Z));
                world = new WorldServer(this, this.ax, worldSession, iworlddataserver, worldKey, worlddimension, worldloadlistener, flag, j2, (List<MobSpawner>)list, true, null, World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
                WorldPersistentData worldpersistentdata = world.u();
                this.a(worldpersistentdata);
                this.server.scoreboardManager = new CraftScoreboardManager(this, world.f());
                this.as = new PersistentCommandStorage(worldpersistentdata);
            } else {
                worldloadlistener = this.H.create(this.j.o().c(GameRules.Z));
                ImmutableList spawners = GlobalConfiguration.get().misc.useDimensionTypeForCustomSpawners && this.bc().d(Registries.aK).d(worlddimension.a().a()).orElseThrow() == BuiltinDimensionTypes.a ? list : Collections.emptyList();
                world = new WorldServer(this, this.ax, worldSession, iworlddataserver, worldKey, worlddimension, worldloadlistener, flag, j2, (List<MobSpawner>)spawners, true, this.I().L(), World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
            }
            worlddata.a(this.getServerModName(), this.P().a());
            this.addLevel(world);
            this.initWorld(world, worlddata, this.j, worldoptions);
            this.ah().a(world);
            if (worlddata.E() == null) continue;
            this.aN().a(worlddata.E(), this.bc());
        }
        this.t();
        for (WorldServer worldserver : this.K()) {
            this.prepareLevels(worldserver.l().a.E, worldserver);
            this.server.getPluginManager().callEvent((Event)new WorldLoadEvent((World)worldserver.getWorld()));
        }
        ScoreboardServer scoreboard = this.aK();
        Collection toRemove = scoreboard.g().stream().filter(team -> team.b().startsWith("collideRule_")).map(ScoreboardTeam::b).collect(Collectors.toList());
        for (String teamName : toRemove) {
            scoreboard.d(scoreboard.b(teamName));
        }
        if (!GlobalConfiguration.get().collisions.enablePlayerCollisions) {
            this.ah().collideRuleTeamName = StringUtils.left((String)("collideRule_" + ThreadLocalRandom.current().nextInt()), (int)16);
            ScoreboardTeam collideTeam = scoreboard.c(this.ah().collideRuleTeamName);
            collideTeam.b(false);
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        if (PluginInitializerManager.instance().pluginRemapper != null) {
            PluginInitializerManager.instance().pluginRemapper.pluginsEnabled();
        }
        PaperCommands.INSTANCE.setValid();
        LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, Plugin.class, ReloadableRegistrarEvent.Cause.INITIAL);
        ((SimpleHelpMap)this.server.getHelpMap()).initializeCommands();
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.G.acceptConnections();
    }

    public void initWorld(WorldServer worldserver, IWorldDataServer iworlddataserver, SaveData saveData, WorldOptions worldoptions) {
        boolean flag = saveData.A();
        if (worldserver.generator != null) {
            worldserver.getWorld().getPopulators().addAll(worldserver.generator.getDefaultPopulators((World)worldserver.getWorld()));
        }
        WorldBorder worldborder = worldserver.C_();
        worldborder.a(iworlddataserver.p());
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)worldserver.getWorld()));
        if (!iworlddataserver.n()) {
            try {
                MinecraftServer.a(worldserver, iworlddataserver, worldoptions.d(), flag);
                iworlddataserver.c(true);
                if (flag) {
                    this.a(this.j);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.a(throwable, "Exception initializing level");
                try {
                    worldserver.a(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            iworlddataserver.c(true);
        }
    }

    private static void a(WorldServer world, IWorldDataServer worldProperties, boolean bonusChest, boolean debugWorld) {
        if (debugWorld) {
            worldProperties.a(BlockPosition.c.b(80), 0.0f);
        } else {
            int i2;
            ChunkProviderServer chunkproviderserver = world.l();
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(chunkproviderserver.i().b().a());
            if (world.generator != null) {
                Random rand = new Random(world.C());
                Location spawn = world.generator.getFixedSpawnLocation((World)world.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != world.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + worldProperties.e() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    worldProperties.a(new BlockPosition(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()), spawn.getYaw());
                    return;
                }
            }
            if ((i2 = chunkproviderserver.g().a(world)) < world.I_()) {
                BlockPosition blockposition = chunkcoordintpair.l();
                i2 = world.a(HeightMap.Type.b, blockposition.u() + 8, blockposition.w() + 8);
            }
            worldProperties.a(chunkcoordintpair.l().b(8, i2, 8), 0.0f);
            int j2 = 0;
            int k2 = 0;
            int l2 = 0;
            int i1 = -1;
            for (int j1 = 0; j1 < MathHelper.h(11); ++j1) {
                BlockPosition blockposition1;
                if (j2 >= -5 && j2 <= 5 && k2 >= -5 && k2 <= 5 && (blockposition1 = WorldProviderNormal.a(world, new ChunkCoordIntPair(chunkcoordintpair.e + j2, chunkcoordintpair.f + k2))) != null) {
                    worldProperties.a(blockposition1, 0.0f);
                    break;
                }
                if (j2 == k2 || j2 < 0 && j2 == -k2 || j2 > 0 && j2 == 1 - k2) {
                    int k1 = l2;
                    l2 = -i1;
                    i1 = k1;
                }
                j2 += l2;
                k2 += i1;
            }
            if (bonusChest) {
                world.H_().c(Registries.aI).flatMap(iregistry -> iregistry.b(MiscOverworldFeatures.m)).ifPresent(holder_c -> ((WorldGenFeatureConfigured)holder_c.a()).a(world, chunkproviderserver.g(), world.z, worldProperties.a()));
            }
        }
    }

    @Override
    private void a(SaveData properties) {
        properties.a(EnumDifficulty.a);
        properties.d(true);
        IWorldDataServer iworlddataserver = properties.I();
        iworlddataserver.b(false);
        iworlddataserver.a(false);
        iworlddataserver.a(1000000000);
        iworlddataserver.b(6000L);
        iworlddataserver.a(EnumGamemode.d);
    }

    public void prepareLevels(WorldLoadListener worldloadlistener, WorldServer worldserver) {
        int j2;
        this.forceTicks = true;
        k.info("Preparing start region for dimension {}", (Object)worldserver.af().a());
        BlockPosition blockposition = worldserver.V();
        worldloadlistener.a(new ChunkCoordIntPair(blockposition));
        ChunkProviderServer chunkproviderserver = worldserver.l();
        this.an = SystemUtils.d();
        worldserver.a(blockposition, worldserver.W());
        int i2 = worldserver.ab().c(GameRules.Z);
        int n2 = j2 = i2 > 0 ? MathHelper.h(WorldLoadListener.a(i2)) : 0;
        while (chunkproviderserver.b() < j2) {
            this.executeModerately();
        }
        this.executeModerately();
        WorldServer worldserver1 = worldserver;
        ForcedChunk forcedchunk = worldserver1.u().b(ForcedChunk.a(), "chunks");
        if (forcedchunk != null) {
            LongIterator longiterator = forcedchunk.b().iterator();
            while (longiterator.hasNext()) {
                long k2 = longiterator.nextLong();
                ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(k2);
                worldserver1.l().a(chunkcoordintpair, true);
            }
        }
        this.executeModerately();
        worldloadlistener.b();
        worldserver.b(worldserver.K.q() != EnumDifficulty.a && ((DedicatedServer)this).r.a().x, this.ab());
        this.forceTicks = false;
    }

    public EnumGamemode u_() {
        return this.j.k();
    }

    public boolean j() {
        return this.j.l();
    }

    public abstract int k();

    public abstract int l();

    public abstract boolean m();

    public boolean a(boolean suppressLogs, boolean flush, boolean force) {
        return this.saveAllChunks(suppressLogs, flush, force, false);
    }

    public boolean saveAllChunks(boolean suppressLogs, boolean flush, boolean force, boolean close) {
        boolean flag3 = false;
        for (WorldServer worldserver : this.K()) {
            if (!suppressLogs) {
                k.info("Saving chunks for level '{}'/{}", (Object)worldserver, (Object)worldserver.af().a());
            }
            worldserver.save(null, flush, worldserver.e && !force, close);
            flag3 = true;
        }
        if (flush) {
            for (WorldServer worldserver2 : this.K()) {
                k.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)worldserver2.l().a.n());
            }
            k.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean b(boolean suppressLogs, boolean flush, boolean force) {
        boolean flag3;
        try {
            this.aD = true;
            this.ah().h();
            flag3 = this.a(suppressLogs, flush, force);
        }
        finally {
            this.aD = false;
        }
        return flag3;
    }

    @Override
    public void close() {
        this.v();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void v() {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        if (!this.hasLoggedStop && this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.shutdownThread = Thread.currentThread();
        WatchdogThread.doStop();
        if (!this.bx()) {
            k.info("Stopping main thread (Ignore any thread death message you see! - DO NOT REPORT THREAD DEATH TO PAPER)");
            while (this.az().isAlive()) {
                this.az().stop();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.z.e()) {
            this.aY();
        }
        k.info("Stopping server");
        CommandDispatcher.COMMAND_SENDING_POOL.shutdownNow();
        MinecraftTimings.stopServer();
        if (this.server != null) {
            this.server.disablePlugins();
            this.server.waitForAsyncTasksShutdown();
        }
        if (PluginInitializerManager.instance().pluginRemapper != null) {
            PluginInitializerManager.instance().pluginRemapper.shutdown();
        }
        this.ai().b();
        this.aD = true;
        if (this.Q != null) {
            k.info("Saving players");
            this.Q.h();
            this.Q.removeAll(this.isRestarting);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        k.info("Saving worlds");
        for (WorldServer worldserver : this.K()) {
            if (worldserver == null) continue;
            worldserver.e = false;
        }
        this.saveAllChunks(false, true, true, true);
        this.aD = false;
        this.az.close();
        try {
            this.f.close();
        }
        catch (IOException ioexception1) {
            k.error("Failed to unlock level {}", (Object)this.f.f(), (Object)ioexception1);
        }
        MCUtil.asyncExecutor.shutdown();
        try {
            MCUtil.asyncExecutor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (SpigotConfig.saveUserCacheOnStopOnly) {
            k.info("Saving usercache.json");
            this.au().save(false);
        }
        RegionFileIOThread.deinit();
        SystemUtils.j();
        try {
            TerminalConsoleAppender.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CustomLogManager.forceReset();
        this.i();
    }

    public String w() {
        return this.M;
    }

    public void a_(String serverIp) {
        this.M = serverIp;
    }

    public boolean x() {
        return this.R;
    }

    @Override
    public void a(boolean waitForShutdown) {
        this.safeShutdown(waitForShutdown, false);
    }

    public void safeShutdown(boolean waitForShutdown, boolean isRestarting) {
        this.isRestarting = isRestarting;
        this.hasLoggedStop = true;
        if (this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.R = false;
        if (waitForShutdown) {
            try {
                this.aj.join();
            }
            catch (InterruptedException interruptedexception) {
                k.error("Error while shutting down", (Throwable)interruptedexception);
            }
        }
    }

    private static double calcTps(double avg, double exp, double tps) {
        return avg * exp + tps * (1.0 - exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void y() {
        try {
            long serverStartTime = SystemUtils.d();
            if (!this.e()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            this.an = SystemUtils.d();
            this.J = this.bD().orElse(null);
            this.I = this.bF();
            k.info("Running delayed init tasks");
            this.server.getScheduler().mainThreadHeartbeat(this.T);
            String doneTime = String.format(Locale.ROOT, "%.3fs", (double)(SystemUtils.d() - serverStartTime) / 1.0E9);
            k.info("Done ({})! For help, type \"help\"", (Object)doneTime);
            WatchdogThread.tick();
            WatchdogThread.hasStarted = true;
            Arrays.fill(this.recentTps, 20.0);
            long tickSection = SystemUtils.d();
            if (GlobalConfiguration.isFirstStart) {
                k.info("*************************************************************************************");
                k.info("This is the first time you're starting this server.");
                k.info("It's recommended you read our 'Getting Started' documentation for guidance.");
                k.info("View this and more helpful information here: https://docs.papermc.io/paper/next-steps");
                k.info("*************************************************************************************");
            }
            while (this.R) {
                boolean flag;
                long i2;
                if (!this.E() && this.aB.a() && this.aB.d()) {
                    i2 = 0L;
                    this.ah = this.an = SystemUtils.d();
                } else {
                    i2 = this.aB.h();
                    long j2 = SystemUtils.d() - this.an;
                    if (j2 > n + 20L * i2 && this.an - this.ah >= p + 100L * i2) {
                        long k2 = j2 / i2;
                        if (this.server.getWarnOnOverload()) {
                            k.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)(j2 / TimeRange.b), (Object)k2);
                        }
                        this.an += k2 * i2;
                        this.ah = this.an;
                    }
                }
                ++currentTickLong;
                long currentTime = SystemUtils.d();
                if (++currentTick % 20 == 0) {
                    long diff = currentTime - tickSection;
                    BigDecimal currentTps = TPS_BASE.divide(new BigDecimal(diff), 30, RoundingMode.HALF_UP);
                    this.tps1.add(currentTps, diff);
                    this.tps5.add(currentTps, diff);
                    this.tps15.add(currentTps, diff);
                    this.recentTps[0] = this.tps1.getAverage();
                    this.recentTps[1] = this.tps5.getAverage();
                    this.recentTps[2] = this.tps15.getAverage();
                    tickSection = currentTime;
                }
                boolean bl = flag = i2 == 0L;
                if (this.F) {
                    this.F = false;
                    this.E = new TimeProfiler(SystemUtils.d(), this.T);
                }
                this.lastTick = currentTime;
                this.an += i2;
                this.bI();
                this.A.a("tick");
                this.a(flag ? () -> false : this::bu);
                Throwable crash = this.chunkSystemCrash;
                if (crash != null) {
                    this.chunkSystemCrash = null;
                    throw new RuntimeException("Chunk system crash propagated to tick()", crash);
                }
                this.A.b("nextTickWait");
                this.ap = true;
                this.ao = Math.max(SystemUtils.d() + i2, this.an);
                this.bs();
                this.v_();
                this.bt();
                if (flag) {
                    this.aB.e();
                }
                this.A.c();
                this.br();
                this.aU();
                this.ag = true;
                JvmProfiler.f.a(this.aw);
            }
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                k.error("Main thread terminated by WatchDog due to hard crash", throwable);
                return;
            }
            k.error("Encountered an unexpected exception", throwable);
            CrashReport crashreport = MinecraftServer.a(throwable);
            this.b(crashreport.f());
            Path path = this.D().resolve("crash-reports").resolve("crash-" + SystemUtils.f() + "-server.txt");
            if (crashreport.a(path, ReportType.a)) {
                k.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
            } else {
                k.error("We were unable to save this crash report to disk.");
            }
            this.a(crashreport);
            return;
        }
        finally {
            try {
                this.S = true;
                this.v();
            }
            catch (Throwable throwable1) {
                k.error("Exception stopping the server", throwable1);
            }
            finally {
                if (this.i.f() != null) {
                    this.i.f().a();
                }
            }
        }
    }

    private void br() {
        long i2 = SystemUtils.d();
        if (this.g()) {
            this.f().a(i2 - this.ak);
        }
        this.ak = i2;
    }

    private void bs() {
        if (this.g()) {
            this.al = SystemUtils.d();
            this.am = 0L;
        }
    }

    private void bt() {
        if (this.g()) {
            SampleLogger samplelogger = this.f();
            samplelogger.a(SystemUtils.d() - this.al - this.am, TpsDebugDimensions.c.ordinal());
            samplelogger.a(this.am, TpsDebugDimensions.d.ordinal());
        }
    }

    private static CrashReport a(Throwable throwable) {
        CrashReport crashreport;
        ReportedException reportedexception = null;
        for (Throwable throwable1 = throwable; throwable1 != null; throwable1 = throwable1.getCause()) {
            ReportedException reportedexception1;
            if (!(throwable1 instanceof ReportedException)) continue;
            reportedexception = reportedexception1 = (ReportedException)throwable1;
        }
        if (reportedexception != null) {
            crashreport = reportedexception.a();
            if (reportedexception != throwable) {
                crashreport.a("Wrapped in").a("Wrapping exception", throwable);
            }
        } else {
            crashreport = new CrashReport("Exception in server tick loop", throwable);
        }
        return crashreport;
    }

    private boolean bu() {
        if (this.isOversleep) {
            return this.canOversleep();
        }
        return this.forceTicks || this.bC() || SystemUtils.d() < (this.ap ? this.ao : this.an);
    }

    private boolean canOversleep() {
        return this.ap && SystemUtils.d() < this.ao;
    }

    private boolean canSleepForTickNoOversleep() {
        return this.forceTicks || this.bC() || SystemUtils.d() < this.an;
    }

    private void executeModerately() {
        this.bB();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    public static boolean z() {
        RuntimeException runtimeexception = aE.get();
        if (runtimeexception != null) {
            throw runtimeexception;
        }
        return true;
    }

    public static void a(RuntimeException exception) {
        aE.compareAndSet(null, exception);
    }

    @Override
    public void b(BooleanSupplier stopCondition) {
        super.b(() -> MinecraftServer.z() && stopCondition.getAsBoolean());
    }

    protected void v_() {
        this.b(() -> !this.canSleepForTickNoOversleep());
    }

    @Override
    public void A() {
        boolean flag = this.g();
        long i2 = flag ? SystemUtils.d() : 0L;
        super.A();
        if (flag) {
            this.am += SystemUtils.d() - i2;
        }
    }

    public TickTask a(Runnable runnable) {
        if (this.hasStopped && Thread.currentThread().equals(this.shutdownThread)) {
            runnable.run();
            runnable = () -> {};
        }
        return new TickTask(this.T, runnable);
    }

    protected boolean a(TickTask ticktask) {
        return ticktask.a() + 3 < this.T || this.bu();
    }

    @Override
    public boolean B() {
        boolean flag;
        this.ap = flag = this.bv();
        return flag;
    }

    private boolean bv() {
        if (super.B()) {
            return true;
        }
        boolean ret = false;
        if (this.aB.a() || this.bu()) {
            for (WorldServer worldserver : this.K()) {
                if (!worldserver.l().d()) continue;
                ret = true;
            }
        }
        return ret;
    }

    public void b(TickTask ticktask) {
        this.aT().d("runTask");
        super.d(ticktask);
    }

    private Optional<ServerPing.a> bD() {
        Optional<Path> optional = Optional.of(this.c("server-icon.png")).filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])).or(() -> this.f.j().filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])));
        return optional.flatMap(path -> {
            try {
                BufferedImage bufferedimage = ImageIO.read(path.toFile());
                Preconditions.checkState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedimage, "PNG", bytearrayoutputstream);
                return Optional.of(new ServerPing.a(bytearrayoutputstream.toByteArray()));
            }
            catch (Exception exception) {
                k.error("Couldn't load server icon", (Throwable)exception);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> C() {
        return this.f.j();
    }

    public Path D() {
        return Path.of("", new String[0]);
    }

    @Override
    public void a(CrashReport report) {
    }

    public void i() {
    }

    public boolean E() {
        return false;
    }

    @Override
    public void a(BooleanSupplier shouldKeepTicking) {
        TimingsManager.FULL_SERVER_TICK.startTiming();
        long i2 = SystemUtils.d();
        this.isOversleep = true;
        MinecraftTimings.serverOversleep.startTiming();
        this.b(() -> !this.canOversleep());
        this.isOversleep = false;
        MinecraftTimings.serverOversleep.stopTiming();
        new ServerTickStartEvent(this.T + 1).callEvent();
        ++this.T;
        this.aB.m();
        this.c(shouldKeepTicking);
        if (i2 - this.ai >= r) {
            this.ai = i2;
            this.I = this.bF();
        }
        --this.U;
        if (this.autosavePeriod > 0 && this.U <= 0) {
            this.U = this.autosavePeriod;
            k.debug("Autosave started");
            this.A.a("save");
            this.b(true, false, false);
            this.A.c();
            k.debug("Autosave finished");
        }
        CachedLists.reset();
        try (Timing ignored = MinecraftTimings.processTasksTimer.startTiming();){
            this.bB();
        }
        long endTime = System.nanoTime();
        long remaining = 50000000L - (endTime - this.lastTick) - this.catchupTime;
        new ServerTickEndEvent(this.T, (double)(endTime - this.lastTick) / 1000000.0, remaining).callEvent();
        this.A.a("tallying");
        long j2 = SystemUtils.d() - i2;
        int k2 = this.T % 100;
        this.ac -= this.ab[k2];
        this.ac += j2;
        this.ab[k2] = j2;
        this.aw = this.aw * 0.8f + (float)j2 / (float)TimeRange.b * 0.19999999f;
        this.tickTimes5s.add(this.T, j2);
        this.tickTimes10s.add(this.T, j2);
        this.tickTimes60s.add(this.T, j2);
        this.a(i2);
        this.A.c();
        WatchdogThread.tick();
        TimingsManager.FULL_SERVER_TICK.stopTiming();
    }

    @Override
    private void a(long tickStartTime) {
        if (this.g()) {
            this.f().a(SystemUtils.d() - tickStartTime, TpsDebugDimensions.b.ordinal());
        }
    }

    private int bE() {
        float f2;
        if (this.aB.a()) {
            long i2 = this.aR() + 1L;
            f2 = (float)TimeRange.a / (float)i2;
        } else {
            f2 = this.aB.f();
        }
        boolean flag = true;
        return Math.max(100, (int)(f2 * 300.0f));
    }

    public void F() {
        int i2 = this.bE();
        if (i2 < this.U) {
            this.U = i2;
        }
    }

    protected abstract SampleLogger f();

    public abstract boolean g();

    private ServerPing bF() {
        ServerPing.ServerPingPlayerSample serverping_serverpingplayersample = this.bG();
        return new ServerPing(PaperAdventure.asVanilla(this.motd), Optional.of(serverping_serverpingplayersample), Optional.of(ServerPing.ServerData.a()), Optional.ofNullable(this.J), this.aB());
    }

    private ServerPing.ServerPingPlayerSample bG() {
        List<EntityPlayer> list = this.Q.t();
        int i2 = this.N();
        if (this.ao()) {
            return new ServerPing.ServerPingPlayerSample(i2, list.size(), List.of());
        }
        int j2 = Math.min(list.size(), SpigotConfig.playerSample);
        ObjectArrayList objectarraylist = new ObjectArrayList(j2);
        int k2 = MathHelper.a(this.K, 0, list.size() - j2);
        for (int l2 = 0; l2 < j2; ++l2) {
            EntityPlayer entityplayer = list.get(k2 + l2);
            objectarraylist.add((Object)(entityplayer.aa() ? entityplayer.fX() : e));
        }
        SystemUtils.c(objectarraylist, this.K);
        return new ServerPing.ServerPingPlayerSample(i2, list.size(), (List<GameProfile>)objectarraylist);
    }

    public void c(BooleanSupplier shouldKeepTicking) {
        this.ah().t().forEach(entityplayer -> entityplayer.c.f());
        MinecraftTimings.bukkitSchedulerTimer.startTiming();
        this.server.getScheduler().mainThreadHeartbeat(this.T);
        MinecraftTimings.bukkitSchedulerTimer.stopTiming();
        ((FoliaGlobalRegionScheduler)Bukkit.getGlobalRegionScheduler()).tick();
        this.K().forEach(level -> {
            for (Entity entity : level.moonrise$getEntityLookup().getAllCopy()) {
                CraftEntity bukkit;
                if (entity.dJ() || (bukkit = entity.getBukkitEntityRaw()) == null) continue;
                bukkit.taskScheduler.executeTick();
            }
        });
        ClickCallbackProviderImpl.CALLBACK_MANAGER.handleQueue(this.T);
        this.A.a("commandFunctions");
        MinecraftTimings.commandFunctionsTimer.startTiming();
        this.aF().b();
        MinecraftTimings.commandFunctionsTimer.stopTiming();
        this.A.b("levels");
        MinecraftTimings.processQueueTimer.startTiming();
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        MinecraftTimings.processQueueTimer.stopTiming();
        MinecraftTimings.timeUpdateTimer.startTiming();
        for (WorldServer level2 : this.K()) {
            boolean doDaylight = level2.ab().b(GameRules.l);
            long dayTime = level2.aa();
            long worldTime = level2.Z();
            PacketPlayOutUpdateTime worldPacket = new PacketPlayOutUpdateTime(worldTime, dayTime, doDaylight);
            for (EntityHuman entityHuman : level2.x()) {
                if (!(entityHuman instanceof EntityPlayer) || (this.T + entityHuman.an()) % 20 != 0) continue;
                EntityPlayer entityplayer2 = (EntityPlayer)entityHuman;
                long playerTime = entityplayer2.getPlayerTime();
                PacketPlayOutUpdateTime packet = playerTime == dayTime ? worldPacket : new PacketPlayOutUpdateTime(worldTime, playerTime, doDaylight);
                entityplayer2.c.b(packet);
            }
        }
        MinecraftTimings.timeUpdateTimer.stopTiming();
        this.isIteratingOverLevels = true;
        for (WorldServer worldserver : this.K()) {
            worldserver.hasPhysicsEvent = BlockPhysicsEvent.getHandlerList().getRegisteredListeners().length > 0;
            worldserver.hasEntityMoveEvent = EntityMoveEvent.getHandlerList().getRegisteredListeners().length > 0;
            TileEntityHopper.skipHopperEvents = worldserver.paperConfig().hopper.disableMoveEvent || InventoryMoveItemEvent.getHandlerList().getRegisteredListeners().length == 0;
            this.A.a(() -> {
                String s2 = String.valueOf(worldserver);
                return s2 + " " + String.valueOf(worldserver.af().a());
            });
            this.A.a("tick");
            try {
                worldserver.timings.doTick.startTiming();
                worldserver.a(shouldKeepTicking);
                worldserver.timings.doTick.stopTiming();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.a(throwable, "Exception ticking world");
                worldserver.a(crashreport);
                throw new ReportedException(crashreport);
            }
            this.A.c();
            this.A.c();
            worldserver.explosionDensityCache.clear();
        }
        this.isIteratingOverLevels = false;
        this.A.b("connection");
        MinecraftTimings.connectionTimer.startTiming();
        this.ai().c();
        MinecraftTimings.connectionTimer.stopTiming();
        this.A.b("players");
        MinecraftTimings.playerListTimer.startTiming();
        this.Q.d();
        MinecraftTimings.playerListTimer.stopTiming();
        if (SharedConstants.aV && this.aB.i()) {
            GameTestHarnessTicker.a.b();
        }
        this.A.b("server gui refresh");
        MinecraftTimings.tickablesTimer.startTiming();
        for (int i2 = 0; i2 < this.y.size(); ++i2) {
            this.y.get(i2).run();
        }
        MinecraftTimings.tickablesTimer.stopTiming();
        this.A.b("send chunks");
        for (EntityPlayer entityplayer3 : this.Q.t()) {
            entityplayer3.c.g.a(entityplayer3);
            entityplayer3.c.g();
        }
        this.A.c();
    }

    private void b(WorldServer world) {
        this.Q.a(new PacketPlayOutUpdateTime(world.Z(), world.aa(), world.ab().b(GameRules.l)), world.af());
    }

    public void G() {
        this.A.a("timeSync");
        for (WorldServer worldserver : this.K()) {
            this.b(worldserver);
        }
        this.A.c();
    }

    public boolean a(net.minecraft.world.level.World world) {
        return true;
    }

    public void b(Runnable tickable) {
        this.y.add(tickable);
    }

    protected void b(String serverId) {
        this.ay = serverId;
    }

    public boolean H() {
        return !this.aj.isAlive();
    }

    public Path c(String path) {
        return this.D().resolve(path);
    }

    public final WorldServer I() {
        return this.P.get(net.minecraft.world.level.World.h);
    }

    @Nullable
    public WorldServer a(ResourceKey<net.minecraft.world.level.World> key) {
        return this.P.get(key);
    }

    public void addLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.P;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.put(level.af(), level);
        this.P = Collections.unmodifiableMap(newLevels);
    }

    public void removeLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.P;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.remove(level.af());
        this.P = Collections.unmodifiableMap(newLevels);
    }

    public Set<ResourceKey<net.minecraft.world.level.World>> J() {
        return this.P.keySet();
    }

    public Iterable<WorldServer> K() {
        return this.P.values();
    }

    @Override
    public String L() {
        return SharedConstants.b().c();
    }

    @Override
    public int M() {
        return this.Q.m();
    }

    @Override
    public int N() {
        return this.Q.n();
    }

    public String[] O() {
        return this.Q.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return ServerBuildInfo.buildInfo().brandName();
    }

    public SystemReport b(SystemReport details) {
        details.a("Server Running", () -> Boolean.toString(this.R));
        if (this.Q != null) {
            details.a("Player Count", () -> {
                int i2 = this.Q.m();
                return i2 + " / " + this.Q.n() + "; " + String.valueOf(this.Q.t());
            });
        }
        details.a("Active Data Packs", () -> ResourcePackRepository.a(this.aq.f()));
        details.a("Available Data Packs", () -> ResourcePackRepository.a(this.aq.c()));
        details.a("Enabled Feature Flags", () -> FeatureFlags.d.b(this.j.K()).stream().map(MinecraftKey::toString).collect(Collectors.joining(", ")));
        details.a("World Generation", () -> this.j.B().toString());
        details.a("World Seed", () -> String.valueOf(this.j.y().b()));
        if (this.ay != null) {
            details.a("Server Id", () -> this.ay);
        }
        return this.a(details);
    }

    public abstract SystemReport a(SystemReport var1);

    public ModCheck P() {
        return ModCheck.a(b, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void a(IChatBaseComponent message) {
        k.info((String)PaperAdventure.ANSI_SERIALIZER.serialize(PaperAdventure.asAdventure(message)));
    }

    public KeyPair Q() {
        return this.ad;
    }

    public int R() {
        return this.N;
    }

    @Override
    public void a(int serverPort) {
        this.N = serverPort;
    }

    @Nullable
    public GameProfile S() {
        return this.ae;
    }

    public void b(@Nullable GameProfile hostProfile) {
        this.ae = hostProfile;
    }

    public boolean T() {
        return this.ae != null;
    }

    protected void U() {
        k.info("Generating keypair");
        try {
            this.ad = MinecraftEncryption.b();
        }
        catch (CryptographyException cryptographyexception) {
            throw new IllegalStateException("Failed to generate key pair", cryptographyexception);
        }
    }

    public void setDifficulty(WorldServer level, EnumDifficulty difficulty, boolean forceUpdate) {
        WorldDataServer worldData = level.K;
        if (forceUpdate || !worldData.r()) {
            worldData.a(worldData.l() ? EnumDifficulty.d : difficulty);
            level.b(worldData.q() != EnumDifficulty.a && ((DedicatedServer)this).r.a().x, this.ab());
        }
    }

    public int b(int initialDistance) {
        return initialDistance;
    }

    private void bH() {
        for (WorldServer worldserver : this.K()) {
            worldserver.b(worldserver.K.q() != EnumDifficulty.a && ((DedicatedServer)this).r.a().x, this.ab());
        }
    }

    public void b(boolean locked) {
        this.j.d(locked);
        this.ah().t().forEach(this::c);
    }

    private void c(EntityPlayer player) {
        WorldData worlddata = player.dO().A_();
        player.c.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
    }

    public boolean V() {
        return this.j.q() != EnumDifficulty.a;
    }

    public boolean W() {
        return this.af;
    }

    public void c(boolean demo) {
        this.af = demo;
    }

    public Optional<ServerResourcePackInfo> X() {
        return Optional.empty();
    }

    public boolean Y() {
        return this.X().filter(ServerResourcePackInfo::d).isPresent();
    }

    public abstract boolean n();

    public abstract int o();

    public boolean Z() {
        return this.V;
    }

    @Override
    public void d(boolean onlineMode) {
        this.V = onlineMode;
    }

    public boolean aa() {
        return this.W;
    }

    public void e(boolean preventProxyConnections) {
        this.W = preventProxyConnections;
    }

    public boolean ab() {
        return true;
    }

    public boolean ac() {
        return true;
    }

    public abstract boolean p();

    public boolean ad() {
        return this.X;
    }

    public void f(boolean pvpEnabled) {
        this.X = pvpEnabled;
    }

    public boolean ae() {
        return this.Y;
    }

    public void g(boolean flightEnabled) {
        this.Y = flightEnabled;
    }

    public abstract boolean q();

    @Override
    public String af() {
        return LegacyComponentSerializer.legacySection().serialize(this.motd);
    }

    @Override
    public void d(String motd) {
        this.motd = LegacyComponentSerializer.legacySection().deserializeOr((Object)motd, (Component)Component.empty());
    }

    public Component motd() {
        return this.motd;
    }

    public void motd(Component motd) {
        this.motd = motd;
    }

    public boolean ag() {
        return this.S;
    }

    public PlayerList ah() {
        return this.Q;
    }

    @Override
    public void a(PlayerList playerManager) {
        this.Q = playerManager;
    }

    public abstract boolean r();

    @Override
    public void a(EnumGamemode gameMode) {
        this.j.a(gameMode);
    }

    public ServerConnection ai() {
        return this.G == null ? (this.G = new ServerConnection(this)) : this.G;
    }

    public boolean aj() {
        return this.ag;
    }

    public boolean ak() {
        return false;
    }

    public boolean a(@Nullable EnumGamemode gameMode, boolean cheatsAllowed, int port) {
        return false;
    }

    public int al() {
        return this.T;
    }

    public int am() {
        return 16;
    }

    public boolean a(WorldServer world, BlockPosition pos, EntityHuman player) {
        return false;
    }

    public boolean an() {
        return true;
    }

    public boolean ao() {
        return false;
    }

    public Proxy ap() {
        return this.h;
    }

    public int aq() {
        return this.aa;
    }

    public void c(int playerIdleTimeout) {
        this.aa = playerIdleTimeout;
    }

    public MinecraftSessionService ar() {
        return this.i.c();
    }

    @Nullable
    public SignatureValidator as() {
        return this.i.a();
    }

    public GameProfileRepository at() {
        return this.i.e();
    }

    @Nullable
    public UserCache au() {
        return this.i.f();
    }

    @Nullable
    public ServerPing av() {
        return this.I;
    }

    public void aw() {
        this.ai = 0L;
    }

    public int ax() {
        return 29999984;
    }

    @Override
    public boolean ay() {
        return super.ay() && !this.ag();
    }

    @Override
    public void c(Runnable runnable) {
        if (this.ag()) {
            throw new ServerStopRejectedExecutionException("Server already shutting down");
        }
        super.c(runnable);
    }

    @Override
    public Thread az() {
        return this.aj;
    }

    public int aA() {
        return 256;
    }

    public boolean aB() {
        return false;
    }

    public long aC() {
        return this.an;
    }

    public DataFixer aD() {
        return this.L;
    }

    public int a(@Nullable WorldServer world) {
        return world != null ? world.ab().c(GameRules.s) : 10;
    }

    public AdvancementDataWorld aE() {
        return this.az.b.e();
    }

    public CustomFunctionData aF() {
        return this.au;
    }

    @Override
    @Deprecated
    @DoNotUse
    public CompletableFuture<Void> a(Collection<String> dataPacks) {
        return this.reloadResources(dataPacks, ServerResourcesReloadedEvent.Cause.PLUGIN);
    }

    public CompletableFuture<Void> reloadResources(Collection<String> dataPacks, ServerResourcesReloadedEvent.Cause cause) {
        CompletionStage completablefuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Stream stream = dataPacks.stream();
            ResourcePackRepository resourcepackrepository = this.aq;
            Objects.requireNonNull(this.aq);
            return (ImmutableList)stream.map(resourcepackrepository::c).filter(Objects::nonNull).map(ResourcePackLoader::f).collect(ImmutableList.toImmutableList());
        }, this).thenCompose(immutablelist -> {
            ResourceManager resourcemanager = new ResourceManager(EnumResourcePackType.b, (List<IResourcePack>)immutablelist);
            return ((CompletableFuture)DataPackResources.a(resourcemanager, this.O, this.j.K(), this.n() ? CommandDispatcher.ServerType.b : CommandDispatcher.ServerType.c, this.l(), this.ax, this).whenComplete((datapackresources, throwable) -> {
                if (throwable != null) {
                    resourcemanager.close();
                }
            })).thenApply(datapackresources -> new ReloadableResources(resourcemanager, (DataPackResources)datapackresources));
        })).thenAcceptAsync(minecraftserver_reloadableresources -> {
            PaperBrigadier.moveBukkitCommands(this.az.b().d(), minecraftserver_reloadableresources.b().e);
            this.az.close();
            this.az = minecraftserver_reloadableresources;
            this.aq.b(dataPacks);
            WorldDataConfiguration worlddataconfiguration = new WorldDataConfiguration(MinecraftServer.a(this.aq, true), this.j.K());
            this.j.a(worlddataconfiguration);
            this.az.b.g();
            this.aC = this.aC.reload(this.j.K());
            if (Thread.currentThread() != this.aj) {
                return;
            }
            for (EntityPlayer player : this.ah().t()) {
                player.R().b();
            }
            this.ah().u();
            this.au.a(this.az.b.a());
            this.aA.a(this.az.a);
            CraftBlockData.reloadCache();
            PaperCommands.INSTANCE.setValid();
            LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, Plugin.class, ReloadableRegistrarEvent.Cause.RELOAD);
            SimpleHelpMap helpMap = (SimpleHelpMap)this.server.getHelpMap();
            helpMap.clear();
            helpMap.initializeGeneralTopics();
            helpMap.initializeCommands();
            this.server.syncCommands();
            new ServerResourcesReloadedEvent(cause).callEvent();
        }, (Executor)this);
        if (this.bx()) {
            Objects.requireNonNull(completablefuture);
            this.b(((CompletableFuture)completablefuture)::isDone);
        }
        return completablefuture;
    }

    public static WorldDataConfiguration a(ResourcePackRepository resourcePackManager, WorldDataConfiguration dataConfiguration, boolean initMode, boolean safeMode) {
        DataPackConfiguration datapackconfiguration = dataConfiguration.a();
        FeatureFlagSet featureflagset = initMode ? FeatureFlagSet.a() : dataConfiguration.b();
        FeatureFlagSet featureflagset1 = initMode ? FeatureFlags.d.a() : dataConfiguration.b();
        resourcePackManager.a();
        if (safeMode) {
            return MinecraftServer.a(resourcePackManager, List.of(b), featureflagset, false);
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String s2 : datapackconfiguration.a()) {
            if (resourcePackManager.d(s2)) {
                set.add(s2);
                continue;
            }
            k.warn("Missing data pack {}", (Object)s2);
        }
        for (ResourcePackLoader resourcepackloader : resourcePackManager.c()) {
            String s1 = resourcepackloader.g();
            if (datapackconfiguration.b().contains(s1)) continue;
            FeatureFlagSet featureflagset2 = resourcepackloader.e();
            boolean flag2 = set.contains(s1);
            if (!flag2 && resourcepackloader.l().a()) {
                if (featureflagset2.a(featureflagset1)) {
                    k.info("Found new data pack {}, loading it automatically", (Object)s1);
                    set.add(s1);
                } else {
                    k.info("Found new data pack {}, but can't load it due to missing features {}", (Object)s1, (Object)FeatureFlags.a(featureflagset1, featureflagset2));
                }
            }
            if (!flag2 || featureflagset2.a(featureflagset1)) continue;
            k.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)s1, (Object)FeatureFlags.a(featureflagset1, featureflagset2));
            set.remove(s1);
        }
        if (set.isEmpty()) {
            k.info("No datapacks selected, forcing vanilla");
            set.add(b);
        }
        return MinecraftServer.a(resourcePackManager, set, featureflagset, true);
    }

    private static WorldDataConfiguration a(ResourcePackRepository resourcePackManager, Collection<String> enabledProfiles, FeatureFlagSet enabledFeatures, boolean allowEnabling) {
        resourcePackManager.b(enabledProfiles);
        MinecraftServer.a(resourcePackManager, enabledFeatures);
        DataPackConfiguration datapackconfiguration = MinecraftServer.a(resourcePackManager, allowEnabling);
        FeatureFlagSet featureflagset1 = resourcePackManager.e().c(enabledFeatures);
        return new WorldDataConfiguration(datapackconfiguration, featureflagset1);
    }

    private static void a(ResourcePackRepository resourcePackManager, FeatureFlagSet enabledFeatures) {
        FeatureFlagSet featureflagset1 = resourcePackManager.e();
        FeatureFlagSet featureflagset2 = enabledFeatures.d(featureflagset1);
        if (!featureflagset2.b()) {
            ObjectArraySet set = new ObjectArraySet(resourcePackManager.d());
            for (ResourcePackLoader resourcepackloader : resourcePackManager.c()) {
                if (featureflagset2.b()) break;
                if (resourcepackloader.l() != PackSource.d) continue;
                String s2 = resourcepackloader.g();
                FeatureFlagSet featureflagset3 = resourcepackloader.e();
                if (featureflagset3.b() || !featureflagset3.b(featureflagset2) || !featureflagset3.a(enabledFeatures)) continue;
                if (!set.add(s2)) {
                    throw new IllegalStateException("Tried to force '" + s2 + "', but it was already enabled");
                }
                k.info("Found feature pack ('{}') for requested feature, forcing to enabled", (Object)s2);
                featureflagset2 = featureflagset2.d(featureflagset3);
            }
            resourcePackManager.b((Collection<String>)set);
        }
    }

    private static DataPackConfiguration a(ResourcePackRepository dataPackManager, boolean allowEnabling) {
        Collection<String> collection = dataPackManager.d();
        ImmutableList list = ImmutableList.copyOf(collection);
        List<String> list1 = allowEnabling ? dataPackManager.b().stream().filter(s2 -> !collection.contains(s2)).toList() : List.of();
        return new DataPackConfiguration((List<String>)list, list1);
    }

    @Override
    public void a(CommandListenerWrapper source) {
        if (this.aO()) {
            PlayerList playerlist = source.l().ah();
            WhiteList whitelist = playerlist.i();
            if (!((DedicatedServer)MinecraftServer.getServer()).a().X.get().booleanValue()) {
                return;
            }
            ArrayList list = Lists.newArrayList(playerlist.t());
            for (EntityPlayer entityplayer : list) {
                if (whitelist.a(entityplayer.fX()) || this.ah().f(entityplayer.fX())) continue;
                entityplayer.c.disconnect((Component)Component.text((String)SpigotConfig.whitelistMessage), PlayerKickEvent.Cause.WHITELIST);
            }
        }
    }

    public ResourcePackRepository aG() {
        return this.aq;
    }

    public CommandDispatcher aH() {
        return this.az.b.d();
    }

    public CommandListenerWrapper aI() {
        WorldServer worldserver = this.I();
        return new CommandListenerWrapper(this, worldserver == null ? Vec3D.b : Vec3D.a(worldserver.V()), Vec2F.a, worldserver, 4, "Server", IChatBaseComponent.b("Server"), this, null);
    }

    @Override
    public boolean k_() {
        return true;
    }

    @Override
    public boolean w_() {
        return true;
    }

    @Override
    public abstract boolean M_();

    public CraftingManager aJ() {
        return this.az.b.c();
    }

    public ScoreboardServer aK() {
        return this.ar;
    }

    public PersistentCommandStorage aL() {
        if (this.as == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.as;
    }

    public GameRules aM() {
        return this.I().ab();
    }

    public BossBattleCustomData aN() {
        return this.at;
    }

    public boolean aO() {
        return this.av;
    }

    public void h(boolean enforceWhitelist) {
        this.av = enforceWhitelist;
    }

    public float aP() {
        return this.aw;
    }

    public ServerTickRateManager aQ() {
        return this.aB;
    }

    public long aR() {
        return this.ac / (long)Math.min(100, Math.max(this.T, 1));
    }

    public long[] aS() {
        return this.ab;
    }

    public int c(GameProfile profile) {
        if (this.ah().f(profile)) {
            OpListEntry oplistentry = (OpListEntry)this.ah().k().b(profile);
            return oplistentry != null ? oplistentry.a() : (this.a(profile) ? 4 : (this.T() ? (this.ah().v() ? 4 : 0) : this.k()));
        }
        return 0;
    }

    public GameProfilerFiller aT() {
        return this.A;
    }

    public abstract boolean a(GameProfile var1);

    @Override
    public void a(Path file) throws IOException {
    }

    private void b(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<ResourceKey<net.minecraft.world.level.World>, WorldServer> entry : this.P.entrySet()) {
                MinecraftKey minecraftkey = entry.getKey().a();
                Path path2 = path1.resolve(minecraftkey.b()).resolve(minecraftkey.a());
                java.nio.file.Files.createDirectories(path2, new FileAttribute[0]);
                entry.getValue().a(path2);
            }
            this.d(path.resolve("gamerules.txt"));
            this.e(path.resolve("classpath.txt"));
            this.c(path.resolve("stats.txt"));
            this.f(path.resolve("threads.txt"));
            this.a(path.resolve("server.properties.txt"));
            this.g(path.resolve("modules.txt"));
        }
        catch (IOException ioexception) {
            k.warn("Failed to save debug report", (Throwable)ioexception);
        }
    }

    private void c(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.by()));
            bufferedwriter.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.aP())));
            bufferedwriter.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.ab)));
            bufferedwriter.write(String.format(Locale.ROOT, "queue: %s\n", SystemUtils.g()));
        }
    }

    @Override
    private void d(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gamerules = this.aM();
            GameRules.a(new GameRules.GameRuleVisitor(){

                @Override
                public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                    list.add(String.format(Locale.ROOT, "%s=%s\n", key.a(), gamerules.a(key)));
                }
            });
            for (String s2 : list) {
                bufferedwriter.write(s2);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            String s2 = System.getProperty("java.class.path");
            String s1 = System.getProperty("path.separator");
            for (String s22 : Splitter.on((String)s1).split((CharSequence)s2)) {
                bufferedwriter.write(s22);
                bufferedwriter.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
        Arrays.sort(athreadinfo, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            ThreadInfo[] athreadinfo1 = athreadinfo;
            int i2 = athreadinfo.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                ThreadInfo threadinfo = athreadinfo1[j2];
                bufferedwriter.write(threadinfo.toString());
                bufferedwriter.write(10);
            }
        }
    }

    private void g(Path path) throws IOException {
        block11: {
            block10: {
                try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
                    ArrayList arraylist;
                    try {
                        arraylist = Lists.newArrayList(NativeModuleLister.a());
                    }
                    catch (Throwable throwable) {
                        k.warn("Failed to list native modules", throwable);
                        break block10;
                    }
                    arraylist.sort(Comparator.comparing(nativemodulelister_a -> nativemodulelister_a.a));
                    Iterator iterator = arraylist.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            break block11;
                        }
                        NativeModuleLister.a nativemodulelister_a2 = (NativeModuleLister.a)iterator.next();
                        bufferedwriter.write(nativemodulelister_a2.toString());
                        bufferedwriter.write(10);
                    }
                }
            }
            return;
        }
    }

    @Override
    public boolean bx() {
        return TickThread.isTickThread();
    }

    public boolean isDebugging() {
        return false;
    }

    public static MinecraftServer getServer() {
        return SERVER;
    }

    @Deprecated
    public static IRegistryCustom getDefaultRegistryAccess() {
        return CraftRegistry.getMinecraftRegistry();
    }

    private void bI() {
        if (this.D) {
            this.z = ActiveMetricsRecorder.a(new ServerMetricsSamplersProvider(SystemUtils.c, this.n()), SystemUtils.c, SystemUtils.h(), new MetricsPersister("server"), this.B, path -> {
                this.h(() -> this.b(path.resolve("server")));
                this.C.accept((Path)path);
            });
            this.D = false;
        }
        this.A = GameProfilerTick.a(this.z.f(), GameProfilerTick.a("Server"));
        this.z.c();
        this.A.a();
    }

    public void aU() {
        this.A.b();
        this.z.d();
    }

    public boolean aV() {
        return this.z.e();
    }

    public void a(Consumer<MethodProfilerResults> resultConsumer, Consumer<Path> dumpConsumer) {
        this.B = methodprofilerresults -> {
            this.aW();
            resultConsumer.accept((MethodProfilerResults)methodprofilerresults);
        };
        this.C = dumpConsumer;
        this.D = true;
    }

    public void aW() {
        this.z = InactiveMetricsRecorder.a;
    }

    public void aX() {
        this.z.a();
    }

    public void aY() {
        this.z.b();
        this.A = this.z.f();
    }

    public Path a(SavedFile worldSavePath) {
        return this.f.a(worldSavePath);
    }

    public boolean aZ() {
        return true;
    }

    public StructureTemplateManager ba() {
        return this.aA;
    }

    public SaveData bb() {
        return this.j;
    }

    public IRegistryCustom.Dimension bc() {
        return this.O.a();
    }

    public LayeredRegistryAccess<RegistryLayer> bd() {
        return this.O;
    }

    public ReloadableServerRegistries.b be() {
        return this.az.b.b();
    }

    public ITextFilter a(EntityPlayer player) {
        return ITextFilter.a;
    }

    public PlayerInteractManager b(EntityPlayer player) {
        return this.W() ? new DemoPlayerInteractManager(player) : new PlayerInteractManager(player);
    }

    @Nullable
    public EnumGamemode bf() {
        return null;
    }

    public IResourceManager bg() {
        return this.az.a;
    }

    public boolean bh() {
        return this.aD;
    }

    public boolean bi() {
        return this.F || this.E != null;
    }

    public void bj() {
        this.F = true;
    }

    public MethodProfilerResults bk() {
        if (this.E == null) {
            return MethodProfilerResultsEmpty.a;
        }
        MethodProfilerResults methodprofilerresults = this.E.a(SystemUtils.d(), this.T);
        this.E = null;
        return methodprofilerresults;
    }

    public int bl() {
        return 1000000;
    }

    public void a(IChatBaseComponent message, ChatMessageType.a params, @Nullable String prefix) {
        Component s1 = PaperAdventure.asAdventure(params.a(message));
        if (prefix != null) {
            COMPONENT_LOGGER.info("[{}] {}", (Object)prefix, (Object)s1);
        } else {
            COMPONENT_LOGGER.info("{}", (Object)s1);
        }
    }

    public ChatDecorator bm() {
        return this.improvedChatDecorator;
    }

    public boolean bn() {
        return true;
    }

    public void a(EntityPlayer player, RemoteDebugSampleType type) {
    }

    public boolean bo() {
        return false;
    }

    private void a(CrashReport report, ChunkCoordIntPair pos, RegionStorageInfo key) {
        SystemUtils.h().execute(() -> {
            try {
                Path path = this.c("debug");
                FileUtils.c(path);
                String s2 = FileUtils.a(key.a());
                Path path1 = path.resolve("chunk-" + s2 + "-" + SystemUtils.f() + "-server.txt");
                FileStore filestore = java.nio.file.Files.getFileStore(path);
                long i2 = filestore.getUsableSpace();
                if (i2 < 8192L) {
                    k.warn("Not storing chunk IO report due to low space on drive {}", (Object)filestore.name());
                    return;
                }
                CrashReportSystemDetails crashreportsystemdetails = report.a("Chunk Info");
                Objects.requireNonNull(key);
                crashreportsystemdetails.a("Level", key::a);
                crashreportsystemdetails.a("Dimension", () -> key.b().a().toString());
                Objects.requireNonNull(key);
                crashreportsystemdetails.a("Storage", key::c);
                Objects.requireNonNull(pos);
                crashreportsystemdetails.a("Position", pos::toString);
                report.a(path1, ReportType.e);
                k.info("Saved details to {}", (Object)report.e());
            }
            catch (Exception exception) {
                k.warn("Failed to store chunk IO exception", (Throwable)exception);
            }
        });
    }

    @Override
    public void a(Throwable exception, RegionStorageInfo key, ChunkCoordIntPair chunkPos) {
        k.error("Failed to load chunk {},{}", new Object[]{chunkPos.e, chunkPos.f, exception});
        this.a(CrashReport.a(exception, "Chunk load failure"), chunkPos, key);
    }

    @Override
    public void b(Throwable exception, RegionStorageInfo key, ChunkCoordIntPair chunkPos) {
        k.error("Failed to save chunk {},{}", new Object[]{chunkPos.e, chunkPos.f, exception});
        this.a(CrashReport.a(exception, "Chunk save failure"), chunkPos, key);
    }

    public PotionBrewer bp() {
        return this.aC;
    }

    public ServerLinks bq() {
        return ServerLinks.a;
    }

    private static /* synthetic */ boolean lambda$stopServer$9() {
        return true;
    }

    private static /* synthetic */ boolean lambda$stopServer$8(WorldServer worldserver1) {
        return worldserver1.l().a.e();
    }

    static {
        k = LogUtils.getLogger();
        COMPONENT_LOGGER = ComponentLogger.logger((String)k.getName());
        n = 30L * TimeRange.a / 20L;
        p = 10L * TimeRange.a;
        r = 5L * TimeRange.a;
        s = 10L * TimeRange.b;
        d = new WorldSettings("Demo World", EnumGamemode.a, false, EnumDifficulty.c, false, new GameRules(), WorldDataConfiguration.c);
        e = new GameProfile(SystemUtils.e, "Anonymous Player");
        aE = new AtomicReference();
        currentTickLong = 0L;
        TPS_BASE = new BigDecimal(1.0E9).multiply(new BigDecimal(20));
    }

    public static class TickTimes {
        private final long[] times;

        public TickTimes(int length) {
            this.times = new long[length];
        }

        void add(int index, long time) {
            this.times[index % this.times.length] = time;
        }

        public long[] getTimes() {
            return (long[])this.times.clone();
        }

        public double getAverage() {
            long total = 0L;
            for (long value : this.times) {
                total += value;
            }
            return (double)total / (double)this.times.length * 1.0E-6;
        }
    }

    public static class RollingAverage {
        private final int size;
        private long time;
        private BigDecimal total;
        private int index = 0;
        private final BigDecimal[] samples;
        private final long[] times;

        RollingAverage(int size) {
            this.size = size;
            this.time = (long)size * 1000000000L;
            this.total = RollingAverage.dec(20L).multiply(RollingAverage.dec(1000000000L)).multiply(RollingAverage.dec(size));
            this.samples = new BigDecimal[size];
            this.times = new long[size];
            for (int i2 = 0; i2 < size; ++i2) {
                this.samples[i2] = RollingAverage.dec(20L);
                this.times[i2] = 1000000000L;
            }
        }

        private static BigDecimal dec(long t2) {
            return new BigDecimal(t2);
        }

        public void add(BigDecimal x2, long t2) {
            this.time -= this.times[this.index];
            this.total = this.total.subtract(this.samples[this.index].multiply(RollingAverage.dec(this.times[this.index])));
            this.samples[this.index] = x2;
            this.times[this.index] = t2;
            this.time += t2;
            this.total = this.total.add(x2.multiply(RollingAverage.dec(t2)));
            if (++this.index == this.size) {
                this.index = 0;
            }
        }

        public double getAverage() {
            return this.total.divide(RollingAverage.dec(this.time), 30, RoundingMode.HALF_UP).doubleValue();
        }
    }

    public record ReloadableResources(IReloadableResourceManager a, DataPackResources b) implements AutoCloseable
    {
        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this, o2);
        }
    }

    private static class TimeProfiler {
        final long a;
        final int b;

        TimeProfiler(long time, int tick) {
            this.a = time;
            this.b = tick;
        }

        MethodProfilerResults a(final long endTime, final int endTick) {
            return new MethodProfilerResults(){

                @Override
                public List<MethodProfilerResultsField> a(String parentPath) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path path) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return endTime;
                }

                @Override
                public int d() {
                    return endTick;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }

    public record ServerResourcePackInfo(UUID a, String b, String c, boolean d, @Nullable IChatBaseComponent e) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this, o2);
        }
    }
}

