/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.util.thread.IAsyncTaskHandler;
import org.slf4j.Logger;

public class PlayerConnectionUtils {
    private static final Logger a = LogUtils.getLogger();

    public static <T extends PacketListener> void a(Packet<T> packet, T listener, WorldServer world) throws CancelledPacketHandleException {
        PlayerConnectionUtils.a(packet, listener, world.o());
    }

    public static <T extends PacketListener> void a(Packet<T> packet, T listener, IAsyncTaskHandler<?> engine) throws CancelledPacketHandleException {
        if (!engine.bx()) {
            engine.c(() -> {
                if (listener instanceof ServerCommonPacketListenerImpl) {
                    ServerCommonPacketListenerImpl serverCommonPacketListener = (ServerCommonPacketListenerImpl)listener;
                    if (serverCommonPacketListener.processedDisconnect) {
                        return;
                    }
                }
                if (listener.a(packet)) {
                    Timing timing = MinecraftTimings.getPacketTiming(packet);
                    try (Timing ignored = timing.startTiming();){
                        packet.a(listener);
                    }
                    catch (Exception exception) {
                        ReportedException reportedexception;
                        if (exception instanceof ReportedException && (reportedexception = (ReportedException)exception).getCause() instanceof OutOfMemoryError) {
                            throw PlayerConnectionUtils.a(exception, packet, listener);
                        }
                        listener.a(packet, exception);
                    }
                } else {
                    a.debug("Ignoring packet due to disconnection: {}", (Object)packet);
                }
            });
            throw CancelledPacketHandleException.a;
        }
    }

    public static <T extends PacketListener> ReportedException a(Exception exception, Packet<T> packet, T listener) {
        if (exception instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)exception;
            PlayerConnectionUtils.a(reportedexception.a(), listener, packet);
            return reportedexception;
        }
        CrashReport crashreport = CrashReport.a(exception, "Main thread packet handler");
        PlayerConnectionUtils.a(crashreport, listener, packet);
        return new ReportedException(crashreport);
    }

    public static <T extends PacketListener> void a(CrashReport report, T listener, @Nullable Packet<T> packet) {
        if (packet != null) {
            CrashReportSystemDetails crashreportsystemdetails = report.a("Incoming Packet");
            crashreportsystemdetails.a("Type", () -> packet.a().toString());
            crashreportsystemdetails.a("Is Terminal", () -> Boolean.toString(packet.d()));
            crashreportsystemdetails.a("Is Skippable", () -> Boolean.toString(packet.c()));
        }
        listener.a(report);
    }
}

