/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ByteProcessor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PacketDataSerializer
extends ByteBuf {
    public static final int a = 0x200000;
    private final ByteBuf d;
    @Nullable
    public final Locale adventure$locale = PacketEncoder.ADVENTURE_LOCALE.get();
    public static final short b = Short.MAX_VALUE;
    public static final int c = 262144;
    private static final int e = 256;
    private static final int f = 256;
    private static final int g = 512;
    private static final Gson h = new Gson();

    public PacketDataSerializer(ByteBuf parent) {
        this.d = parent;
    }

    @Deprecated
    public <T> T a(DynamicOps<NBTBase> ops, Codec<T> codec) {
        return this.a(ops, codec, NBTReadLimiter.a());
    }

    @Deprecated
    public <T> T a(DynamicOps<NBTBase> ops, Codec<T> codec, NBTReadLimiter sizeTracker) {
        NBTBase nbtbase = this.a(sizeTracker);
        return (T)codec.parse(ops, (Object)nbtbase).getOrThrow(s2 -> new DecoderException("Failed to decode: " + s2 + " " + String.valueOf(nbtbase)));
    }

    @Deprecated
    public <T> PacketDataSerializer a(DynamicOps<NBTBase> ops, Codec<T> codec, T value) {
        NBTBase nbtbase = (NBTBase)codec.encodeStart(ops, value).getOrThrow(s2 -> new EncoderException("Failed to encode: " + s2 + " " + String.valueOf(value)));
        this.a(nbtbase);
        return this;
    }

    public <T> T a(Codec<T> codec) {
        JsonElement jsonelement = ChatDeserializer.a(h, this.p(), JsonElement.class);
        DataResult dataresult = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement);
        return (T)dataresult.getOrThrow(s2 -> new DecoderException("Failed to decode json: " + s2));
    }

    public <T> void a(Codec<T> codec, T value) {
        this.writeJsonWithCodec(codec, value, Short.MAX_VALUE);
    }

    public <T> void writeJsonWithCodec(Codec<T> codec, T value, int maxLength) {
        DataResult dataresult = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value);
        this.a(h.toJson((JsonElement)dataresult.getOrThrow(s2 -> new EncoderException("Failed to encode: " + s2 + " " + String.valueOf(value)))), maxLength);
    }

    public static <T> IntFunction<T> a(IntFunction<T> applier, int max) {
        return j2 -> {
            if (j2 > max) {
                throw new DecoderException("Value " + j2 + " is larger than limit " + max);
            }
            return applier.apply(j2);
        };
    }

    public <T, C extends Collection<T>> C a(IntFunction<C> collectionFactory, StreamDecoder<? super PacketDataSerializer, T> reader) {
        int i2 = this.l();
        Collection c0 = (Collection)collectionFactory.apply(i2);
        for (int j2 = 0; j2 < i2; ++j2) {
            c0.add(reader.decode(this));
        }
        return (C)c0;
    }

    public <T> void a(Collection<T> collection, StreamEncoder<? super PacketDataSerializer, T> writer) {
        this.c(collection.size());
        for (T t0 : collection) {
            writer.encode(this, t0);
        }
    }

    public <T> List<T> a(StreamDecoder<? super PacketDataSerializer, T> reader) {
        return (List)this.a((ByteBuf)((IntFunction<ArrayList>)Lists::newArrayListWithCapacity), (StreamDecoder)reader);
    }

    public IntList a() {
        int i2 = this.l();
        IntArrayList intarraylist = new IntArrayList();
        for (int j2 = 0; j2 < i2; ++j2) {
            intarraylist.add(this.l());
        }
        return intarraylist;
    }

    public void a(IntList list) {
        this.c(list.size());
        list.forEach(this::c);
    }

    public <K, V, M extends Map<K, V>> M a(IntFunction<M> mapFactory, StreamDecoder<? super PacketDataSerializer, K> keyReader, StreamDecoder<? super PacketDataSerializer, V> valueReader) {
        int i2 = this.l();
        Map m0 = (Map)mapFactory.apply(i2);
        for (int j2 = 0; j2 < i2; ++j2) {
            K k0 = keyReader.decode(this);
            V v0 = valueReader.decode(this);
            m0.put(k0, v0);
        }
        return (M)m0;
    }

    public <K, V> Map<K, V> a(StreamDecoder<? super PacketDataSerializer, K> keyReader, StreamDecoder<? super PacketDataSerializer, V> valueReader) {
        return this.a(Maps::newHashMapWithExpectedSize, keyReader, valueReader);
    }

    public <K, V> void a(Map<K, V> map, StreamEncoder<? super PacketDataSerializer, K> keyWriter, StreamEncoder<? super PacketDataSerializer, V> valueWriter) {
        this.c(map.size());
        map.forEach((object, object1) -> {
            keyWriter.encode(this, object);
            valueWriter.encode(this, object1);
        });
    }

    public void a(Consumer<PacketDataSerializer> consumer) {
        int i2 = this.l();
        for (int j2 = 0; j2 < i2; ++j2) {
            consumer.accept(this);
        }
    }

    public <E extends Enum<E>> void a(EnumSet<E> enumSet, Class<E> type) {
        Enum[] ae = (Enum[])type.getEnumConstants();
        BitSet bitset = new BitSet(ae.length);
        for (int i2 = 0; i2 < ae.length; ++i2) {
            bitset.set(i2, enumSet.contains(ae[i2]));
        }
        this.a(bitset, ae.length);
    }

    public <E extends Enum<E>> EnumSet<E> a(Class<E> type) {
        Enum[] ae = (Enum[])type.getEnumConstants();
        BitSet bitset = this.e(ae.length);
        EnumSet<Enum> enumset = EnumSet.noneOf(type);
        for (int i2 = 0; i2 < ae.length; ++i2) {
            if (!bitset.get(i2)) continue;
            enumset.add(ae[i2]);
        }
        return enumset;
    }

    public <T> void a(Optional<T> value, StreamEncoder<? super PacketDataSerializer, T> writer) {
        if (value.isPresent()) {
            this.a(true);
            writer.encode(this, value.get());
        } else {
            this.a(false);
        }
    }

    public <T> Optional<T> b(StreamDecoder<? super PacketDataSerializer, T> reader) {
        return this.readBoolean() ? Optional.of(reader.decode(this)) : Optional.empty();
    }

    @Nullable
    public <T> T c(StreamDecoder<? super PacketDataSerializer, T> reader) {
        return PacketDataSerializer.a(this, reader);
    }

    @Nullable
    public static <T, B extends ByteBuf> T a(B buf, StreamDecoder<? super B, T> reader) {
        return buf.readBoolean() ? (T)reader.decode((B)buf) : null;
    }

    public <T> void a(@Nullable T value, StreamEncoder<? super PacketDataSerializer, T> writer) {
        PacketDataSerializer.a(this, value, writer);
    }

    public static <T, B extends ByteBuf> void a(B buf, @Nullable T value, StreamEncoder<? super B, T> writer) {
        if (value != null) {
            buf.writeBoolean(true);
            writer.encode(buf, value);
        } else {
            buf.writeBoolean(false);
        }
    }

    public byte[] b() {
        return PacketDataSerializer.a(this);
    }

    public static byte[] a(ByteBuf buf) {
        return PacketDataSerializer.a(buf, buf.readableBytes());
    }

    public PacketDataSerializer a(byte[] array) {
        PacketDataSerializer.a((ByteBuf)this, array);
        return this;
    }

    public static void a(ByteBuf buf, byte[] array) {
        VarInt.a(buf, array.length);
        buf.writeBytes(array);
    }

    public byte[] a(int maxSize) {
        return PacketDataSerializer.a((ByteBuf)this, maxSize);
    }

    public static byte[] a(ByteBuf buf, int maxSize) {
        int j2 = VarInt.a(buf);
        if (j2 > maxSize) {
            throw new DecoderException("ByteArray with size " + j2 + " is bigger than allowed " + maxSize);
        }
        byte[] abyte = new byte[j2];
        buf.readBytes(abyte);
        return abyte;
    }

    public PacketDataSerializer a(int[] array) {
        this.c(array.length);
        int[] aint1 = array;
        int i2 = array.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            int k2 = aint1[j2];
            this.c(k2);
        }
        return this;
    }

    public int[] c() {
        return this.b(this.readableBytes());
    }

    public int[] b(int maxSize) {
        int j2 = this.l();
        if (j2 > maxSize) {
            throw new DecoderException("VarIntArray with size " + j2 + " is bigger than allowed " + maxSize);
        }
        int[] aint = new int[j2];
        for (int k2 = 0; k2 < aint.length; ++k2) {
            aint[k2] = this.l();
        }
        return aint;
    }

    public PacketDataSerializer a(long[] array) {
        this.c(array.length);
        long[] along1 = array;
        int i2 = array.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            long k2 = along1[j2];
            this.b(k2);
        }
        return this;
    }

    public long[] d() {
        return this.b((long[])null);
    }

    public long[] b(@Nullable long[] toArray) {
        return this.a(toArray, this.readableBytes() / 8);
    }

    public long[] a(@Nullable long[] toArray, int maxSize) {
        int j2 = this.l();
        if (toArray == null || toArray.length != j2) {
            if (j2 > maxSize) {
                throw new DecoderException("LongArray with size " + j2 + " is bigger than allowed " + maxSize);
            }
            toArray = new long[j2];
        }
        for (int k2 = 0; k2 < toArray.length; ++k2) {
            toArray[k2] = this.readLong();
        }
        return toArray;
    }

    public BlockPosition e() {
        return PacketDataSerializer.b(this);
    }

    public static BlockPosition b(ByteBuf buf) {
        return BlockPosition.d(buf.readLong());
    }

    public PacketDataSerializer a(BlockPosition pos) {
        PacketDataSerializer.a((ByteBuf)this, pos);
        return this;
    }

    public static void a(ByteBuf buf, BlockPosition pos) {
        buf.writeLong(pos.a());
    }

    public ChunkCoordIntPair f() {
        return new ChunkCoordIntPair(this.readLong());
    }

    public PacketDataSerializer a(ChunkCoordIntPair pos) {
        this.b(pos.a());
        return this;
    }

    public SectionPosition g() {
        return SectionPosition.a(this.readLong());
    }

    public PacketDataSerializer a(SectionPosition pos) {
        this.b(pos.s());
        return this;
    }

    public GlobalPos h() {
        ResourceKey<World> resourcekey = this.a(Registries.ba);
        BlockPosition blockposition = this.e();
        return GlobalPos.a(resourcekey, blockposition);
    }

    public void a(GlobalPos pos) {
        this.b(pos.a());
        this.a(pos.b());
    }

    public Vector3f i() {
        return PacketDataSerializer.c(this);
    }

    public static Vector3f c(ByteBuf buf) {
        return new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public void a(Vector3f vector3f) {
        PacketDataSerializer.a((ByteBuf)this, vector3f);
    }

    public static void a(ByteBuf buf, Vector3f vector) {
        buf.writeFloat(vector.x());
        buf.writeFloat(vector.y());
        buf.writeFloat(vector.z());
    }

    public Quaternionf j() {
        return PacketDataSerializer.d(this);
    }

    public static Quaternionf d(ByteBuf buf) {
        return new Quaternionf(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public void a(Quaternionf quaternionf) {
        PacketDataSerializer.a((ByteBuf)this, quaternionf);
    }

    public static void a(ByteBuf buf, Quaternionf quaternion) {
        buf.writeFloat(quaternion.x);
        buf.writeFloat(quaternion.y);
        buf.writeFloat(quaternion.z);
        buf.writeFloat(quaternion.w);
    }

    public Vec3D k() {
        return new Vec3D(this.readDouble(), this.readDouble(), this.readDouble());
    }

    public void a(Vec3D vec) {
        this.a(vec.a());
        this.a(vec.b());
        this.a(vec.c());
    }

    public <T extends Enum<T>> T b(Class<T> enumClass) {
        return (T)((Enum[])enumClass.getEnumConstants())[this.l()];
    }

    public PacketDataSerializer a(Enum<?> instance) {
        return this.c(instance.ordinal());
    }

    public <T> T a(IntFunction<T> idToValue) {
        int i2 = this.l();
        return idToValue.apply(i2);
    }

    public <T> PacketDataSerializer a(ToIntFunction<T> valueToId, T value) {
        int i2 = valueToId.applyAsInt(value);
        return this.c(i2);
    }

    public int l() {
        return VarInt.a(this.d);
    }

    public long m() {
        return VarLong.a(this.d);
    }

    public PacketDataSerializer a(UUID uuid) {
        PacketDataSerializer.a((ByteBuf)this, uuid);
        return this;
    }

    public static void a(ByteBuf buf, UUID uuid) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    public UUID n() {
        return PacketDataSerializer.e(this);
    }

    public static UUID e(ByteBuf buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    public PacketDataSerializer c(int value) {
        VarInt.a(this.d, value);
        return this;
    }

    public PacketDataSerializer a(long value) {
        VarLong.a(this.d, value);
        return this;
    }

    public PacketDataSerializer a(@Nullable NBTBase nbt) {
        PacketDataSerializer.a((ByteBuf)this, nbt);
        return this;
    }

    public static void a(ByteBuf buf, @Nullable NBTBase nbt) {
        if (nbt == null) {
            nbt = NBTTagEnd.b;
        }
        try {
            NBTCompressedStreamTools.a(nbt, (DataOutput)new ByteBufOutputStream(buf));
        }
        catch (Exception ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    @Nullable
    public NBTTagCompound o() {
        return PacketDataSerializer.f(this);
    }

    @Nullable
    public static NBTTagCompound f(ByteBuf buf) {
        NBTBase nbtbase = PacketDataSerializer.a(buf, NBTReadLimiter.a(0x200000L));
        if (nbtbase != null && !(nbtbase instanceof NBTTagCompound)) {
            throw new DecoderException("Not a compound tag: " + String.valueOf(nbtbase));
        }
        return (NBTTagCompound)nbtbase;
    }

    @Nullable
    public static NBTBase a(ByteBuf buf, NBTReadLimiter sizeTracker) {
        try {
            NBTBase nbtbase = NBTCompressedStreamTools.b((DataInput)new ByteBufInputStream(buf), sizeTracker);
            return nbtbase.b() == 0 ? null : nbtbase;
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    @Nullable
    public NBTBase a(NBTReadLimiter sizeTracker) {
        return PacketDataSerializer.a((ByteBuf)this, sizeTracker);
    }

    public String p() {
        return this.d(Short.MAX_VALUE);
    }

    public String d(int maxLength) {
        return Utf8String.a(this.d, maxLength);
    }

    public PacketDataSerializer a(String string) {
        return this.a(string, Short.MAX_VALUE);
    }

    public PacketDataSerializer a(String string, int maxLength) {
        Utf8String.a(this.d, string, maxLength);
        return this;
    }

    public MinecraftKey q() {
        return MinecraftKey.a(this.d(Short.MAX_VALUE));
    }

    public PacketDataSerializer a(MinecraftKey id) {
        this.a(id.toString());
        return this;
    }

    public <T> ResourceKey<T> a(ResourceKey<? extends IRegistry<T>> registryRef) {
        MinecraftKey minecraftkey = this.q();
        return ResourceKey.a(registryRef, minecraftkey);
    }

    public void b(ResourceKey<?> key) {
        this.a(key.a());
    }

    public <T> ResourceKey<? extends IRegistry<T>> r() {
        MinecraftKey minecraftkey = this.q();
        return ResourceKey.a(minecraftkey);
    }

    public Date s() {
        return new Date(this.readLong());
    }

    public PacketDataSerializer a(Date date) {
        this.b(date.getTime());
        return this;
    }

    public Instant t() {
        return Instant.ofEpochMilli(this.readLong());
    }

    public void a(Instant instant) {
        this.b(instant.toEpochMilli());
    }

    public PublicKey u() {
        try {
            return MinecraftEncryption.a(this.a(512));
        }
        catch (CryptographyException cryptographyexception) {
            throw new DecoderException("Malformed public key bytes", (Throwable)cryptographyexception);
        }
    }

    public PacketDataSerializer a(PublicKey publicKey) {
        this.a(publicKey.getEncoded());
        return this;
    }

    public MovingObjectPositionBlock v() {
        BlockPosition blockposition = this.e();
        EnumDirection enumdirection = this.b(EnumDirection.class);
        float f2 = this.readFloat();
        float f1 = this.readFloat();
        float f22 = this.readFloat();
        boolean flag = this.readBoolean();
        return new MovingObjectPositionBlock(new Vec3D((double)blockposition.u() + (double)f2, (double)blockposition.v() + (double)f1, (double)blockposition.w() + (double)f22), enumdirection, blockposition, flag);
    }

    public void a(MovingObjectPositionBlock hitResult) {
        BlockPosition blockposition = hitResult.a();
        this.a(blockposition);
        this.a(hitResult.b());
        Vec3D vec3d = hitResult.e();
        this.a((float)(vec3d.c - (double)blockposition.u()));
        this.a((float)(vec3d.d - (double)blockposition.v()));
        this.a((float)(vec3d.e - (double)blockposition.w()));
        this.a(hitResult.d());
    }

    public BitSet w() {
        return BitSet.valueOf(this.d());
    }

    public void a(BitSet bitSet) {
        this.a(bitSet.toLongArray());
    }

    public BitSet e(int size) {
        byte[] abyte = new byte[MathHelper.e(size, 8)];
        this.b(abyte);
        return BitSet.valueOf(abyte);
    }

    public void a(BitSet bitSet, int size) {
        if (bitSet.length() > size) {
            int j2 = bitSet.length();
            throw new EncoderException("BitSet is larger than expected size (" + j2 + ">" + size + ")");
        }
        byte[] abyte = bitSet.toByteArray();
        this.c(Arrays.copyOf(abyte, MathHelper.e(size, 8)));
    }

    public boolean isContiguous() {
        return this.d.isContiguous();
    }

    public int maxFastWritableBytes() {
        return this.d.maxFastWritableBytes();
    }

    public int capacity() {
        return this.d.capacity();
    }

    public PacketDataSerializer f(int i2) {
        this.d.capacity(i2);
        return this;
    }

    public int maxCapacity() {
        return this.d.maxCapacity();
    }

    public ByteBufAllocator alloc() {
        return this.d.alloc();
    }

    public ByteOrder order() {
        return this.d.order();
    }

    public ByteBuf order(ByteOrder byteorder) {
        return this.d.order(byteorder);
    }

    public ByteBuf unwrap() {
        return this.d;
    }

    public boolean isDirect() {
        return this.d.isDirect();
    }

    public boolean isReadOnly() {
        return this.d.isReadOnly();
    }

    public ByteBuf asReadOnly() {
        return this.d.asReadOnly();
    }

    public int readerIndex() {
        return this.d.readerIndex();
    }

    public PacketDataSerializer g(int i2) {
        this.d.readerIndex(i2);
        return this;
    }

    public int writerIndex() {
        return this.d.writerIndex();
    }

    public PacketDataSerializer h(int i2) {
        this.d.writerIndex(i2);
        return this;
    }

    public PacketDataSerializer a(int i2, int j2) {
        this.d.setIndex(i2, j2);
        return this;
    }

    public int readableBytes() {
        return this.d.readableBytes();
    }

    public int writableBytes() {
        return this.d.writableBytes();
    }

    public int maxWritableBytes() {
        return this.d.maxWritableBytes();
    }

    public boolean isReadable() {
        return this.d.isReadable();
    }

    public boolean isReadable(int i2) {
        return this.d.isReadable(i2);
    }

    public boolean isWritable() {
        return this.d.isWritable();
    }

    public boolean isWritable(int i2) {
        return this.d.isWritable(i2);
    }

    public PacketDataSerializer x() {
        this.d.clear();
        return this;
    }

    public PacketDataSerializer y() {
        this.d.markReaderIndex();
        return this;
    }

    public PacketDataSerializer z() {
        this.d.resetReaderIndex();
        return this;
    }

    public PacketDataSerializer A() {
        this.d.markWriterIndex();
        return this;
    }

    public PacketDataSerializer B() {
        this.d.resetWriterIndex();
        return this;
    }

    public PacketDataSerializer C() {
        this.d.discardReadBytes();
        return this;
    }

    public PacketDataSerializer D() {
        this.d.discardSomeReadBytes();
        return this;
    }

    public PacketDataSerializer i(int i2) {
        this.d.ensureWritable(i2);
        return this;
    }

    public int ensureWritable(int i2, boolean flag) {
        return this.d.ensureWritable(i2, flag);
    }

    public boolean getBoolean(int i2) {
        return this.d.getBoolean(i2);
    }

    public byte getByte(int i2) {
        return this.d.getByte(i2);
    }

    public short getUnsignedByte(int i2) {
        return this.d.getUnsignedByte(i2);
    }

    public short getShort(int i2) {
        return this.d.getShort(i2);
    }

    public short getShortLE(int i2) {
        return this.d.getShortLE(i2);
    }

    public int getUnsignedShort(int i2) {
        return this.d.getUnsignedShort(i2);
    }

    public int getUnsignedShortLE(int i2) {
        return this.d.getUnsignedShortLE(i2);
    }

    public int getMedium(int i2) {
        return this.d.getMedium(i2);
    }

    public int getMediumLE(int i2) {
        return this.d.getMediumLE(i2);
    }

    public int getUnsignedMedium(int i2) {
        return this.d.getUnsignedMedium(i2);
    }

    public int getUnsignedMediumLE(int i2) {
        return this.d.getUnsignedMediumLE(i2);
    }

    public int getInt(int i2) {
        return this.d.getInt(i2);
    }

    public int getIntLE(int i2) {
        return this.d.getIntLE(i2);
    }

    public long getUnsignedInt(int i2) {
        return this.d.getUnsignedInt(i2);
    }

    public long getUnsignedIntLE(int i2) {
        return this.d.getUnsignedIntLE(i2);
    }

    public long getLong(int i2) {
        return this.d.getLong(i2);
    }

    public long getLongLE(int i2) {
        return this.d.getLongLE(i2);
    }

    public char getChar(int i2) {
        return this.d.getChar(i2);
    }

    public float getFloat(int i2) {
        return this.d.getFloat(i2);
    }

    public double getDouble(int i2) {
        return this.d.getDouble(i2);
    }

    public PacketDataSerializer a(int i2, ByteBuf bytebuf) {
        this.d.getBytes(i2, bytebuf);
        return this;
    }

    public PacketDataSerializer a(int i2, ByteBuf bytebuf, int j2) {
        this.d.getBytes(i2, bytebuf, j2);
        return this;
    }

    public PacketDataSerializer a(int i2, ByteBuf bytebuf, int j2, int k2) {
        this.d.getBytes(i2, bytebuf, j2, k2);
        return this;
    }

    public PacketDataSerializer a(int i2, byte[] abyte) {
        this.d.getBytes(i2, abyte);
        return this;
    }

    public PacketDataSerializer a(int i2, byte[] abyte, int j2, int k2) {
        this.d.getBytes(i2, abyte, j2, k2);
        return this;
    }

    public PacketDataSerializer a(int i2, ByteBuffer bytebuffer) {
        this.d.getBytes(i2, bytebuffer);
        return this;
    }

    public PacketDataSerializer a(int i2, OutputStream outputstream, int j2) throws IOException {
        this.d.getBytes(i2, outputstream, j2);
        return this;
    }

    public int getBytes(int i2, GatheringByteChannel gatheringbytechannel, int j2) throws IOException {
        return this.d.getBytes(i2, gatheringbytechannel, j2);
    }

    public int getBytes(int i2, FileChannel filechannel, long j2, int k2) throws IOException {
        return this.d.getBytes(i2, filechannel, j2, k2);
    }

    public CharSequence getCharSequence(int i2, int j2, Charset charset) {
        return this.d.getCharSequence(i2, j2, charset);
    }

    public PacketDataSerializer a(int i2, boolean flag) {
        this.d.setBoolean(i2, flag);
        return this;
    }

    public PacketDataSerializer b(int i2, int j2) {
        this.d.setByte(i2, j2);
        return this;
    }

    public PacketDataSerializer c(int i2, int j2) {
        this.d.setShort(i2, j2);
        return this;
    }

    public PacketDataSerializer d(int i2, int j2) {
        this.d.setShortLE(i2, j2);
        return this;
    }

    public PacketDataSerializer e(int i2, int j2) {
        this.d.setMedium(i2, j2);
        return this;
    }

    public PacketDataSerializer f(int i2, int j2) {
        this.d.setMediumLE(i2, j2);
        return this;
    }

    public PacketDataSerializer g(int i2, int j2) {
        this.d.setInt(i2, j2);
        return this;
    }

    public PacketDataSerializer h(int i2, int j2) {
        this.d.setIntLE(i2, j2);
        return this;
    }

    public PacketDataSerializer a(int i2, long j2) {
        this.d.setLong(i2, j2);
        return this;
    }

    public PacketDataSerializer b(int i2, long j2) {
        this.d.setLongLE(i2, j2);
        return this;
    }

    public PacketDataSerializer i(int i2, int j2) {
        this.d.setChar(i2, j2);
        return this;
    }

    public PacketDataSerializer a(int i2, float f2) {
        this.d.setFloat(i2, f2);
        return this;
    }

    public PacketDataSerializer a(int i2, double d0) {
        this.d.setDouble(i2, d0);
        return this;
    }

    public PacketDataSerializer b(int i2, ByteBuf bytebuf) {
        this.d.setBytes(i2, bytebuf);
        return this;
    }

    public PacketDataSerializer b(int i2, ByteBuf bytebuf, int j2) {
        this.d.setBytes(i2, bytebuf, j2);
        return this;
    }

    public PacketDataSerializer b(int i2, ByteBuf bytebuf, int j2, int k2) {
        this.d.setBytes(i2, bytebuf, j2, k2);
        return this;
    }

    public PacketDataSerializer b(int i2, byte[] abyte) {
        this.d.setBytes(i2, abyte);
        return this;
    }

    public PacketDataSerializer b(int i2, byte[] abyte, int j2, int k2) {
        this.d.setBytes(i2, abyte, j2, k2);
        return this;
    }

    public PacketDataSerializer b(int i2, ByteBuffer bytebuffer) {
        this.d.setBytes(i2, bytebuffer);
        return this;
    }

    public int setBytes(int i2, InputStream inputstream, int j2) throws IOException {
        return this.d.setBytes(i2, inputstream, j2);
    }

    public int setBytes(int i2, ScatteringByteChannel scatteringbytechannel, int j2) throws IOException {
        return this.d.setBytes(i2, scatteringbytechannel, j2);
    }

    public int setBytes(int i2, FileChannel filechannel, long j2, int k2) throws IOException {
        return this.d.setBytes(i2, filechannel, j2, k2);
    }

    public PacketDataSerializer j(int i2, int j2) {
        this.d.setZero(i2, j2);
        return this;
    }

    public int setCharSequence(int i2, CharSequence charsequence, Charset charset) {
        return this.d.setCharSequence(i2, charsequence, charset);
    }

    public boolean readBoolean() {
        return this.d.readBoolean();
    }

    public byte readByte() {
        return this.d.readByte();
    }

    public short readUnsignedByte() {
        return this.d.readUnsignedByte();
    }

    public short readShort() {
        return this.d.readShort();
    }

    public short readShortLE() {
        return this.d.readShortLE();
    }

    public int readUnsignedShort() {
        return this.d.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.d.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.d.readMedium();
    }

    public int readMediumLE() {
        return this.d.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.d.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.d.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.d.readInt();
    }

    public int readIntLE() {
        return this.d.readIntLE();
    }

    public long readUnsignedInt() {
        return this.d.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.d.readUnsignedIntLE();
    }

    public long readLong() {
        return this.d.readLong();
    }

    public long readLongLE() {
        return this.d.readLongLE();
    }

    public char readChar() {
        return this.d.readChar();
    }

    public float readFloat() {
        return this.d.readFloat();
    }

    public double readDouble() {
        return this.d.readDouble();
    }

    public ByteBuf readBytes(int i2) {
        return this.d.readBytes(i2);
    }

    public ByteBuf readSlice(int i2) {
        return this.d.readSlice(i2);
    }

    public ByteBuf readRetainedSlice(int i2) {
        return this.d.readRetainedSlice(i2);
    }

    public PacketDataSerializer g(ByteBuf bytebuf) {
        this.d.readBytes(bytebuf);
        return this;
    }

    public PacketDataSerializer b(ByteBuf bytebuf, int i2) {
        this.d.readBytes(bytebuf, i2);
        return this;
    }

    public PacketDataSerializer a(ByteBuf bytebuf, int i2, int j2) {
        this.d.readBytes(bytebuf, i2, j2);
        return this;
    }

    public PacketDataSerializer b(byte[] abyte) {
        this.d.readBytes(abyte);
        return this;
    }

    public PacketDataSerializer a(byte[] abyte, int i2, int j2) {
        this.d.readBytes(abyte, i2, j2);
        return this;
    }

    public PacketDataSerializer a(ByteBuffer bytebuffer) {
        this.d.readBytes(bytebuffer);
        return this;
    }

    public PacketDataSerializer a(OutputStream outputstream, int i2) throws IOException {
        this.d.readBytes(outputstream, i2);
        return this;
    }

    public int readBytes(GatheringByteChannel gatheringbytechannel, int i2) throws IOException {
        return this.d.readBytes(gatheringbytechannel, i2);
    }

    public CharSequence readCharSequence(int i2, Charset charset) {
        return this.d.readCharSequence(i2, charset);
    }

    public int readBytes(FileChannel filechannel, long i2, int j2) throws IOException {
        return this.d.readBytes(filechannel, i2, j2);
    }

    public PacketDataSerializer j(int i2) {
        this.d.skipBytes(i2);
        return this;
    }

    public PacketDataSerializer a(boolean flag) {
        this.d.writeBoolean(flag);
        return this;
    }

    public PacketDataSerializer k(int i2) {
        this.d.writeByte(i2);
        return this;
    }

    public PacketDataSerializer l(int i2) {
        this.d.writeShort(i2);
        return this;
    }

    public PacketDataSerializer m(int i2) {
        this.d.writeShortLE(i2);
        return this;
    }

    public PacketDataSerializer n(int i2) {
        this.d.writeMedium(i2);
        return this;
    }

    public PacketDataSerializer o(int i2) {
        this.d.writeMediumLE(i2);
        return this;
    }

    public PacketDataSerializer p(int i2) {
        this.d.writeInt(i2);
        return this;
    }

    public PacketDataSerializer q(int i2) {
        this.d.writeIntLE(i2);
        return this;
    }

    public PacketDataSerializer b(long i2) {
        this.d.writeLong(i2);
        return this;
    }

    public PacketDataSerializer c(long i2) {
        this.d.writeLongLE(i2);
        return this;
    }

    public PacketDataSerializer r(int i2) {
        this.d.writeChar(i2);
        return this;
    }

    public PacketDataSerializer a(float f2) {
        this.d.writeFloat(f2);
        return this;
    }

    public PacketDataSerializer a(double d0) {
        this.d.writeDouble(d0);
        return this;
    }

    public PacketDataSerializer h(ByteBuf bytebuf) {
        this.d.writeBytes(bytebuf);
        return this;
    }

    public PacketDataSerializer c(ByteBuf bytebuf, int i2) {
        this.d.writeBytes(bytebuf, i2);
        return this;
    }

    public PacketDataSerializer b(ByteBuf bytebuf, int i2, int j2) {
        this.d.writeBytes(bytebuf, i2, j2);
        return this;
    }

    public PacketDataSerializer c(byte[] abyte) {
        this.d.writeBytes(abyte);
        return this;
    }

    public PacketDataSerializer b(byte[] abyte, int i2, int j2) {
        this.d.writeBytes(abyte, i2, j2);
        return this;
    }

    public PacketDataSerializer b(ByteBuffer bytebuffer) {
        this.d.writeBytes(bytebuffer);
        return this;
    }

    public int writeBytes(InputStream inputstream, int i2) throws IOException {
        return this.d.writeBytes(inputstream, i2);
    }

    public int writeBytes(ScatteringByteChannel scatteringbytechannel, int i2) throws IOException {
        return this.d.writeBytes(scatteringbytechannel, i2);
    }

    public int writeBytes(FileChannel filechannel, long i2, int j2) throws IOException {
        return this.d.writeBytes(filechannel, i2, j2);
    }

    public PacketDataSerializer s(int i2) {
        this.d.writeZero(i2);
        return this;
    }

    public int writeCharSequence(CharSequence charsequence, Charset charset) {
        return this.d.writeCharSequence(charsequence, charset);
    }

    public int indexOf(int i2, int j2, byte b0) {
        return this.d.indexOf(i2, j2, b0);
    }

    public int bytesBefore(byte b0) {
        return this.d.bytesBefore(b0);
    }

    public int bytesBefore(int i2, byte b0) {
        return this.d.bytesBefore(i2, b0);
    }

    public int bytesBefore(int i2, int j2, byte b0) {
        return this.d.bytesBefore(i2, j2, b0);
    }

    public int forEachByte(ByteProcessor byteprocessor) {
        return this.d.forEachByte(byteprocessor);
    }

    public int forEachByte(int i2, int j2, ByteProcessor byteprocessor) {
        return this.d.forEachByte(i2, j2, byteprocessor);
    }

    public int forEachByteDesc(ByteProcessor byteprocessor) {
        return this.d.forEachByteDesc(byteprocessor);
    }

    public int forEachByteDesc(int i2, int j2, ByteProcessor byteprocessor) {
        return this.d.forEachByteDesc(i2, j2, byteprocessor);
    }

    public ByteBuf copy() {
        return this.d.copy();
    }

    public ByteBuf copy(int i2, int j2) {
        return this.d.copy(i2, j2);
    }

    public ByteBuf slice() {
        return this.d.slice();
    }

    public ByteBuf retainedSlice() {
        return this.d.retainedSlice();
    }

    public ByteBuf slice(int i2, int j2) {
        return this.d.slice(i2, j2);
    }

    public ByteBuf retainedSlice(int i2, int j2) {
        return this.d.retainedSlice(i2, j2);
    }

    public ByteBuf duplicate() {
        return this.d.duplicate();
    }

    public ByteBuf retainedDuplicate() {
        return this.d.retainedDuplicate();
    }

    public int nioBufferCount() {
        return this.d.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.d.nioBuffer();
    }

    public ByteBuffer nioBuffer(int i2, int j2) {
        return this.d.nioBuffer(i2, j2);
    }

    public ByteBuffer internalNioBuffer(int i2, int j2) {
        return this.d.internalNioBuffer(i2, j2);
    }

    public ByteBuffer[] nioBuffers() {
        return this.d.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int i2, int j2) {
        return this.d.nioBuffers(i2, j2);
    }

    public boolean hasArray() {
        return this.d.hasArray();
    }

    public byte[] array() {
        return this.d.array();
    }

    public int arrayOffset() {
        return this.d.arrayOffset();
    }

    public boolean hasMemoryAddress() {
        return this.d.hasMemoryAddress();
    }

    public long memoryAddress() {
        return this.d.memoryAddress();
    }

    public String toString(Charset charset) {
        return this.d.toString(charset);
    }

    public String toString(int i2, int j2, Charset charset) {
        return this.d.toString(i2, j2, charset);
    }

    public int hashCode() {
        return this.d.hashCode();
    }

    public boolean equals(Object object) {
        return this.d.equals(object);
    }

    public int compareTo(ByteBuf bytebuf) {
        return this.d.compareTo(bytebuf);
    }

    public String toString() {
        return this.d.toString();
    }

    public PacketDataSerializer t(int i2) {
        this.d.retain(i2);
        return this;
    }

    public PacketDataSerializer E() {
        this.d.retain();
        return this;
    }

    public PacketDataSerializer F() {
        this.d.touch();
        return this;
    }

    public PacketDataSerializer a(Object object) {
        this.d.touch(object);
        return this;
    }

    public int refCnt() {
        return this.d.refCnt();
    }

    public boolean release() {
        return this.d.release();
    }

    public boolean release(int i2) {
        return this.d.release(i2);
    }
}

