/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.EnumChatFormat;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.slf4j.Logger;

public class TextComponentTagVisitor
implements TagVisitor {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 8;
    private static final int c = 64;
    private static final int d = 128;
    private static final ByteCollection e = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private static final EnumChatFormat f = EnumChatFormat.l;
    private static final EnumChatFormat g = EnumChatFormat.k;
    private static final EnumChatFormat h = EnumChatFormat.g;
    private static final EnumChatFormat i = EnumChatFormat.m;
    private static final Pattern j = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String k = "[";
    private static final String l = "]";
    private static final String m = ";";
    private static final String n = " ";
    private static final String o = "{";
    private static final String p = "}";
    private static final String q = "\n";
    private static final String r = ": ";
    private static final String s = String.valueOf(',');
    private static final String t = s + "\n";
    private static final String u = s + " ";
    private static final IChatBaseComponent v = IChatBaseComponent.b("<...>").a(EnumChatFormat.h);
    private static final IChatBaseComponent w = IChatBaseComponent.b("b").a(i);
    private static final IChatBaseComponent x = IChatBaseComponent.b("s").a(i);
    private static final IChatBaseComponent y = IChatBaseComponent.b("I").a(i);
    private static final IChatBaseComponent z = IChatBaseComponent.b("L").a(i);
    private static final IChatBaseComponent A = IChatBaseComponent.b("f").a(i);
    private static final IChatBaseComponent B = IChatBaseComponent.b("d").a(i);
    private static final IChatBaseComponent C = IChatBaseComponent.b("B").a(i);
    private final String D;
    private int E;
    private int F;
    private final IChatMutableComponent G = IChatBaseComponent.i();

    public TextComponentTagVisitor(String prefix) {
        this.D = prefix;
    }

    public IChatBaseComponent a(NBTBase element) {
        element.a(this);
        return this.G;
    }

    @Override
    @Override
    public void a(NBTTagString element) {
        String string = NBTTagString.b(element.s_());
        String string2 = string.substring(0, 1);
        IChatMutableComponent component = IChatBaseComponent.b(string.substring(1, string.length() - 1)).a(g);
        this.G.f(string2).b(component).f(string2);
    }

    @Override
    @Override
    public void a(NBTTagByte element) {
        this.G.b(IChatBaseComponent.b(String.valueOf(element.l())).a(h)).b(w);
    }

    @Override
    @Override
    public void a(NBTTagShort element) {
        this.G.b(IChatBaseComponent.b(String.valueOf(element.l())).a(h)).b(x);
    }

    @Override
    @Override
    public void a(NBTTagInt element) {
        this.G.b(IChatBaseComponent.b(String.valueOf(element.l())).a(h));
    }

    @Override
    @Override
    public void a(NBTTagLong element) {
        this.G.b(IChatBaseComponent.b(String.valueOf(element.l())).a(h)).b(z);
    }

    @Override
    @Override
    public void a(NBTTagFloat element) {
        this.G.b(IChatBaseComponent.b(String.valueOf(element.k())).a(h)).b(A);
    }

    @Override
    @Override
    public void a(NBTTagDouble element) {
        this.G.b(IChatBaseComponent.b(String.valueOf(element.j())).a(h)).b(B);
    }

    @Override
    @Override
    public void a(NBTTagByteArray element) {
        this.G.f(k).b(C).f(m);
        byte[] bs = element.e();
        for (int i2 = 0; i2 < bs.length && i2 < 128; ++i2) {
            IChatMutableComponent mutableComponent = IChatBaseComponent.b(String.valueOf(bs[i2])).a(h);
            this.G.f(n).b(mutableComponent).b(C);
            if (i2 == bs.length - 1) continue;
            this.G.f(s);
        }
        if (bs.length > 128) {
            this.G.b(v);
        }
        this.G.f(l);
    }

    @Override
    @Override
    public void a(NBTTagIntArray element) {
        this.G.f(k).b(y).f(m);
        int[] is = element.g();
        for (int i2 = 0; i2 < is.length && i2 < 128; ++i2) {
            this.G.f(n).b(IChatBaseComponent.b(String.valueOf(is[i2])).a(h));
            if (i2 == is.length - 1) continue;
            this.G.f(s);
        }
        if (is.length > 128) {
            this.G.b(v);
        }
        this.G.f(l);
    }

    @Override
    @Override
    public void a(NBTTagLongArray element) {
        this.G.f(k).b(z).f(m);
        long[] ls = element.g();
        for (int i2 = 0; i2 < ls.length && i2 < 128; ++i2) {
            IChatMutableComponent component = IChatBaseComponent.b(String.valueOf(ls[i2])).a(h);
            this.G.f(n).b(component).b(z);
            if (i2 == ls.length - 1) continue;
            this.G.f(s);
        }
        if (ls.length > 128) {
            this.G.b(v);
        }
        this.G.f(l);
    }

    @Override
    @Override
    public void a(NBTTagList element) {
        if (element.isEmpty()) {
            this.G.f("[]");
            return;
        }
        if (this.F >= 64) {
            this.G.f(k).b(v).f(l);
            return;
        }
        if (e.contains(element.f()) && element.size() <= 8) {
            this.G.f(k);
            for (int i2 = 0; i2 < element.size(); ++i2) {
                if (i2 != 0) {
                    this.G.f(u);
                }
                this.a(element.k(i2), false);
            }
            this.G.f(l);
            return;
        }
        this.G.f(k);
        if (!this.D.isEmpty()) {
            this.G.f(q);
        }
        String string = Strings.repeat((String)this.D, (int)(this.E + 1));
        for (int j2 = 0; j2 < element.size() && j2 < 128; ++j2) {
            this.G.f(string);
            this.a(element.k(j2), true);
            if (j2 == element.size() - 1) continue;
            this.G.f(this.D.isEmpty() ? u : t);
        }
        if (element.size() > 128) {
            this.G.f(string).b(v);
        }
        if (!this.D.isEmpty()) {
            this.G.f(q + Strings.repeat((String)this.D, (int)this.E));
        }
        this.G.f(l);
    }

    @Override
    @Override
    public void a(NBTTagCompound compound) {
        if (compound.g()) {
            this.G.f("{}");
            return;
        }
        if (this.F >= 64) {
            this.G.f(o).b(v).f(p);
            return;
        }
        this.G.f(o);
        Collection<String> collection = compound.e();
        if (a.isDebugEnabled()) {
            ArrayList list = Lists.newArrayList(compound.e());
            Collections.sort(list);
            collection = list;
        }
        if (!this.D.isEmpty()) {
            this.G.f(q);
        }
        String string = Strings.repeat((String)this.D, (int)(this.E + 1));
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            this.G.f(string).b(TextComponentTagVisitor.a(string2)).f(r);
            this.a(compound.c(string2), true);
            if (!iterator.hasNext()) continue;
            this.G.f(this.D.isEmpty() ? u : t);
        }
        if (!this.D.isEmpty()) {
            this.G.f(q + Strings.repeat((String)this.D, (int)this.E));
        }
        this.G.f(p);
    }

    private void a(NBTBase element, boolean indent) {
        if (indent) {
            ++this.E;
        }
        ++this.F;
        try {
            element.a(this);
        }
        finally {
            if (indent) {
                --this.E;
            }
            --this.F;
        }
    }

    protected static IChatBaseComponent a(String name) {
        if (j.matcher(name).matches()) {
            return IChatBaseComponent.b(name).a(f);
        }
        String string = NBTTagString.b(name);
        String string2 = string.substring(0, 1);
        IChatMutableComponent component = IChatBaseComponent.b(string.substring(1, string.length() - 1)).a(f);
        return IChatBaseComponent.b(string2).b(component).f(string2);
    }

    @Override
    @Override
    public void a(NBTTagEnd element) {
    }
}

