/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public class NBTTagLongArray
extends NBTList<NBTTagLong> {
    private static final int b = 24;
    public static final NBTTagType<NBTTagLongArray> a = new NBTTagType.b<NBTTagLongArray>(){

        @Override
        public NBTTagLongArray a(DataInput dataInput, NBTReadLimiter nbtAccounter) throws IOException {
            return new NBTTagLongArray(1.d(dataInput, nbtAccounter));
        }

        @Override
        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter tracker) throws IOException {
            return visitor.a(1.d(input, tracker));
        }

        private static long[] d(DataInput input, NBTReadLimiter tracker) throws IOException {
            tracker.b(24L);
            int i2 = input.readInt();
            tracker.a(8L, i2);
            long[] ls = new long[i2];
            for (int j2 = 0; j2 < i2; ++j2) {
                ls[j2] = input.readLong();
            }
            return ls;
        }

        @Override
        @Override
        public void b(DataInput input, NBTReadLimiter tracker) throws IOException {
            input.skipBytes(input.readInt() * 8);
        }

        @Override
        @Override
        public String a() {
            return "LONG[]";
        }

        @Override
        @Override
        public String b() {
            return "TAG_Long_Array";
        }

        @Override
        public /* synthetic */ NBTBase c(DataInput input, NBTReadLimiter tracker) throws IOException {
            return this.a(input, tracker);
        }
    };
    private long[] c;

    public NBTTagLongArray(long[] value) {
        this.c = value;
    }

    public NBTTagLongArray(LongSet value) {
        this.c = value.toLongArray();
    }

    public NBTTagLongArray(List<Long> value) {
        this(NBTTagLongArray.a(value));
    }

    private static long[] a(List<Long> list) {
        long[] ls = new long[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Long long_ = list.get(i2);
            ls[i2] = long_ == null ? 0L : long_;
        }
        return ls;
    }

    @Override
    @Override
    public void a(DataOutput output) throws IOException {
        output.writeInt(this.c.length);
        for (long l2 : this.c) {
            output.writeLong(l2);
        }
    }

    @Override
    @Override
    public int a() {
        return 24 + 8 * this.c.length;
    }

    @Override
    @Override
    public byte b() {
        return 12;
    }

    @Override
    public NBTTagType<NBTTagLongArray> c() {
        return a;
    }

    @Override
    @Override
    public String toString() {
        return this.s_();
    }

    @Override
    public NBTTagLongArray e() {
        long[] ls = new long[this.c.length];
        System.arraycopy(this.c, 0, ls, 0, this.c.length);
        return new NBTTagLongArray(ls);
    }

    @Override
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof NBTTagLongArray && Arrays.equals(this.c, ((NBTTagLongArray)object).c);
    }

    @Override
    @Override
    public int hashCode() {
        return Arrays.hashCode(this.c);
    }

    @Override
    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    public long[] g() {
        return this.c;
    }

    @Override
    @Override
    public int size() {
        return this.c.length;
    }

    @Override
    public NBTTagLong a(int i2) {
        return NBTTagLong.a(this.c[i2]);
    }

    @Override
    public NBTTagLong a(int i2, NBTTagLong longTag) {
        long l2 = this.c[i2];
        this.c[i2] = longTag.f();
        return NBTTagLong.a(l2);
    }

    @Override
    public void b(int i2, NBTTagLong longTag) {
        this.c = ArrayUtils.add((long[])this.c, (int)i2, (long)longTag.f());
    }

    @Override
    @Override
    public boolean a(int index, NBTBase element) {
        if (element instanceof NBTNumber) {
            this.c[index] = ((NBTNumber)element).f();
            return true;
        }
        return false;
    }

    @Override
    @Override
    public boolean b(int index, NBTBase element) {
        if (element instanceof NBTNumber) {
            this.c = ArrayUtils.add((long[])this.c, (int)index, (long)((NBTNumber)element).f());
            return true;
        }
        return false;
    }

    @Override
    public NBTTagLong b(int i2) {
        long l2 = this.c[i2];
        this.c = ArrayUtils.remove((long[])this.c, (int)i2);
        return NBTTagLong.a(l2);
    }

    @Override
    @Override
    public byte f() {
        return 4;
    }

    @Override
    @Override
    public void clear() {
        this.c = new long[0];
    }

    @Override
    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        return visitor.a(this.c);
    }

    @Override
    public /* synthetic */ NBTBase c(int i2) {
        return this.b(i2);
    }

    @Override
    public /* synthetic */ void c(int i2, NBTBase tag) {
        this.b(i2, (NBTTagLong)tag);
    }

    @Override
    public /* synthetic */ NBTBase d(int i2, NBTBase tag) {
        return this.a(i2, (NBTTagLong)tag);
    }

    @Override
    public /* synthetic */ NBTBase d() {
        return this.e();
    }

    @Override
    public /* synthetic */ Object remove(int i2) {
        return this.b(i2);
    }

    @Override
    public /* synthetic */ void add(int i2, Object object) {
        this.b(i2, (NBTTagLong)object);
    }

    @Override
    public /* synthetic */ Object set(int i2, Object object) {
        return this.a(i2, (NBTTagLong)object);
    }

    @Override
    public /* synthetic */ Object get(int i2) {
        return this.a(i2);
    }
}

