/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.ReportType;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestBatchFactory;
import net.minecraft.gametest.framework.GameTestHarnessBatch;
import net.minecraft.gametest.framework.GameTestHarnessCollector;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListenerLogger;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.debugchart.LocalSampleLogger;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import org.slf4j.Logger;

public class GameTestServer
extends MinecraftServer {
    private static final Logger k = LogUtils.getLogger();
    private static final int l = 20;
    private static final int m = 14999992;
    private static final Services n = new Services(null, ServicesKeySet.EMPTY, null, null);
    private final LocalSampleLogger o = new LocalSampleLogger(4);
    private List<GameTestHarnessBatch> p = new ArrayList<GameTestHarnessBatch>();
    private final List<GameTestHarnessTestFunction> q;
    private final BlockPosition r;
    private final Stopwatch s = Stopwatch.createUnstarted();
    private static final GameRules t = SystemUtils.a(new GameRules(), (? super T gameRules) -> {
        gameRules.a(GameRules.e).set(false, null);
        gameRules.a(GameRules.v).set(false, null);
        gameRules.a(GameRules.o).set(0, null);
        gameRules.a(GameRules.b).set(false, null);
    });
    private static final WorldOptions u = new WorldOptions(0L, false, false);
    @Nullable
    private GameTestHarnessCollector v;

    public static GameTestServer a(Thread thread, Convertable.ConversionSession session, ResourcePackRepository resourcePackManager, Collection<GameTestHarnessTestFunction> batches, BlockPosition pos) {
        if (batches.isEmpty()) {
            throw new IllegalArgumentException("No test functions were given!");
        }
        resourcePackManager.a();
        WorldDataConfiguration worldDataConfiguration = new WorldDataConfiguration(new DataPackConfiguration(new ArrayList<String>(resourcePackManager.b()), List.of()), FeatureFlags.d.a());
        WorldSettings levelSettings = new WorldSettings("Test Level", EnumGamemode.b, false, EnumDifficulty.c, true, t, worldDataConfiguration);
        WorldLoader.d packConfig = new WorldLoader.d(resourcePackManager, worldDataConfiguration, false, true);
        WorldLoader.c initConfig = new WorldLoader.c(packConfig, CommandDispatcher.ServerType.b, 4);
        try {
            k.debug("Starting resource loading");
            Stopwatch stopwatch = Stopwatch.createStarted();
            WorldStem worldStem = (WorldStem)SystemUtils.c(executor -> WorldLoader.a(initConfig, (WorldLoader.a context) -> {
                IRegistry<WorldDimension> registry = new RegistryMaterials<WorldDimension>(Registries.bb, Lifecycle.stable()).m();
                WorldDimensions.b complete = context.c().d(Registries.aY).g(WorldPresets.b).a().a().a(registry);
                return new WorldLoader.b<WorldDataServer>(new WorldDataServer(levelSettings, u, complete.d(), complete.a()), complete.b());
            }, WorldStem::new, SystemUtils.g(), executor)).get();
            stopwatch.stop();
            k.debug("Finished resource loading after {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return new GameTestServer(thread, session, resourcePackManager, worldStem, batches, pos);
        }
        catch (Exception exception) {
            k.warn("Failed to load vanilla datapack, bit oops", (Throwable)exception);
            System.exit(-1);
            throw new IllegalStateException();
        }
    }

    private GameTestServer(Thread serverThread, Convertable.ConversionSession session, ResourcePackRepository dataPackManager, WorldStem saveLoader, Collection<GameTestHarnessTestFunction> testFunctions, BlockPosition pos) {
        super(serverThread, session, dataPackManager, saveLoader, Proxy.NO_PROXY, DataConverterRegistry.a(), n, WorldLoadListenerLogger::b);
        this.q = Lists.newArrayList(testFunctions);
        this.r = pos;
    }

    @Override
    @Override
    public boolean e() {
        this.a(new PlayerList(this, this, this.bd(), this.g, 1){});
        this.loadLevel();
        WorldServer serverLevel = this.I();
        this.p = Lists.newArrayList(GameTestBatchFactory.a(this.q, serverLevel));
        serverLevel.a(this.r, 0.0f);
        int i2 = 20000000;
        serverLevel.a(20000000, 20000000, false, false);
        k.info("Started game test server");
        return true;
    }

    @Override
    @Override
    public void a(BooleanSupplier shouldKeepTicking) {
        super.a(shouldKeepTicking);
        WorldServer serverLevel = this.I();
        if (!this.br()) {
            this.b(serverLevel);
        }
        if (serverLevel.Z() % 20L == 0L) {
            k.info(this.v.j());
        }
        if (this.v.i()) {
            this.a(false);
            k.info(this.v.j());
            GlobalTestReporter.a();
            k.info("========= {} GAME TESTS COMPLETE IN {} ======================", (Object)this.v.h(), (Object)this.s.stop());
            if (this.v.d()) {
                k.info("{} required tests failed :(", (Object)this.v.a());
                this.v.f().forEach(test -> k.info("   - {}", (Object)test.b()));
            } else {
                k.info("All {} required tests passed :)", (Object)this.v.h());
            }
            if (this.v.e()) {
                k.info("{} optional tests failed", (Object)this.v.b());
                this.v.g().forEach(test -> k.info("   - {}", (Object)test.b()));
            }
            k.info("====================================================");
        }
    }

    @Override
    @Override
    public SampleLogger f() {
        return this.o;
    }

    @Override
    @Override
    public boolean g() {
        return false;
    }

    @Override
    @Override
    public void v_() {
        this.bB();
    }

    @Override
    @Override
    public SystemReport a(SystemReport details) {
        details.a("Type", "Game test server");
        return details;
    }

    @Override
    @Override
    public void i() {
        super.i();
        k.info("Game test server shutting down");
        System.exit(this.v.a());
    }

    @Override
    @Override
    public void a(CrashReport report) {
        super.a(report);
        k.error("Game test server crashed\n{}", (Object)report.a(ReportType.a));
        System.exit(1);
    }

    private void b(WorldServer world) {
        BlockPosition blockPos = new BlockPosition(world.z.a(-14999992, 14999992), -59, world.z.a(-14999992, 14999992));
        GameTestHarnessRunner gameTestRunner = GameTestHarnessRunner.a.a(this.p, world).a((GameTestHarnessRunner.c)new StructureGridSpawner(blockPos, 8, false)).a();
        List<GameTestHarnessInfo> collection = gameTestRunner.a();
        this.v = new GameTestHarnessCollector(collection);
        k.info("{} tests are now running at position {}!", (Object)this.v.h(), (Object)blockPos.x());
        this.s.reset();
        this.s.start();
        gameTestRunner.b();
    }

    private boolean br() {
        return this.v != null;
    }

    @Override
    @Override
    public boolean j() {
        return false;
    }

    @Override
    @Override
    public int k() {
        return 0;
    }

    @Override
    @Override
    public int l() {
        return 4;
    }

    @Override
    @Override
    public boolean m() {
        return false;
    }

    @Override
    @Override
    public boolean n() {
        return false;
    }

    @Override
    @Override
    public int o() {
        return 0;
    }

    @Override
    @Override
    public boolean p() {
        return false;
    }

    @Override
    @Override
    public boolean q() {
        return true;
    }

    @Override
    @Override
    public boolean r() {
        return false;
    }

    @Override
    @Override
    public boolean M_() {
        return false;
    }

    @Override
    @Override
    public boolean a(GameProfile profile) {
        return false;
    }
}

