/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.stream.IntStream;
import javax.annotation.concurrent.Immutable;
import net.minecraft.SystemUtils;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.LevelHeightAccessor;

@Immutable
public class BaseBlockPosition
implements Comparable<BaseBlockPosition> {
    public static final Codec<BaseBlockPosition> f = Codec.INT_STREAM.comapFlatMap(stream -> SystemUtils.a(stream, 3).map(coordinates -> new BaseBlockPosition(coordinates[0], coordinates[1], coordinates[2])), vec -> IntStream.of(vec.u(), vec.v(), vec.w()));
    public static final BaseBlockPosition g = new BaseBlockPosition(0, 0, 0);
    protected int a;
    protected int b;
    protected int c;

    public static Codec<BaseBlockPosition> v(int maxAbsValue) {
        return f.validate(vec -> Math.abs(vec.u()) < maxAbsValue && Math.abs(vec.v()) < maxAbsValue && Math.abs(vec.w()) < maxAbsValue ? DataResult.success((Object)vec) : DataResult.error(() -> "Position out of range, expected at most " + maxAbsValue + ": " + String.valueOf(vec)));
    }

    public final boolean isInsideBuildHeightAndWorldBoundsHorizontal(LevelHeightAccessor levelHeightAccessor) {
        return this.u() >= -30000000 && this.w() >= -30000000 && this.u() < 30000000 && this.w() < 30000000 && !levelHeightAccessor.d(this.v());
    }

    public BaseBlockPosition(int x2, int y2, int z2) {
        this.a = x2;
        this.b = y2;
        this.c = z2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof BaseBlockPosition)) return false;
        BaseBlockPosition vec3i = (BaseBlockPosition)object;
        if (this.u() != vec3i.u()) return false;
        if (this.v() != vec3i.v()) return false;
        if (this.w() != vec3i.w()) return false;
        return true;
    }

    public final int hashCode() {
        return (this.v() + this.w() * 31) * 31 + this.u();
    }

    public int i(BaseBlockPosition vec3i) {
        if (this.v() == vec3i.v()) {
            return this.w() == vec3i.w() ? this.u() - vec3i.u() : this.w() - vec3i.w();
        }
        return this.v() - vec3i.v();
    }

    public final int u() {
        return this.a;
    }

    public final int v() {
        return this.b;
    }

    public final int w() {
        return this.c;
    }

    protected BaseBlockPosition u(int x2) {
        this.a = x2;
        return this;
    }

    protected BaseBlockPosition t(int y2) {
        this.b = y2;
        return this;
    }

    protected BaseBlockPosition s(int z2) {
        this.c = z2;
        return this;
    }

    public BaseBlockPosition c(int x2, int y2, int z2) {
        return x2 == 0 && y2 == 0 && z2 == 0 ? this : new BaseBlockPosition(this.u() + x2, this.v() + y2, this.w() + z2);
    }

    public BaseBlockPosition f(BaseBlockPosition vec) {
        return this.c(vec.u(), vec.v(), vec.w());
    }

    public BaseBlockPosition e(BaseBlockPosition vec) {
        return this.c(-vec.u(), -vec.v(), -vec.w());
    }

    public BaseBlockPosition o(int scale) {
        if (scale == 1) {
            return this;
        }
        return scale == 0 ? g : new BaseBlockPosition(this.u() * scale, this.v() * scale, this.w() * scale);
    }

    public BaseBlockPosition q() {
        return this.n(1);
    }

    public BaseBlockPosition n(int distance) {
        return this.b(EnumDirection.b, distance);
    }

    public BaseBlockPosition p() {
        return this.m(1);
    }

    public BaseBlockPosition m(int distance) {
        return this.b(EnumDirection.a, distance);
    }

    public BaseBlockPosition o() {
        return this.l(1);
    }

    public BaseBlockPosition l(int distance) {
        return this.b(EnumDirection.c, distance);
    }

    public BaseBlockPosition n() {
        return this.k(1);
    }

    public BaseBlockPosition k(int distance) {
        return this.b(EnumDirection.d, distance);
    }

    public BaseBlockPosition m() {
        return this.j(1);
    }

    public BaseBlockPosition j(int distance) {
        return this.b(EnumDirection.e, distance);
    }

    public BaseBlockPosition l() {
        return this.i(1);
    }

    public BaseBlockPosition i(int distance) {
        return this.b(EnumDirection.f, distance);
    }

    public BaseBlockPosition b(EnumDirection direction) {
        return this.b(direction, 1);
    }

    public BaseBlockPosition b(EnumDirection direction, int distance) {
        return distance == 0 ? this : new BaseBlockPosition(this.u() + direction.j() * distance, this.v() + direction.k() * distance, this.w() + direction.l() * distance);
    }

    public BaseBlockPosition b(EnumDirection.EnumAxis axis, int distance) {
        if (distance == 0) {
            return this;
        }
        int i2 = axis == EnumDirection.EnumAxis.a ? distance : 0;
        int j2 = axis == EnumDirection.EnumAxis.b ? distance : 0;
        int k2 = axis == EnumDirection.EnumAxis.c ? distance : 0;
        return new BaseBlockPosition(this.u() + i2, this.v() + j2, this.w() + k2);
    }

    public BaseBlockPosition d(BaseBlockPosition vec) {
        return new BaseBlockPosition(this.v() * vec.w() - this.w() * vec.v(), this.w() * vec.u() - this.u() * vec.w(), this.u() * vec.v() - this.v() * vec.u());
    }

    public boolean a(BaseBlockPosition vec, double distance) {
        return this.j(vec) < MathHelper.k(distance);
    }

    public boolean a(IPosition pos, double distance) {
        return this.b(pos) < MathHelper.k(distance);
    }

    public double j(BaseBlockPosition vec) {
        return this.d(vec.u(), vec.v(), vec.w());
    }

    public double b(IPosition pos) {
        return this.c(pos.a(), pos.b(), pos.c());
    }

    public double c(double x2, double y2, double z2) {
        double d2 = (double)this.u() + 0.5 - x2;
        double e2 = (double)this.v() + 0.5 - y2;
        double f2 = (double)this.w() + 0.5 - z2;
        return d2 * d2 + e2 * e2 + f2 * f2;
    }

    public double d(double x2, double y2, double z2) {
        double d2 = (double)this.u() - x2;
        double e2 = (double)this.v() - y2;
        double f2 = (double)this.w() - z2;
        return d2 * d2 + e2 * e2 + f2 * f2;
    }

    public int k(BaseBlockPosition vec) {
        float f2 = Math.abs(vec.u() - this.u());
        float g2 = Math.abs(vec.v() - this.v());
        float h2 = Math.abs(vec.w() - this.w());
        return (int)(f2 + g2 + h2);
    }

    public int a(EnumDirection.EnumAxis axis) {
        return axis.a(this.a, this.b, this.c);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.u()).add("y", this.v()).add("z", this.w()).toString();
    }

    public String x() {
        return this.u() + ", " + this.v() + ", " + this.w();
    }
}

