/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.MappingEnvironment;
import io.papermc.paper.util.ObfHelper;
import io.papermc.paper.util.StringPool;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public enum StacktraceDeobfuscator {
    INSTANCE;

    private final Map<Class<?>, Int2ObjectMap<String>> lineMapCache = Collections.synchronizedMap(new LinkedHashMap<Class<?>, Int2ObjectMap<String>>(128, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Class<?>, Int2ObjectMap<String>> eldest) {
            return this.size() > 127;
        }
    });

    public void deobfuscateThrowable(Throwable throwable) {
        if (!MappingEnvironment.reobf()) {
            return;
        }
        if (GlobalConfiguration.get() != null && !GlobalConfiguration.get().logging.deobfuscateStacktraces) {
            return;
        }
        throwable.setStackTrace(this.deobfuscateStacktrace(throwable.getStackTrace()));
        Throwable cause = throwable.getCause();
        if (cause != null) {
            this.deobfuscateThrowable(cause);
        }
        for (Throwable suppressed : throwable.getSuppressed()) {
            this.deobfuscateThrowable(suppressed);
        }
    }

    public StackTraceElement[] deobfuscateStacktrace(StackTraceElement[] traceElements) {
        if (!MappingEnvironment.reobf()) {
            return traceElements;
        }
        if (GlobalConfiguration.get() != null && !GlobalConfiguration.get().logging.deobfuscateStacktraces) {
            return traceElements;
        }
        @Nullable Map<String, ObfHelper.ClassMapping> mappings = ObfHelper.INSTANCE.mappingsByObfName();
        if (mappings == null || traceElements.length == 0) {
            return traceElements;
        }
        StackTraceElement[] result = new StackTraceElement[traceElements.length];
        for (int i2 = 0; i2 < traceElements.length; ++i2) {
            Class<?> clazz;
            StackTraceElement element = traceElements[i2];
            String className = element.getClassName();
            String methodName = element.getMethodName();
            ObfHelper.ClassMapping classMapping = mappings.get(className);
            if (classMapping == null) {
                result[i2] = element;
                continue;
            }
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            @Nullable String methodKey = this.determineMethodForLine(clazz, element.getLineNumber());
            @Nullable String mappedMethodName = methodKey == null ? null : classMapping.methodsByObf().get(methodKey);
            result[i2] = new StackTraceElement(element.getClassLoaderName(), element.getModuleName(), element.getModuleVersion(), classMapping.mojangName(), mappedMethodName != null ? mappedMethodName : methodName, StacktraceDeobfuscator.sourceFileName(classMapping.mojangName()), element.getLineNumber());
        }
        return result;
    }

    private @Nullable String determineMethodForLine(Class<?> clazz, int lineNumber) {
        return (String)this.lineMapCache.computeIfAbsent(clazz, StacktraceDeobfuscator::buildLineMap).get(lineNumber);
    }

    private static String sourceFileName(String fullClassName) {
        int dot = fullClassName.lastIndexOf(46);
        String className = dot == -1 ? fullClassName : fullClassName.substring(dot + 1);
        String rootClassName = className.split("\\$")[0];
        return rootClassName + ".java";
    }

    private static Int2ObjectMap<String> buildLineMap(Class<?> key) {
        final StringPool pool = new StringPool();
        Int2ObjectOpenHashMap lineMap = new Int2ObjectOpenHashMap();
        ClassVisitor classVisitor = new ClassVisitor(589824, (Int2ObjectMap)lineMap){
            final /* synthetic */ Int2ObjectMap val$lineMap;
            {
                this.val$lineMap = int2ObjectMap;
                super(arg0);
            }

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                final class LineCollectingMethodVisitor
                extends MethodVisitor {
                    private final String name;
                    private final String descriptor;
                    final /* synthetic */ Int2ObjectMap val$lineMap;
                    final /* synthetic */ StringPool val$pool;

                    LineCollectingMethodVisitor(String name, String descriptor) {
                        this.val$lineMap = int2ObjectMap;
                        this.val$pool = stringPool;
                        super(589824);
                        this.name = name;
                        this.descriptor = descriptor;
                    }

                    public void visitLineNumber(int line, Label start) {
                        this.val$lineMap.put(line, (Object)this.val$pool.string(ObfHelper.methodKey(this.name, this.descriptor)));
                    }
                }
                return new LineCollectingMethodVisitor(name, descriptor, this.val$lineMap, pool);
            }
        };
        try {
            byte[] classData;
            @Nullable InputStream inputStream = StacktraceDeobfuscator.class.getClassLoader().getResourceAsStream(key.getName().replace('.', '/') + ".class");
            if (inputStream == null) {
                throw new IllegalStateException("Could not find class file: " + key.getName());
            }
            try (InputStream inputStream2 = inputStream;){
                classData = inputStream.readAllBytes();
            }
            ClassReader reader = new ClassReader(classData);
            reader.accept(classVisitor, 0);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return lineMap;
    }
}

