/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.ItemContainerContents;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DataSanitizationUtil {
    private static final ThreadLocal<DataSanitizer> DATA_SANITIZER = ThreadLocal.withInitial(DataSanitizer::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChargedProjectiles> CHARGED_PROJECTILES = DataSanitizationUtil.codec(ChargedProjectiles.c, DataSanitizationUtil::sanitizeChargedProjectiles);
    public static final StreamCodec<RegistryFriendlyByteBuf, BundleContents> BUNDLE_CONTENTS = DataSanitizationUtil.codec(BundleContents.c, DataSanitizationUtil::sanitizeBundleContents);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemContainerContents> CONTAINER = DataSanitizationUtil.codec(ItemContainerContents.c, contents -> ItemContainerContents.a);

    public static DataSanitizer start(boolean sanitize) {
        DataSanitizer sanitizer = DATA_SANITIZER.get();
        if (sanitize) {
            sanitizer.start();
        }
        return sanitizer;
    }

    private static ChargedProjectiles sanitizeChargedProjectiles(ChargedProjectiles projectiles) {
        if (projectiles.b()) {
            return projectiles;
        }
        List<ItemStack> items = projectiles.a();
        ArrayList<ItemStack> sanitized = new ArrayList<ItemStack>();
        for (int i2 = 0; i2 < Math.min(items.size(), 3); ++i2) {
            sanitized.add(new ItemStack(items.get(i2).h()));
        }
        return ChargedProjectiles.a(sanitized);
    }

    private static BundleContents sanitizeBundleContents(BundleContents contents) {
        int sizeUsed = 0;
        for (ItemStack item : contents.b()) {
            int scale = 64 / item.j();
            sizeUsed += scale * item.H();
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(new ItemStack(Items.qO, sizeUsed));
        return new BundleContents(items);
    }

    private static <B, A> StreamCodec<B, A> codec(StreamCodec<B, A> delegate, UnaryOperator<A> sanitizer) {
        return new DataSanitizationCodec<B, A>(delegate, sanitizer);
    }

    private DataSanitizationUtil() {
    }

    public record DataSanitizer(AtomicBoolean value) implements AutoCloseable
    {
        public DataSanitizer() {
            this(new AtomicBoolean(false));
        }

        public void start() {
            this.value.compareAndSet(false, true);
        }

        @Override
        public void close() {
            this.value.compareAndSet(true, false);
        }
    }

    private record DataSanitizationCodec<B, A>(StreamCodec<B, A> delegate, UnaryOperator<A> sanitizer) implements StreamCodec<B, A>
    {
        @Override
        public @NonNull A decode(@NonNull B buf) {
            return (A)this.delegate.decode(buf);
        }

        @Override
        public void encode(@NonNull B buf, @NonNull A value) {
            if (!DATA_SANITIZER.get().value().get()) {
                this.delegate.encode(buf, value);
            } else {
                this.delegate.encode(buf, this.sanitizer.apply(value));
            }
        }
    }
}

