/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.lifecycle.event.types;

import io.papermc.paper.plugin.lifecycle.event.LifecycleEvent;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import io.papermc.paper.plugin.lifecycle.event.handler.LifecycleEventHandler;
import io.papermc.paper.plugin.lifecycle.event.handler.configuration.AbstractLifecycleEventHandlerConfiguration;
import io.papermc.paper.plugin.lifecycle.event.handler.configuration.MonitorLifecycleEventHandlerConfiguration;
import io.papermc.paper.plugin.lifecycle.event.handler.configuration.MonitorLifecycleEventHandlerConfigurationImpl;
import io.papermc.paper.plugin.lifecycle.event.types.AbstractLifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class MonitorableLifecycleEventType<O extends LifecycleEventOwner, E extends LifecycleEvent>
extends AbstractLifecycleEventType<O, E, MonitorLifecycleEventHandlerConfiguration<O>>
implements LifecycleEventType.Monitorable<O, E> {
    final List<AbstractLifecycleEventType.RegisteredHandler<O, E>> handlers = new ArrayList<AbstractLifecycleEventType.RegisteredHandler<O, E>>();
    int nonMonitorIdx = 0;

    public MonitorableLifecycleEventType(String name, Class<? extends O> ownerType) {
        super(name, ownerType);
    }

    public MonitorLifecycleEventHandlerConfigurationImpl<O, E> newHandler(LifecycleEventHandler<? super E> handler) {
        return new MonitorLifecycleEventHandlerConfigurationImpl(handler, this);
    }

    @Override
    protected void register(O owner, AbstractLifecycleEventHandlerConfiguration<O, E> config) {
        if (!(config instanceof MonitorLifecycleEventHandlerConfigurationImpl)) {
            throw new IllegalArgumentException("Configuration must be a MonitorLifecycleEventHandlerConfiguration");
        }
        MonitorLifecycleEventHandlerConfigurationImpl monitor = (MonitorLifecycleEventHandlerConfigurationImpl)config;
        AbstractLifecycleEventType.RegisteredHandler<O, E> registeredHandler = new AbstractLifecycleEventType.RegisteredHandler<O, E>(owner, config);
        if (!monitor.isMonitor()) {
            this.handlers.add(this.nonMonitorIdx, registeredHandler);
            ++this.nonMonitorIdx;
        } else {
            this.handlers.add(registeredHandler);
        }
    }

    @Override
    public void forEachHandler(E event, Consumer<AbstractLifecycleEventType.RegisteredHandler<O, E>> consumer, Predicate<AbstractLifecycleEventType.RegisteredHandler<O, E>> predicate) {
        for (AbstractLifecycleEventType.RegisteredHandler<O, E> handler : this.handlers) {
            if (!predicate.test(handler)) continue;
            consumer.accept(handler);
        }
    }

    @Override
    public void removeMatching(Predicate<AbstractLifecycleEventType.RegisteredHandler<O, E>> predicate) {
        this.handlers.removeIf(predicate);
    }
}

