/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.lifecycle.event.types;

import io.papermc.paper.plugin.lifecycle.event.LifecycleEvent;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventRunner;
import io.papermc.paper.plugin.lifecycle.event.handler.LifecycleEventHandler;
import io.papermc.paper.plugin.lifecycle.event.handler.configuration.AbstractLifecycleEventHandlerConfiguration;
import io.papermc.paper.plugin.lifecycle.event.handler.configuration.LifecycleEventHandlerConfiguration;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import java.util.function.Consumer;
import java.util.function.Predicate;

public abstract class AbstractLifecycleEventType<O extends LifecycleEventOwner, E extends LifecycleEvent, C extends LifecycleEventHandlerConfiguration<O>>
implements LifecycleEventType<O, E, C> {
    private final String name;
    private final Class<? extends O> ownerType;

    protected AbstractLifecycleEventType(String name, Class<? extends O> ownerType) {
        this.name = name;
        this.ownerType = ownerType;
    }

    public String name() {
        return this.name;
    }

    private void verifyOwner(O owner) {
        if (!this.ownerType.isInstance(owner)) {
            throw new IllegalArgumentException("You cannot register the lifecycle event '" + this.name + "' on " + String.valueOf(owner));
        }
    }

    public abstract void forEachHandler(E var1, Consumer<RegisteredHandler<O, E>> var2, Predicate<RegisteredHandler<O, E>> var3);

    public abstract void removeMatching(Predicate<RegisteredHandler<O, E>> var1);

    protected abstract void register(O var1, AbstractLifecycleEventHandlerConfiguration<O, E> var2);

    public final void tryRegister(O owner, AbstractLifecycleEventHandlerConfiguration<O, E> config) {
        this.verifyOwner(owner);
        LifecycleEventRunner.INSTANCE.checkRegisteredHandler((LifecycleEventOwner)owner, this);
        this.register(owner, config);
    }

    public record RegisteredHandler<O extends LifecycleEventOwner, E extends LifecycleEvent>(O owner, AbstractLifecycleEventHandlerConfiguration<O, E> config) {
        public LifecycleEventHandler<? super E> lifecycleEventHandler() {
            return this.config().handler();
        }
    }
}

