/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin;

import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.plugin.entrypoint.Entrypoint;
import io.papermc.paper.plugin.entrypoint.LaunchEntryPointHandler;
import io.papermc.paper.plugin.provider.PluginProvider;
import io.papermc.paper.plugin.provider.source.DirectoryProviderSource;
import io.papermc.paper.plugin.provider.source.PluginFlagProviderSource;
import io.papermc.paper.plugin.provider.type.paper.PaperPluginParent;
import io.papermc.paper.plugin.util.EntrypointUtil;
import io.papermc.paper.pluginremap.PluginRemapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import joptsimple.OptionSet;
import net.minecraft.server.dedicated.DedicatedServer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.LibraryLoader;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PluginInitializerManager {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    private static PluginInitializerManager impl;
    private final Path pluginDirectory;
    private final Path updateDirectory;
    public final @MonotonicNonNull PluginRemapper pluginRemapper;

    PluginInitializerManager(Path pluginDirectory, Path updateDirectory) {
        this.pluginDirectory = pluginDirectory;
        this.updateDirectory = updateDirectory;
        this.pluginRemapper = Boolean.getBoolean("paper.disable-plugin-rewriting") ? null : PluginRemapper.create(pluginDirectory);
        LibraryLoader.REMAPPER = this.pluginRemapper == null ? Function.identity() : this.pluginRemapper::remapLibraries;
    }

    private static PluginInitializerManager parse(@NotNull OptionSet minecraftOptionSet) throws Exception {
        boolean isSameFile;
        File configFileLocationBukkit = (File)minecraftOptionSet.valueOf("bukkit-settings");
        Path pluginDirectory = ((File)minecraftOptionSet.valueOf("plugins")).toPath();
        YamlConfiguration configuration = PaperConfigurations.loadLegacyConfigFile(configFileLocationBukkit);
        String updateDirectoryName = configuration.getString("settings.update-folder", "update");
        if (updateDirectoryName.isBlank()) {
            return new PluginInitializerManager(pluginDirectory, null);
        }
        Path resolvedUpdateDirectory = pluginDirectory.resolve(updateDirectoryName);
        if (!Files.isDirectory(resolvedUpdateDirectory, new LinkOption[0])) {
            if (Files.exists(resolvedUpdateDirectory, new LinkOption[0])) {
                LOGGER.error("Misconfigured update directory!");
                LOGGER.error("Your configured update directory ({}) in bukkit.yml is pointing to a non-directory path. Auto updating functionality will not work.", (Object)resolvedUpdateDirectory);
            }
            return new PluginInitializerManager(pluginDirectory, null);
        }
        try {
            isSameFile = Files.isSameFile(resolvedUpdateDirectory, pluginDirectory);
        }
        catch (IOException e2) {
            LOGGER.error("Misconfigured update directory!");
            LOGGER.error("Failed to compare update/plugin directory", (Throwable)e2);
            return new PluginInitializerManager(pluginDirectory, null);
        }
        if (isSameFile) {
            LOGGER.error("Misconfigured update directory!");
            LOGGER.error("Your configured update directory (%s) in bukkit.yml is pointing to the same location as the plugin directory (%s). Disabling auto updating functionality.".formatted(resolvedUpdateDirectory, pluginDirectory));
            return new PluginInitializerManager(pluginDirectory, null);
        }
        return new PluginInitializerManager(pluginDirectory, resolvedUpdateDirectory);
    }

    public static PluginInitializerManager init(OptionSet optionSet) throws Exception {
        impl = PluginInitializerManager.parse(optionSet);
        return impl;
    }

    public static PluginInitializerManager instance() {
        return impl;
    }

    @NotNull
    public Path pluginDirectoryPath() {
        return this.pluginDirectory;
    }

    @Nullable
    public Path pluginUpdatePath() {
        return this.updateDirectory;
    }

    public static void load(OptionSet optionSet) throws Exception {
        PluginInitializerManager pluginSystem = PluginInitializerManager.init(optionSet);
        if (pluginSystem.pluginRemapper != null) {
            pluginSystem.pluginRemapper.loadingPlugins();
        }
        EntrypointUtil.registerProvidersFromSource(DirectoryProviderSource.INSTANCE, pluginSystem.pluginDirectoryPath());
        List<Path> files = optionSet.valuesOf("add-plugin").stream().map(File::toPath).toList();
        EntrypointUtil.registerProvidersFromSource(PluginFlagProviderSource.INSTANCE, files);
    }

    public static void reload(DedicatedServer dedicatedServer) {
        LaunchEntryPointHandler.INSTANCE.populateProviderStorage();
        try {
            PluginInitializerManager.load(dedicatedServer.options);
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to reload!", e2);
        }
        boolean hasPaperPlugin = false;
        for (PluginProvider<?> provider : LaunchEntryPointHandler.INSTANCE.getStorage().get(Entrypoint.PLUGIN).getRegisteredProviders()) {
            if (!(provider instanceof PaperPluginParent.PaperServerPluginProvider)) continue;
            hasPaperPlugin = true;
            break;
        }
        if (hasPaperPlugin) {
            LOGGER.warn("======== WARNING ========");
            LOGGER.warn("You are reloading while having Paper plugins installed on your server.");
            LOGGER.warn("Paper plugins do NOT support being reloaded. This will cause some unexpected issues.");
            LOGGER.warn("=========================");
        }
    }
}

