/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.serializer;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.logging.LogUtils;
import io.leangen.geantyref.TypeToken;
import io.papermc.paper.configuration.serializer.collections.MapSerializer;
import io.papermc.paper.util.MappingEnvironment;
import io.papermc.paper.util.ObfHelper;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.network.protocol.Packet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

public final class PacketClassSerializer
extends ScalarSerializer<Class<? extends Packet<?>>>
implements MapSerializer.WriteBack {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    private static final TypeToken<Class<? extends Packet<?>>> TYPE = new TypeToken<Class<? extends Packet<?>>>(){};
    private static final List<String> SUBPACKAGES = List.of("game", "handshake", "login", "status");
    private static final BiMap<String, String> MOJANG_TO_OBF;

    public PacketClassSerializer() {
        super(TYPE);
    }

    public Class<? extends Packet<?>> deserialize(Type type, Object obj) throws SerializationException {
        @Nullable Class<?> packetClass = null;
        for (String subpackage : SUBPACKAGES) {
            String fullClassName = "net.minecraft.network.protocol." + subpackage + "." + String.valueOf(obj);
            try {
                packetClass = Class.forName(fullClassName);
                break;
            }
            catch (ClassNotFoundException ex) {
                @Nullable String spigotClassName = (String)MOJANG_TO_OBF.get((Object)fullClassName);
                if (spigotClassName == null) continue;
                try {
                    packetClass = Class.forName(spigotClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        if (packetClass == null || !Packet.class.isAssignableFrom(packetClass)) {
            throw new SerializationException("Could not deserialize a packet from " + String.valueOf(obj));
        }
        return packetClass;
    }

    protected @Nullable Object serialize(Class<? extends Packet<?>> packetClass, Predicate<Class<?>> typeSupported) {
        int pos;
        String mojName;
        String name = packetClass.getName();
        String string = mojName = ObfHelper.INSTANCE.mappingsByMojangName() == null || !MappingEnvironment.reobf() ? name : (String)MOJANG_TO_OBF.inverse().get((Object)name);
        if (mojName == null && MOJANG_TO_OBF.containsKey((Object)name)) {
            mojName = name;
        }
        if (mojName != null && (pos = mojName.lastIndexOf(46)) != -1 && pos != mojName.length() - 1) {
            return mojName.substring(pos + 1);
        }
        LOGGER.error("Could not serialize {} into a mojang-mapped packet class name", packetClass);
        return null;
    }

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        @Nullable Map<String, ObfHelper.ClassMapping> classMappingMap = ObfHelper.INSTANCE.mappingsByMojangName();
        if (classMappingMap != null) {
            classMappingMap.forEach((mojMap, classMapping) -> {
                if (mojMap.startsWith("net.minecraft.network.protocol.")) {
                    builder.put((Object)classMapping.mojangName(), (Object)classMapping.obfName());
                }
            });
        }
        MOJANG_TO_OBF = builder.build();
    }
}

