/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.brigadier;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.ApiMirrorRootNode;
import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandRegistrationFlag;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.PluginCommandNode;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import io.papermc.paper.plugin.lifecycle.event.registrar.PaperRegistrar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PaperCommands
implements Commands,
PaperRegistrar<LifecycleEventOwner> {
    public static final PaperCommands INSTANCE = new PaperCommands();
    private @org.checkerframework.checker.nullness.qual.Nullable LifecycleEventOwner currentContext;
    private @MonotonicNonNull CommandDispatcher<CommandSourceStack> dispatcher;
    private @MonotonicNonNull CommandBuildContext buildContext;
    private boolean invalid = false;

    @Override
    public void setCurrentContext(@org.checkerframework.checker.nullness.qual.Nullable LifecycleEventOwner context) {
        this.currentContext = context;
    }

    public void setDispatcher(final net.minecraft.commands.CommandDispatcher commands, CommandBuildContext commandBuildContext) {
        this.invalid = false;
        this.dispatcher = new CommandDispatcher<CommandSourceStack>(new ApiMirrorRootNode(this){

            @Override
            public CommandDispatcher<CommandListenerWrapper> getDispatcher() {
                return commands.a();
            }
        });
        this.buildContext = commandBuildContext;
    }

    public void setValid() {
        this.invalid = false;
    }

    @Override
    public void invalidate() {
        this.invalid = true;
    }

    public CommandDispatcher<CommandSourceStack> getDispatcherInternal() {
        Preconditions.checkState((this.dispatcher != null ? 1 : 0) != 0, (Object)"the dispatcher hasn't been set yet");
        return this.dispatcher;
    }

    public CommandBuildContext getBuildContext() {
        Preconditions.checkState((this.buildContext != null ? 1 : 0) != 0, (Object)"the build context hasn't been set yet");
        return this.buildContext;
    }

    public CommandDispatcher<CommandSourceStack> getDispatcher() {
        Preconditions.checkState((!this.invalid && this.dispatcher != null ? 1 : 0) != 0, (Object)"cannot access the dispatcher in this context");
        return this.dispatcher;
    }

    public @Unmodifiable Set<String> register(LiteralCommandNode<CommandSourceStack> node, @org.checkerframework.checker.nullness.qual.Nullable String description, Collection<String> aliases) {
        return this.register(Objects.requireNonNull(this.currentContext, "No lifecycle owner context is set").getPluginMeta(), node, description, aliases);
    }

    public @Unmodifiable Set<String> register(PluginMeta pluginMeta, LiteralCommandNode<CommandSourceStack> node, @org.checkerframework.checker.nullness.qual.Nullable String description, Collection<String> aliases) {
        return this.registerWithFlags(pluginMeta, node, description, aliases, Set.of());
    }

    public @Unmodifiable Set<String> registerWithFlags(@NotNull PluginMeta pluginMeta, @NotNull LiteralCommandNode<CommandSourceStack> node, @Nullable String description, @NotNull Collection<String> aliases, @NotNull Set<CommandRegistrationFlag> flags) {
        boolean hasFlattenRedirectFlag = flags.contains(CommandRegistrationFlag.FLATTEN_ALIASES);
        String identifier = pluginMeta.getName().toLowerCase(Locale.ROOT);
        String literal = node.getLiteral();
        PluginCommandNode pluginLiteral = new PluginCommandNode(identifier + ":" + literal, pluginMeta, node, description);
        HashSet<String> registeredLabels = new HashSet<String>(aliases.size() * 2 + 2);
        if (this.registerIntoDispatcher(pluginLiteral, true)) {
            registeredLabels.add(pluginLiteral.getLiteral());
        }
        if (this.registerRedirect(literal, pluginMeta, pluginLiteral, description, true, hasFlattenRedirectFlag)) {
            registeredLabels.add(literal);
        }
        ArrayList<String> registeredAliases = new ArrayList<String>(aliases.size() * 2);
        for (String alias : aliases) {
            if (this.registerRedirect(alias, pluginMeta, pluginLiteral, description, false, hasFlattenRedirectFlag)) {
                registeredAliases.add(alias);
            }
            if (!this.registerRedirect(identifier + ":" + alias, pluginMeta, pluginLiteral, description, false, hasFlattenRedirectFlag)) continue;
            registeredAliases.add(identifier + ":" + alias);
        }
        if (!registeredAliases.isEmpty()) {
            pluginLiteral.setAliases(registeredAliases);
        }
        registeredLabels.addAll(registeredAliases);
        return registeredLabels.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(registeredLabels);
    }

    private boolean registerRedirect(String aliasLiteral, PluginMeta plugin, PluginCommandNode redirectTo, @org.checkerframework.checker.nullness.qual.Nullable String description, boolean override, boolean hasFlattenRedirectFlag) {
        LiteralCommandNode redirect;
        if (redirectTo.getChildren().isEmpty() || hasFlattenRedirectFlag) {
            redirect = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)aliasLiteral).executes(redirectTo.getCommand())).requires(redirectTo.getRequirement())).build();
            for (CommandNode child : redirectTo.getChildren()) {
                redirect.addChild(child);
            }
        } else {
            redirect = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)aliasLiteral).executes(redirectTo.getCommand())).redirect((CommandNode)((Object)redirectTo))).requires(redirectTo.getRequirement())).build();
        }
        return this.registerIntoDispatcher(new PluginCommandNode(aliasLiteral, plugin, (LiteralCommandNode<CommandSourceStack>)redirect, description), override);
    }

    private boolean registerIntoDispatcher(PluginCommandNode node, boolean override) {
        boolean hasChild;
        boolean bl = hasChild = this.getDispatcher().getRoot().getChild(node.getLiteral()) != null;
        if (!hasChild || override) {
            if (override) {
                this.getDispatcher().getRoot().removeCommand(node.getLiteral());
            }
            this.getDispatcher().getRoot().addChild((CommandNode)((Object)node));
            return true;
        }
        return false;
    }

    public @Unmodifiable Set<String> register(String label, @org.checkerframework.checker.nullness.qual.Nullable String description, Collection<String> aliases, BasicCommand basicCommand) {
        return this.register(Objects.requireNonNull(this.currentContext, "No lifecycle owner context is set").getPluginMeta(), label, description, aliases, basicCommand);
    }

    public @Unmodifiable Set<String> register(PluginMeta pluginMeta, String label, @org.checkerframework.checker.nullness.qual.Nullable String description, Collection<String> aliases, BasicCommand basicCommand) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)label).then(Commands.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((context, suggestionsBuilder) -> {
            String[] args = StringUtils.split((String)suggestionsBuilder.getRemaining());
            SuggestionsBuilder offsetSuggestionsBuilder = suggestionsBuilder.createOffset(suggestionsBuilder.getInput().lastIndexOf(32) + 1);
            Collection suggestions = basicCommand.suggest((CommandSourceStack)context.getSource(), args);
            suggestions.forEach(arg_0 -> ((SuggestionsBuilder)offsetSuggestionsBuilder).suggest(arg_0));
            return offsetSuggestionsBuilder.buildFuture();
        }).executes(stack -> {
            basicCommand.execute((CommandSourceStack)stack.getSource(), StringUtils.split((String)((String)stack.getArgument("args", String.class)), (char)' '));
            return 1;
        }))).executes(stack -> {
            basicCommand.execute((CommandSourceStack)stack.getSource(), new String[0]);
            return 1;
        });
        return this.register(pluginMeta, (LiteralCommandNode<CommandSourceStack>)builder.build(), description, aliases);
    }
}

