/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util.maplist;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.shorts.Short2LongOpenHashMap;
import java.util.Arrays;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.DataPaletteGlobal;

public final class IBlockDataList {
    static final DataPaletteGlobal<IBlockData> GLOBAL_PALETTE = new DataPaletteGlobal<IBlockData>(Block.q);
    private final Short2LongOpenHashMap map = new Short2LongOpenHashMap(2, 0.8f);
    private static final long[] EMPTY_LIST = new long[0];
    private long[] byIndex;
    private int size;

    public IBlockDataList() {
        this.map.defaultReturnValue(Long.MAX_VALUE);
        this.byIndex = EMPTY_LIST;
    }

    public static int getLocationKey(int x2, int y2, int z2) {
        return x2 & 0xF | (z2 & 0xF) << 4 | (y2 & 0xFF) << 8;
    }

    public static IBlockData getBlockDataFromRaw(long raw) {
        return GLOBAL_PALETTE.a((int)(raw >>> 32));
    }

    public static int getIndexFromRaw(long raw) {
        return (int)(raw & 0xFFFFL);
    }

    public static int getLocationFromRaw(long raw) {
        return (int)(raw >>> 16 & 0xFFFFL);
    }

    public static long getRawFromValues(int index, int location, IBlockData data) {
        return (long)index | (long)location << 16 | (long)GLOBAL_PALETTE.a(data) << 32;
    }

    public static long setIndexRawValues(long value, int index) {
        return value & 0xFFFFFFFFFFFF0000L | (long)index;
    }

    public long add(int x2, int y2, int z2, IBlockData data) {
        return this.add(IBlockDataList.getLocationKey(x2, y2, z2), data);
    }

    public long add(int location, IBlockData data) {
        long curr = this.map.get((short)location);
        if (curr == Long.MAX_VALUE) {
            int index = this.size++;
            long raw = IBlockDataList.getRawFromValues(index, location, data);
            this.map.put((short)location, raw);
            if (index >= this.byIndex.length) {
                this.byIndex = Arrays.copyOf(this.byIndex, (int)Math.max(4L, (long)this.byIndex.length * 2L));
            }
            this.byIndex[index] = raw;
            return raw;
        }
        int index = IBlockDataList.getIndexFromRaw(curr);
        long raw = this.byIndex[index] = IBlockDataList.getRawFromValues(index, location, data);
        this.map.put((short)location, raw);
        return raw;
    }

    public long remove(int x2, int y2, int z2) {
        return this.remove(IBlockDataList.getLocationKey(x2, y2, z2));
    }

    public long remove(int location) {
        long ret = this.map.remove((short)location);
        int index = IBlockDataList.getIndexFromRaw(ret);
        if (ret == Long.MAX_VALUE) {
            return ret;
        }
        int endIndex = --this.size;
        long end = this.byIndex[endIndex];
        if (index != endIndex) {
            this.map.put((short)IBlockDataList.getLocationFromRaw(end), IBlockDataList.setIndexRawValues(end, index));
        }
        this.byIndex[index] = end;
        this.byIndex[endIndex] = 0L;
        return ret;
    }

    public int size() {
        return this.size;
    }

    public long getRaw(int index) {
        return this.byIndex[index];
    }

    public int getLocation(int index) {
        return IBlockDataList.getLocationFromRaw(this.getRaw(index));
    }

    public IBlockData getData(int index) {
        return IBlockDataList.getBlockDataFromRaw(this.getRaw(index));
    }

    public void clear() {
        this.size = 0;
        this.map.clear();
    }

    public LongIterator getRawIterator() {
        return this.map.values().iterator();
    }
}

