/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server;

import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import io.papermc.paper.util.TickThread;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.LevelCallback;

public final class ServerEntityLookup
extends EntityLookup {
    private final WorldServer serverWorld;

    public ServerEntityLookup(WorldServer world, LevelCallback<Entity> worldCallback) {
        super(world, worldCallback);
        this.serverWorld = world;
    }

    @Override
    protected Boolean blockTicketUpdates() {
        return this.serverWorld.moonrise$getChunkTaskScheduler().chunkHolderManager.blockTicketUpdates();
    }

    @Override
    protected void setBlockTicketUpdates(Boolean value) {
        this.serverWorld.moonrise$getChunkTaskScheduler().chunkHolderManager.unblockTicketUpdates(value);
    }

    @Override
    protected void checkThread(int chunkX, int chunkZ, String reason) {
        TickThread.ensureTickThread(this.serverWorld, chunkX, chunkZ, reason);
    }

    @Override
    protected void checkThread(Entity entity, String reason) {
        TickThread.ensureTickThread(entity, reason);
    }

    @Override
    protected ChunkEntitySlices createEntityChunk(int chunkX, int chunkZ, boolean transientChunk) {
        return this.serverWorld.moonrise$getChunkTaskScheduler().chunkHolderManager.getOrCreateEntityChunk(chunkX, chunkZ, transientChunk);
    }

    @Override
    protected void onEmptySlices(int chunkX, int chunkZ) {
    }
}

