/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.async_save.AsyncChunkSaveData;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;

public final class ChunkSystemFeatures {
    public static boolean supportsAsyncChunkSave() {
        return true;
    }

    public static AsyncChunkSaveData getAsyncSaveData(WorldServer world, IChunkAccess chunk) {
        return ChunkRegionLoader.getAsyncSaveData(world, chunk);
    }

    public static NBTTagCompound saveChunkAsync(WorldServer world, IChunkAccess chunk, AsyncChunkSaveData asyncSaveData) {
        return ChunkRegionLoader.saveChunk(world, chunk, asyncSaveData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean forceNoSave(IChunkAccess chunk) {
        if (!(chunk instanceof Chunk)) return false;
        Chunk levelChunk = (Chunk)chunk;
        if (!levelChunk.mustNotSave) return false;
        return true;
    }

    public static boolean supportsAsyncChunkDeserialization() {
        return true;
    }

    private ChunkSystemFeatures() {
    }
}

