/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.slf4j.Logger;

public final class ChunkSystem {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void scheduleChunkTask(WorldServer level, int chunkX, int chunkZ, Runnable run) {
        ChunkSystem.scheduleChunkTask(level, chunkX, chunkZ, run, PrioritisedExecutor.Priority.NORMAL);
    }

    public static void scheduleChunkTask(WorldServer level, int chunkX, int chunkZ, Runnable run, PrioritisedExecutor.Priority priority) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkTask(chunkX, chunkZ, run, priority);
    }

    public static void scheduleChunkLoad(WorldServer level, int chunkX, int chunkZ, boolean gen, ChunkStatus toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<IChunkAccess> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, gen, toStatus, addTicket, priority, onComplete);
    }

    public static void scheduleChunkLoad(WorldServer level, int chunkX, int chunkZ, ChunkStatus toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<IChunkAccess> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    public static void scheduleTickingState(WorldServer level, int chunkX, int chunkZ, FullChunkStatus toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<Chunk> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleTickingState(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    public static List<PlayerChunk> getVisibleChunkHolders(WorldServer level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders();
    }

    public static List<PlayerChunk> getUpdatingChunkHolders(WorldServer level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders();
    }

    public static int getVisibleChunkHolderCount(WorldServer level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    public static int getUpdatingChunkHolderCount(WorldServer level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    public static boolean hasAnyChunkHolders(WorldServer level) {
        return ChunkSystem.getUpdatingChunkHolderCount(level) != 0;
    }

    public static void onEntityPreAdd(WorldServer level, Entity entity) {
        io.papermc.paper.chunk.system.ChunkSystem.onEntityPreAdd(level, entity);
    }

    public static void onChunkHolderCreate(WorldServer level, PlayerChunk holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkHolderCreate(level, holder);
    }

    public static void onChunkHolderDelete(WorldServer level, PlayerChunk holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkHolderDelete(level, holder);
    }

    public static void onChunkPreBorder(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.F()).l().moonrise$setFullChunk(chunk.f().e, chunk.f().f, chunk);
    }

    public static void onChunkBorder(Chunk chunk, PlayerChunk holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkBorder(chunk, holder);
        chunk.loadCallback();
    }

    public static void onChunkNotBorder(Chunk chunk, PlayerChunk holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkNotBorder(chunk, holder);
        chunk.unloadCallback();
    }

    public static void onChunkPostNotBorder(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.F()).l().moonrise$setFullChunk(chunk.f().e, chunk.f().f, null);
    }

    public static void onChunkTicking(Chunk chunk, PlayerChunk holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkTicking(chunk, holder);
        if (!chunk.moonrise$isPostProcessingDone()) {
            chunk.H();
        }
        ((WorldServer)chunk.F()).b(chunk);
        ((WorldServer)chunk.F()).l().a.H.incrementAndGet();
    }

    public static void onChunkNotTicking(Chunk chunk, PlayerChunk holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkNotTicking(chunk, holder);
    }

    public static void onChunkEntityTicking(Chunk chunk, PlayerChunk holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkEntityTicking(chunk, holder);
    }

    public static void onChunkNotEntityTicking(Chunk chunk, PlayerChunk holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkNotEntityTicking(chunk, holder);
    }

    public static PlayerChunk getUnloadingChunkHolder(WorldServer level, int chunkX, int chunkZ) {
        return null;
    }

    public static int getSendViewDistance(EntityPlayer player) {
        return RegionizedPlayerChunkLoader.getAPISendViewDistance(player);
    }

    public static int getLoadViewDistance(EntityPlayer player) {
        return RegionizedPlayerChunkLoader.getLoadViewDistance(player);
    }

    public static int getTickViewDistance(EntityPlayer player) {
        return RegionizedPlayerChunkLoader.getAPITickViewDistance(player);
    }

    public static void addPlayerToDistanceMaps(WorldServer world, EntityPlayer player) {
        world.moonrise$getPlayerChunkLoader().addPlayer(player);
    }

    public static void removePlayerFromDistanceMaps(WorldServer world, EntityPlayer player) {
        world.moonrise$getPlayerChunkLoader().removePlayer(player);
    }

    public static void updateMaps(WorldServer world, EntityPlayer player) {
        world.moonrise$getPlayerChunkLoader().updatePlayer(player);
    }

    private ChunkSystem() {
    }
}

