/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.executor;

import ca.spottedleaf.concurrentutil.executor.Cancellable;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import java.util.function.BooleanSupplier;

public interface BaseExecutor {
    default public boolean haveAllTasksExecuted() {
        long scheduled;
        long completed = this.getTotalTasksExecuted();
        return completed == (scheduled = this.getTotalTasksScheduled());
    }

    public long getTotalTasksScheduled();

    public long getTotalTasksExecuted();

    default public void waitUntilAllExecuted() throws IllegalStateException {
        long failures = 1L;
        while (!this.haveAllTasksExecuted()) {
            Thread.yield();
            failures = ConcurrentUtil.linearLongBackoff(failures, 250000L, 5000000L);
        }
    }

    public boolean executeTask() throws IllegalStateException;

    default public boolean executeAll() {
        if (!this.executeTask()) {
            return false;
        }
        while (this.executeTask()) {
        }
        return true;
    }

    default public void executeConditionally(BooleanSupplier condition) {
        long failures = 0L;
        while (!condition.getAsBoolean()) {
            if (this.executeTask()) {
                failures >>>= 2;
                continue;
            }
            failures = ConcurrentUtil.linearLongBackoff(failures, 100000L, 10000000L);
        }
    }

    default public void executeConditionally(BooleanSupplier condition, long deadline) {
        long failures = 0L;
        while (System.nanoTime() - deadline < 0L && !condition.getAsBoolean() && System.nanoTime() - deadline < 0L) {
            if (this.executeTask()) {
                failures >>>= 2;
                continue;
            }
            failures = ConcurrentUtil.linearLongBackoffDeadline(failures, 100000L, 10000000L, deadline);
        }
    }

    default public void executeUntil(long deadline) {
        long failures = 0L;
        while (System.nanoTime() - deadline < 0L) {
            if (this.executeTask()) {
                failures >>>= 2;
                continue;
            }
            failures = ConcurrentUtil.linearLongBackoffDeadline(failures, 100000L, 10000000L, deadline);
        }
    }

    default public boolean shutdown() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    default public boolean isShutdown() {
        return false;
    }

    public static interface BaseTask
    extends Cancellable {
        public boolean queue();

        @Override
        public boolean cancel();

        public boolean execute();
    }
}

