/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.builder;

import io.papermc.asm.rules.RewriteRule;
import io.papermc.asm.rules.builder.ConfiguredRuleFactory;
import io.papermc.asm.rules.builder.RuleFactoryConfigurationImpl;
import java.lang.constant.ClassDesc;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public interface RuleFactoryConfiguration {
    public static RuleFactoryConfiguration create(ClassDesc delegateOwner) {
        return new RuleFactoryConfigurationImpl(delegateOwner);
    }

    public ClassDesc delegateOwner();

    public static interface Holder {
        public RuleFactoryConfiguration configuration();

        default public RewriteRule forOwnerClass(Class<?> owner, ConfiguredRuleFactory.Factory firstFactoryConsumer, ConfiguredRuleFactory.Factory ... factoryConsumers) {
            return this.forOwnerClasses(Collections.singleton(owner), firstFactoryConsumer, factoryConsumers);
        }

        default public RewriteRule forOwnerClasses(Set<Class<?>> owners, ConfiguredRuleFactory.Factory firstFactoryConsumer, ConfiguredRuleFactory.Factory ... factoryConsumers) {
            return this.forOwners(owners.stream().map(c -> c.describeConstable().orElseThrow()).collect(Collectors.toUnmodifiableSet()), firstFactoryConsumer, factoryConsumers);
        }

        default public RewriteRule forOwner(ClassDesc owner, ConfiguredRuleFactory.Factory firstFactoryConsumer, ConfiguredRuleFactory.Factory ... factoryConsumers) {
            return this.forOwners(Collections.singleton(owner), firstFactoryConsumer, factoryConsumers);
        }

        default public RewriteRule forOwners(Set<ClassDesc> owners, ConfiguredRuleFactory.Factory firstFactoryConsumer, ConfiguredRuleFactory.Factory ... factoryConsumers) {
            ConfiguredRuleFactory factory = ConfiguredRuleFactory.create(owners, this.configuration());
            firstFactoryConsumer.accept(factory);
            for (ConfiguredRuleFactory.Factory factoryConsumer : factoryConsumers) {
                factoryConsumer.accept(factory);
            }
            return factory.build();
        }
    }
}

