/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2371;
import net.minecraft.class_2561;

public class UpgradeItem
extends class_1792 {
    private final Upgrade type;
    public static List<Supplier<class_1792>> upgrades = Arrays.asList(() -> ModItems.IRON_TIER_UPGRADE, () -> ModItems.GOLD_TIER_UPGRADE, () -> ModItems.DIAMOND_TIER_UPGRADE, () -> ModItems.NETHERITE_TIER_UPGRADE);

    public UpgradeItem(class_1792.class_1793 settings, Upgrade type) {
        super(settings);
        this.type = type;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 tooltipType) {
        if (TravelersBackpackConfig.getConfig().backpackSettings.enableTierUpgrades) {
            switch (this.type.ordinal()) {
                case 0: {
                    tooltip.add((class_2561)class_2561.method_43471((String)"item.travelersbackpack.blank_upgrade_tooltip").method_27692(class_124.field_1078));
                    break;
                }
                case 1: {
                    tooltip.add((class_2561)class_2561.method_43469((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.LEATHER.getName()}).method_27692(class_124.field_1078));
                    break;
                }
                case 2: {
                    tooltip.add((class_2561)class_2561.method_43469((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.IRON.getName()}).method_27692(class_124.field_1078));
                    break;
                }
                case 3: {
                    tooltip.add((class_2561)class_2561.method_43469((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.GOLD.getName()}).method_27692(class_124.field_1078));
                    break;
                }
                case 4: {
                    tooltip.add((class_2561)class_2561.method_43469((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.DIAMOND.getName()}).method_27692(class_124.field_1078));
                }
            }
        } else if (this.type != Upgrade.CRAFTING_UPGRADE) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.travelersbackpack.upgrade_disabled"));
        }
        if (this.type == Upgrade.CRAFTING_UPGRADE) {
            if (TravelersBackpackConfig.getConfig().backpackSettings.crafting.enableUpgrade) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.travelersbackpack.crafting_upgrade_tooltip").method_27692(class_124.field_1078));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.travelersbackpack.upgrade_disabled").method_27692(class_124.field_1061));
            }
        }
    }

    public static class_2371<class_1799> getUpgrades(ITravelersBackpackInventory inventory) {
        class_2371 list = class_2371.method_10211();
        for (int i = 1; i <= inventory.getTier().getOrdinal(); ++i) {
            list.add((Object)upgrades.get(i - 1).get().method_7854());
        }
        if (inventory.getSettingsManager().hasCraftingGrid()) {
            list.add((Object)ModItems.CRAFTING_UPGRADE.method_7854());
        }
        return list;
    }

    public static enum Upgrade {
        BLANK_UPGRADE,
        IRON_TIER_UPGRADE,
        GOLD_TIER_UPGRADE,
        DIAMOND_TIER_UPGRADE,
        NETHERITE_TIER_UPGRADE,
        CRAFTING_UPGRADE;

    }
}

