/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.components.Slots;
import com.tiviacz.travelersbackpack.init.ModComponentTypes;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class SlotManager {
    protected final ITravelersBackpackInventory inventory;
    protected List<Integer> unsortableSlots = new ArrayList<Integer>();
    protected List<Pair<Integer, class_1799>> memorySlots = new ArrayList<Pair<Integer, class_1799>>();
    protected boolean isUnsortableActive = false;
    protected boolean isMemoryActive = false;
    public static final String UNSORTABLE_SLOTS = "UnsortableSlots";
    public static final String MEMORY_SLOTS = "MemorySlots";
    public static final byte UNSORTABLE = 0;
    public static final byte MEMORY = 1;

    public SlotManager(ITravelersBackpackInventory inventory) {
        this.inventory = inventory;
    }

    public List<Integer> getUnsortableSlots() {
        return this.unsortableSlots;
    }

    public List<Pair<Integer, class_1799>> getMemorySlots() {
        return this.memorySlots;
    }

    public boolean isSlot(byte type, int slot) {
        if (type == 0) {
            return this.unsortableSlots.contains(slot);
        }
        if (type == 1) {
            for (Pair<Integer, class_1799> pair : this.memorySlots) {
                if ((Integer)pair.getFirst() != slot) continue;
                return true;
            }
        }
        return false;
    }

    public void setUnsortableSlots(List<Integer> slots, boolean isFinal) {
        if (this.isSelectorActive((byte)0)) {
            this.unsortableSlots = slots;
            if (isFinal) {
                this.setChanged();
            }
        }
    }

    public void setMemorySlots(List<Integer> slots, List<class_1799> stacks, boolean isFinal) {
        if (this.isSelectorActive((byte)1)) {
            ArrayList<Pair<Integer, class_1799>> pairs = new ArrayList<Pair<Integer, class_1799>>();
            for (int i = 0; i < stacks.size(); ++i) {
                pairs.add((Pair<Integer, class_1799>)Pair.of((Object)slots.get(i), (Object)stacks.get(i)));
            }
            pairs.sort(Comparator.comparing(Pair::getFirst));
            this.memorySlots = pairs;
            if (isFinal) {
                this.setChanged();
            }
        }
    }

    public void setUnsortableSlot(int slot) {
        if (this.isSelectorActive((byte)0) && slot <= this.inventory.getInventory().method_5439() - 1) {
            if (this.isSlot((byte)0, slot)) {
                this.unsortableSlots.remove((Object)slot);
            } else {
                this.unsortableSlots.add(slot);
            }
        }
    }

    public void setMemorySlot(int slot, class_1799 stack) {
        if (this.isSelectorActive((byte)1) && slot <= this.inventory.getInventory().method_5439() - 1) {
            if (this.isSlot((byte)1, slot)) {
                this.memorySlots.removeIf(p -> (Integer)p.getFirst() == slot);
            } else {
                this.memorySlots.add((Pair<Integer, class_1799>)Pair.of((Object)slot, (Object)stack));
            }
        }
    }

    public void clearUnsortables() {
        if (this.isSelectorActive((byte)0)) {
            this.unsortableSlots = new ArrayList<Integer>();
        }
    }

    public void setChanged() {
        if (this.inventory.getScreenID() != 3) {
            this.inventory.markDataDirty(9);
        } else {
            this.inventory.method_5431();
        }
    }

    public boolean isSelectorActive(byte type) {
        return switch (type) {
            case 0 -> this.isUnsortableActive;
            case 1 -> this.isMemoryActive;
            default -> false;
        };
    }

    public void setSelectorActive(byte type, boolean bool) {
        switch (type) {
            case 0: {
                this.isUnsortableActive = bool;
                break;
            }
            case 1: {
                this.isMemoryActive = bool;
            }
        }
    }

    public void writeUnsortableSlots(class_2487 compound) {
        compound.method_10539(UNSORTABLE_SLOTS, this.getUnsortableSlots().stream().mapToInt(i -> i).toArray());
    }

    public void writeUnsortableSlots(class_1799 stack) {
        Slots newSlots = new Slots(this.getUnsortableSlots(), this.getMemorySlots());
        stack.method_57379(ModComponentTypes.SLOTS, (Object)newSlots);
    }

    public void readUnsortableSlots(class_2487 compound) {
        this.unsortableSlots = Arrays.stream(compound.method_10561(UNSORTABLE_SLOTS)).boxed().collect(Collectors.toList());
    }

    public void readUnsortableSlots(class_1799 stack) {
        this.unsortableSlots = new ArrayList<Integer>(((Slots)stack.method_57825(ModComponentTypes.SLOTS, (Object)Slots.createDefault())).unsortables());
    }

    public void writeMemorySlots(class_7225.class_7874 registryLookup, class_2487 compound) {
        class_2499 memorySlotsList = new class_2499();
        for (Pair<Integer, class_1799> pair : this.memorySlots) {
            if (((class_1799)pair.getSecond()).method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", ((Integer)pair.getFirst()).intValue());
            memorySlotsList.add((Object)((class_1799)pair.getSecond()).method_57376(registryLookup, (class_2520)itemTag));
        }
        compound.method_10566(MEMORY_SLOTS, (class_2520)memorySlotsList);
    }

    public void writeMemorySlots(class_1799 stack) {
        Slots newSlots = new Slots(this.getUnsortableSlots(), this.getMemorySlots());
        stack.method_57379(ModComponentTypes.SLOTS, (Object)newSlots);
    }

    public void readMemorySlots(class_7225.class_7874 registryLookup, class_2487 compound) {
        class_2499 tagList = compound.method_10554(MEMORY_SLOTS, 10);
        ArrayList<Pair<Integer, class_1799>> pairs = new ArrayList<Pair<Integer, class_1799>>();
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTag = tagList.method_10602(i);
            int slot = itemTag.method_10550("Slot");
            if (slot > this.inventory.getInventory().method_5439() - 1) continue;
            Pair pair = Pair.of((Object)slot, (Object)class_1799.method_57359((class_7225.class_7874)registryLookup, (class_2487)itemTag));
            pairs.add((Pair<Integer, class_1799>)pair);
        }
        this.memorySlots = pairs;
    }

    public void readMemorySlots(class_1799 stack) {
        this.memorySlots = new ArrayList<Pair<Integer, class_1799>>(((Slots)stack.method_57825(ModComponentTypes.SLOTS, (Object)Slots.createDefault())).memory());
    }

    public Slots getSlots() {
        return new Slots(this.getUnsortableSlots(), this.getMemorySlots());
    }

    public SlotManager getManager(Slots slots) {
        this.unsortableSlots = new ArrayList<Integer>(slots.unsortables());
        this.memorySlots = new ArrayList<Pair<Integer, class_1799>>(slots.memory());
        return this;
    }
}

